// Generated by CoffeeScript 1.12.7
var CustomDataTypeCommonFacet, CustomDataTypeWithCommons,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeWithCommons = (function(superClass) {
  extend(CustomDataTypeWithCommons, superClass);

  function CustomDataTypeWithCommons() {
    this.getQueryFieldBadge = bind(this.getQueryFieldBadge, this);
    return CustomDataTypeWithCommons.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeWithCommons.prototype.initData = function(data) {
    var cdata;
    if (!data[this.name()]) {
      cdata = null;
      data[this.name()] = cdata;
    } else {
      cdata = data[this.name()];
    }
    if (!cdata.url) {
      cdata.url = "";
    }
    return cdata;
  };

  CustomDataTypeWithCommons.prototype.renderFieldAsGroup = function() {
    return false;
  };

  CustomDataTypeWithCommons.prototype.renderRowAsBlock = function(data, top_level_data, opts) {
    return false;
  };

  CustomDataTypeWithCommons.prototype.getQueryFieldBadge = function(data) {
    var value;
    if (data[(this.name()) + ":unset"]) {
      value = $$("text.column.badge.without");
    } else {
      value = data[this.name()];
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeWithCommons.prototype.supportsStandard = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.supportsPrinting = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.supportsFacet = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.getFacet = function(opts) {
    opts.field = this;
    return new CustomDataTypeCommonFacet(opts);
  };

  CustomDataTypeWithCommons.prototype.getSortFunction = function() {
    return (function(_this) {
      return function(a, b) {
        var ref, ref1;
        return CUI.util.compareIndex(((ref = a[_this.name()]) != null ? ref.conceptName : void 0) || 'zzz', ((ref1 = b[_this.name()]) != null ? ref1.conceptName : void 0) || 'zzz');
      };
    })(this);
  };

  CustomDataTypeWithCommons.prototype.hasRenderForSort = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.sortExtraOpts = function() {
    return [
      {
        text: "conceptName",
        value: "conceptName"
      }, {
        text: "conceptURI",
        value: "conceptURI"
      }
    ];
  };

  CustomDataTypeWithCommons.prototype.renderSearchInput = function(data, opts) {
    var search_token;
    if (opts == null) {
      opts = {};
    }
    return search_token = new SearchToken({
      column: this,
      data: data,
      fields: opts.fields
    }).getInput().DOM;
  };

  CustomDataTypeWithCommons.prototype.getFieldNamesForSearch = function() {
    return this.getFieldNames();
  };

  CustomDataTypeWithCommons.prototype.getFieldNamesForSuggest = function() {
    return this.getFieldNames();
  };

  CustomDataTypeWithCommons.prototype.getFieldNames = function() {
    var field_names;
    field_names = [this.fullName() + ".conceptURI", this.fullName() + ".conceptName"];
    return field_names;
  };

  CustomDataTypeWithCommons.prototype.getSearchFilter = function(data, key) {
    var filter, phrase, ref, str, val;
    if (key == null) {
      key = this.name();
    }
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".conceptName"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    }
    filter = CustomDataTypeWithCommons.__super__.getSearchFilter.call(this, data, key);
    if (filter) {
      return filter;
    }
    if (CUI.util.isEmpty(data[key])) {
      return;
    }
    val = data[key];
    ref = Search.getPhrase(val), str = ref[0], phrase = ref[1];
    switch (data[key + ":type"]) {
      case "token":
      case "fulltext":
      case void 0:
        filter = {
          type: "match",
          mode: data[key + ":mode"],
          fields: this.getFieldNamesForSearch(),
          string: str,
          phrase: phrase
        };
        break;
      case "field":
        filter = {
          type: "in",
          fields: this.getFieldNamesForSearch(),
          "in": [str]
        };
    }
    return filter;
  };

  CustomDataTypeWithCommons.prototype.renderEditorInput = function(data, top_level_data, opts) {
    var name;
    name = this.name(opts);
    if (!data[name]) {
      data[name] = {
        conceptName: '',
        conceptURI: ''
      };
    }
    return this.__renderEditorInputPopover(data, data[name], opts);
  };

  CustomDataTypeWithCommons.prototype.__renderEditorInputPopover = function(data, cdata, opts, customButtonBarEntrys) {
    var classNameForBurgerMenuButton, layout, that;
    if (opts == null) {
      opts = {};
    }
    if (customButtonBarEntrys == null) {
      customButtonBarEntrys = false;
    }
    that = this;
    this.dotsButtonMenu = {};
    layout = {};
    classNameForBurgerMenuButton = 'pluginDirectSelectEditSearch';
    if (ez5.version("6")) {
      classNameForBurgerMenuButton = 'pluginDirectSelectEditSearchFylr';
    } else if (ez5.version("5")) {
      classNameForBurgerMenuButton = 'pluginDirectSelectEditSearch';
    }
    layout = new CUI.HorizontalLayout({
      "class": 'customPluginEditorLayout',
      center: {
        "class": ''
      },
      right: {
        content: new CUI.Buttonbar({
          buttons: [
            new CUI.Button({
              text: '',
              icon: new CUI.Icon({
                "class": "fa-ellipsis-v"
              }),
              "class": classNameForBurgerMenuButton,
              onClick: (function(_this) {
                return function(e, dotsButton) {
                  var deleteClear, detailinfo, itemList, menu_items, uriCall;
                  that.dotsButtonMenu = new CUI.Menu({
                    "class": "customDataTypeCommonsMenu",
                    element: dotsButton
                  }, menu_items = [
                    {
                      text: $$('custom.data.type.commons.controls.search.label'),
                      value: 'search',
                      icon_left: new CUI.Icon({
                        "class": "fa-search"
                      }),
                      onClick: function(e2, btn2) {
                        that.showEditPopover(dotsButton, data, cdata, layout, opts);
                        return that.dotsButtonMenu.hide();
                      }
                    }
                  ], typeof that.__getAdditionalTooltipInfo === "function" ? (detailinfo = {
                    text: $$('custom.data.type.commons.controls.detailinfo.label'),
                    value: 'detail',
                    icon_left: new CUI.Icon({
                      "class": "fa-info-circle"
                    }),
                    disabled: that.isEmpty(data, 0, opts),
                    onClick: function(eDetailInfo, btnDetailInfo) {
                      var tooltip;
                      tooltip = new CUI.Tooltip({
                        element: btnDetailInfo,
                        placement: 'w',
                        markdown: true,
                        show_ms: 1000,
                        hide_ms: 200,
                        content: function(tooltip) {
                          var encodedURI, extendedInfo_xhr;
                          if (!that.isEmpty(data, 0, opts)) {
                            encodedURI = encodeURIComponent(cdata.conceptURI);
                            extendedInfo_xhr = {
                              "xhr": void 0
                            };
                            that.__getAdditionalTooltipInfo(encodedURI, tooltip, extendedInfo_xhr);
                            return new CUI.Label({
                              icon: "spinner",
                              text: $$('custom.data.type.commons.modal.form.popup.loadingstring')
                            });
                          }
                        }
                      });
                      tooltip.show();
                      return CUI.Events.listen({
                        type: ["click", "dblclick", "mouseout"],
                        capture: true,
                        node: btnDetailInfo,
                        only_once: true,
                        call: (function(_this) {
                          return function(ev) {
                            return that.dotsButtonMenu.hide();
                          };
                        })(this)
                      });
                    }
                  }, menu_items.push(detailinfo)) : void 0, uriCall = {
                    text: $$('custom.data.type.commons.controls.calluri.label'),
                    value: 'uri',
                    icon_left: new CUI.Icon({
                      "class": "fa-external-link"
                    }),
                    disabled: that.isEmpty(data, 0, opts) || !CUI.parseLocation(cdata.conceptURI),
                    onClick: function() {
                      window.open(cdata.conceptURI, "_blank");
                      return that.dotsButtonMenu.hide();
                    }
                  }, menu_items.push(uriCall), deleteClear = {
                    text: $$('custom.data.type.commons.controls.delete.label'),
                    value: 'delete',
                    name: 'deleteValueFromDANTEPlugin',
                    "class": 'deleteValueFromDANTEPlugin',
                    icon_left: new CUI.Icon({
                      "class": "fa-trash"
                    }),
                    disabled: that.isEmpty(data, 0, opts),
                    onClick: function() {
                      cdata = {
                        conceptName: '',
                        conceptURI: ''
                      };
                      data[that.name(opts)] = cdata;
                      that.__updateResult(cdata, layout, opts);
                      return that.dotsButtonMenu.hide();
                    }
                  }, menu_items.push(deleteClear), (customButtonBarEntrys != null ? customButtonBarEntrys.length : void 0) > 0 ? menu_items.push.apply(menu_items, customButtonBarEntrys) : void 0, itemList = {
                    items: menu_items
                  });
                  that.dotsButtonMenu._auto_close_after_click = false;
                  that.dotsButtonMenu.setItemList(itemList);
                  return that.dotsButtonMenu.show();
                };
              })(this)
            })
          ]
        })
      }
    });
    this.layout = layout;
    CUI.Events.registerEvent({
      type: "custom-deleteDataFromPlugin",
      bubble: false
    });
    CUI.Events.listen({
      type: "custom-deleteDataFromPlugin",
      instance: that,
      node: layout,
      call: (function(_this) {
        return function() {
          var key;
          for (key in cdata) {
            delete cdata[key];
          }
          data[that.name(opts)] = cdata;
          opts.deleteDataFromPlugin = true;
          return that.__updateResult(cdata, layout, opts);
        };
      })(this)
    });
    this.__updateResult(cdata, layout, opts);
    opts.initialcallfrompoolmanager = false;
    return layout;
  };

  CustomDataTypeWithCommons.prototype.showEditPopover = function(btn, data, cdata, layout, opts) {
    var cdata_form, searchsuggest_xhr, suggest_Menu, that;
    that = this;
    suggest_Menu;
    searchsuggest_xhr = {
      "xhr": void 0
    };
    cdata.countOfSuggestions = 50;
    cdata_form = new CUI.Form({
      "class": 'cdtFormWithPadding',
      data: cdata,
      fields: that.__getEditorFields(cdata),
      onDataChanged: (function(_this) {
        return function(data, elem) {
          _this.__updateResult(cdata, layout, opts);
          _this.__setEditorFieldStatus(cdata, layout);
          return _this.__updateSuggestionsMenu(cdata, cdata_form, data.searchbarInput, elem, suggest_Menu, searchsuggest_xhr, layout, opts);
        };
      })(this)
    }).start();
    suggest_Menu = new CUI.Menu({
      element: cdata_form.getFieldsByName("searchbarInput")[0],
      use_element_width_as_min_width: true,
      "class": "customDataTypeCommonsMenu"
    });
    return this.popover = new CUI.Popover({
      element: btn,
      placement: "wn",
      "class": "commonPlugin_Popover",
      pane: {
        header_left: new CUI.Label({
          text: $$('custom.data.type.commons.popover.choose.label')
        }),
        content: cdata_form
      }
    }).show();
  };

  CustomDataTypeWithCommons.prototype.isEmpty = function(data, top_level_data, opts) {
    var ref, ref1;
    if (opts == null) {
      opts = {};
    }
    if ((opts != null ? opts.mode : void 0) === "expert") {
      if (typeof data[this.name(opts)] === 'object') {
        return CUI.util.isEmpty(data[this.name(opts)] != null);
      } else {
        return CUI.util.isEmpty((ref = data[this.name(opts)]) != null ? ref.trim() : void 0);
      }
    }
    return !((ref1 = data[this.name(opts)]) != null ? ref1.conceptName : void 0);
  };

  CustomDataTypeWithCommons.prototype.getSaveData = function(data, save_data, opts) {
    var cdata, conceptFulltext, conceptNameChosenByHand, conceptNameWithHierarchie, conceptStandard, frontendLanguage, frontendLanguages, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, that;
    that = this;
    if (opts.demo_data) {
      return {
        conceptName: 'Example',
        conceptURI: 'https://example.com'
      };
    }
    cdata = data[this.name(opts)] || ((ref = data._template) != null ? ref[this.name(opts)] : void 0);
    switch (this.getDataStatus(cdata)) {
      case "invalid":
        if (opts.copy) {
          return save_data[this.name(opts)] = null;
        } else {
          throw new InvalidSaveDataException();
        }
        break;
      case "empty":
        return save_data[this.name(opts)] = null;
      case "ok":
        conceptFulltext = {};
        if (cdata != null ? cdata._fulltext : void 0) {
          if ((ref1 = cdata._fulltext) != null ? ref1.string : void 0) {
            if (((ref2 = cdata._fulltext) != null ? ref2.string : void 0) !== '') {
              conceptFulltext.string = cdata._fulltext.string;
            }
          }
          if ((ref3 = cdata._fulltext) != null ? ref3.l10ntext : void 0) {
            if (cdata._fulltext.l10ntext) {
              conceptFulltext.l10ntext = cdata._fulltext.l10ntext;
            }
          }
          if ((ref4 = cdata._fulltext) != null ? ref4.text : void 0) {
            if (cdata._fulltext.text) {
              conceptFulltext.text = cdata._fulltext.text;
            }
          }
        } else {
          conceptFulltext.text = cdata.conceptName.trim();
        }
        conceptStandard = {};
        if (cdata != null ? cdata._standard : void 0) {
          if ((ref5 = cdata._standard) != null ? ref5.l10ntext : void 0) {
            if (cdata._standard.l10ntext) {
              conceptStandard.l10ntext = cdata._standard.l10ntext;
            }
          } else {
            if ((ref6 = cdata._standard) != null ? ref6.text : void 0) {
              if (((ref7 = cdata._standard) != null ? ref7.text : void 0) !== '') {
                conceptStandard.text = cdata._standard.text;
              }
            }
          }
          if ((ref8 = cdata._standard) != null ? ref8.geo : void 0) {
            if (cdata._standard.geo) {
              conceptStandard.geo = cdata._standard.geo;
            }
          }
        }
        frontendLanguages = ez5.loca.getLanguage();
        frontendLanguages = frontendLanguages.split('-');
        frontendLanguage = frontendLanguages[0];
        conceptNameChosenByHand = false;
        if (cdata != null ? cdata.conceptNameChosenByHand : void 0) {
          if (cdata.conceptNameChosenByHand === true) {
            conceptNameChosenByHand = true;
          }
        }
        conceptNameWithHierarchie = false;
        if (cdata != null ? cdata.conceptNameWithHierarchie : void 0) {
          if (cdata.conceptNameWithHierarchie === true) {
            conceptNameWithHierarchie = true;
          }
        }
        save_data[this.name(opts)] = {
          conceptName: cdata.conceptName.trim(),
          conceptURI: cdata.conceptURI.trim(),
          frontendLanguage: frontendLanguage,
          _fulltext: conceptFulltext,
          _standard: conceptStandard
        };
        if (cdata != null ? cdata.conceptAncestors : void 0) {
          if (cdata.conceptAncestors.length > 0) {
            if (Array.isArray(cdata.conceptAncestors)) {
              cdata.conceptAncestors = cdata.conceptAncestors.join(' ');
            }
            save_data[this.name(opts)]['conceptAncestors'] = cdata.conceptAncestors;
          }
        }
        if (cdata != null ? cdata.conceptSource : void 0) {
          if (typeof cdata.conceptSource === 'string') {
            if (cdata.conceptSource.length > 0) {
              save_data[this.name(opts)]['conceptSource'] = cdata.conceptSource;
            }
          }
        }
        if (cdata != null ? cdata.conceptGeoJSON : void 0) {
          if (typeof cdata.conceptGeoJSON === 'object') {
            if (Object.keys(cdata.conceptGeoJSON).length > 0) {
              save_data[this.name(opts)]['conceptGeoJSON'] = cdata.conceptGeoJSON;
            }
          }
        }
        if (cdata != null ? cdata.conceptNameChosenByHand : void 0) {
          if (cdata.conceptNameChosenByHand === true) {
            save_data[this.name(opts)]['conceptNameChosenByHand'] = true;
          }
        }
        if (cdata != null ? cdata.conceptNameWithHierarchie : void 0) {
          if (cdata.conceptNameWithHierarchie === true) {
            save_data[this.name(opts)]['conceptNameWithHierarchie'] = true;
          }
        }
        if (cdata != null ? cdata.facetTerm : void 0) {
          return save_data[this.name(opts)]['facetTerm'] = cdata.facetTerm;
        }
    }
  };

  CustomDataTypeWithCommons.prototype.__updateResult = function(cdata, layout, opts) {
    var displayURI, info, inputX, onelineButtonbar, onelineDisplay, options, ref, ref1, ref2, ref3, ref4, rendered, searchsuggest_xhr, suggest_Menu_directInput, that, topContent;
    that = this;
    if (opts.data) {
      opts.data[that.name(opts)] = cdata;
    }
    onelineDisplay = false;
    if (((ref = this.FieldSchema) != null ? (ref1 = ref.custom_settings) != null ? (ref2 = ref1.editor_display) != null ? ref2.value : void 0 : void 0 : void 0) === 'condensed' || (opts != null ? (ref3 = opts.custom_settings) != null ? (ref4 = ref3.editor_display) != null ? ref4.value : void 0 : void 0 : void 0) === 'condensed') {
      onelineDisplay = true;
    }
    if (cdata != null ? cdata.conceptURI : void 0) {
      displayURI = cdata.conceptURI;
      if (displayURI.length > 20) {
        displayURI = displayURI.replace('http://', '');
        displayURI = displayURI.replace('https://', '');
      }
      if (displayURI.length > 30) {
        displayURI = displayURI.replace('uri.gbv.de/terminology/', '…/');
      }
      topContent = {
        content: new CUI.Label({
          text: cdata.conceptName,
          multiline: true
        })
      };
      if (onelineDisplay && typeof that.__getAdditionalTooltipInfo === "function") {
        onelineButtonbar = new CUI.Buttonbar({
          buttons: [
            new CUI.Label({
              centered: false,
              text: cdata.conceptName,
              multiline: true
            }), new CUI.ButtonHref({
              name: "outputButtonHref",
              "class": "pluginResultButton",
              appearance: "link",
              size: "normal",
              href: cdata.conceptURI,
              target: "_blank",
              tooltip: {
                markdown: true,
                placement: 'nw',
                content: function(tooltip) {
                  var encodedURI, extendedInfo_xhr;
                  extendedInfo_xhr = {
                    "xhr": void 0
                  };
                  encodedURI = encodeURIComponent(cdata.conceptURI);
                  that.__getAdditionalTooltipInfo(encodedURI, tooltip, extendedInfo_xhr);
                  return new CUI.Label({
                    icon: "spinner"
                  });
                }
              }
            })
          ]
        });
        onelineButtonbar.DOM.style.maxWidth = '92%';
        topContent = {
          content: onelineButtonbar
        };
      }
      info = new CUI.VerticalLayout({
        "class": 'ez5-info_commonPlugin',
        top: topContent,
        bottom: !onelineDisplay ? {
          content: new CUI.Button({
            name: "outputButtonHref",
            appearance: "flat",
            size: "normal",
            text: displayURI,
            tooltip: {
              markdown: true,
              placement: 'w',
              content: function(tooltip) {
                var encodedURI, extendedInfo_xhr;
                encodedURI = encodeURIComponent(cdata.conceptURI);
                extendedInfo_xhr = {
                  "xhr": void 0
                };
                if (typeof that.__getAdditionalTooltipInfo === "function") {
                  that.__getAdditionalTooltipInfo(encodedURI, tooltip, extendedInfo_xhr);
                  return new CUI.Label({
                    icon: "spinner",
                    text: $$('custom.data.type.commons.modal.form.popup.loadingstring')
                  });
                }
              }
            },
            onClick: (function(_this) {
              return function(evt, button) {
                return window.open(cdata.conceptURI, "_blank");
              };
            })(this)
          })
        } : void 0
      });
      layout.replace(info, 'center');
      layout.addClass('ez5-linked-object-edit');
      options = {
        "class": 'ez5-linked-object-container'
      };
      layout.__initPane(options, 'center');
    }
    if (!(cdata != null ? cdata.conceptURI : void 0)) {
      suggest_Menu_directInput;
      inputX = new CUI.Input({
        "class": "pluginDirectSelectEditInput",
        undo_and_changed_support: false,
        name: "directSelectInput",
        content_size: false,
        onKeyup: (function(_this) {
          return function(input) {
            var searchstring;
            searchstring = input.getValueForInput();
            if (typeof that.__updateSuggestionsMenu === "function") {
              return _this.__updateSuggestionsMenu(cdata, 0, searchstring, input, suggest_Menu_directInput, searchsuggest_xhr, layout, opts);
            }
          };
        })(this)
      });
      rendered = false;
      if (!(opts != null ? opts.callfrompoolmanager : void 0)) {
        rendered = true;
        inputX.render();
      }
      if (opts.initialcallfrompoolmanager === false && rendered === false) {
        inputX.render();
      }
      opts.initialcallfrompoolmanager = false;
      suggest_Menu_directInput = new CUI.Menu({
        element: inputX,
        use_element_width_as_min_width: true,
        "class": "customDataTypeCommonsMenu"
      });
      searchsuggest_xhr = {
        "xhr": void 0
      };
      layout.replace(inputX, 'center');
      layout.removeClass('ez5-linked-object-edit');
      options = {
        "class": ''
      };
      layout.__initPane(options, 'center');
    }
    if (!opts.deleteDataFromPlugin) {
      return that.__setEditorFieldStatus(cdata, layout);
    }
  };

  CustomDataTypeWithCommons.prototype.__setEditorFieldStatus = function(cdata, element) {
    switch (this.getDataStatus(cdata)) {
      case "invalid":
        element.addClass("cui-input-invalid");
        break;
      default:
        element.removeClass("cui-input-invalid");
    }
    CUI.Events.trigger({
      node: element,
      type: "editor-changed"
    });
    CUI.Events.trigger({
      node: element,
      type: "data-changed"
    });
    return this;
  };

  CustomDataTypeWithCommons.prototype.renderDetailOutput = function(data, top_level_data, opts) {
    return this.__renderButtonByData(data[this.name(opts)]);
  };

  CustomDataTypeWithCommons.prototype.getDataStatus = function(cdata) {
    var nameCheck, uriCheck;
    if (cdata) {
      if (cdata.conceptURI && cdata.conceptName) {
        uriCheck = CUI.parseLocation(cdata.conceptURI);
        nameCheck = cdata.conceptName ? cdata.conceptName.trim() : void 0;
        if (uriCheck && nameCheck) {
          return "ok";
        }
        if (cdata.conceptURI.trim() === '' && cdata.conceptName.trim() === '') {
          return "empty";
        }
        return "invalid";
      }
    }
    return "empty";
  };

  return CustomDataTypeWithCommons;

})(CustomDataType);

CustomDataTypeCommonFacet = (function(superClass) {
  extend(CustomDataTypeCommonFacet, superClass);

  function CustomDataTypeCommonFacet() {
    return CustomDataTypeCommonFacet.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeCommonFacet.prototype.initOpts = function() {
    CustomDataTypeCommonFacet.__super__.initOpts.call(this);
    return this.addOpts({
      field: {
        mandatory: true,
        check: Field
      }
    });
  };

  CustomDataTypeCommonFacet.prototype.requestFacetWithLimit = function(obj) {
    return {
      limit: this.getLimit(),
      field: this._field.fullName() + ".conceptName",
      sort: "count",
      type: "term"
    };
  };

  CustomDataTypeCommonFacet.prototype.getObjects = function(key, data) {
    var ref;
    if (key == null) {
      key = this.name();
    }
    if (data == null) {
      data = this.data();
    }
    return ((ref = data[key]) != null ? ref.terms : void 0) || [];
  };

  CustomDataTypeCommonFacet.prototype.renderObjectText = function(object) {
    return object.term;
  };

  CustomDataTypeCommonFacet.prototype.getObjectPath = function(obj) {
    return [obj.term];
  };

  CustomDataTypeCommonFacet.prototype.name = function() {
    return this._field.fullName() + ".conceptName";
  };

  CustomDataTypeCommonFacet.prototype.requestSearchFilter = function(obj) {
    return {
      bool: "must",
      fields: [this._field.fullName() + ".conceptName"],
      type: "in",
      "in": [obj.term]
    };
  };

  CustomDataTypeCommonFacet.prototype.getObjectsSorted = function(objects) {
    return CustomDataTypeCommonFacet.__super__.getObjectsSorted.call(this, objects);
  };

  CustomDataTypeCommonFacet.prototype.__isAndButtonAvailable = function() {
    return this._field.insideNested();
  };

  return CustomDataTypeCommonFacet;

})(FieldFacet);
// Generated by CoffeeScript 1.12.7
var CustomDataTypeIconclass,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeIconclass = (function(superClass) {
  extend(CustomDataTypeIconclass, superClass);

  function CustomDataTypeIconclass() {
    return CustomDataTypeIconclass.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeIconclass.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-iconclass.iconclass";
  };

  CustomDataTypeIconclass.prototype.getCustomMaskSettings = function() {
    if (this.ColumnSchema) {
      return this.FieldSchema.custom_settings || {};
    } else {
      return {};
    }
  };

  CustomDataTypeIconclass.prototype.getCustomSchemaSettings = function() {
    if (this.ColumnSchema) {
      return this.ColumnSchema.custom_settings || {};
    } else {
      return {};
    }
  };

  CustomDataTypeIconclass.prototype.name = function(opts) {
    var ref;
    if (opts == null) {
      opts = {};
    }
    if (!this.ColumnSchema) {
      if ((opts != null ? opts.callfrompoolmanager : void 0) && (opts != null ? opts.name : void 0) !== '') {
        return opts.name;
      } else {
        return "noNameSet";
      }
    } else {
      return (ref = this.ColumnSchema) != null ? ref.name : void 0;
    }
  };

  CustomDataTypeIconclass.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.iconclass.name");
  };

  CustomDataTypeIconclass.prototype.renderSearchInput = function(data) {
    var form, that;
    that = this;
    if (!data[this.name()]) {
      data[this.name()] = {};
    }
    form = this.renderEditorInput(data, '', {});
    CUI.Events.listen({
      type: "data-changed",
      node: form,
      call: (function(_this) {
        return function() {
          return CUI.Events.trigger({
            type: "search-input-change",
            node: form
          });
        };
      })(this)
    });
    return form.DOM;
  };

  CustomDataTypeIconclass.prototype.getSearchFilter = function(data, key) {
    var filter, ref, that;
    if (key == null) {
      key = this.name();
    }
    that = this;
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".conceptName"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    }
    filter = {
      type: "complex",
      search: [
        {
          type: "match",
          bool: "must",
          mode: "token",
          phrase: false,
          fields: [this.path() + '.' + this.name() + ".conceptAncestors"]
        }
      ]
    };
    if (!data[this.name()]) {
      filter.search[0].string = null;
    } else if ((ref = data[this.name()]) != null ? ref.conceptURI : void 0) {
      filter.search[0].string = data[this.name()].conceptURI;
    } else {
      filter = null;
    }
    return filter;
  };

  CustomDataTypeIconclass.prototype.getQueryFieldBadge = function(data) {
    var ref, value;
    if (!data[this.name()]) {
      value = $$("field.search.badge.without");
    } else if (!((ref = data[this.name()]) != null ? ref.conceptURI : void 0)) {
      value = $$("field.search.badge.without");
    } else {
      value = data[this.name()].conceptName;
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeIconclass.prototype.__updateSuggestionsMenu = function(cdata, cdata_form, input_searchstring, input, suggest_Menu, searchsuggest_xhr, layout, opts) {
    var delayMillisseconds, itemList, menu_items, that;
    that = this;
    delayMillisseconds = 50;
    menu_items = [
      {
        text: $$('custom.data.type.iconclass.modal.form.loadingSuggestions'),
        icon_left: new CUI.Icon({
          "class": "fa-spinner fa-spin"
        }),
        disabled: true
      }
    ];
    itemList = {
      items: menu_items
    };
    suggest_Menu.setItemList(itemList);
    return setTimeout((function() {
      var activeFrontendLanguage, countSuggestions, searchStringIsNotation, searchUrl;
      input_searchstring = input_searchstring.replace(/^\s+|\s+$/g, "");
      input_searchstring = input_searchstring.replace('*', '');
      input_searchstring = input_searchstring.replace(' ', '');
      searchStringIsNotation = false;
      if (isNaN(input_searchstring[0]) === false) {
        searchStringIsNotation = true;
      }
      suggest_Menu.show();
      countSuggestions = 20;
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      activeFrontendLanguage = that.getFrontendLanguage();
      searchUrl = 'https://iconclass.org/api/search?q=' + encodeURIComponent(input_searchstring) + '&lang=' + activeFrontendLanguage + '&size=999&page=1&sort=rank&keys=0';
      if (searchStringIsNotation) {
        searchUrl = 'https://iconclass.org/' + encodeURIComponent(input_searchstring) + '.json';
      }
      searchsuggest_xhr.xhr = new CUI.XHR({
        url: searchUrl
      });
      return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
        var extendedInfo_xhr, fn, i, key, len, suggestion;
        extendedInfo_xhr = {
          "xhr": void 0
        };
        if (!searchStringIsNotation) {
          if (data.result) {
            data = data.result;
          }
        } else {
          if (data.length !== 0) {
            data = [data];
          }
        }
        menu_items = [];
        if (data) {
          fn = function(key) {
            var item, suggestionsLabel, suggestionsURI;
            if (JSON.stringify(suggestion) !== '{}') {
              if (searchStringIsNotation) {
                if (suggestion.txt[activeFrontendLanguage]) {
                  suggestionsLabel = suggestion.txt[activeFrontendLanguage];
                } else {
                  suggestionsLabel = suggestion.txt.de;
                }
                suggestionsLabel = suggestion.n + ' - ' + suggestionsLabel;
                suggestionsURI = 'https://iconclass.org/' + suggestion.n;
                item = {
                  text: suggestionsLabel,
                  value: suggestion,
                  tooltip: {
                    markdown: true,
                    placement: "ne",
                    content: function(tooltip) {
                      that.__getAdditionalTooltipInfo(suggestionsURI, tooltip, extendedInfo_xhr);
                      return new CUI.Label({
                        icon: "spinner",
                        text: $$('custom.data.type.iconclass.modal.form.popup.loadingstring')
                      });
                    }
                  }
                };
                menu_items.push(item);
              }
              if (!searchStringIsNotation) {
                suggestionsURI = 'https://iconclass.org/' + suggestion;
                item = {
                  text: suggestion,
                  value: suggestion,
                  tooltip: {
                    markdown: true,
                    placement: "ne",
                    content: function(tooltip) {
                      that.__getAdditionalTooltipInfo(suggestionsURI, tooltip, extendedInfo_xhr);
                      return new CUI.Label({
                        icon: "spinner",
                        text: $$('custom.data.type.iconclass.modal.form.popup.loadingstring')
                      });
                    }
                  }
                };
                return menu_items.push(item);
              }
            }
          };
          for (key = i = 0, len = data.length; i < len; key = ++i) {
            suggestion = data[key];
            fn(key);
          }
        }
        itemList = {
          onClick: function(ev2, btn) {
            var chosenTempUri, fullInfoUrl, iconclassInfo;
            iconclassInfo = btn.getOpt("value");
            if (!(iconclassInfo != null ? iconclassInfo.n : void 0)) {
              cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo;
              cdata.frontendLanguage = activeFrontendLanguage;
              fullInfoUrl = cdata.conceptURI + '.json';
              searchsuggest_xhr.xhr = new CUI.XHR({
                url: fullInfoUrl
              });
              searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
                var ancestor, j, len1, ref, ref1;
                extendedInfo_xhr = {
                  "xhr": void 0
                };
                iconclassInfo = data;
                cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, cdata);
                cdata.conceptAncestors = [];
                if ((iconclassInfo != null ? (ref = iconclassInfo.p) != null ? ref.length : void 0 : void 0) > 0) {
                  ref1 = iconclassInfo.p;
                  for (j = 0, len1 = ref1.length; j < len1; j++) {
                    ancestor = ref1[j];
                    cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
                  }
                }
                cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
                cdata.conceptAncestors = cdata.conceptAncestors.join(' ');
                cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
                cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that, iconclassInfo, cdata, false);
                that.__updateResult(cdata, layout, opts);
                return this;
              });
            }
            if (iconclassInfo != null ? iconclassInfo.n : void 0) {
              if (iconclassInfo.n.includes('(...)')) {
                chosenTempUri = 'https://iconclass.org/' + iconclassInfo.n;
                return CUI.prompt({
                  text: $$('custom.data.type.iconclass.modal.form.popup.brackets.select') + " " + chosenTempUri + "\n\n" + $$('custom.data.type.iconclass.modal.form.popup.brackets.choose')
                }, "1").done((function(_this) {
                  return function(input) {
                    var ancestor, iconclassLabelKey, iconclassLabelValue, inputLowerCase, inputUpperCase, j, len1, newLabel, ref, ref1, ref2;
                    inputUpperCase = input.toUpperCase();
                    inputLowerCase = input.toLowerCase();
                    iconclassInfo.n = iconclassInfo.n.replace('(...)', "(" + inputUpperCase + ")");
                    ref = iconclassInfo.txt;
                    for (iconclassLabelKey in ref) {
                      iconclassLabelValue = ref[iconclassLabelKey];
                      newLabel = iconclassLabelValue;
                      newLabel = newLabel.replace(" (mit NAMEN)", ': ' + inputLowerCase);
                      newLabel = newLabel.replace(" (with NAME)", ': ' + inputLowerCase);
                      newLabel = newLabel.replace(" (avec NOM)", ': ' + inputLowerCase);
                      newLabel = newLabel.replace(" (col NOME)", ': ' + inputLowerCase);
                      newLabel = newLabel.replace(" (NIMEN kanssa)", ': ' + inputLowerCase);
                      iconclassInfo.txt[iconclassLabelKey] = newLabel;
                    }
                    cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo.n;
                    cdata.frontendLanguage = activeFrontendLanguage;
                    cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, cdata);
                    cdata.conceptAncestors = [];
                    if ((iconclassInfo != null ? (ref1 = iconclassInfo.p) != null ? ref1.length : void 0 : void 0) > 0) {
                      ref2 = iconclassInfo.p;
                      for (j = 0, len1 = ref2.length; j < len1; j++) {
                        ancestor = ref2[j];
                        cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
                      }
                    }
                    cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
                    cdata.conceptAncestors = cdata.conceptAncestors.join(' ');
                    cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
                    cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that, iconclassInfo, cdata, false);
                    that.__updateResult(cdata, layout, opts);
                    return _this;
                  };
                })(this)).fail((function(_this) {
                  return function() {
                    cdata = {};
                    that.__updateResult(cdata, layout, opts);
                    return _this;
                  };
                })(this));
              } else {
                if (iconclassInfo != null ? iconclassInfo.n : void 0) {
                  cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo.n;
                }
                cdata.frontendLanguage = activeFrontendLanguage;
                fullInfoUrl = cdata.conceptURI + '.json';
                searchsuggest_xhr.xhr = new CUI.XHR({
                  url: fullInfoUrl
                });
                return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
                  var ancestor, j, len1, ref, ref1;
                  extendedInfo_xhr = {
                    "xhr": void 0
                  };
                  iconclassInfo = data;
                  cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, cdata);
                  cdata.conceptAncestors = [];
                  if ((iconclassInfo != null ? (ref = iconclassInfo.p) != null ? ref.length : void 0 : void 0) > 0) {
                    ref1 = iconclassInfo.p;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                      ancestor = ref1[j];
                      cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
                    }
                  }
                  cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
                  cdata.conceptAncestors = cdata.conceptAncestors.join(' ');
                  cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
                  cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that, iconclassInfo, cdata, false);
                  that.__updateResult(cdata, layout, opts);
                  return this;
                });
              }
            }
          },
          items: menu_items
        };
        if (itemList.items.length === 0) {
          itemList = {
            items: [
              {
                text: $$('custom.data.type.iconclass.modal.form.popup.suggest.nohit'),
                value: void 0
              }
            ]
          };
        }
        suggest_Menu.setItemList(itemList);
        return suggest_Menu.show();
      });
    }), delayMillisseconds);
  };

  CustomDataTypeIconclass.prototype.renderEditorInput = function(data, top_level_data, opts) {
    var cdata;
    if (!data[this.name()]) {
      cdata = {
        conceptName: '',
        conceptURI: ''
      };
      data[this.name()] = cdata;
    } else {
      cdata = data[this.name()];
    }
    return this.__renderEditorInputPopover(data, cdata, opts);
  };

  CustomDataTypeIconclass.prototype.getFrontendLanguage = function() {
    var desiredLanguage;
    desiredLanguage = ez5.loca.getLanguage();
    desiredLanguage = desiredLanguage.split('-');
    desiredLanguage = desiredLanguage[0];
    return desiredLanguage;
  };

  CustomDataTypeIconclass.prototype.__getAdditionalTooltipInfo = function(iconclassURI, tooltip, extendedInfo_xhr, context) {
    var that, url;
    if (context == null) {
      context = null;
    }
    that = this;
    if (iconclassURI.indexOf('%') !== -1) {
      iconclassURI = decodeURIComponent(iconclassURI);
    }
    if (context) {
      that = context;
    }
    if (extendedInfo_xhr.xhr !== void 0) {
      extendedInfo_xhr.xhr.abort();
    }
    url = iconclassURI + '.json';
    extendedInfo_xhr.xhr = new CUI.XHR({
      url: url
    });
    extendedInfo_xhr.xhr.start().done(function(data, status, statusText) {
      var htmlContent;
      htmlContent = ez5.IconclassUtil.getPreview(data, that.getFrontendLanguage());
      if (htmlContent) {
        tooltip.DOM.innerHTML = htmlContent;
      } else {
        tooltip.DOM.innerHTML = '<div class="iconclassTooltip" style="padding: 10px">' + $$('custom.data.type.iconclass.modal.form.popup.no_information_found') + '</div>';
      }
      return tooltip.autoSize();
    });
  };

  CustomDataTypeIconclass.prototype.buildAndSetTreeviewLayout = function(popover, layout, cdata, cdata_form, that, topMethod, returnDfr, opts) {
    var activeFrontendLanguage, treeview, treeviewDfr, treeviewPane;
    if (topMethod == null) {
      topMethod = 0;
    }
    if (returnDfr == null) {
      returnDfr = false;
    }
    that = this;
    treeview = new Iconclass_ListViewTree(popover, layout, cdata, cdata_form, that, opts);
    activeFrontendLanguage = that.getFrontendLanguage();
    if (returnDfr === false) {
      treeview.getTopTreeView(activeFrontendLanguage);
    } else {
      treeviewDfr = treeview.getTopTreeView(activeFrontendLanguage);
    }
    treeviewPane = new CUI.Pane({
      "class": "cui-pane iconclass_treeviewPane",
      top: {
        content: [
          new CUI.PaneHeader({
            left: {
              content: new CUI.Label({
                text: $$('custom.data.type.iconclass.modal.form.popup.choose')
              })
            }
          })
        ]
      },
      center: {
        content: [treeview.treeview, cdata_form]
      }
    });
    this.popover.setContent(treeviewPane);
    if (returnDfr === false) {
      return treeview;
    } else {
      return treeviewDfr;
    }
  };

  CustomDataTypeIconclass.prototype.showEditPopover = function(btn, data, cdata, layout, opts) {
    var that;
    that = this;
    this.popover = new CUI.Popover({
      element: btn,
      placement: "wn",
      "class": "commonPlugin_Popover"
    });
    this.buildAndSetTreeviewLayout(this.popover, layout, cdata, null, that, 1, false, opts);
    return this.popover.show();
  };

  CustomDataTypeIconclass.prototype.__getEditorFields = function(cdata) {
    var fields, option, that;
    that = this;
    fields = [];
    option = {
      type: CUI.Input,
      "class": "commonPlugin_Input",
      undo_and_changed_support: false,
      form: {
        label: $$("custom.data.type.iconclass.modal.form.text.searchbar")
      },
      placeholder: $$("custom.data.type.iconclass.modal.form.text.searchbar.placeholder"),
      name: "searchbarInput"
    };
    fields.push(option);
    return fields;
  };

  CustomDataTypeIconclass.prototype.getDataStatus = function(cdata) {
    var nameCheck, uriCheck;
    if (cdata) {
      if (cdata.conceptURI && cdata.conceptName) {
        uriCheck = false;
        if (cdata.conceptURI.trim() !== '') {
          uriCheck = true;
        }
        nameCheck = cdata.conceptName ? cdata.conceptName.trim() : void 0;
        if (uriCheck && nameCheck) {
          return "ok";
        }
        if (cdata.conceptURI.trim() === '' || cdata.conceptName.trim() === '') {
          return "empty";
        }
        return "invalid";
      }
    }
    return "empty";
  };

  CustomDataTypeIconclass.prototype.__renderButtonByData = function(cdata) {
    var extendedInfo_xhr, frontendLanguage, outputLabel, ref, ref1, that;
    that = this;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.iconclass.edit.no_entry")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.iconclass.edit.no_valid_entry")
        }).DOM;
    }
    extendedInfo_xhr = {
      "xhr": void 0
    };
    frontendLanguage = ez5.loca.getLanguage();
    outputLabel = cdata.conceptName;
    if ((cdata != null ? (ref = cdata._standard) != null ? (ref1 = ref.l10ntext) != null ? ref1[frontendLanguage] : void 0 : void 0 : void 0) && (cdata != null ? cdata.conceptNameChosenByHand : void 0) !== true) {
      outputLabel = cdata._standard.l10ntext[frontendLanguage];
    }
    cdata.conceptURI;
    return new CUI.HorizontalLayout({
      maximize: true,
      left: {
        content: new CUI.Label({
          centered: false,
          text: outputLabel
        })
      },
      center: {
        content: new CUI.ButtonHref({
          name: "outputButtonHref",
          "class": "pluginResultButton",
          appearance: "link",
          size: "normal",
          href: cdata.conceptURI,
          target: "_blank",
          "class": "cdt_iconclass_smallMarginTop",
          tooltip: {
            markdown: true,
            placement: 'nw',
            content: function(tooltip) {
              that.__getAdditionalTooltipInfo(cdata.conceptURI, tooltip, extendedInfo_xhr);
              return new CUI.Label({
                icon: "spinner",
                text: $$('custom.data.type.iconclass.modal.form.popup.loadingstring')
              });
            }
          }
        })
      },
      right: null
    }).DOM;
  };

  CustomDataTypeIconclass.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    if (Object.keys(custom_settings).length === 0) {
      return ['Ohne Optionen'];
    }
  };

  return CustomDataTypeIconclass;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeIconclass);
// Generated by CoffeeScript 1.12.7
var Iconclass_ListViewTree, Iconclass_ListViewTreeNode,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Iconclass_ListViewTree = (function() {
  function Iconclass_ListViewTree(popover, editor_layout, cdata1, cdata_form, context, iconclass_opts) {
    var column, options, row, that, treeview;
    this.popover = popover != null ? popover : null;
    this.editor_layout = editor_layout != null ? editor_layout : null;
    this.cdata = cdata1 != null ? cdata1 : null;
    this.cdata_form = cdata_form != null ? cdata_form : null;
    this.context = context != null ? context : null;
    this.iconclass_opts = iconclass_opts != null ? iconclass_opts : {};
    options = {
      "class": "customPlugin_Treeview",
      cols: ["maximize", "auto"],
      fixedRows: 0,
      fixedCols: 0,
      no_hierarchy: false
    };
    that = this;
    treeview = new CUI.ListViewTree(options);
    treeview.render();
    treeview.root.open();
    row = new CUI.ListViewRow();
    column = new CUI.ListViewColumn({
      colspan: 2,
      element: new CUI.Label({
        icon: "spinner",
        appearance: "title",
        text: $$("custom.data.type.iconclass.modal.form.popup.loadingstringtreeview")
      })
    });
    row.addColumn(column);
    treeview.appendRow(row);
    treeview.root.open();
    this.treeview = treeview;
    this.treeview;
  }

  Iconclass_ListViewTree.prototype.getTopTreeView = function(activeFrontendLanguage) {
    var dfr, that, topTree_xhr, url;
    dfr = new CUI.Deferred();
    that = this;
    topTree_xhr = {
      "xhr": void 0
    };
    url = 'https://jsontojsonp.gbv.de/?url=' + encodeURIComponent('https://iconclass.org/json/?notation=1&notation=2&notation=3&notation=4&notation=5&notation=6&notation=7&notation=8&notation=9');
    topTree_xhr.xhr = new CUI.XHR({
      url: url
    });
    topTree_xhr.xhr.start().done(function(data, status, statusText) {
      var hasNarrowers, i, iconclassEntry, key, len, newNode, prefLabel, ref, ref1;
      if (that.treeview.getRow(0)) {
        that.treeview.removeRow(0);
      }
      if (data != null ? data.result : void 0) {
        data = data.result;
      }
      for (key = i = 0, len = data.length; i < len; key = ++i) {
        iconclassEntry = data[key];
        if (iconclassEntry != null ? iconclassEntry.txt[activeFrontendLanguage] : void 0) {
          prefLabel = iconclassEntry != null ? iconclassEntry.txt[activeFrontendLanguage] : void 0;
        } else {
          prefLabel = iconclassEntry != null ? (ref = iconclassEntry.txt) != null ? ref.de : void 0 : void 0;
        }
        prefLabel = iconclassEntry.n + ' - ' + prefLabel;
        if (((ref1 = iconclassEntry.c) != null ? ref1.length : void 0) > 0) {
          hasNarrowers = true;
        } else {
          hasNarrowers = false;
        }
        newNode = new Iconclass_ListViewTreeNode({
          selectable: false
        }, {
          prefLabel: prefLabel,
          uri: 'https://iconclass.org/' + iconclassEntry.n,
          iconclassInfo: iconclassEntry,
          hasNarrowers: hasNarrowers,
          popover: that.popover,
          cdata: that.cdata,
          cdata_form: that.cdata_form,
          context: that.context,
          iconclass_opts: that.iconclass_opts,
          editor_layout: that.editor_layout,
          activeFrontendLanguage: activeFrontendLanguage
        });
        that.treeview.addNode(newNode);
      }
      CUI.Events.trigger({
        node: that.popover,
        type: "content-resize"
      });
      dfr.resolve();
      return dfr.promise();
    });
    return dfr;
  };

  return Iconclass_ListViewTree;

})();

Iconclass_ListViewTreeNode = (function(superClass) {
  var prefLabel, uri;

  extend(Iconclass_ListViewTreeNode, superClass);

  prefLabel = '';

  uri = '';

  function Iconclass_ListViewTreeNode(opts, additionalOpts) {
    this.opts = opts != null ? opts : {};
    this.additionalOpts = additionalOpts != null ? additionalOpts : {};
    this.renderContent = bind(this.renderContent, this);
    this.isLeaf = bind(this.isLeaf, this);
    this.getChildren = bind(this.getChildren, this);
    Iconclass_ListViewTreeNode.__super__.constructor.call(this);
    this.prefLabel = this.additionalOpts.prefLabel;
    this.uri = this.additionalOpts.uri;
    this.iconclassInfo = this.additionalOpts.iconclassEntry;
    this.popover = this.additionalOpts.popover;
    this.cdata = this.additionalOpts.cdata;
    this.cdata_form = this.additionalOpts.cdata_form;
    this.context = this.additionalOpts.context;
    this.iconclass_opts = this.additionalOpts.iconclass_opts;
    this.editor_layout = this.additionalOpts.editor_layout;
    this.activeFrontendLanguage = this.additionalOpts.activeFrontendLanguage;
  }

  Iconclass_ListViewTreeNode.prototype.getChildren = function() {
    var children, dfr, getChildren_xhr, i, len, notation, notationKey, notations, notationsString, that, url;
    that = this;
    dfr = new CUI.Deferred();
    children = [];
    notations = this.additionalOpts.iconclassInfo.c;
    notationsString = '';
    for (notationKey = i = 0, len = notations.length; i < len; notationKey = ++i) {
      notation = notations[notationKey];
      notationsString = notationsString + '&notation=' + encodeURIComponent(notation);
    }
    url = 'https://jsontojsonp.gbv.de/?url=' + encodeURIComponent('https://iconclass.org/json/?' + notationsString);
    getChildren_xhr = {
      "xhr": void 0
    };
    getChildren_xhr.xhr = new CUI.XHR({
      url: url
    });
    getChildren_xhr.xhr.start().done(function(data, status, statusText) {
      var hasNarrowers, iconclassEntry, j, key, len1, newNode, ref, ref1;
      if (data != null ? data.result : void 0) {
        data = data.result;
      }
      for (key = j = 0, len1 = data.length; j < len1; key = ++j) {
        iconclassEntry = data[key];
        if (iconclassEntry != null ? iconclassEntry.txt[this.activeFrontendLanguage] : void 0) {
          prefLabel = iconclassEntry != null ? iconclassEntry.txt[this.activeFrontendLanguage] : void 0;
        } else {
          prefLabel = iconclassEntry != null ? (ref = iconclassEntry.txt) != null ? ref.de : void 0 : void 0;
        }
        prefLabel = iconclassEntry.n + ' - ' + prefLabel;
        if (((ref1 = iconclassEntry.c) != null ? ref1.length : void 0) > 0) {
          hasNarrowers = true;
        } else {
          hasNarrowers = false;
        }
        newNode = new Iconclass_ListViewTreeNode({
          selectable: false
        }, {
          prefLabel: prefLabel,
          uri: 'https://iconclass.org/' + iconclassEntry.n,
          hasNarrowers: hasNarrowers,
          popover: that.popover,
          cdata: that.cdata,
          cdata_form: that.cdata_form,
          context: that.context,
          iconclass_opts: that.iconclass_opts,
          editor_layout: that.editor_layout,
          iconclassInfo: iconclassEntry
        });
        children.push(newNode);
      }
      return dfr.resolve(children);
    });
    return dfr.promise();
  };

  Iconclass_ListViewTreeNode.prototype.isLeaf = function() {
    if (this.additionalOpts.hasNarrowers === true) {
      return false;
    } else {
      return true;
    }
  };

  Iconclass_ListViewTreeNode.prototype.renderContent = function() {
    var activeFrontendLanguage, buttonBar, buttons, d, extendedInfo_xhr, icon, infoButton, plusButton, that, tooltipText;
    that = this;
    extendedInfo_xhr = {
      "xhr": void 0
    };
    d = CUI.dom.div();
    buttons = [];
    icon = 'fa-plus-circle';
    tooltipText = $$('custom.data.type.iconclass.modal.form.popup.add_choose');
    activeFrontendLanguage = CustomDataTypeIconclass.prototype.getFrontendLanguage();
    plusButton = new CUI.Button({
      text: "",
      icon_left: new CUI.Icon({
        "class": icon
      }),
      active: false,
      group: "default",
      tooltip: {
        text: tooltipText
      },
      onClick: (function(_this) {
        return function() {
          var ancestor, chosenTempUri, i, iconclassInfo, len, ref, ref1;
          iconclassInfo = that.additionalOpts.iconclassInfo;
          if (iconclassInfo.n.includes('(...)')) {
            chosenTempUri = 'https://iconclass.org/' + iconclassInfo.n;
            return CUI.prompt({
              text: $$('custom.data.type.iconclass.modal.form.popup.brackets.select') + " " + chosenTempUri + "\n\n" + $$('custom.data.type.iconclass.modal.form.popup.brackets.choose')
            }, "1").done(function(input) {
              var ancestor, i, iconclassLabelKey, iconclassLabelValue, inputLowerCase, inputUpperCase, len, newLabel, ref, ref1, ref2;
              inputUpperCase = input.toUpperCase();
              inputLowerCase = input.toLowerCase();
              that.cdata.conceptName = that.cdata.conceptName.replace('(...)', "(" + inputUpperCase + ")");
              iconclassInfo.n = iconclassInfo.n.replace('(...)', "(" + inputUpperCase + ")");
              ref = iconclassInfo.txt;
              for (iconclassLabelKey in ref) {
                iconclassLabelValue = ref[iconclassLabelKey];
                newLabel = iconclassLabelValue;
                newLabel = newLabel.replace(" (mit NAMEN)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (with NAME)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (avec NOM)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (col NOME)", ': ' + inputLowerCase);
                newLabel = newLabel.replace(" (NIMEN kanssa)", ': ' + inputLowerCase);
                iconclassInfo.txt[iconclassLabelKey] = newLabel;
              }
              that.cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo.n;
              that.cdata.frontendLanguage = activeFrontendLanguage;
              that.cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, that.cdata);
              that.cdata.conceptAncestors = [];
              if ((iconclassInfo != null ? (ref1 = iconclassInfo.p) != null ? ref1.length : void 0 : void 0) > 0) {
                ref2 = iconclassInfo.p;
                for (i = 0, len = ref2.length; i < len; i++) {
                  ancestor = ref2[i];
                  that.cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
                }
              }
              that.cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
              that.cdata.conceptAncestors = that.cdata.conceptAncestors.join(' ');
              that.cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
              that.cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that.context, iconclassInfo, that.cdata, false);
              CustomDataTypeIconclass.prototype.__updateResult(that.cdata, that.editor_layout, that.iconclass_opts);
              that.popover.hide();
              return _this;
            }).fail(function() {
              var cdata;
              cdata = {};
              CustomDataTypeIconclass.prototype.__updateResult(that.cdata, that.editor_layout, that.iconclass_opts);
              that.popover.hide();
              return _this;
            });
          } else {
            that.cdata.conceptURI = 'https://iconclass.org/' + iconclassInfo.n;
            that.cdata.frontendLanguage = activeFrontendLanguage;
            that.cdata.conceptName = ez5.IconclassUtil.getConceptNameFromObject(iconclassInfo, that.cdata);
            that.cdata.conceptAncestors = [];
            if ((iconclassInfo != null ? (ref = iconclassInfo.p) != null ? ref.length : void 0 : void 0) > 0) {
              ref1 = iconclassInfo.p;
              for (i = 0, len = ref1.length; i < len; i++) {
                ancestor = ref1[i];
                that.cdata.conceptAncestors.push('https://iconclass.org/' + ancestor);
              }
            }
            that.cdata.conceptAncestors.push('https://iconclass.org/' + iconclassInfo.n);
            that.cdata.conceptAncestors = that.cdata.conceptAncestors.join(' ');
            that.cdata._fulltext = ez5.IconclassUtil.getFullTextFromObject(iconclassInfo, false);
            that.cdata._standard = ez5.IconclassUtil.getStandardTextFromObject(that.context, iconclassInfo, that.cdata, false);
            CustomDataTypeIconclass.prototype.__updateResult(that.cdata, that.editor_layout, that.iconclass_opts);
            that.popover.hide();
            return _this;
          }
        };
      })(this)
    });
    plusButton.setEnabled(true);
    buttons.push(plusButton);
    infoButton = new CUI.Button({
      text: "",
      icon_left: new CUI.Icon({
        "class": "fa-info-circle"
      }),
      active: false,
      group: "default",
      tooltip: {
        markdown: true,
        placement: "e",
        content: function(tooltip) {
          CustomDataTypeIconclass.prototype.__getAdditionalTooltipInfo(that.uri, tooltip, extendedInfo_xhr, that.context);
          return new CUI.Label({
            icon: "spinner",
            text: $$('custom.data.type.iconclass.modal.form.popup.loadingstring')
          });
        }
      }
    });
    buttons.push(infoButton);
    buttonBar = new CUI.Buttonbar({
      buttons: buttons
    });
    CUI.dom.append(d, CUI.dom.append(CUI.dom.div(), buttonBar.DOM));
    this.addColumn(new CUI.ListViewColumn({
      element: d,
      colspan: 1
    }));
    CUI.Events.trigger({
      node: that.popover,
      type: "content-resize"
    });
    return new CUI.Label({
      text: this.prefLabel
    });
  };

  return Iconclass_ListViewTreeNode;

})(CUI.ListViewTreeNode);
// Generated by CoffeeScript 1.12.7
ez5.IconclassUtil = (function() {
  function IconclassUtil() {}

  IconclassUtil.getPreview = function(data, language) {
    var html, key, keywords, keywordsString, prefLabel, ref, ref1, ref2, ref3, that, val, xuri;
    that = this;
    html = '';
    if (data instanceof Array) {
      data = data[0];
    }
    if (!(data != null ? data.n : void 0)) {
      return false;
    }
    if (data != null ? data.txt[language] : void 0) {
      prefLabel = data != null ? data.txt[language] : void 0;
    } else {
      prefLabel = data != null ? (ref = data.txt) != null ? ref.de : void 0 : void 0;
    }
    xuri = 'https://iconclass.org/' + data.n;
    html += '<div style="font-size: 12px; color: #999;"><span class="cui-label-icon"><i class="fa  fa-external-link"></i></span>&nbsp;' + xuri + '</div>';
    html += '<h3><span class="cui-label-icon"><i class="fa  fa-info-circle"></i></span>&nbsp;' + prefLabel + '</h3>';
    keywordsString = '';
    keywords = [];
    if (data != null ? (ref1 = data.kw) != null ? ref1.language : void 0 : void 0) {
      keywords = data != null ? (ref2 = data.kw) != null ? ref2.language : void 0 : void 0;
    } else {
      keywords = data != null ? (ref3 = data.kw) != null ? ref3.de : void 0 : void 0;
    }
    for (key in keywords) {
      val = keywords[key];
      keywordsString = ' - ' + val + '<br />' + keywordsString;
    }
    if (keywordsString) {
      html += '<h4>' + $$('custom.data.type.iconclass.modal.form.popup.preview.keywords') + '</h4>' + keywordsString;
    }
    html = '<style>.iconclassTooltip { padding: 10px; min-width:200px; } .iconclassTooltip h4 { margin-bottom: 0px; }</style><div class="iconclassTooltip">' + html + '</div>';
    return html;
  };

  IconclassUtil.getConceptNameFromObject = function(object, cdata) {
    var activeFrontendLanguage, conceptName, ref, ref1, ref2;
    if (cdata != null ? cdata.frontendLanguage : void 0) {
      if ((cdata != null ? (ref = cdata.frontendLanguage) != null ? ref.length : void 0 : void 0) === 2) {
        activeFrontendLanguage = cdata.frontendLanguage;
      }
    }
    if (Array.isArray(object)) {
      object = object[0];
    }
    conceptName = '';
    if (object.txt[activeFrontendLanguage]) {
      conceptName = object.txt[activeFrontendLanguage];
    } else if (typeof iconclassInfo !== "undefined" && iconclassInfo !== null ? (ref1 = iconclassInfo.txt) != null ? ref1.de : void 0 : void 0) {
      conceptName = object.txt.de;
    } else if (typeof iconclassInfo !== "undefined" && iconclassInfo !== null ? (ref2 = iconclassInfo.txt) != null ? ref2.en : void 0 : void 0) {
      conceptName = object.txt.en;
    } else {
      conceptName = object.txt[Object.keys(object.txt)[0]];
    }
    conceptName = object.n + ' - ' + conceptName;
    return conceptName;
  };

  IconclassUtil.getStandardTextFromObject = function(context, object, cdata, databaseLanguages) {
    var _standard, activeFrontendLanguage, i, l10nObject, l10nObjectKey, l10nObjectValue, language, len, ref, shortenedDatabaseLanguages, shortenedLanguage, standardTextString;
    if (databaseLanguages == null) {
      databaseLanguages = false;
    }
    if (databaseLanguages === false) {
      databaseLanguages = ez5.loca.getDatabaseLanguages();
    }
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    activeFrontendLanguage = null;
    if (context) {
      activeFrontendLanguage = context.getFrontendLanguage();
    }
    if (cdata != null ? cdata.frontendLanguage : void 0) {
      if ((cdata != null ? (ref = cdata.frontendLanguage) != null ? ref.length : void 0 : void 0) === 2) {
        activeFrontendLanguage = cdata.frontendLanguage;
      }
    }
    if (Array.isArray(object)) {
      object = object[0];
    }
    _standard = {};
    standardTextString = '';
    l10nObject = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    if (object.txt[activeFrontendLanguage]) {
      standardTextString = object.txt[activeFrontendLanguage];
    } else {
      standardTextString = object.txt[Object.keys(object.txt)[0]];
    }
    standardTextString = object.n + ' - ' + standardTextString;
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      shortenedLanguage = l10nObjectKey.split('-')[0];
      if (object.txt[shortenedLanguage]) {
        l10nObject[l10nObjectKey] = object.n + ' - ' + object.txt[shortenedLanguage];
      }
    }
    _standard.l10ntext = l10nObject;
    return _standard;
  };

  IconclassUtil.getFullTextFromObject = function(object, databaseLanguages) {
    var _fulltext, arrayValue, arrayValueOfObject, fullTextString, i, j, k, key, l, l10nObject, l10nObjectKey, l10nObjectValue, l10nObjectWithShortenedLanguages, l10nObjectWithShortenedLanguagesKey, l10nObjectWithShortenedLanguagesValue, language, len, len1, len2, len3, objectKey, objectKeys, objectValue, propertyType, ref, ref1, shortenedDatabaseLanguages, shortenedLanguage, value;
    if (databaseLanguages == null) {
      databaseLanguages = false;
    }
    if (databaseLanguages === false) {
      databaseLanguages = ez5.loca.getDatabaseLanguages();
    }
    shortenedDatabaseLanguages = databaseLanguages.map(function(value, key, array) {
      return value.split('-').shift();
    });
    if (Array.isArray(object)) {
      object = object[0];
    }
    _fulltext = {};
    fullTextString = '';
    l10nObject = {};
    l10nObjectWithShortenedLanguages = {};
    for (i = 0, len = databaseLanguages.length; i < len; i++) {
      language = databaseLanguages[i];
      l10nObject[language] = '';
    }
    for (j = 0, len1 = shortenedDatabaseLanguages.length; j < len1; j++) {
      language = shortenedDatabaseLanguages[j];
      l10nObjectWithShortenedLanguages[language] = '';
    }
    objectKeys = ["kw", "n", "txt"];
    for (key in object) {
      value = object[key];
      if (objectKeys.includes(key)) {
        propertyType = typeof value;
        if (propertyType === 'string') {
          fullTextString += value + ' ';
          for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
            l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
            l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + value + ' ';
          }
        }
        if (propertyType === 'object') {
          if (Array.isArray(object[key])) {
            ref = object[key];
            for (k = 0, len2 = ref.length; k < len2; k++) {
              arrayValue = ref[k];
              fullTextString += arrayValue + ' ';
              for (l10nObjectWithShortenedLanguagesKey in l10nObjectWithShortenedLanguages) {
                l10nObjectWithShortenedLanguagesValue = l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey];
                l10nObjectWithShortenedLanguages[l10nObjectWithShortenedLanguagesKey] = l10nObjectWithShortenedLanguagesValue + arrayValue + ' ';
              }
            }
          } else {
            ref1 = object[key];
            for (objectKey in ref1) {
              objectValue = ref1[objectKey];
              if (Array.isArray(objectValue)) {
                for (l = 0, len3 = objectValue.length; l < len3; l++) {
                  arrayValueOfObject = objectValue[l];
                  fullTextString += arrayValueOfObject + ' ';
                  if (l10nObjectWithShortenedLanguages.hasOwnProperty(objectKey)) {
                    l10nObjectWithShortenedLanguages[objectKey] += arrayValueOfObject + ' ';
                  }
                }
              }
              if (typeof objectValue === 'string') {
                fullTextString += objectValue + ' ';
                if (l10nObjectWithShortenedLanguages.hasOwnProperty(objectKey)) {
                  l10nObjectWithShortenedLanguages[objectKey] += objectValue + ' ';
                }
              }
            }
          }
        }
      }
    }
    for (l10nObjectKey in l10nObject) {
      l10nObjectValue = l10nObject[l10nObjectKey];
      shortenedLanguage = l10nObjectKey.split('-')[0];
      if (l10nObjectWithShortenedLanguages[shortenedLanguage]) {
        l10nObject[l10nObjectKey] = l10nObjectWithShortenedLanguages[shortenedLanguage];
      }
    }
    _fulltext.text = fullTextString;
    _fulltext.l10ntext = l10nObject;
    return _fulltext;
  };

  return IconclassUtil;

})();
