// Generated by CoffeeScript 1.12.7
ez5.IUCNUtil = (function() {
  function IUCNUtil() {}

  IUCNUtil.LINK_FIELD_SEPARATOR = ":__link:";

  IUCNUtil.getFieldType = function() {
    return "custom:base.custom-data-type-iucn.iucn";
  };

  IUCNUtil.getAssessmentData = function(plugin_endpoint, assessment_id) {
    return ez5.IUCNUtil.getFromPlugin("/assessment/" + assessment_id, plugin_endpoint);
  };

  IUCNUtil.searchByTaxonname = function(plugin_endpoint, genus, species) {
    return ez5.IUCNUtil.getFromPlugin("/taxa/scientific_name?genus_name=" + encodeURIComponent(genus) + "&species_name=" + encodeURIComponent(species), plugin_endpoint);
  };

  IUCNUtil.searchBySisTaxonId = function(plugin_endpoint, sis_taxon_id) {
    return ez5.IUCNUtil.getFromPlugin("/taxa/sis/" + sis_taxon_id, plugin_endpoint);
  };

  IUCNUtil.getFromPlugin = function(iucn_query, url) {
    var url_data, xhr;
    if (url == null) {
      url = null;
    }
    url = url || ez5.IUCNUtil.getPluginEndpoint();
    url_data = {
      "iucn_query": iucn_query
    };
    xhr = new CUI.XHR({
      method: "GET",
      url: CUI.appendToUrl(url, url_data),
      headers: {
        "authorization": 'Bearer ' + ez5.session.token,
        "x-easydb-token": ez5.session.token
      }
    });
    return xhr.start();
  };

  IUCNUtil.setObjectData = function(object, data) {
    var i, len, n, ref, ref1;
    if (CUI.util.isEmpty(data)) {
      delete object.idTaxon;
      delete object.scientificName;
      delete object.mainCommonName;
      delete object.category;
      delete object.redList;
      return;
    }
    if (CUI.util.isArray(data)) {
      data = data[0];
    }
    object.redList = false;
    object.category = "";
    object.mainCommonName = "";
    object.scientificName = data.scientific_name;
    if (!data.sis_taxon_id) {
      return object;
    }
    object.idTaxon = "" + data.sis_taxon_id;
    if (!data.taxon) {
      return object;
    }
    object.scientificName = data.taxon.scientific_name || "";
    if (data.red_list_category.code) {
      object.category = data.red_list_category.code;
      object.redList = (ref = data.red_list_category.code) === "EX" || ref === "EW" || ref === "CR" || ref === "EN" || ref === "VU";
    }
    if (!data.taxon.common_names) {
      return object;
    }
    if (!CUI.util.isArray(data.taxon.common_names)) {
      return object;
    }
    ref1 = data.taxon.common_names;
    for (i = 0, len = ref1.length; i < len; i++) {
      n = ref1[i];
      if (!n.main) {
        continue;
      }
      if (!n.name) {
        continue;
      }
      object.mainCommonName = n.name;
      break;
    }
    return object;
  };

  IUCNUtil.isEqual = function(objectOne, objectTwo) {
    var i, key, len, ref;
    ref = ["idTaxon", "scientificName", "mainCommonName", "category", "redList"];
    for (i = 0, len = ref.length; i < len; i++) {
      key = ref[i];
      if (!CUI.util.isEqual(objectOne[key], objectTwo[key])) {
        return false;
      }
    }
    return true;
  };

  IUCNUtil.getSaveData = function(data) {
    var saveData;
    saveData = {
      idTaxon: data.idTaxon,
      scientificName: data.scientificName,
      mainCommonName: data.mainCommonName,
      category: data.category,
      redList: data.redList,
      _fulltext: {
        text: data.scientificName + " " + data.mainCommonName,
        string: data.idTaxon != null ? "" + data.idTaxon : ""
      },
      _standard: {
        text: data.scientificName
      }
    };
    return saveData;
  };

  IUCNUtil.getSettings = function() {
    return ez5.session.getBaseConfig("plugin", "custom-data-type-iucn").iucn_settings;
  };

  IUCNUtil.getPluginEndpoint = function() {
    var ref;
    return ((ref = ez5.pluginManager.getPlugin('custom-data-type-iucn')) != null ? ref.__plugin_url : void 0) + "/proxy_api_v4";
  };

  IUCNUtil.getLatestAssessmentIdFromSearchResult = function(data) {
    var a, deferred, i, len, ref;
    deferred = new CUI.Deferred();
    if (!data) {
      return {};
    }
    if (!data.assessments) {
      return {};
    }
    if (!CUI.util.isArray(data.assessments)) {
      return {};
    }
    ref = data.assessments;
    for (i = 0, len = ref.length; i < len; i++) {
      a = ref[i];
      if (!a.latest) {
        continue;
      }
      if (!a.assessment_id) {
        continue;
      }
      return a.assessment_id;
    }
    return 0;
  };

  return IUCNUtil;

})();
// Generated by CoffeeScript 1.12.7
var CustomDataTypeIUCN,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeIUCN = (function(superClass) {
  extend(CustomDataTypeIUCN, superClass);

  function CustomDataTypeIUCN() {
    this.getQueryFieldBadge = bind(this.getQueryFieldBadge, this);
    return CustomDataTypeIUCN.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeIUCN.prototype.getCustomDataTypeName = function() {
    return ez5.IUCNUtil.getFieldType();
  };

  CustomDataTypeIUCN.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.iucn.name");
  };

  CustomDataTypeIUCN.prototype.getCustomDataOptionsInDatamodelInfo = function() {
    return [];
  };

  CustomDataTypeIUCN.prototype.renderSearchInput = function(data, opts) {
    if (opts == null) {
      opts = {};
    }
    return new SearchToken({
      column: this,
      data: data,
      fields: opts.fields
    }).getInput().DOM;
  };

  CustomDataTypeIUCN.prototype.getFieldNamesForSearch = function() {
    return this.__getFieldNames();
  };

  CustomDataTypeIUCN.prototype.getFieldNamesForSuggest = function() {
    return this.__getFieldNames();
  };

  CustomDataTypeIUCN.prototype.getSearchFilter = function(data, key) {
    var filter, phrase, ref, str, val;
    if (key == null) {
      key = this.name();
    }
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".scientificName"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    }
    filter = CustomDataTypeIUCN.__super__.getSearchFilter.call(this, data, key);
    if (filter) {
      return filter;
    }
    if (CUI.util.isEmpty(data[key])) {
      return;
    }
    val = data[key];
    ref = Search.getPhrase(val), str = ref[0], phrase = ref[1];
    switch (data[key + ":type"]) {
      case "token":
      case "fulltext":
      case void 0:
        filter = {
          type: "match",
          mode: data[key + ":mode"],
          fields: this.getFieldNamesForSearch(),
          string: str,
          phrase: phrase
        };
        break;
      case "field":
        filter = {
          type: "in",
          fields: this.getFieldNamesForSearch(),
          "in": [str]
        };
    }
    return filter;
  };

  CustomDataTypeIUCN.prototype.__getFieldNames = function() {
    var fieldNames;
    fieldNames = [this.fullName() + ".idTaxon", this.fullName() + ".scientificName", this.fullName() + ".mainCommonName"];
    return fieldNames;
  };

  CustomDataTypeIUCN.prototype.getQueryFieldBadge = function(data) {
    var value;
    if (data[(this.name()) + ":unset"]) {
      value = $$("text.column.badge.without");
    } else {
      value = data[this.name()];
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeIUCN.prototype.renderEditorInput = function(data) {
    var div, searchField, toggleOutput;
    data = this.__initData(data);
    div = CUI.dom.div();
    toggleOutput = (function(_this) {
      return function() {
        var output;
        CUI.Events.trigger({
          node: div,
          type: "editor-changed"
        });
        if (data.idTaxon || data.scientificName) {
          output = _this.__getOutput(data, true, function() {
            ez5.IUCNUtil.setObjectData(data);
            return toggleOutput();
          });
          return CUI.dom.replace(div, output);
        } else {
          return CUI.dom.replace(div, searchField);
        }
      };
    })(this);
    searchField = this.__getSearchField(data, toggleOutput);
    toggleOutput();
    return div;
  };

  CustomDataTypeIUCN.prototype.__getSearchField = function(data, onSearch) {
    var doSearch, layout, searchButton, searchInput, toggleButton;
    doSearch = (function(_this) {
      return function() {
        var genus, parts, species;
        searchButton.startSpinner();
        if (isNaN(data.searchName)) {
          parts = data.searchName.split(/\s+/).filter(function(part) {
            return part.trim() !== "";
          });
          genus = "";
          species = "";
          if (parts.length > 0) {
            genus = parts[0];
          }
          if (parts.length > 1) {
            species = parts[1];
          }
          return ez5.IUCNUtil.searchByTaxonname(ez5.IUCNUtil.getPluginEndpoint(), genus, species).done(function(response) {
            var _assessment_id;
            if (!response) {
              CUI.alert({
                text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                markdown: true
              });
              return;
            }
            _assessment_id = ez5.IUCNUtil.getLatestAssessmentIdFromSearchResult(response);
            if (_assessment_id === 0 || CUI.util.isEmpty(response)) {
              ez5.IUCNUtil.setObjectData(data, {
                scientific_name: data.searchName
              });
              return onSearch();
            } else {
              return ez5.IUCNUtil.getAssessmentData(ez5.IUCNUtil.getPluginEndpoint(), _assessment_id).done(function(response) {
                if (!response) {
                  CUI.alert({
                    text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                    markdown: true
                  });
                  return;
                }
                ez5.IUCNUtil.setObjectData(data, response);
                return onSearch();
              }).fail(function(e) {
                ez5.IUCNUtil.setObjectData(data, {
                  scientific_name: data.searchName
                });
              });
            }
          }).always(function() {
            return searchButton.stopSpinner();
          });
        } else {
          return ez5.IUCNUtil.searchBySisTaxonId(ez5.IUCNUtil.getPluginEndpoint(), data.searchName).done(function(response) {
            var _assessment_id;
            if (!response) {
              CUI.alert({
                text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                markdown: true
              });
              return;
            }
            _assessment_id = ez5.IUCNUtil.getLatestAssessmentIdFromSearchResult(response);
            if (_assessment_id === 0 || CUI.util.isEmpty(response)) {
              ez5.IUCNUtil.setObjectData(data, {
                scientific_name: data.searchName
              });
              return onSearch();
            } else {
              return ez5.IUCNUtil.getAssessmentData(ez5.IUCNUtil.getPluginEndpoint(), _assessment_id).done(function(response) {
                if (!response) {
                  CUI.alert({
                    text: $$("custom.data.type.iucn.editor.search.token-invalid"),
                    markdown: true
                  });
                  return;
                }
                ez5.IUCNUtil.setObjectData(data, response);
                return onSearch();
              }).fail(function(e) {
                ez5.IUCNUtil.setObjectData(data, {
                  scientific_name: data.searchName
                });
              });
            }
          }).always(function() {
            return searchButton.stopSpinner();
          });
        }
      };
    })(this);
    searchButton = new CUI.Button({
      icon: "search",
      "class": "ez5-custom-data-type-iucn-search-button",
      tooltip: {
        text: $$("custom.data.type.iucn.editor.search-button.tooltip")
      },
      onClick: doSearch
    });
    toggleButton = function() {
      if (CUI.util.isEmpty(data.searchName)) {
        searchButton.disable();
      } else {
        searchButton.enable();
      }
    };
    searchInput = new CUI.Input({
      data: data,
      "class": "ez5-custom-data-type-iucn-search-input",
      name: "searchName",
      placeholder: $$("custom.data.type.iucn.editor.search-input.placeholder"),
      onDataInit: toggleButton,
      onDataChanged: toggleButton
    });
    searchInput.start();
    CUI.Events.listen({
      node: searchInput,
      type: "keyup",
      call: (function(_this) {
        return function(ev) {
          if (ev.keyCode() !== 13) {
            return;
          }
          doSearch();
        };
      })(this)
    });
    layout = new CUI.HorizontalLayout({
      center: {
        content: searchInput
      },
      right: {
        content: searchButton
      }
    });
    return layout;
  };

  CustomDataTypeIUCN.prototype.__getOutput = function(data, isEditor, onDelete) {
    var content, idRedListTag, layout, menuButton, ref, rightContent, statusText, tag;
    if (isEditor == null) {
      isEditor = false;
    }
    if (data.redList) {
      statusText = $$("custom.data.type.iucn.output.status.red-list.text");
    } else {
      statusText = $$("custom.data.type.iucn.output.status.not-on-red-list.text");
    }
    if (isEditor) {
      menuButton = new LocaButton({
        loca_key: "custom.data.type.iucn.editor.menu.button",
        icon: "ellipsis_v",
        icon_right: false,
        appearance: "flat",
        menu: {
          items: [
            new LocaButton({
              loca_key: "custom.data.type.iucn.editor.menu.delete-button",
              onClick: (function(_this) {
                return function() {
                  return typeof onDelete === "function" ? onDelete() : void 0;
                };
              })(this)
            })
          ]
        }
      });
    }
    rightContent = new CUI.HorizontalLayout({
      right: {
        content: ""
      }
    });
    if (data.redList) {
      idRedListTag = (ref = ez5.IUCNUtil.getSettings()) != null ? ref.tag_red : void 0;
      tag = ez5.tagForm.findTagByAnyId(idRedListTag);
      if (tag) {
        rightContent.append(tag.getLabel(), "center");
      }
    }
    if (isEditor) {
      rightContent.append(menuButton, "right");
    }
    if (data.idTaxon) {
      content = new CUI.VerticalList({
        content: [
          new CUI.ButtonHref({
            text: data.mainCommonName,
            "class": "pluginResultButton",
            appearance: "link",
            href: "https://apistaging.iucnredlist.org/species/" + data.idTaxon,
            target: "_blank"
          }), new CUI.Label({
            text: data.idTaxon + " - " + data.scientificName,
            appearance: "secondary"
          }), new CUI.Label({
            text: statusText,
            appearance: "secondary"
          })
        ]
      });
    } else {
      content = new CUI.Label({
        text: data.scientificName
      });
    }
    layout = new CUI.HorizontalLayout({
      "class": "ez5-field-object ez5-custom-data-type-iucn-card",
      left: {
        content: this.__getLogoImage()
      },
      center: {
        content: content
      },
      right: {
        content: rightContent
      }
    });
    return layout;
  };

  CustomDataTypeIUCN.prototype.renderDetailOutput = function(data, _, opts) {
    data = this.__initData(data);
    return this.__getOutput(data);
  };

  CustomDataTypeIUCN.prototype.getSaveData = function(data, save_data) {
    data = data[this.name()];
    if (CUI.util.isEmpty(data)) {
      return save_data[this.name()] = null;
    }
    return save_data[this.name()] = ez5.IUCNUtil.getSaveData(data);
  };

  CustomDataTypeIUCN.prototype.isEmpty = function(data, _, opts) {
    if (opts == null) {
      opts = {};
    }
    data = data[this.name()];
    if (opts.mode === "expert") {
      return CUI.util.isEmpty(data != null ? data.trim() : void 0);
    }
    return CUI.util.isEmpty(data != null ? data.idTaxon : void 0) && CUI.util.isEmpty(data != null ? data.scientificName : void 0);
  };

  CustomDataTypeIUCN.prototype.__initData = function(data) {
    var initData;
    if (!data[this.name()]) {
      initData = {};
      data[this.name()] = initData;
    } else {
      initData = data[this.name()];
    }
    return initData;
  };

  CustomDataTypeIUCN.prototype.__getLogoImage = function() {
    var plugin;
    if (this.__previewImage) {
      return this.__previewImage;
    }
    plugin = ez5.pluginManager.getPlugin("custom-data-type-iucn");
    this.__previewImage = new Image();
    this.__previewImage.src = plugin.getBaseURL() + plugin.getWebfrontend().logo;
    return this.__previewImage;
  };

  CustomDataTypeIUCN.prototype.renderFieldAsGroup = function() {
    return false;
  };

  CustomDataTypeIUCN.prototype.supportsStandard = function() {
    return true;
  };

  return CustomDataTypeIUCN;

})(CustomDataType);

CustomDataType.register(CustomDataTypeIUCN);
// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.CustomBaseConfigIUCN = (function(superClass) {
  extend(CustomBaseConfigIUCN, superClass);

  function CustomBaseConfigIUCN() {
    return CustomBaseConfigIUCN.__super__.constructor.apply(this, arguments);
  }

  CustomBaseConfigIUCN.prototype.getFieldDefFromParm = function(baseConfig, fieldName, def) {
    var field, i, j, len, len1, options, ref, ref1, tag, tagGroup;
    switch (def.plugin_type) {
      case 'iucn_tag':
        options = [
          {
            text: $$("server.config.parameter.system.iucn_settings.tag.placeholder." + fieldName),
            value: null
          }
        ];
        ref = ez5.tagForm.tagGroups;
        for (i = 0, len = ref.length; i < len; i++) {
          tagGroup = ref[i];
          options.push({
            label: tagGroup.getDisplayName()
          });
          ref1 = tagGroup.getTags();
          for (j = 0, len1 = ref1.length; j < len1; j++) {
            tag = ref1[j];
            options.push({
              text: tag.getDisplayName(),
              value: tag.getId()
            });
          }
        }
        field = {
          type: CUI.Select,
          name: fieldName,
          options: options
        };
        break;
      case 'iucn_field_name':
        options = this.__searchInAllObjecttypes();
        field = {
          type: CUI.Select,
          name: fieldName,
          options: options
        };
    }
    return field;
  };

  CustomBaseConfigIUCN.prototype.__searchInAllObjecttypes = function() {
    var _, _options, addField, getFields, getLinkedFields, objecttype, options, optionsByObjecttype, ref;
    optionsByObjecttype = {};
    addField = function(tableName, field, path, fieldPath) {
      var label, value;
      if (path == null) {
        path = "";
      }
      if (fieldPath == null) {
        fieldPath = [];
      }
      if (!(field instanceof CustomDataTypeIUCN)) {
        return;
      }
      value = path + field.fullName();
      if (optionsByObjecttype[tableName].some(function(option) {
        return option.value === value;
      })) {
        return;
      }
      fieldPath.push(field);
      label = fieldPath.map(function(_field) {
        return _field.fullNameLocalized();
      }).join(" / ");
      return optionsByObjecttype[tableName].push({
        text: label,
        value: value
      });
    };
    getLinkedFields = function(linkedField) {
      var idTable, mask, path, tableName;
      idTable = linkedField.linkMask().table.id();
      path = linkedField.fullName() + ez5.IUCNUtil.LINK_FIELD_SEPARATOR;
      tableName = path.split(".")[0];
      mask = Mask.getMaskByMaskName("_all_fields", idTable);
      mask.invokeOnFields("all", true, ((function(_this) {
        return function(field) {
          return addField(tableName, field, path, [linkedField]);
        };
      })(this)));
    };
    getFields = function(idTable) {
      var mask, tableName, tableNameLocalized;
      mask = Mask.getMaskByMaskName("_all_fields", idTable);
      if (!mask.hasTags()) {
        return;
      }
      tableName = mask.table.name();
      tableNameLocalized = mask.table.nameLocalized();
      if (!optionsByObjecttype[tableName]) {
        optionsByObjecttype[tableName] = [
          {
            label: tableNameLocalized
          }
        ];
      }
      return mask.invokeOnFields("all", true, ((function(_this) {
        return function(field) {
          var _field, i, len, ref;
          if (field instanceof MaskSplitter) {
            return;
          }
          if (field.isTopLevelField() || field.isSystemField()) {
            return;
          }
          if (field instanceof LinkedObject) {
            if (field.table.id() === field.linkMask().table.id()) {
              return;
            }
            getLinkedFields(field);
            return;
          } else if (field instanceof ReverseLinkedTable) {
            ref = field.getFields("all");
            for (i = 0, len = ref.length; i < len; i++) {
              _field = ref[i];
              if (!(_field instanceof LinkedObject)) {
                addField(tableName, _field);
                continue;
              }
              getLinkedFields(_field);
            }
            return;
          }
          addField(tableName, field);
        };
      })(this)));
    };
    ref = ez5.schema.CURRENT._objecttype_by_name;
    for (_ in ref) {
      objecttype = ref[_];
      if (objecttype.name.indexOf('@') > -1) {
        continue;
      }
      getFields(objecttype.table_id);
    }
    options = [
      {
        text: $$("server.config.parameter.system.iucn_settings.iucn_fields.placeholder"),
        value: null
      }
    ];
    for (_ in optionsByObjecttype) {
      _options = optionsByObjecttype[_];
      if (_options.length === 1) {
        continue;
      }
      options = options.concat(_options);
    }
    return options;
  };

  return CustomBaseConfigIUCN;

})(BaseConfigPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return BaseConfig.registerPlugin(new ez5.CustomBaseConfigIUCN());
  };
})(this));
