// Generated by CoffeeScript 1.12.7
ez5.IUCNUtil = (function() {
  function IUCNUtil() {}

  IUCNUtil.LINK_FIELD_SEPARATOR = ":__link:";

  IUCNUtil.getFieldType = function() {
    return "custom:base.custom-data-type-iucn.iucn";
  };

  IUCNUtil.getAssessmentData = function(plugin_endpoint, assessment_id) {
    return ez5.IUCNUtil.getFromPlugin("/assessment/" + assessment_id, plugin_endpoint);
  };

  IUCNUtil.searchByTaxonname = function(plugin_endpoint, genus, species) {
    return ez5.IUCNUtil.getFromPlugin("/taxa/scientific_name?genus_name=" + encodeURIComponent(genus) + "&species_name=" + encodeURIComponent(species), plugin_endpoint);
  };

  IUCNUtil.searchBySisTaxonId = function(plugin_endpoint, sis_taxon_id) {
    return ez5.IUCNUtil.getFromPlugin("/taxa/sis/" + sis_taxon_id, plugin_endpoint);
  };

  IUCNUtil.getFromPlugin = function(iucn_query, url) {
    var url_data, xhr;
    if (url == null) {
      url = null;
    }
    url = url || ez5.IUCNUtil.getPluginEndpoint();
    url_data = {
      "iucn_query": iucn_query
    };
    xhr = new CUI.XHR({
      method: "GET",
      url: CUI.appendToUrl(url, url_data),
      headers: {
        "authorization": 'Bearer ' + ez5.session.token,
        "x-easydb-token": ez5.session.token
      }
    });
    return xhr.start();
  };

  IUCNUtil.setObjectData = function(object, data) {
    var i, len, n, ref, ref1;
    if (CUI.util.isEmpty(data)) {
      delete object.idTaxon;
      delete object.scientificName;
      delete object.mainCommonName;
      delete object.category;
      delete object.redList;
      return;
    }
    if (CUI.util.isArray(data)) {
      data = data[0];
    }
    object.redList = false;
    object.category = "";
    object.mainCommonName = "";
    object.scientificName = data.scientific_name;
    if (!data.sis_taxon_id) {
      return object;
    }
    object.idTaxon = "" + data.sis_taxon_id;
    if (!data.taxon) {
      return object;
    }
    object.scientificName = data.taxon.scientific_name || "";
    if (data.red_list_category.code) {
      object.category = data.red_list_category.code;
      object.redList = (ref = data.red_list_category.code) === "EX" || ref === "EW" || ref === "CR" || ref === "EN" || ref === "VU";
    }
    if (!data.taxon.common_names) {
      return object;
    }
    if (!CUI.util.isArray(data.taxon.common_names)) {
      return object;
    }
    ref1 = data.taxon.common_names;
    for (i = 0, len = ref1.length; i < len; i++) {
      n = ref1[i];
      if (!n.main) {
        continue;
      }
      if (!n.name) {
        continue;
      }
      object.mainCommonName = n.name;
      break;
    }
    return object;
  };

  IUCNUtil.isEqual = function(objectOne, objectTwo) {
    var i, key, len, ref;
    ref = ["idTaxon", "scientificName", "mainCommonName", "category", "redList"];
    for (i = 0, len = ref.length; i < len; i++) {
      key = ref[i];
      if (!CUI.util.isEqual(objectOne[key], objectTwo[key])) {
        return false;
      }
    }
    return true;
  };

  IUCNUtil.getSaveData = function(data) {
    var saveData;
    saveData = {
      idTaxon: data.idTaxon,
      scientificName: data.scientificName,
      mainCommonName: data.mainCommonName,
      category: data.category,
      redList: data.redList,
      _fulltext: {
        text: data.scientificName + " " + data.mainCommonName,
        string: data.idTaxon != null ? "" + data.idTaxon : ""
      },
      _standard: {
        text: data.scientificName
      }
    };
    return saveData;
  };

  IUCNUtil.getSettings = function() {
    return ez5.session.getBaseConfig("plugin", "custom-data-type-iucn").iucn_settings;
  };

  IUCNUtil.getPluginEndpoint = function() {
    var ref;
    return ((ref = ez5.pluginManager.getPlugin('custom-data-type-iucn')) != null ? ref.__plugin_url : void 0) + "/proxy_api_v4";
  };

  IUCNUtil.getLatestAssessmentIdFromSearchResult = function(data) {
    var a, deferred, i, len, ref;
    deferred = new CUI.Deferred();
    if (!data) {
      return {};
    }
    if (!data.assessments) {
      return {};
    }
    if (!CUI.util.isArray(data.assessments)) {
      return {};
    }
    ref = data.assessments;
    for (i = 0, len = ref.length; i < len; i++) {
      a = ref[i];
      if (!a.latest) {
        continue;
      }
      if (!a.assessment_id) {
        continue;
      }
      return a.assessment_id;
    }
    return 0;
  };

  return IUCNUtil;

})();
