// Generated by CoffeeScript 1.12.7
var LocationUtils;

LocationUtils = (function() {
  function LocationUtils() {}

  LocationUtils.getSaveData = function(data) {
    var fullText, mapPosition, position, saveData;
    mapPosition = data != null ? data.mapPosition : void 0;
    position = mapPosition != null ? mapPosition.position : void 0;
    if (!position || !CUI.Map.isValidPosition(position)) {
      return null;
    }
    saveData = {
      mapPosition: mapPosition
    };
    if (!CUI.util.isEmpty(data.displayValue)) {
      saveData.displayValue = data.displayValue;
      fullText = Object.values(data.displayValue).filter(function(value) {
        return !!value;
      }).join(", ");
      saveData._standard = {
        l10ntext: data.displayValue
      };
      saveData._fulltext = {
        l10ntext: data.displayValue,
        text: fullText,
        string: fullText
      };
    }
    if (data.group) {
      saveData.group = data.group;
    }
    return saveData;
  };

  return LocationUtils;

})();
// Generated by CoffeeScript 1.12.7

/*
 * easydb-custom-data-type-location
 * Copyright (c) 2013 - 2016 Programmfabrik GmbH
 * MIT Licence
 * https://github.com/programmfabrik/coffeescript-ui, http://www.coffeescript-ui.org
 */
var CustomDataTypeLocation,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeLocation = (function(superClass) {
  extend(CustomDataTypeLocation, superClass);

  function CustomDataTypeLocation() {
    return CustomDataTypeLocation.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeLocation.__groupOptions = [
    {
      value: {
        type: "long_dash",
        options: {
          polyline: "10,8",
          color: "black"
        }
      },
      text: "── ── ── ──"
    }, {
      value: {
        type: "short_dash",
        options: {
          polyline: "5,5",
          color: "black"
        }
      },
      text: "─ ─ ─ ─ ─ ─ ─"
    }, {
      value: {
        type: "dot_dash",
        options: {
          polyline: "1,4",
          color: "black"
        }
      },
      text: "∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙∙"
    }
  ];

  CustomDataTypeLocation.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-location.location";
  };

  CustomDataTypeLocation.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.location.name");
  };

  CustomDataTypeLocation.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var preffix, tags;
    preffix = "custom.data.type.location.setting.schema.rendered_options.";
    tags = [];
    if (custom_settings["type"]) {
      tags.push($$(preffix + custom_settings["type"]["value"]));
    }
    return tags;
  };

  CustomDataTypeLocation.prototype.renderFieldAsGroup = function(_, __, opts) {
    return opts.mode === 'editor' || opts.mode === 'editor-template';
  };

  CustomDataTypeLocation.prototype.renderEditorInput = function(data) {
    var form, initData;
    initData = this.__initData(data);
    form = this.__initForm(initData);
    return form;
  };

  CustomDataTypeLocation.prototype.isVisible = function(mode, opts) {
    return CustomDataTypeLocation.__super__.isVisible.call(this, mode, opts) && mode !== "expert";
  };

  CustomDataTypeLocation.prototype.isEmpty = function(data) {
    var isEmpty, position, ref;
    isEmpty = CustomDataTypeLocation.__super__.isEmpty.call(this, data);
    if (isEmpty) {
      return isEmpty;
    }
    position = (ref = data[this.name()].mapPosition) != null ? ref.position : void 0;
    if (!position) {
      return true;
    }
    return !CUI.Map.isValidPosition(position);
  };

  CustomDataTypeLocation.prototype.needsDirectRender = function() {
    return true;
  };

  CustomDataTypeLocation.prototype.__getOutputLabel = function(data) {
    var displayFormat, initData, label, position, ref;
    initData = this.__initData(data);
    position = (ref = initData.mapPosition) != null ? ref.position : void 0;
    if (!position) {
      return;
    }
    label = this.__buildDisplayNameOutput(initData);
    if (!label) {
      displayFormat = CUI.MapInput.getDefaultDisplayFormat();
      label = new CUI.Label({
        text: CUI.util.formatCoordinates(position, displayFormat),
        size: "normal"
      });
    }
    return label;
  };

  CustomDataTypeLocation.prototype.renderTableOutput = function(data, top_level_data, opts) {
    return this.__getOutputLabel(data);
  };

  CustomDataTypeLocation.prototype.renderDetailOutput = function(data, _, opts) {
    var horizontalLayout, i, icon, initData, label, len, mapData, mapPlugin, plugin, plugins;
    initData = this.__initData(data);
    label = this.__getOutputLabel(data);
    icon = new CUI.IconMarker({
      icon: initData.mapPosition.iconName,
      color: initData.mapPosition.iconColor,
      tooltip: {
        text: $$("custom.data.type.location.detail.output.center-button")
      },
      onClick: (function(_this) {
        return function() {
          if (typeof MapDetailPlugin !== 'undefined') {
            return CUI.Events.trigger({
              type: "map-detail-center",
              info: position
            });
          } else {
            return console.warn("MapDetailPlugin is not available.");
          }
        };
      })(this)
    });
    horizontalLayout = new CUI.HorizontalLayout({
      maximize_horizontal: true,
      left: {
        content: icon
      },
      center: {
        content: label
      }
    });
    if (!opts.detail) {
      return horizontalLayout;
    }
    plugins = opts.detail.getPlugins();
    for (i = 0, len = plugins.length; i < len; i++) {
      plugin = plugins[i];
      if (typeof MapDetailPlugin !== 'undefined' && plugin instanceof MapDetailPlugin) {
        mapPlugin = plugin;
        break;
      }
    }
    if (mapPlugin) {
      mapData = {
        position: initData.mapPosition.position,
        iconColor: initData.mapPosition.iconColor,
        iconName: initData.mapPosition.iconName,
        group: initData.group
      };
      mapPlugin.addMarker(mapData);
      CUI.Events.listen({
        type: "map-detail-click-location",
        node: horizontalLayout,
        call: (function(_this) {
          return function(_, info) {
            if (info.data === mapData) {
              CUI.dom.scrollIntoView(horizontalLayout);
              CUI.dom.addClass(horizontalLayout, "ez5-marker-highlight");
              return CUI.setTimeout(function() {
                return CUI.dom.removeClass(horizontalLayout, "ez5-marker-highlight");
              }, 2000);
            }
          };
        })(this)
      });
      CUI.Events.listen({
        type: "map-detail-fullscreen-click-location",
        node: horizontalLayout,
        call: (function(_this) {
          return function(_, info) {
            var multiOutput, popover;
            if (info.data === mapData) {
              multiOutput = _this.__buildDisplayNameOutput(initData);
              popover = new CUI.Popover({
                element: info.icon,
                pane: {
                  padded: true,
                  content: multiOutput || CUI.util.formatCoordinates(initData.mapPosition.position, CUI.MapInput.getDefaultDisplayFormat())
                },
                onHide: function() {
                  return popover.destroy();
                }
              });
              return popover.show();
            }
          };
        })(this)
      });
    }
    return horizontalLayout;
  };

  CustomDataTypeLocation.prototype.__buildDisplayNameOutput = function(initData) {
    var _, hasDisplayValue, multiOutput, ref, value;
    hasDisplayValue = false;
    ref = initData.displayValue;
    for (_ in ref) {
      value = ref[_];
      if (!CUI.util.isEmpty(value)) {
        hasDisplayValue = true;
        break;
      }
    }
    if (hasDisplayValue) {
      multiOutput = (new CUI.MultiOutput({
        name: "displayValue",
        data: initData,
        control: ez5.loca.getLanguageControl(),
        showOnlyPreferredKey: false
      })).start();
    }
    return multiOutput;
  };

  CustomDataTypeLocation.prototype.__initData = function(data) {
    var group, i, initData, len, ref;
    if (!data[this.name()]) {
      initData = {};
      data[this.name()] = initData;
    } else {
      initData = data[this.name()];
    }
    if (initData.group) {
      ref = CustomDataTypeLocation.__groupOptions;
      for (i = 0, len = ref.length; i < len; i++) {
        group = ref[i];
        if (initData.group.type === group.value.type) {
          initData.group = group.value;
          break;
        }
      }
    }
    return initData;
  };

  CustomDataTypeLocation.prototype.__initForm = function(initData) {
    var fields, form;
    fields = [
      {
        type: CUI.MapInput,
        name: "mapPosition",
        mapOptions: {
          zoom: 2
        }
      }, {
        type: CUI.Form,
        horizontal: true,
        fields: [
          {
            type: CUI.Select,
            name: "group",
            options: (function(_this) {
              return function() {
                var group, i, len, options, ref;
                options = [
                  {
                    text: ez5.loca.text("custom.data.type.location.select.no.group"),
                    value: null
                  }
                ];
                ref = CustomDataTypeLocation.__groupOptions;
                for (i = 0, len = ref.length; i < len; i++) {
                  group = ref[i];
                  options.push({
                    text: group.text,
                    value: group.value
                  });
                }
                return options;
              };
            })(this)
          }
        ]
      }, {
        type: CUI.Form,
        fields: [
          {
            type: CUI.MultiInput,
            name: "displayValue",
            control: ez5.loca.getLanguageControl()
          }
        ]
      }
    ];
    form = new CUI.Form({
      maximize_horizontal: true,
      fields: fields,
      data: initData,
      onDataChanged: (function(_this) {
        return function() {
          return CUI.Events.trigger({
            node: form,
            type: "editor-changed"
          });
        };
      })(this)
    });
    form.start();
    return form;
  };

  CustomDataTypeLocation.prototype.getSaveData = function(data, save_data) {
    var ref;
    if (save_data == null) {
      save_data = {};
    }
    data = data[this.name()] || ((ref = data._template) != null ? ref[this.name()] : void 0);
    return save_data[this.name()] = LocationUtils.getSaveData(data);
  };

  CustomDataTypeLocation.prototype.isPluginSupported = function(plugin) {
    if (typeof MapDetailPlugin !== 'undefined' && plugin instanceof MapDetailPlugin) {
      return true;
    }
    return false;
  };

  CustomDataTypeLocation.prototype.allowsList = function() {
    return false;
  };

  CustomDataTypeLocation.prototype.supportsStandard = function() {
    return true;
  };

  return CustomDataTypeLocation;

})(CustomDataType);

CustomDataType.register(CustomDataTypeLocation);
