class Easydb4MigrationPlugin extends CUI.Plugin
	initOpts: ->
		super()
		@addOpts
			migration:
				check: Easydb4Migration
				mandatory: true

	name: ->
		"default"

	init: ->
		# init code for plugin

	payload: (filename, json, update, store_file) ->
		console.info("Plugin:", @name(), filename, json, update)

	splitByType: (filename, json, update, store_file, tn, col, obj_type_map = null, obj_type_func = null) ->

		payloads = {}

		for obj in json.objects
			typ = obj[tn][col]

			if CUI.util.isEmpty(typ)
				typ = "undefined"

			obj_type = tn+"_"+typ
			if obj_type_map
				obj_type = obj_type_map[obj_type]

			if obj_type_func
				obj_type = obj_type_func(obj)

			if not obj_type
				@_migration.logwarn("Object type '"+tn+"_"+typ+"' not found in mapping. Setting type to 'unknown'.")
				typ = "unknown"
				obj_type = tn+"_unknown"

			if CUI.util.isArray(obj_type)
				obj_types = obj_type
			else
				obj_types = [ obj_type ]

			for _obj_type in obj_types

				if not payloads[_obj_type]
					payloads[_obj_type] =
						import_type: "db"
						objecttype: _obj_type
						objects: []

				new_obj =
					_mask: "_all_fields"
					_objecttype: _obj_type

				new_obj[_obj_type] = CUI.util.copyObject(obj[tn], true)

				if typ == "unknown"
					new_obj[_obj_type].__unknown_type = obj[tn][col]

				delete(new_obj[_obj_type][col])
				payloads[_obj_type].objects.push(new_obj)


		for typ, payload of payloads
			filename_payload = ez5.bareBasename(filename)+"_"+typ+".json"
			store_file(filename_payload, payload)
			console.debug(typ, payload, filename_payload)

		return CUI.resolvedPromise(dont_store: true)
