// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Easydb4MigrationPlugin.KlosterkammerHannover = (function(superClass) {
  extend(KlosterkammerHannover, superClass);

  function KlosterkammerHannover() {
    return KlosterkammerHannover.__super__.constructor.apply(this, arguments);
  }

  KlosterkammerHannover.prototype.name = function() {
    return "klosterkammer-hannover";
  };

  KlosterkammerHannover.prototype.init = function() {
    var dfr1;
    this.tag_refs_by_name = {};
    this.sammlungsobjekte_typus = {};
    dfr1 = new CUI.Deferred();
    this._migration.query("SELECT\n	lk_obj_id AS id,\n	typus\nFROM \"source.public.sammlungsobjekte__objs\"\nWHERE lk_obj_id  IS NOT NULL\nAND   lk_bild_id IS NOT NULL\nAND   typus      IS NOT NULL\nAND   typus      != ''").fail(dfr1.reject).done((function(_this) {
      return function(result) {
        var i, len, ref, ref1, row;
        ref1 = result.rows;
        for (i = 0, len = ref1.length; i < len; i++) {
          row = ref1[i];
          _this.sammlungsobjekte_typus[row.id] = row.typus;
          if (!_this.tag_refs_by_name[row.typus]) {
            ref = row.typus.toLowerCase();
            ref = ref.replace(/[^a-z]/g, '_');
            _this.tag_refs_by_name[row.typus] = "typus:" + ref;
          }
        }
        console.debug("[klosterkammer-hannover]: loaded typus for objs:", result.rows.length, "typus entries");
        dfr1.resolve();
      };
    })(this));
    return dfr1.promise();
  };

  KlosterkammerHannover.prototype.payload = function(filename, json, update, store_file) {
    var i, len, name, obj, ref, ref1, ref2, tag_ref, tags_typus, typus;
    if (json.import_type === "tags") {
      tags_typus = [];
      ref1 = this.tag_refs_by_name;
      for (name in ref1) {
        ref = ref1[name];
        console.debug("[klosterkammer-hannover]: new tag | name:", name, "| reference:", ref);
        tags_typus.push({
          tag: {
            shortname: ref,
            reference: ref,
            displayname: {
              "de-DE": name
            },
            is_default: false,
            enabled: true,
            displaytype: "search",
            type: "individual"
          }
        });
      }
      json.tags.push({
        taggroup: {
          shortname: "typus",
          reference: "typus",
          type: "checkbox",
          displayname: {
            "de-DE": "Typus"
          }
        },
        _tags: tags_typus
      });
      return;
    }
    if (json.import_type !== "db") {
      return;
    }
    if (json.objecttype !== "objs") {
      return;
    }
    ref2 = json.objects;
    for (i = 0, len = ref2.length; i < len; i++) {
      obj = ref2[i];
      if (!obj["objs"]) {
        continue;
      }
      if (!obj["objs"]["__key"]) {
        continue;
      }
      if (!this.sammlungsobjekte_typus[obj.objs.__key]) {
        continue;
      }
      typus = this.sammlungsobjekte_typus[obj.objs.__key];
      tag_ref = this.tag_refs_by_name[typus];
      if (!tag_ref) {
        continue;
      }
      console.debug("[klosterkammer-hannover]: objs.__key:", obj.objs.__key, "| typus:", typus, "| tag_ref:", tag_ref);
      if (!obj._tags) {
        obj._tags = [];
      }
      obj._tags.push({
        "lookup:_id": {
          reference: tag_ref
        }
      });
    }
  };

  return KlosterkammerHannover;

})(Easydb4MigrationPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.KlosterkammerHannover);
  };
})(this));
