// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Easydb4MigrationPlugin.LmzStuttgart = (function(superClass) {
  extend(LmzStuttgart, superClass);

  function LmzStuttgart() {
    return LmzStuttgart.__super__.constructor.apply(this, arguments);
  }

  LmzStuttgart.prototype.name = function() {
    return "lmz-stuttgart";
  };

  LmzStuttgart.prototype.init = function() {
    var p1, p2, p3;
    this.schlagworte = {};
    p1 = this._migration.query(" SELECT * FROM \"source.lmz_stuttgart.schlagwort\" ");
    p1.done((function(_this) {
      return function(result) {
        var i, len, ref, results, row;
        ref = result.rows;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          row = ref[i];
          results.push(_this.schlagworte[row.id] = row);
        }
        return results;
      };
    })(this));
    this.bilder_urheber = {};
    p2 = this._migration.query(" SELECT lk_bild_id as bild_id, (vorname || ' ' || name) as urheber FROM \"source.lmz_stuttgart.bilder__urheber\" a LEFT JOIN \"source.lmz_stuttgart.urheber\" b ON (a.lk_urheber_id = b.id) ").done((function(_this) {
      return function(result) {
        var i, len, ref, results, row;
        ref = result.rows;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          row = ref[i];
          if (_this.bilder_urheber[row.bild_id]) {
            _this.bilder_urheber[row.bild_id] += "\n";
          } else {
            _this.bilder_urheber[row.bild_id] = "";
          }
          results.push(_this.bilder_urheber[row.bild_id] += row.urheber);
        }
        return results;
      };
    })(this));
    this.bilder_art = {};
    p3 = this._migration.query(" SELECT from_id AS bild_id, b.name, unique_identifier FROM \"source.lmz_stuttgart.eadb_links\" a JOIN \"source.lmz_stuttgart.art\" b ON (b.id = to_id) WHERE to_table_id=36 ").done((function(_this) {
      return function(result) {
        var i, len, ref, results, row;
        ref = result.rows;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          row = ref[i];
          if (!_this.bilder_art[row.bild_id]) {
            _this.bilder_art[row.bild_id] = [];
          }
          results.push(_this.bilder_art[row.bild_id].push(row));
        }
        return results;
      };
    })(this));
    this.attr_map = {};
    return CUI.when(p1, p2, p3);
  };

  LmzStuttgart.prototype.store = function(ot, value) {
    if (!this.attr_map[ot]) {
      this.attr_map[ot] = {};
    }
    if (this.attr_map[ot][value]) {
      this.attr_map[ot][value]++;
    } else {
      this.attr_map[ot][value] = 1;
    }
  };

  LmzStuttgart.prototype.storeAttrs = function(store_file) {
    var count, data, obj, ot, payload, promises, ref, value;
    console.debug("attr map:", this.attr_map);
    promises = [];
    ref = this.attr_map;
    for (ot in ref) {
      data = ref[ot];
      payload = {
        import_type: "db",
        objecttype: ot,
        objects: []
      };
      for (value in data) {
        count = data[value];
        obj = {
          _objecttype: ot,
          _mask: "_all_fields"
        };
        obj[ot] = {
          _version: 1,
          name: value
        };
        payload.objects.push(obj);
      }
      promises.push(store_file("art-split-" + ot + ".json", payload));
    }
    return CUI.when(promises);
  };

  LmzStuttgart.prototype.payload = function(filename, json, update, store_file) {
    var art, i, id, j, k, len, len1, len2, link, obj, ok_schlagworte, ref, ref1, ref2, schl, schlagwort;
    if (filename === "basetype_user_ldap_sso.json") {
      return this.storeAttrs(store_file);
    }
    if (!filename.startsWith("Bilder-")) {
      return;
    }
    link = function(ot, value) {
      var lobj;
      lobj = {
        _objecttype: ot,
        _mask: "_all_fields"
      };
      lobj[ot] = {};
      lobj[ot]["lookup:_id"] = {
        name: value
      };
      return lobj;
    };
    ref = json.objects;
    for (i = 0, len = ref.length; i < len; i++) {
      obj = ref[i];
      if (this.bilder_urheber[obj.objekte.__key]) {
        obj.objekte.urheber_migration = this.bilder_urheber[obj.objekte.__key];
      }
      ref1 = this.bilder_art[obj.objekte.__key] || [];
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        art = ref1[j];
        if (!art.unique_identifier) {
          this._migration.logwarn("Art '" + art.name + "' hat keinen unique_identifier. Objekt: " + obj.objekte.__key);
          continue;
        }
        if (art.unique_identifier.startsWith("/Art")) {
          obj.objekte.lk_art_id = link("art", art.name);
          this.store("art", art.name);
        }
        if (art.unique_identifier.startsWith("/Größe")) {
          obj.objekte.lk_groesse_id = link("groesse", art.name);
          this.store("groesse", art.name);
        }
        if (art.unique_identifier.startsWith("/Format")) {
          obj.objekte.lk_format_id = link("format", art.name);
          this.store("format", art.name);
        }
        if (art.unique_identifier.startsWith("/Farbe")) {
          if (!obj.objekte["_nested:objekte__farben"]) {
            obj.objekte["_nested:objekte__farben"] = [];
          }
          obj.objekte["_nested:objekte__farben"].push({
            lk_farbe_id: link("farben", art.name)
          });
          this.store("farben", art.name);
        }
      }
      ok_schlagworte = [];
      ref2 = obj.objekte["_nested:objekte__schlagworte"] || [];
      for (k = 0, len2 = ref2.length; k < len2; k++) {
        schlagwort = ref2[k];
        id = schlagwort["lk_schlagwort_id"]["schlagwort"]["lookup:_id"]["__not_mapped"];
        schl = this.schlagworte[id];
        if (schl) {
          schlagwort["lk_schlagwort_id"]["schlagwort"]["__id_in_easydb4"] = id;
          delete schlagwort["lk_schlagwort_id"]["schlagwort"]["lookup:_id"]["__not_mapped"];
          schlagwort["lk_schlagwort_id"]["schlagwort"]["lookup:_id"]["name"] = schl.name;
          ok_schlagworte.push(schlagwort);
        }
      }
      obj.objekte["_nested:objekte__schlagworte"] = ok_schlagworte;
      obj.objekte["_nested:objekte__eigennamen"] = [];
    }
  };

  return LmzStuttgart;

})(Easydb4MigrationPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.LmzStuttgart);
  };
})(this));
