class Easydb4MigrationPlugin.UniRostock extends Easydb4MigrationPlugin
	name: ->
		"uni-rostock"

	payload: (filename, json, update, store_file) ->
		map =
			"AttributeTyp:1": "attribut_kontrast"
			"AttributeTyp:2": "attribut_groesse"
			"AttributeTyp:3": "attribut_zustand"
			"AttributeTyp:4": "attribut_format"
			"AttributeTyp:6": "attribut_gefaessform"
			"AttributeTyp:7": "attribut_gattung"
			"AttributeTyp:8": "attribut_epoche"
			"AttributeTyp:9": "attribut_developmental_stage"
			"AttributeTyp:10": "attribut_sex"
			"AttributeTyp:11": "attribut_circulatory_system"
			"AttributeTyp:12": "attribut_fixation_storage"
			"AttributeTyp:142": "attribut_embedding_medium"
			"AttributeTyp:143": "attribut_thickness_of_sections"
			"AttributeTyp:144": "attribut_staining"
			"AttributeTyp:145": "attribut_sectioning_plane"
			"AttributeTyp:146": "attribut_resin_type"
			"AttributeTyp:147": "attribut_add_ons"
			"AttributeTyp:148": "attribut_post_injection_treatment_1"
			"AttributeTyp:149": "attribut_post_injection_treatment_2"
			"AttributeTyp:150": "attribut_sectioning"
			"AttributeTyp:151": "attribut_mounting_medium"
			"AttributeTyp:152": "attribut_dna_isolation_method"
			"AttributeTyp:153": "attribut_pcr_product_purification"
			"AttributeTyp:154": "attribut_sequencing"
			"AttributeTyp:155": "attribut_light_microscope"
			"AttributeTyp:156": "attribut_objective_magnification"
			"AttributeTyp:157": "attribut_correcture_lens"
			"AttributeTyp:158": "attribut_lm_mode"
			"AttributeTyp:159": "attribut_micro_ct"
			"AttributeTyp:160": "attribut_volume_reconstruction"
			"AttributeTyp:161": "attribut_drying_technique"
			"AttributeTyp:162": "attribut_sputter_coating"
			"AttributeTyp:163": "attribut_electronmicroscope"
			"AttributeTyp:164": "attribut_data_type"
			"AttributeTyp:165": "attribut_video_camera"

		if json.objecttype == "attribute"

			@__renameDuplicates(json.objects)

			return @splitByType(filename, json, update, store_file, "attribute", "typ", null, (object) =>
				key = @__getAttributeType(object)
				return map[key]
			)

	__renameDuplicates: (objects) ->
		map = {}
		for object in objects
			attributeType = @__getAttributeType(object)
			attributeMap = map[attributeType]
			if not map[attributeType]
				map[attributeType] = {}
				attributeMap = map[attributeType]

			nameValue = object.attribute.name
			nameMap = attributeMap[nameValue]
			if not nameMap
				attributeMap[nameValue] = []
			else
				if object.attribute
					nameMap.push(object.attribute)

		for attributeType, nameMap of map
			for nameValue, duplicatedObjects of nameMap
				duplicatedIndex = 2
				for object in duplicatedObjects
					newName = object.name + " [#{duplicatedIndex}]"
					object.name = newName
					@_migration.logwarn("Renaming duplicated name value [#{nameValue}] to [#{newName}] for type: [#{attributeType}])")
					duplicatedIndex++

		return

	__getAttributeType: (object) ->
		return object?.attribute?.lk_typ_id?.attributetyp?["lookup:_id"]?.easydb4_reference

ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.UniRostock)
