// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

Easydb4Migration.UniWuerzburg = (function(superClass) {
  extend(UniWuerzburg, superClass);

  function UniWuerzburg() {
    return UniWuerzburg.__super__.constructor.apply(this, arguments);
  }

  UniWuerzburg.prototype.name = function() {
    return "uni-wuerzburg";
  };

  UniWuerzburg.prototype.payload = function(filename, json, update) {
    var dfr;
    if (json.objecttype !== "bilder") {
      return;
    }
    console.debug("payload:", json, update);
    dfr = new CUI.Deferred();
    this._migration.query('SELECT * FROM "source.public.pool"').fail(dfr.reject).done((function(_this) {
      return function(result) {
        var hochschule, i, kunstgeschichte, len, museum, mvw, ptb, ref, ref1, row, sinologie;
        ptb = _this._migration.__info.pool_tables[0];
        sinologie = [];
        hochschule = [];
        kunstgeschichte = [];
        mvw = [];
        museum = [];
        ref1 = result.rows;
        for (i = 0, len = ref1.length; i < len; i++) {
          row = ref1[i];
          if (!row.editmask) {
            continue;
          }
          ref = ptb.real_source_name + ":" + row.id;
          if (row.editmask.match(/Sinologie/)) {
            sinologie.push(ref);
          }
          if (row.editmask.match(/Hochschule/)) {
            hochschule.push(ref);
          }
          if (row.editmask.match(/KuG/)) {
            kunstgeschichte.push(ref);
          }
          if (row.editmask.match(/mvw/)) {
            mvw.push(ref);
          } else if (row.editmask.match(/Museum/)) {
            museum.push(ref);
          }
        }
        return _this._migration.query('SELECT id FROM "source.public.bilder"').fail(dfr.reject).done(function(result) {
          var bild_ids, ez_ref, inv_nested, j, k, l, len1, len2, len3, move_linked, move_map, move_reg, obj, ref2, ref3, ref4;
          bild_ids = [];
          ref2 = result.rows;
          for (j = 0, len1 = ref2.length; j < len1; j++) {
            row = ref2[j];
            bild_ids.push(row.id);
          }
          console.debug("all bild ids:", bild_ids);
          move_linked = function(obj, key, key2) {
            if (obj.bilder[key] === void 0) {
              return;
            }
            obj.bilder[key2 + ":source_name"] = obj.bilder[key + ":source_name"];
            obj.bilder[key2] = obj.bilder[key];
            delete obj.bilder[key];
            return delete obj.bilder[key + ":source_name"];
          };
          move_reg = function(obj, key, key2) {
            if (obj.bilder[key] === void 0) {
              return;
            }
            obj.bilder[key2] = obj.bilder[key];
            return delete obj.bilder[key];
          };
          move_map = function(map, key, key2) {
            if (map[key] === void 0) {
              return;
            }
            map[key2] = map[key];
            return delete map[key];
          };
          ref3 = json.objects;
          for (k = 0, len2 = ref3.length; k < len2; k++) {
            obj = ref3[k];
            ref = obj.bilder._pool.pool["lookup:_id"].reference;
            if (indexOf.call(sinologie, ref) >= 0) {
              move_reg(obj, "datum", "datum_sinologie");
              move_reg(obj, "formatmasse_hsk", "formatmassenventa");
              move_linked(obj, "gattung_id", "gattung_id_sinologie");
              move_linked(obj, "fundort_id", "fundort_id_sinologie");
            }
            if (indexOf.call(hochschule, ref) >= 0) {
              move_reg(obj, "beschreibung", "beschreibung_hsk");
            }
            if (indexOf.call(kunstgeschichte, ref) >= 0) {
              move_reg(obj, "name", "name_kug");
              move_reg(obj, "detail", "detail_kug");
              move_linked(obj, "standort_id", "standort_id_kug");
            }
            if (indexOf.call(museum, ref) >= 0) {
              move_reg(obj, "_nested:bilder__inventarnummern", "_nested:bilder__inventarnummern_museum");
              ref4 = obj.bilder["_nested:bilder__inventarnummern_museum"] || [];
              for (l = 0, len3 = ref4.length; l < len3; l++) {
                inv_nested = ref4[l];
                move_map(inv_nested, "inventarnummer", "inventarnr");
              }
              move_reg(obj, "zustand", "zustand_museum");
            }
            if (indexOf.call(mvw, ref) >= 0) {
              move_reg(obj, "wasserzeichen", "wasserzeichen_mvw");
            }
            ez_ref = obj.bilder.easydb4_reference;
            CUI.util.removeFromArray(null, obj.bilder["_nested:bilder__bilder"] || [], function(bild__bild) {
              var bild_id, ref5;
              ref = (ref5 = bild__bild.bild_id) != null ? ref5.bilder["lookup:_id"].easydb4_reference : void 0;
              bild_id = parseInt(ref.split(":")[1]);
              if (indexOf.call(bild_ids, bild_id) < 0) {
                _this._migration.logwarn("Ref '" + ref + "' not found in exported objects, removing nested entry.");
                return true;
              }
              if (ref === ez_ref) {
                _this._migration.logwarn("Removed self referencing bilder__bilder link from " + ez_ref);
                return true;
              } else {
                return false;
              }
            });
          }
          dfr.resolve();
        });
      };
    })(this));
    return dfr.promise();
  };

  return UniWuerzburg;

})(Easydb4MigrationPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.plugins.registerPlugin(Easydb4Migration.UniWuerzburg);
  };
})(this));
