// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.OrcidUserPlugin = (function(superClass) {
  extend(OrcidUserPlugin, superClass);

  function OrcidUserPlugin() {
    return OrcidUserPlugin.__super__.constructor.apply(this, arguments);
  }

  OrcidUserPlugin.URL = "https://orcid.org/";

  OrcidUserPlugin.REGEX_ID = /^0000-000(1-[5-9]|2-[0-9]|3-[0-4])\d{3}-\d{3}[\dX]$/;

  OrcidUserPlugin.prototype.getTabs = function(tabs) {
    tabs.push({
      name: "orcid",
      text: $$("orcid.user.plugin.tab-text"),
      content: (function(_this) {
        return function() {
          var form, outputField;
          outputField = new CUI.DataFieldProxy({
            form: {
              label: $$("orcid.user.plugin.form.url.label")
            },
            element: function() {
              var orcid;
              orcid = _this._user.data.user.custom_data.orcid;
              if (CUI.util.isEmpty(orcid)) {
                return new CUI.Label({
                  text: $$("orcid.user.plugin.form.url.empty.md"),
                  markdown: true
                });
              }
              if (!ez5.OrcidUserPlugin.REGEX_ID.test(orcid)) {
                return new CUI.Label({
                  text: $$("orcid.user.plugin.form.url.not-valid.md"),
                  markdown: true
                });
              }
              return new CUI.Label({
                text: $$("orcid.user.plugin.form.url.link.md", {
                  url: ez5.OrcidUserPlugin.URL + orcid
                }),
                markdown: true
              });
            }
          });
          form = new CUI.Form({
            data: _this._user.data.user,
            name: "custom_data",
            fields: [
              {
                type: CUI.Input,
                name: "orcid",
                form: {
                  label: $$("orcid.user.plugin.form.id.label"),
                  hint: $$("orcid.user.plugin.form.id.hint.md")
                },
                onDataChanged: function() {
                  return outputField.reload();
                }
              }, outputField
            ]
          });
          return form.start();
        };
      })(this)
    });
    return tabs;
  };

  OrcidUserPlugin.prototype.getSaveData = function(saveData) {
    saveData.user.custom_data.orcid = this._user.data.user.custom_data.orcid;
  };

  OrcidUserPlugin.prototype.isAllowed = function() {
    return this._user.data.user.type === "easydb";
  };

  return OrcidUserPlugin;

})(ez5.UserPlugin);

User.plugins.registerPlugin(ez5.OrcidUserPlugin);
