class ez5.PdfCreator.ObjecttypePlugin extends ez5.ObjecttypePlugin

	getTab: ->
		if not ez5.session.hasSystemRight("root", "plugin.pdf-creator.show_pdf_creator")
			return
		tab =
			padded: false
			name: "pdf_creator"
			text: $$("admin.objecttype.tab.pdf_creator")
			content: =>
				@__renderPdfCreatorTab()
		return tab

	onLoad: ->
		data = @__getData()
		if not data.objecttype.custom_data.webfrontend.pdf_creator
			data.objecttype.custom_data.webfrontend.pdf_creator = {}
		return

	getSaveData: (saveData) ->
		saveData.objecttype.custom_data.webfrontend.pdf_creator = @__getDataWithoutEmptyFields()
		return

	__renderPdfCreatorTab: ->
		preferredMaskId = ez5.schema.CURRENT._objecttype_by_name[@__getData().objecttype.name]._preferred_mask?.mask_id
		pdfCreator = new ez5.PdfCreator(
			data: @__getData().objecttype.custom_data.webfrontend.pdf_creator
			idObjecttype: @__getData().objecttype._id
			idMask: preferredMaskId
		)
		return pdfCreator.renderList()

	__getDataWithoutEmptyFields: ->
		# In previous versions of the pdf creator the field node saved all the fields even if
		# were disabled so with this function we clean this filds if there is any.
		data = CUI.util.copyObject(@__getData().objecttype.custom_data.webfrontend.pdf_creator, true)
		@__removedFields = 0
		removeDisabledFieldsOnFieldsNode = (parent) =>
			for child in parent.children or []
				if child.children
					removeDisabledFieldsOnFieldsNode(child)
				if child.name == "field"
					for k, v of child.data?.dataFields
						if not v._enabled
							@__removedFields++
							delete child.data.dataFields[k]

		for template in data.templates or []
			removeDisabledFieldsOnFieldsNode(template.documentData)
		if @__removedFields > 0
			console.warn  "#{@__removedFields} fields were removed from templated because they are empty"
		return data

Objecttype.plugins.registerPlugin(ez5.PdfCreator.ObjecttypePlugin)
