from server_modules.util import make_table, make_data, make_map, get_json_value

num_column = 'num'

sql_count_objects = """
SELECT COUNT(*) AS {1} FROM "{0}"
"""

sql_group_assets = """
SELECT {0}, COUNT(*) AS {1} FROM ez_assets GROUP BY {0} ORDER BY {1} DESC, {0}
"""

sql_count_deleted_assets = """
SELECT count(eas_id) AS count, sum(filesize) AS sum
FROM ez_assets
WHERE eas_id < 0
"""

sql_group_events_by_type = """
SELECT '{0}' AS range, COUNT(*) AS {3} FROM ez_event WHERE type = '{1}'
AND created_timestamp >= NOW() - INTERVAL '{2}' GROUP BY type
"""

sql_get_asset_counts_per_objecttype = """
SELECT "ez_objecttype:id" AS ot_id, count(*) AS cnt
FROM ez_assets
WHERE "ez_objecttype:id" IS NOT NULL
GROUP BY 1
"""

def build_event_group_statement(ranges, event_type):
    return " UNION ALL ".join([sql_group_events_by_type.format(x[0], event_type, x[1], num_column) for x in ranges])


def get_info(easydb_context, db_cursor, config, instance, loggername):

    infos = []

    # objecttypes and objects
    datamodel = easydb_context.get_datamodel(show_has_easy_owning_tables=True)
    if 'user' in datamodel and 'tables' in datamodel['user']:
        total = 0
        assets_total = 0
        objecttypes = []

        db_cursor.execute(sql_get_asset_counts_per_objecttype)
        asset_count_by_ot_id = {}
        for row in db_cursor.fetchall():
            asset_count_by_ot_id[int(row['ot_id'])] = int(row['cnt'])

        for t in datamodel['user']['tables']:
            if not 'has_easy_owning_tables' in t:
                continue
            if t['has_easy_owning_tables'] is True:
                continue

            asset_cnt = asset_count_by_ot_id.get(t['table_id'], 0)
            objecttypes.append([t['name'], 0, asset_cnt])
            assets_total += asset_cnt

            db_cursor.execute(sql_count_objects.format(objecttypes[-1][0], num_column))
            count = 0
            try:
                count = int(db_cursor.fetchone()[num_column])
            except Exception as e:
                pass
            objecttypes[-1][1] = count
            total += count

        objecttypes = sorted(objecttypes, key=lambda x: x[1], reverse=True)
        objecttype_counts = [x[1] for x in objecttypes]
        objecttype_asset_counts = [x[2] for x in objecttypes]
        objecttypes = [x[0] for x in objecttypes]

        infos.append(make_table('objecttypes', 'name', objecttypes, [
            make_data('integer', 'count', objecttype_counts),
            make_data('integer', 'asset_count', objecttype_asset_counts),
        ]))
        infos.append(make_map('count', [
            make_data('integer', 'objecttypes_total', len(objecttypes)),
            make_data('integer', 'objects_total', total),
            make_data('integer', 'object_assets_total', assets_total),
        ]))

    # assets
    asset_fields = ['fileclass',  'mimetype', 'extension']
    asset_groups = {}
    total = 0
    db_cursor.execute(sql_group_assets.format(
        ', '.join(asset_fields),
        num_column
    ))
    rows = db_cursor.fetchall()

    if len(rows) > 0:
        for i in range(len(rows)):
            for f in asset_fields:
                if not f in asset_groups:
                    asset_groups[f] = []
                if rows[i][f] is None or len(rows[i][f]) < 1:
                    asset_groups[f].append('unknown')
                else:
                    asset_groups[f].append(rows[i][f])
            if not num_column in asset_groups:
                asset_groups[num_column] = []
            count = 0
            try:
                count = int(rows[i][num_column])
            except Exception as e:
                print(e)
            asset_groups[num_column].append(count)
            total += count

        asset_data = [make_data('string', f, asset_groups[f]) for f in asset_fields[1:]]
        asset_data.append(make_data('integer', 'count', asset_groups[num_column]))
        infos.append(make_table('assets', asset_fields[0], asset_groups[asset_fields[0]], asset_data))
    else:
        asset_data = [make_data('string', f, []) for f in asset_fields[1:]]
        infos.append(make_table('assets', asset_fields[0], [], asset_data))

    db_cursor.execute(sql_count_deleted_assets)
    row = db_cursor.fetchone()
    count_delete = row['count']
    bytes_delete = row['sum']

    infos.append(make_map('asset_count', [
        make_data('integer', 'total', total),
        make_data('integer', 'count_delete', count_delete),
        make_data('integer', 'bytes_delete', bytes_delete),
    ]))

    # languages
    config = easydb_context.get_config()
    if 'base' in config and 'system' in config['base']:
        config = config['base']['system']

        langs_data = []
        for lang in ['languages.database', 'languages.frontend']:
            db_langs = get_json_value(config, lang)
            if not isinstance(db_langs, list):
                db_langs = []
            langs_data.append({
                'values': [db_langs],
                'type': 'json',
                'name': lang
            })

        db_langs = []
        if 'search.suggest.autocompletion' in config:
            if 'languages' in config['search.suggest.autocompletion']:
                db_langs = config['search.suggest.autocompletion']['languages']
                if not isinstance(db_langs, list):
                    db_langs = []
        langs_data.append({
            'values': [db_langs],
            'type': 'json',
            'name': 'languages.suggest'
        })

        infos.append({
            'type': '2d-map',
            'name': 'languages',
            'headers': {
                'values': [''],
                'name': 'header'
            },
            'data': langs_data
        })

    # usage
    ranges = [('last_hour', '1 hour'), ('last_24_hours', '24 hours'),
              ('last_week', '1 week'), ('last_month', '1 month')]
    events = [('USER_LOGIN', 'login_events'), ('SEARCH', 'search_events')]

    for e in events:
        db_cursor.execute(build_event_group_statement(ranges, e[0]))
        event_data = [make_data('integer', row['range'], row[num_column])
                      for row in db_cursor.fetchall()]
        if len(event_data) < 1:
            event_data = [make_data('integer', r[0], 0) for r in ranges[-1:]]
        infos.append(make_map(e[1], event_data))

    return infos
