# easydb-wordpress-plugin

Plugin to easily transport media files to Wordpress CMS. It is available for **easydb5** and **fylr**.

Currently this supports creating of new media as well as updating media metadata. When media are updated in easydb5 or fylr, a new media is created (or updated if it exists) in Wordpress. There is no support for deleting media.

## Setup Wordpress 

* This plugin was built and tested for Wordpress version `4.7.` and higher
* Wordpress needs to have the **JSON-Rest-API** enabled (which is the default) and authentication set up
* This plugin supports **JSON Basic Authentication** and **WP REST API - OAuth 1.0a Server**
  * Install Wordpress plugin(s) for authentication
  * Enable plugin(s)
* Setup an Application User for oauth plugin
  * Callback URL: `<Instance URL>/api/v1/plugin/base/easydb-wordpress-plugin/oauth1`

## Install Plugin in easydb5

* Add the following lines to your `easydb-server.yml`:

```yaml
base:
  plugins+:
    - name: wordpress
      file: path/to/plugins/easydb-wordpress-plugin/manifest.master.yml

plugins:
  enabled+:
    - base.wordpress
```

## Install Plugin in fylr

* To use the plugin as a **disk** plugin, add the following lines to your `fylr.yml`:

```yaml
fylr+
  plugins+:
    paths+:
      - path/to/plugins/easydb-wordpress-plugin
```

* Alternativly, you can add the plugin in the plugin manager in the frontend as a **zip** or **url** plugin

## Setup in the Base Configuration

* Go to the Base Configuration and find the "Wordpress" config block
* Use **`+`** to add a new configuration
* Enter name, url and choose an authentication method

### HTTP-Authentication

* Use an admins login & password to connect
* For the password, generate and use a new **Application Password** for the user in Wordpress

### OAuth 1.0a

* Copy **Client Key** and **Client Secret** from the prepared **Application User** from Wordpress
* Press "Generate Key" to connect to Wordpress, authenticate and retrieve a **Token** and **Token Secret**
  * These are automatically added to the Base Configuration
* Don't forget to save the Base Configuration

## Authenticate users

* Use system rights "Wordpress" & "Wordpress transport" and authorize anybody who should be able to use Wordpress Transport

## Use in easydb5 and fylr

* In any export, use "Transport Wordpress" to transport all exported files to Wordpress
* Pick the prepared and configured Wordpress instance for the transport
* Optionally choose a schedule and incremental updates for regular updates
