class BaseMigrationNodeGroup extends BaseMigrationNodeData

	getDisplayText: ->
		ez5.loca.getBestFrontendValue(@getData().group.displayname)

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getActionFields: ->
		fields = [
			type: CUI.Output
			form:
				label: if @children then $$("base.migration.node.groups.text") else $$("base.migration.node.group.text")
			text: @getDisplayText()
		,
			type: CUI.Options
			name: "migrate"
			form:
				label: $$("base.migration.common.selection")
			options: [
				text: $$("base.migration.node.group.migrate_acl")
				value: "acl"
			,
				text: $$("base.migration.node.group.migrate_system_rights")
				value: "system_rights"
			]
		,
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$("base.migration.common.options")
			options: [
				text: $$("base.migration.common.replace")
				value: "replace"
			,
				text: $$("base.migration.common.add")
				value: "add"
			]
		]

		if @getData().group?.type == "system"
			fields.splice(2,1)

		fields

	checkMigrateButton: ->
		@__migrateBtn.enable()

	migrate: (ev, action_data) ->

		new_group = @migrateGroup(action_data)

		if ev.hasModifierKey()
			console.debug "migrate Group:", CUI.util.dump(new_group), new_group
			return CUI.resolvedPromise()

		@saveGroups([new_group])


	migrateGroup: (action_data) ->
		source_group = CUI.util.copyObject(@getData(), true)
		migration = @getMigration()

		# return comparable group name
		get_group_name = (group) =>
			name = group.group.name?.trim()
			if CUI.util.isEmpty(name)
				name = ez5.loca.getBestFrontendValue(group.group.displayname)

			if CUI.util.isEmpty(name)
				return null

			return name

		compareGroupRef = (source_group, target_group) ->
			if CUI.util.isEmpty(source_group.group.reference) or CUI.util.isEmpty(target_group.group.reference)
				return false
			if not ez5.version("6")
				return false
			return source_group.group.reference?.trim() == target_group.group.reference?.trim()

		source_gn = get_group_name(source_group)

		console.debug "migrate group", source_gn, action_data, source_group

		new_group =
			_basetype: "group"

			# don't send _acl and _system_rights if not required,
			# we don't want to overwrite
			_acl: undefined
			_system_rights: undefined

			group:
				_id: undefined
				_version: 1

		if (source_group.group.type == "system" or action_data.mode == "replace") and not CUI.util.isEmpty(source_gn)
			# find existing group

			for _group in @getMigration().getBaseData().group
				if source_gn?.toLowerCase() == get_group_name(_group)?.toLowerCase() or compareGroupRef(source_group, _group)
					console.info("found group:", source_gn, "update...")
					new_group.group._id = _group.group._id
					new_group.group._version = _group.group._version + 1
					break

		for k in [
			"displayname"
			"frontend_prefs"
			"name"
			"type"
			"authorization_info"
			"comment"
			"reference"
		]
			if not new_group.group[k]
				new_group.group[k] = CUI.util.copyObject(source_group.group[k], true)

		if source_group.group.type == "system"
			delete(new_group.group["reference"])

		if "system_rights" in action_data.migrate
			new_group._system_rights = CUI.util.copyObject(source_group._system_rights, true)

		if "acl" in action_data.migrate
			new_acl = migration.migrateACL(source_group._acl)
			if new_acl.length > 0
				new_group._acl = new_acl

		if ez5.version("6")
			for k in [
				"_ip_subnet_filter"
				"_pseudonymization"
				"_auth_method_group_maps"
			]
				if source_group[k]
					new_group[k] = CUI.util.copyObject(source_group[k], true)

		new_group


	saveGroups: (groups) ->
		@log($$("base.migration.console.log.group.saving.md", count: groups.length))
		fail = =>
			@log($$("base.migration.console.log.group.saving-failed.md", count: groups.length))
			dfr.reject.apply(dfr.reject, arguments)

		dfr = new CUI.Deferred()
		ez5.api.group
			type: "POST"
			json_data: groups
		.done (groups) =>
			console.debug "groups done...", groups
			ez5.api.group
				type: "GET"
			.done (_groups) =>
				@log($$("base.migration.console.log.group.migrated.md", count: groups.length))
				console.debug "groups updated...", groups
				@getMigration().getBaseData().group = _groups
				dfr.resolve()
			.fail(dfr.reject)
		.fail(dfr.reject)
		dfr.promise()


	@getSourceNodesFromData: (migration, data) ->

		groups =
			easydb: []
			system: []

		for group in data
			type = group.group.type
			if type  in ["easydb", "system"]
				groups[type].push(new BaseMigrationNodeGroup(migration: migration, data: group))

		[new BaseMigrationNodeGroups(migration: migration, children: [
			new BaseMigrationNodeGroupType(migration: migration, type: "system", children: groups.system)
		,
			new BaseMigrationNodeGroupType(migration: migration, type: "easydb", children: groups.easydb)
		])]

