// Generated by CoffeeScript 1.12.7
var BaseMigrationNodeObjecttype,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

BaseMigrationNodeObjecttype = (function(superClass) {
  extend(BaseMigrationNodeObjecttype, superClass);

  function BaseMigrationNodeObjecttype() {
    return BaseMigrationNodeObjecttype.__super__.constructor.apply(this, arguments);
  }

  BaseMigrationNodeObjecttype.prototype.readOpts = function() {
    var i, idx, len, ot, ref;
    BaseMigrationNodeObjecttype.__super__.readOpts.call(this);
    this.__target_objecttype = null;
    ref = this.getMigration().getBaseData().objecttype;
    for (idx = i = 0, len = ref.length; i < len; idx = ++i) {
      ot = ref[idx];
      if (ot.objecttype.name === this.getData().objecttype.name) {
        ot._idx_in_base_data = idx;
        this.__target_objecttype = ot;
        break;
      }
    }
  };

  BaseMigrationNodeObjecttype.prototype.getTargetObjecttype = function() {
    return this.__target_objecttype;
  };

  BaseMigrationNodeObjecttype.prototype.getDisplayText = function() {
    return this.getData().objecttype.name;
  };

  BaseMigrationNodeObjecttype.prototype.getActionPane = function() {
    var pane;
    pane = this.getActionPaneBase();
    return pane;
  };

  BaseMigrationNodeObjecttype.prototype.getActionFields = function() {
    var ref, ref1;
    return [
      {
        type: CUI.Output,
        form: {
          label: $$("base.migration.node.objecttype.objecttype.label")
        },
        text: this.getDisplayText()
      }, {
        type: CUI.Options,
        name: "migrate",
        form: {
          label: $$("base.migration.node.objecttype.migrate.label")
        },
        options: [
          {
            text: $$("base.migration.node.objecttype.migrate.check_acl", {
              acl_count: (ref = this.getData()._acl) != null ? ref.length : void 0
            }),
            disabled: ((ref1 = this.getData()._acl) != null ? ref1.length : void 0) === 0,
            value: "acl"
          }, {
            text: $$("base.migration.node.objecttype.migrate.columnfilters", {
              acl_count: this.getData()._columnfilters.length
            }),
            disabled: this.getData()._columnfilters.length === 0,
            value: "columnfilters"
          }
        ]
      }, {
        type: CUI.Options,
        name: "mode",
        radio: true,
        form: {
          label: $$('base.migration.node.objecttype.mode.label')
        },
        options: [
          {
            text: $$('base.migration.node.objecttype.mode.replace'),
            value: "replace"
          }, {
            text: $$('base.migration.node.objecttype.mode.add'),
            value: "add"
          }
        ]
      }
    ];
  };

  BaseMigrationNodeObjecttype.prototype.migrate = function(ev, action_data) {
    var _acl, acl, cf, do_save, i, j, len, len1, migration, new_acl, new_cf, new_columnfilters, ref, ref1, ref2, ref3, save_ot, source_ot, target_ot, who;
    console.debug("migrate Objecttype:", this.getDisplayText());
    source_ot = this.getData();
    target_ot = this.getTargetObjecttype();
    migration = this.getMigration();
    if (!target_ot) {
      this.log($$("base.migration.console.log.objecttype.target-not-found.md", {
        name: source_ot.objecttype.name
      }));
      return CUI.resolvedPromise();
    }
    save_ot = {
      _basetype: "objecttype",
      objecttype: {
        _id: target_ot.objecttype._id,
        _version: target_ot.objecttype._version + 1
      }
    };
    do_save = false;
    if (indexOf.call(action_data.migrate, "acl") >= 0) {
      new_acl = migration.migrateACL(source_ot._acl);
      if (new_acl.length > 0) {
        save_ot._acl = [];
        if (action_data.mode === "add") {
          save_ot._acl.push.apply(save_ot._acl, target_ot._acl);
        }
        save_ot._acl.push.apply(save_ot._acl, new_acl);
        do_save = true;
      }
    }
    if (indexOf.call(action_data.migrate, 'columnfilters') >= 0) {
      save_ot._columnfilters = [];
      new_columnfilters = [];
      ref = source_ot._columnfilters;
      for (i = 0, len = ref.length; i < len; i++) {
        cf = ref[i];
        new_cf = {
          internal_name: cf.internal_name,
          columns: cf.columns
        };
        if (cf.tagfilter) {
          new_cf.tagfilter = migration.migrateTagFilter(cf.tagfilter) || {};
        }
        acl = [];
        ref1 = cf.who || [];
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          who = ref1[j];
          acl.push({
            who: who
          });
        }
        new_acl = migration.migrateACL(acl);
        if (new_acl.length > 0) {
          new_cf.who = (function() {
            var k, len2, results;
            results = [];
            for (k = 0, len2 = new_acl.length; k < len2; k++) {
              _acl = new_acl[k];
              results.push(_acl.who);
            }
            return results;
          })();
        }
        if (!((ref2 = cf.who) != null ? ref2.length : void 0) || ((ref3 = new_cf.who) != null ? ref3.length : void 0)) {
          new_columnfilters.push(new_cf);
        }
      }
      if (new_columnfilters.length > 0) {
        save_ot._columnfilters = [];
        if (action_data.mode === "add") {
          save_ot._columnfilters.push.apply(save_ot._columnfilters, target_ot._columnfilters);
        }
        save_ot._columnfilters.push.apply(save_ot._columnfilters, new_columnfilters);
        do_save = true;
      }
    }
    if (!do_save) {
      this.log($$("base.migration.console.log.objecttype.no-data-found.md"));
      return CUI.resolvedPromise();
    }
    if (ev.hasModifierKey()) {
      console.debug("objecttype save:", CUI.util.dump(save_ot));
      return CUI.resolvedPromise();
    }
    this.log($$("base.migration.console.log.objecttype.saving.md", {
      name: this.getDisplayText()
    }));
    return ez5.api.objecttype({
      type: "POST",
      json_data: [save_ot]
    }).done((function(_this) {
      return function(ot_data) {
        _this.log($$("base.migration.console.log.objecttype.migrated.md", {
          name: _this.getDisplayText(),
          count_acl: ot_data[0]._acl.length,
          count_columns: ot_data[0]._columnfilters.length
        }));
        return _this.getMigration().getBaseData().objecttype[target_ot._idx_in_base_data] = ot_data[0];
      };
    })(this)).fail((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.objecttype.failed.md", {
          name: _this.getDisplayText()
        }));
      };
    })(this));
  };

  BaseMigrationNodeObjecttype.prototype.checkMigrateButton = function() {
    this.__migrateBtn.disable();
    if (!this.getTargetObjecttype()) {
      return;
    }
    if (this.__actionData.migrate.length === 0) {
      return;
    }
    this.__migrateBtn.enable();
  };

  BaseMigrationNodeObjecttype.getSourceNodesFromData = function(migration, data) {
    var i, len, objecttype, objecttypes;
    objecttypes = [];
    for (i = 0, len = data.length; i < len; i++) {
      objecttype = data[i];
      objecttypes.push(new BaseMigrationNodeObjecttype({
        migration: migration,
        data: objecttype
      }));
    }
    objecttypes.sort((function(_this) {
      return function(a, b) {
        return CUI.util.compareIndex(a.getDisplayText(), b.getDisplayText());
      };
    })(this));
    return [
      new BaseMigrationNodeObjecttypes({
        migration: migration,
        children: objecttypes
      })
    ];
  };

  return BaseMigrationNodeObjecttype;

})(BaseMigrationNodeData);
