// Generated by CoffeeScript 1.12.7
var BaseMigrationNodeTagGroup,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

BaseMigrationNodeTagGroup = (function(superClass) {
  extend(BaseMigrationNodeTagGroup, superClass);

  function BaseMigrationNodeTagGroup() {
    return BaseMigrationNodeTagGroup.__super__.constructor.apply(this, arguments);
  }

  BaseMigrationNodeTagGroup.prototype.readOpts = function() {
    var i, len, ref, tag;
    BaseMigrationNodeTagGroup.__super__.readOpts.call(this);
    this.children = [];
    ref = this.getData()._tags;
    for (i = 0, len = ref.length; i < len; i++) {
      tag = ref[i];
      this.children.push(new BaseMigrationNodeTag({
        migration: this._migration,
        data: tag
      }));
    }
  };

  BaseMigrationNodeTagGroup.prototype.getDisplayText = function() {
    return ez5.loca.getBestFrontendValue(this.getData().taggroup.displayname);
  };

  BaseMigrationNodeTagGroup.prototype.getActionPane = function() {
    var pane;
    pane = this.getActionPaneBase();
    return pane;
  };

  BaseMigrationNodeTagGroup.prototype.getActionFields = function() {
    return [
      {
        type: CUI.Output,
        form: {
          label: $$("base.migration.node.tag.group.text")
        },
        text: this.getDisplayText()
      }, {
        type: CUI.Options,
        name: "migrate",
        form: {
          label: $$("base.migration.common.selection")
        },
        options: [
          {
            text: $$("base.migration.node.tag.group.migrate_acl"),
            value: "acl"
          }
        ]
      }, {
        type: CUI.Options,
        name: "mode",
        radio: true,
        form: {
          label: $$("base.migration.common.options")
        },
        options: [
          {
            text: $$("base.migration.common.replace"),
            value: "replace"
          }, {
            text: $$("base.migration.common.add"),
            value: "add"
          }
        ]
      }
    ];
  };

  BaseMigrationNodeTagGroup.prototype.checkMigrateButton = function() {
    return this.__migrateBtn.enable();
  };

  BaseMigrationNodeTagGroup.prototype.migrate = function(ev, action_data) {
    var target;
    target = CUI.util.copyObject(this.getMigration().getBaseData().tags, true);
    this.migrateTagGroup(target, action_data);
    if (ev.hasModifierKey()) {
      console.debug("migrate TagGroup:", CUI.util.dump(target), target);
      return CUI.resolvedPromise();
    }
    return this.saveTags(target);
  };

  BaseMigrationNodeTagGroup.prototype.saveTags = function(tags) {
    this.log($$("base.migration.console.log.tag.saving.md", {
      count: tags.length
    }));
    return ez5.api.tags({
      type: "POST",
      json_data: tags
    }).done((function(_this) {
      return function(tags) {
        var _tags, i, j, len, len1, ref, tag, taggroup;
        for (i = 0, len = tags.length; i < len; i++) {
          taggroup = tags[i];
          _tags = [];
          ref = taggroup._tags;
          for (j = 0, len1 = ref.length; j < len1; j++) {
            tag = ref[j];
            _tags.push("**" + CUI.MarkdownInput.escape(ez5.loca.getBestFrontendValue(tag.tag.displayname)) + "**");
          }
          _this.log($$("base.migration.console.log.tag.migrated.md", {
            name: CUI.MarkdownInput.escape(ez5.loca.getBestFrontendValue(taggroup.taggroup.displayname)),
            tags: _tags.join(", ")
          }));
        }
        console.debug("updating base data:", tags);
        return _this.getMigration().getBaseData().tags = tags;
      };
    })(this)).fail((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.tag.failed"));
      };
    })(this));
  };

  BaseMigrationNodeTagGroup.prototype.migrateTagGroup = function(target, action_data) {
    var add, dn_source, find_tags, i, idx, j, k, l, len, len1, len2, len3, len4, len5, m, migration, n, newTags, new_acl, new_tag, new_taggroup, ref, ref1, ref2, ref3, ref4, source_tag, source_tg, tag, target_tags, tg;
    source_tg = CUI.util.copyObject(this.getData(), true);
    migration = this.getMigration();
    find_tags = function(search_tag, tags) {
      var dn_search_tag;
      dn_search_tag = ez5.loca.getBestFrontendValue(search_tag.tag.displayname).trim();
      return tags.filter((function(_this) {
        return function(arg) {
          var tag;
          tag = arg.tag;
          return ez5.loca.getBestFrontendValue(tag.displayname).trim() === dn_search_tag;
        };
      })(this));
    };
    add = true;
    dn_source = ez5.loca.getBestFrontendValue(source_tg.taggroup.displayname).trim();
    if (action_data.mode === "replace") {
      if (!CUI.util.isEmpty(dn_source)) {
        for (idx = i = 0, len = target.length; i < len; idx = ++i) {
          tg = target[idx];
          if (ez5.loca.getBestFrontendValue(tg.taggroup.displayname).trim() !== dn_source) {
            continue;
          }
          if (!tg.taggroup._id) {
            continue;
          }
          if (tg.__update) {
            continue;
          }
          new_taggroup = {
            _basetype: "taggroup",
            __update: true,
            taggroup: {
              _id: tg.taggroup._id,
              type: source_tg.taggroup.type,
              displayname: source_tg.taggroup.displayname
            },
            _tags: []
          };
          newTags = new Set();
          ref = source_tg._tags;
          for (j = 0, len1 = ref.length; j < len1; j++) {
            source_tag = ref[j];
            target_tags = find_tags(source_tag, tg._tags);
            new_tag = source_tag;
            if (target_tags.length <= 1) {
              if (((ref1 = target_tags[0]) != null ? ref1.tag._id : void 0) !== new_tag.tag._id) {
                delete new_tag.tag._id;
              }
              newTags.add(new_tag);
            } else {
              for (k = 0, len2 = target_tags.length; k < len2; k++) {
                tag = target_tags[k];
                newTags.add(tag);
              }
              this.log("Found multiple tags with name '" + (ez5.loca.getBestFrontendValue(target_tags[0].tag.displayname).trim()) + "'. Can't safely distinguish which to update, needs to be fixed manually!");
            }
          }
          new_taggroup._tags = Array.from(newTags);
          add = false;
          target[idx] = new_taggroup;
          console.info("Taggroup:", dn_source, "updated.");
          break;
        }
      }
    }
    if (add) {
      new_taggroup = source_tg;
      delete new_taggroup.taggroup._id;
      delete new_taggroup._tag_identifier;
      ref2 = new_taggroup._tags;
      for (l = 0, len3 = ref2.length; l < len3; l++) {
        tag = ref2[l];
        delete tag.tag._id;
      }
      target.push(new_taggroup);
      console.info("Taggroup:", dn_source, "added.");
    }
    if (indexOf.call(action_data.migrate, "acl") < 0) {
      ref3 = new_taggroup._tags;
      for (m = 0, len4 = ref3.length; m < len4; m++) {
        tag = ref3[m];
        tag._acl = [];
      }
    } else {
      ref4 = new_taggroup._tags;
      for (n = 0, len5 = ref4.length; n < len5; n++) {
        tag = ref4[n];
        new_acl = migration.migrateACL(tag._acl);
        tag._acl = new_acl;
      }
    }
    return this;
  };

  BaseMigrationNodeTagGroup.getSourceNodesFromData = function(migration, data) {
    var i, len, taggroup, taggroups;
    taggroups = [];
    for (i = 0, len = data.length; i < len; i++) {
      taggroup = data[i];
      taggroups.push(new BaseMigrationNodeTagGroup({
        migration: migration,
        data: taggroup
      }));
    }
    return [
      new BaseMigrationNodeTagGroups({
        migration: migration,
        children: taggroups
      })
    ];
  };

  return BaseMigrationNodeTagGroup;

})(BaseMigrationNodeData);
