class Easydb4MigrationPlugin.LmzStuttgart extends Easydb4MigrationPlugin
	name: ->
		"lmz-stuttgart"

	init: ->
		@schlagworte = {}
		p1 = @_migration.query(""" SELECT * FROM "source.lmz_stuttgart.schlagwort" """)
		p1.done (result) =>
			for row in result.rows
				@schlagworte[row.id] = row

		@bilder_urheber = {}
		p2 = @_migration.query(""" SELECT lk_bild_id as bild_id, (vorname || ' ' || name) as urheber FROM "source.lmz_stuttgart.bilder__urheber" a LEFT JOIN "source.lmz_stuttgart.urheber" b ON (a.lk_urheber_id = b.id) """)
		.done (result) =>
			for row in result.rows
				if @bilder_urheber[row.bild_id]
					@bilder_urheber[row.bild_id] += "\n"
				else
					@bilder_urheber[row.bild_id] = ""

				@bilder_urheber[row.bild_id] += row.urheber

		@bilder_art = {}
		p3 = @_migration.query(""" SELECT from_id AS bild_id, b.name, unique_identifier FROM "source.lmz_stuttgart.eadb_links" a JOIN "source.lmz_stuttgart.art" b ON (b.id = to_id) WHERE to_table_id=36 """)
		.done (result) =>
			for row in result.rows
				if not @bilder_art[row.bild_id]
					@bilder_art[row.bild_id] = []

				@bilder_art[row.bild_id].push(row)


		@attr_map = {}
		return CUI.when(p1, p2, p3)

	store: (ot, value) ->
		if not @attr_map[ot]
			@attr_map[ot] = {}
		if @attr_map[ot][value]
			@attr_map[ot][value]++
		else
			@attr_map[ot][value] = 1
		return

	storeAttrs: (store_file) ->
		console.debug("attr map:", @attr_map)

		promises = []

		for ot, data of @attr_map
			payload = import_type: "db", objecttype: ot, objects: []
			for value, count of data

				obj =
					_objecttype: ot
					_mask: "_all_fields"

				obj[ot] =
					_version: 1
					name: value

				payload.objects.push(obj)

			promises.push(store_file("art-split-"+ot+".json", payload))

		return CUI.when(promises)



	payload: (filename, json, update, store_file) ->

		if filename == "basetype_user_ldap_sso.json"
			return @storeAttrs(store_file)

		if not filename.startsWith("Bilder-")
			return

		link = (ot, value) ->
			lobj =
				_objecttype: ot
				_mask: "_all_fields"

			lobj[ot] = {}

			lobj[ot]["lookup:_id"] =
				name: value

			return lobj


		for obj in json.objects
			if @bilder_urheber[obj.objekte.__key]
				obj.objekte.urheber_migration = @bilder_urheber[obj.objekte.__key]

			for art in @bilder_art[obj.objekte.__key] or []
				if not art.unique_identifier
					@_migration.logwarn("Art '"+art.name+"' hat keinen unique_identifier. Objekt: "+obj.objekte.__key)
					continue

				if art.unique_identifier.startsWith("/Art")
					obj.objekte.lk_art_id = link("art", art.name)
					@store("art", art.name)

				if art.unique_identifier.startsWith("/Größe")
					obj.objekte.lk_groesse_id = link("groesse", art.name)
					@store("groesse", art.name)

				if art.unique_identifier.startsWith("/Format")
					obj.objekte.lk_format_id = link("format", art.name)
					@store("format", art.name)

				if art.unique_identifier.startsWith("/Farbe")
					if not obj.objekte["_nested:objekte__farben"]
						obj.objekte["_nested:objekte__farben"] = []
					obj.objekte["_nested:objekte__farben"].push(lk_farbe_id: link("farben", art.name))
					@store("farben", art.name)

			ok_schlagworte = []
			for schlagwort in obj.objekte["_nested:objekte__schlagworte"] or []
				id = schlagwort["lk_schlagwort_id"]["schlagwort"]["lookup:_id"]["__not_mapped"]
				schl = @schlagworte[id]
				if schl
					schlagwort["lk_schlagwort_id"]["schlagwort"]["__id_in_easydb4"] = id
					delete(schlagwort["lk_schlagwort_id"]["schlagwort"]["lookup:_id"]["__not_mapped"])
					schlagwort["lk_schlagwort_id"]["schlagwort"]["lookup:_id"]["name"] = schl.name
					# store("schlagwort", schl.name)
					ok_schlagworte.push(schlagwort)

			obj.objekte["_nested:objekte__schlagworte"] = ok_schlagworte
			# not mapped for now
			obj.objekte["_nested:objekte__eigennamen"] = []

		return


ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.LmzStuttgart)
