// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

Easydb4MigrationPlugin.UniFreiburg = (function(superClass) {
  extend(UniFreiburg, superClass);

  function UniFreiburg() {
    return UniFreiburg.__super__.constructor.apply(this, arguments);
  }

  UniFreiburg.prototype.name = function() {
    return "uni-freiburg";
  };

  UniFreiburg.prototype.init = function() {
    console.error("reset bildansichten");
    return this.bildansichten = {
      bildansicht_arch_neu: [],
      bildansicht_kuge_neu: [],
      bildansicht_muenz_neu: []
    };
  };

  UniFreiburg.prototype.payload = function(filename, json, update, store_file) {
    var dfr;
    if (json.objecttype === "listenfelder") {
      return this.splitByType(filename, json, update, store_file, "listenfelder", "type", {
        "listenfelder_Objektgattung": "liste_objektgattung",
        "listenfelder_Befundgattung": "liste_befundgattung",
        "listenfelder_Bildart": "liste_bildart",
        "listenfelder_Datierung-Epoche": "liste_epoche",
        "listenfelder_Entstehung_theol": "liste_entstehung_theol",
        "listenfelder_Epoche_Muenz": "liste_epoche_muenz",
        "listenfelder_Epoche_theol": "liste_epoche_theol",
        "listenfelder_Jahr": "liste_jahr",
        "listenfelder_Region_theol": "liste_region_theol",
        "listenfelder_Verfügbarkeit": "liste_verfuegbarkeit",
        "listenfelder_Wiedergabe": "liste_wiedergabe"
      });
    }
    if (json.objecttype !== "bilder") {
      return;
    }
    dfr = new CUI.Deferred();
    this._migration.query('SELECT * FROM "source.public.pool"').fail(dfr.reject).done((function(_this) {
      return function(result) {
        var arch, bildansichten, i, j, k, key, kuge, l, len, len1, len2, lobj, move_reg, muenz, obj, ot_name, payload, ptb, ref, ref1, ref2, ref3, row, theol, v, value, values;
        move_reg = function(obj, key, key2) {
          if (obj.bilder[key] === void 0) {
            return;
          }
          obj.bilder[key2] = obj.bilder[key];
          return delete obj.bilder[key];
        };
        ptb = _this._migration.__info.pool_tables[0];
        theol = [];
        arch = [];
        kuge = [];
        muenz = [];
        ref1 = result.rows;
        for (i = 0, len = ref1.length; i < len; i++) {
          row = ref1[i];
          if (!row.editmask) {
            continue;
          }
          ref = ptb.real_source_name + ":" + row.id;
          if (row.editmask.match(/Theol/)) {
            theol.push(ref);
          }
          if (row.editmask.match(/Arch/)) {
            arch.push(ref);
          }
          if (row.editmask.match(/KuGe/)) {
            kuge.push(ref);
          }
          if (row.editmask.match(/Muenz/)) {
            muenz.push(ref);
          }
        }
        bildansichten = {
          bildansicht_arch_neu: [],
          bildansicht_kuge_neu: [],
          bildansicht_muenz_neu: []
        };
        ref2 = json.objects;
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          obj = ref2[j];
          ref = obj.bilder._pool.pool["lookup:_id"].reference;
          if (indexOf.call(theol, ref) >= 0) {
            move_reg(obj, "herstellungsort", "herstellungsort_theol_neu");
            move_reg(obj, "titel", "titel_theol_neu");
          }
          if (indexOf.call(arch, ref) >= 0) {
            move_reg(obj, "titel", "titel_arch_neu");
          }
          if (indexOf.call(kuge, ref) >= 0) {
            move_reg(obj, "titel", "titel_kuge_neu");
          }
          value = (ref3 = obj.bilder.bildansicht) != null ? ref3.trim() : void 0;
          if (!CUI.util.isEmpty(value)) {
            key = null;
            if (indexOf.call(arch, ref) >= 0) {
              key = "arch";
            }
            if (indexOf.call(kuge, ref) >= 0) {
              key = "kuge";
            }
            if (indexOf.call(muenz, ref) >= 0) {
              key = "muenz";
            }
            if (key) {
              lobj = {};
              lobj["lookup:_id"] = {
                easydb4_reference: "bildansicht:" + value
              };
              ot_name = "bildansicht_" + key + "_neu";
              obj.bilder[ot_name] = {
                _objecttype: ot_name,
                _mask: "_all_fields"
              };
              obj.bilder[ot_name][ot_name] = lobj;
              if (indexOf.call(_this.bildansichten[ot_name], value) < 0) {
                bildansichten[ot_name].push(value);
                _this.bildansichten[ot_name].push(value);
              }
              delete obj.bilder.bildansicht;
            }
          }
        }
        for (k in bildansichten) {
          v = bildansichten[k];
          console.info("Bildansichten:", key, "neu:", v.length, "totel:", _this.bildansichten[k].length);
        }
        for (ot_name in bildansichten) {
          values = bildansichten[ot_name];
          if (values.length === 0) {
            continue;
          }
          payload = {
            import_type: "db",
            objecttype: ot_name,
            objects: []
          };
          for (l = 0, len2 = values.length; l < len2; l++) {
            value = values[l];
            obj = {
              _objecttype: ot_name,
              _mask: "_all_fields"
            };
            obj[ot_name] = {
              _version: 1,
              easydb4_reference: "bildansicht:" + value,
              name: value
            };
            payload.objects.push(obj);
          }
          store_file(ot_name + ".json", payload);
        }
        return dfr.resolve();
      };
    })(this));
    return dfr.promise();
  };

  return UniFreiburg;

})(Easydb4MigrationPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.UniFreiburg);
  };
})(this));
