// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.HijriGregorianConverterMaskSplitter = (function(superClass) {
  extend(HijriGregorianConverterMaskSplitter, superClass);

  function HijriGregorianConverterMaskSplitter() {
    return HijriGregorianConverterMaskSplitter.__super__.constructor.apply(this, arguments);
  }

  HijriGregorianConverterMaskSplitter.prototype.isSimpleSplit = function() {
    return false;
  };

  HijriGregorianConverterMaskSplitter.prototype.renderField = function(opts) {
    var areDatesAlreadyConverted, buttonBar, data, dateFields, dateGregorian, dateHijri, fields, fieldsRendererPlain, innerFields, toGregorianButton, toHijriButton;
    innerFields = this.renderInnerFields(opts);
    if (opts.mode === "detail" || opts.mode === "expert") {
      return innerFields;
    }
    fieldsRendererPlain = this.__customFieldsRenderer.fields[0];
    if (!(fieldsRendererPlain instanceof FieldsRendererPlain)) {
      return innerFields;
    }
    fields = fieldsRendererPlain.getFields() || [];
    if (!fields) {
      return innerFields;
    }
    dateFields = fields.filter(function(field) {
      return field instanceof DateColumn;
    });
    dateGregorian = dateFields[0];
    dateHijri = dateFields[1];
    if (!dateGregorian || !dateHijri) {
      return innerFields;
    }
    if (dateGregorian instanceof DateRangeColumn && !(dateHijri instanceof DateRangeColumn)) {
      return innerFields;
    }
    if (dateHijri instanceof DateRangeColumn && !(dateGregorian instanceof DateRangeColumn)) {
      return innerFields;
    }
    data = opts.data;
    toHijriButton = new LocaButton({
      loca_key: "hijri.gregorian.converter.button.to-hijri",
      disabled: this.__isDateInvalidOrEmpty(data, dateGregorian, opts),
      onClick: (function(_this) {
        return function() {
          var gregorianValue, hijriValue;
          gregorianValue = _this.__getDateValue(data, dateGregorian);
          hijriValue = _this.__toHijri(gregorianValue);
          dateHijri.updateValue(data, hijriValue);
          toHijriButton.disable();
          return toGregorianButton.disable();
        };
      })(this)
    });
    toGregorianButton = new LocaButton({
      loca_key: "hijri.gregorian.converter.button.to-gregorian",
      disabled: this.__isDateInvalidOrEmpty(data, dateHijri, opts),
      onClick: (function(_this) {
        return function() {
          var gregorianValue, hijriValue;
          hijriValue = _this.__getDateValue(data, dateHijri);
          gregorianValue = _this.__toGregorian(hijriValue);
          dateGregorian.updateValue(data, gregorianValue);
          toHijriButton.disable();
          return toGregorianButton.disable();
        };
      })(this)
    });
    areDatesAlreadyConverted = (function(_this) {
      return function() {
        var gregorianValue, hijriConvertedValue, hijriValue;
        if (toHijriButton.isDisabled() || toGregorianButton.isDisabled()) {
          return;
        }
        gregorianValue = _this.__getDateValue(data, dateGregorian);
        hijriValue = _this.__getDateValue(data, dateHijri);
        hijriConvertedValue = _this.__toGregorian(hijriValue);
        if (_this.__isSameDateValue(dateGregorian, gregorianValue, hijriConvertedValue)) {
          toHijriButton.disable();
          toGregorianButton.disable();
        }
      };
    })(this);
    areDatesAlreadyConverted();
    CUI.Events.listen({
      node: innerFields[0],
      type: ["editor-changed", "search-input-change"],
      call: (function(_this) {
        return function() {
          if (_this.__isDateInvalidOrEmpty(data, dateGregorian, opts)) {
            toHijriButton.disable();
          } else {
            toHijriButton.enable();
          }
          if (_this.__isDateInvalidOrEmpty(data, dateHijri, opts)) {
            toGregorianButton.disable();
          } else {
            toGregorianButton.enable();
          }
          return areDatesAlreadyConverted();
        };
      })(this)
    });
    buttonBar = new CUI.Buttonbar({
      "class": "ez5-field-block",
      buttons: [toHijriButton, toGregorianButton]
    });
    CUI.dom.append(innerFields[0], buttonBar);
    return innerFields;
  };

  HijriGregorianConverterMaskSplitter.prototype.__isDateInvalidOrEmpty = function(data, field, opts) {
    var checkedValue, gregorianValue;
    gregorianValue = this.__getDateValue(data, field);
    if (CUI.util.isEmpty(gregorianValue)) {
      return true;
    }
    checkedValue = field.checkValue(data, null, opts);
    if (!CUI.util.isTrue(checkedValue)) {
      return true;
    }
    return false;
  };

  HijriGregorianConverterMaskSplitter.prototype.__getDateValue = function(_data, field) {
    var data;
    data = _data[field.name()];
    if (!data) {
      return;
    }
    if (!CUI.util.isUndef(data.value)) {
      return data.value;
    }
    return {
      from: data.from,
      to: data.to
    };
  };

  HijriGregorianConverterMaskSplitter.prototype.__toGregorian = function(value) {
    var returnValue;
    if (CUI.util.isPlainObject(value)) {
      returnValue = {};
      if (value.from) {
        returnValue.from = ez5.HijriGregorianConverter.hijriToGregorian(value.from);
      }
      if (value.to) {
        returnValue.to = ez5.HijriGregorianConverter.hijriToGregorian(value.to);
      }
      return returnValue;
    }
    return ez5.HijriGregorianConverter.hijriToGregorian(value);
  };

  HijriGregorianConverterMaskSplitter.prototype.__toHijri = function(value) {
    var returnValue;
    if (CUI.util.isPlainObject(value)) {
      returnValue = {};
      if (value.from) {
        returnValue.from = ez5.HijriGregorianConverter.gregorianToHijri(value.from);
      }
      if (value.to) {
        returnValue.to = ez5.HijriGregorianConverter.gregorianToHijri(value.to);
      }
      return returnValue;
    }
    return ez5.HijriGregorianConverter.gregorianToHijri(value);
  };

  HijriGregorianConverterMaskSplitter.prototype.__isSameDateValue = function(dateField, value, convertedValue) {
    if (CUI.util.isPlainObject(value) && CUI.util.isPlainObject(convertedValue)) {
      return dateField.renderDateValue("" + value.from) === dateField.renderDateValue("" + convertedValue.to) && dateField.renderDateValue("" + value.from) === dateField.renderDateValue("" + convertedValue.to);
    }
    return dateField.renderDateValue("" + value) === dateField.renderDateValue("" + convertedValue);
  };

  HijriGregorianConverterMaskSplitter.prototype.getOptions = function() {
    return [];
  };

  HijriGregorianConverterMaskSplitter.prototype.trashable = function() {
    return true;
  };

  HijriGregorianConverterMaskSplitter.prototype.isEnabledForNested = function() {
    return true;
  };

  return HijriGregorianConverterMaskSplitter;

})(CustomMaskSplitter);

CUI.ready((function(_this) {
  return function() {
    return MaskSplitter.plugins.registerPlugin(ez5.HijriGregorianConverterMaskSplitter);
  };
})(this));
// Generated by CoffeeScript 1.12.7

/* CODE Copyright:  http://www.islamicity.com/PrayerTimes/defaultHijriConv.asp */
ez5.HijriGregorianConverter = (function() {
  function HijriGregorianConverter() {}

  HijriGregorianConverter.gregorianToHijri = function(value) {
    return "" + ez5.HijriGregorianConverter.prototype.convert_text_to_dates('C', value);
  };

  HijriGregorianConverter.hijriToGregorian = function(value) {
    return "" + ez5.HijriGregorianConverter.prototype.convert_text_to_dates('H', value);
  };

  HijriGregorianConverter.prototype.convert_text_to_dates = function(format, txt) {
    var err, from, from_date, has_to, spl, to, to_date;
    txt = txt.trim();
    from = void 0;
    to = void 0;
    spl = void 0;
    has_to = void 0;
    to_date = void 0;
    from_date = void 0;
    if (txt.length === 0) {
      return [null, null];
    }
    spl = txt.split(' - ');
    from = spl[0].trim();
    if (spl.length > 1) {
      to = spl[1].trim();
      has_to = true;
    }
    try {
      from_date = this.convert_text_to_date(format, from);
      if (has_to) {
        to_date = this.convert_text_to_date(format, to);
      }
      if (has_to) {
        return from_date + ' - ' + to_date;
      } else {
        return from_date;
      }
    } catch (error) {
      err = error;
      return err;
    }
  };

  HijriGregorianConverter.prototype.convert_text_to_date = function(format, txt) {
    var arr, day, map, mode, month, spl, use_format, year, zeroArray;
    spl = void 0;
    year = void 0;
    month = void 0;
    day = void 0;
    mode = void 0;
    use_format = void 0;
    if (txt === null) {
      return null;
    }
    if (txt.indexOf('.') > -1) {
      spl = txt.split('.');
      day = spl[0];
      month = spl[1];
      year = spl[2];
      mode = '.';
    } else {
      spl = txt.split('-');
      year = spl[0];
      month = spl[1];
      day = spl[2];
      mode = '-';
    }
    if (format === "C" && year < 622) {
      throw "invalid";
    }
    if (format === "H" && year < 1) {
      throw "invalid";
    }
    map = {};
    map[format + 'Day'] = parseInt(day) || 15;
    map[format + 'Month'] = parseInt(month) || 8;
    map[format + 'Year'] = parseInt(year);
    if (format === 'C') {
      this.__gregToIsl(map);
    } else {
      this.__islToGreg(map);
    }
    if (format === 'C') {
      use_format = 'H';
    } else {
      use_format = 'C';
    }
    if (mode === '-') {
      arr = [map[use_format + 'Year'], map[use_format + 'Month'], map[use_format + 'Day']];
    } else {
      arr = [map[use_format + 'Day'], map[use_format + 'Month'], map[use_format + 'Year']];
    }
    year = "" + arr[0];
    if (year.length < 4 && year[0] !== "-") {
      zeroArray = (function() {
        var o, ref, results;
        results = [];
        for (o = 1, ref = 4 - year.length; 1 <= ref ? o <= ref : o >= ref; 1 <= ref ? o++ : o--) {
          results.push(0);
        }
        return results;
      })();
      year = zeroArray.join("") + year;
      arr[0] = year;
    }
    if (spl.length === 1) {
      return arr[0];
    } else if (spl.length === 2) {
      return arr[0] + mode + arr[1];
    } else {
      return arr.join(mode);
    }
  };

  HijriGregorianConverter.prototype.__intPart = function(floatNum) {
    if (floatNum < -0.0000001) {
      return Math.ceil(floatNum - 0.0000001);
    }
    return Math.floor(floatNum + 0.0000001);
  };

  HijriGregorianConverter.prototype.__isNumeric = function(num) {
    var i, strlen;
    strlen = num.length;
    i = void 0;
    i = 0;
    while (i < strlen) {
      if (!(num.charAt(i) >= '0' && num.charAt(i) <= '9' || num.charAt(i) === '.' || num.charAt(i) === '-')) {
        return false;
      }
      ++i;
    }
  };

  HijriGregorianConverter.prototype.__gregToIsl = function(arg) {
    var d, delta, j, jd, jd1, l, m, n, y;
    if (this.__gValidate(arg) === false) {
      return false;
    }
    d = parseInt(arg.CDay);
    m = parseInt(arg.CMonth);
    y = parseInt(arg.CYear);
    delta = 0;
    if (y > 1582 || y === 1582 && m > 10 || y === 1582 && m === 10 && d > 14) {
      jd = this.__intPart(1461 * (y + 4800 + this.__intPart((m - 14) / 12)) / 4) + this.__intPart(367 * (m - 2 - (12 * this.__intPart((m - 14) / 12))) / 12) - this.__intPart(3 * this.__intPart((y + 4900 + this.__intPart((m - 14) / 12)) / 100) / 4) + d - 32075 + delta;
    } else {
      jd = 367 * y - this.__intPart(7 * (y + 5001 + this.__intPart((m - 9) / 7)) / 4) + this.__intPart(275 * m / 9) + d + 1729777 + delta;
    }
    jd1 = jd - delta;
    l = jd - 1948440 + 10632;
    n = this.__intPart((l - 1) / 10631);
    l = l - (10631 * n) + 354;
    j = this.__intPart((10985 - l) / 5316) * this.__intPart(50 * l / 17719) + this.__intPart(l / 5670) * this.__intPart(43 * l / 15238);
    l = l - (this.__intPart((30 - j) / 15) * this.__intPart(17719 * j / 50)) - (this.__intPart(j / 16) * this.__intPart(15238 * j / 43)) + 29;
    m = this.__intPart(24 * l / 709);
    d = l - this.__intPart(709 * m / 24);
    y = 30 * n + j - 30;
    arg.HDay = d;
    arg.HMonth = m;
    arg.HYear = y;
  };

  HijriGregorianConverter.prototype.__islToGreg = function(arg) {
    var d, delta, i, j, jd, k, l, m, n, y;
    if (this.__hValidate(arg) === false) {
      return false;
    }
    d = parseInt(arg.HDay);
    m = parseInt(arg.HMonth);
    y = parseInt(arg.HYear);
    delta = 0;
    jd = this.__intPart((11 * y + 3) / 30) + 354 * y + 30 * m - this.__intPart((m - 1) / 2) + d + 1948440 - 385 - delta;
    if (jd > 2299160) {
      l = jd + 68569;
      n = this.__intPart(4 * l / 146097);
      l = l - this.__intPart((146097 * n + 3) / 4);
      i = this.__intPart(4000 * (l + 1) / 1461001);
      l = l - this.__intPart(1461 * i / 4) + 31;
      j = this.__intPart(80 * l / 2447);
      d = l - this.__intPart(2447 * j / 80);
      l = this.__intPart(j / 11);
      m = j + 2 - (12 * l);
      y = 100 * (n - 49) + i + l;
    } else {
      j = jd + 1402;
      k = this.__intPart((j - 1) / 1461);
      l = j - (1461 * k);
      n = this.__intPart((l - 1) / 365) - this.__intPart(l / 1461);
      i = l - (365 * n) + 30;
      j = this.__intPart(80 * i / 2447);
      d = i - this.__intPart(2447 * j / 80);
      i = this.__intPart(j / 11);
      m = j + 2 - (12 * i);
      y = 4 * k + n + i - 4716;
    }
    arg.CDay = d;
    arg.CMonth = m;
    arg.CYear = y;
  };

  HijriGregorianConverter.prototype.__hValidate = function(arg) {
    var dh, hdays, leaph, m1h, mh, yh;
    hdays = new Array(30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29);
    dh = void 0;
    mh = void 0;
    yh = void 0;
    m1h = void 0;
    leaph = void 0;
    dh = arg.HDay;
    mh = arg.HMonth;
    yh = arg.HYear;
    if (arg.HYear === '') {
      alert('Hijri Year can not be empty');
      return false;
    }
    if (this.__isNumeric(yh) === false) {
      alert('Hijri Year should be in numerics');
      return false;
    }
    m1h = yh % 30;
    leaph = mh === 12 && (m1h === 2 || m1h === 5 || m1h === 7 || m1h === 10 || m1h === 13 || m1h === 16 || m1h === 18 || m1h === 21 || m1h === 24 || m1h === 26 || m1h === 29) ? 1 : 0;
    if (dh > hdays[mh - 1] + leaph) {
      alert(mh + '/' + dh + '/' + yh + ' is not a valid Hijri date.');
      return false;
    }
    return true;
  };

  HijriGregorianConverter.prototype.__gValidate = function(arg) {
    var cdays, d, leap, m, m1, m2, m3, y, yleap;
    cdays = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    yleap = void 0;
    d = void 0;
    m = void 0;
    y = void 0;
    m1 = void 0;
    m2 = void 0;
    m3 = void 0;
    leap = void 0;
    d = arg.CDay;
    m = arg.CMonth;
    y = arg.CYear;
    if (arg.CYear === '') {
      alert('Gregorian Year can be not empty');
      return false;
    }
    if (this.__isNumeric(y) === false) {
      alert('Gregorian Year should be in numerics');
      return false;
    }
    m1 = y % 4;
    m2 = y % 100;
    m3 = y % 400;
    leap = m === 2 && (m3 === 0 || m1 === 0 && m2 !== 0) ? 1 : 0;
    if (d > cdays[m - 1] + leap) {
      alert(m + '/' + d + '/' + y + ' is not a valid Gregorian date.');
      return false;
    }
    return true;
  };

  return HijriGregorianConverter;

})();
