// Generated by CoffeeScript 1.12.7
var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Modal = (function(superClass) {
  extend(Modal, superClass);

  function Modal() {
    this.__setZoom = bind(this.__setZoom, this);
    this.__buildTree = bind(this.__buildTree, this);
    this.__onWheel = bind(this.__onWheel, this);
    this.__updatePreviewNavigation = bind(this.__updatePreviewNavigation, this);
    return Modal.__super__.constructor.apply(this, arguments);
  }

  Modal.prototype.initOpts = function() {
    Modal.__super__.initOpts.call(this);
    this.addOpts({
      data: {
        check: "PlainObject",
        "default": {}
      },
      onSave: {
        check: Function
      },
      idObjecttype: {
        check: "Integer",
        mandatory: true
      },
      idMask: {
        check: "Integer"
      }
    });
    return this;
  };

  Modal.prototype.readOpts = function() {
    var collection, content, i, len, mask, maskInstances, masks, mfs, searchPopover, selectedMaskName;
    Modal.__super__.readOpts.call(this);
    this.__currentZoom = 100;
    this.__previewObjects = [];
    this.__saveButton = new LocaButton({
      loca_key: "pdf-creator.modal.save.button",
      disabled: true,
      primary: true,
      onClick: (function(_this) {
        return function() {
          _this.__save();
          if (typeof _this._onSave === "function") {
            _this._onSave(_this._data);
          }
          return _this.__modal.destroy();
        };
      })(this)
    });
    this.__printPreviewButton = new LocaButton({
      loca_key: "pdf-creator.preview.print.button",
      group: "print-preview",
      left: true,
      disabled: true,
      onClick: (function(_this) {
        return function() {
          _this.__printPreviewButton.startSpinner();
          return _this.__printPreview().fail(function(errorMessage) {
            if (!CUI.util.isString(errorMessage)) {
              errorMessage = $$("pdf-creator.preview.print.error-message");
            }
            return CUI.problem({
              text: errorMessage
            });
          }).always(function() {
            return _this.__printPreviewButton.stopSpinner();
          });
        };
      })(this)
    });
    masks = ez5.mask.CURRENT._masks_by_table_id[this._idObjecttype];
    maskInstances = [Mask.getMaskByMaskName("_all_fields", this._idObjecttype)];
    for (i = 0, len = masks.length; i < len; i++) {
      mask = masks[i];
      if (mask.mask_id === this._idMask) {
        selectedMaskName = mask.name;
      }
      maskInstances.push(ez5.mask.CURRENT._mask_instance_by_name[mask.name]);
    }
    mfs = new MaskFieldSelectorDetail({
      mask_name: selectedMaskName || "_all_fields",
      masks: maskInstances,
      show_all_fields_mask: true,
      onChanged: (function(_this) {
        return function(old_mask, new_mask) {
          var ref;
          _this._idMask = (ref = ez5.mask.CURRENT._mask_instance_by_name[new_mask]) != null ? ref._id : void 0;
          _this.__pdfDocumentNode.setMask(_this._idMask);
          _this.__updatePreview();
          return CUI.resolvedPromise();
        };
      })(this)
    });
    this.__maskSelector = mfs.getSelect().start();
    this.__previewObjectPage = 0;
    this.__previewObjectOffset = 0;
    this.__previewObjectNavigation = new NavigationToolbar({
      onLoadPage: (function(_this) {
        return function(__previewObjectPage) {
          _this.__previewObjectPage = __previewObjectPage;
          _this.__updatePreview();
        };
      })(this)
    });
    this.__searchPopoverButton = new LocaButton({
      loca_key: "pdf-creator.preview.select-objects.button",
      group: "print-preview",
      left: true,
      disabled: false,
      onClick: (function(_this) {
        return function() {
          return searchPopover.openPopover();
        };
      })(this)
    });
    content = this.__buildModalContent();
    mask = this.__pdfDocumentNode.getMask();
    collection = new CollectionMemory;
    searchPopover = new SearchPopover({
      link_mask: mask,
      popover_element: this.__searchPopoverButton,
      collection: collection,
      request_format: "long",
      onDone: (function(_this) {
        return function() {
          _this.__previewLabel.setText($$("pdf-creator.preview.selected-objects|label", {
            count: collection.getCount()
          }));
          _this.__previewObjects = collection.getObjects().map(function(object) {
            return object.getObject();
          });
          _this.__searchPopoverButton.startSpinner();
          return ez5.PdfCreatorUtils.fetchLinkedObjects(_this.__previewObjects).done(function() {
            _this.__previewObjectPage = 0;
            _this.__updatePreview();
            if (_this.__previewObjects.length > 0) {
              _this.__printPreviewButton.enable();
            } else {
              _this.__printPreviewButton.disable();
            }
            return _this.__searchPopoverButton.stopSpinner();
          });
        };
      })(this)
    });
    this.__modal = new CUI.Modal({
      fill_space: "both",
      cancel: true,
      onCancel: (function(_this) {
        return function() {
          if (!_this.__saveButton.isEnabled()) {
            return _this.__modal.destroy();
          }
          return CUI.confirm({
            text: $$("pdf-creator.modal.close.confirmation|text")
          }).done(function() {
            return _this.__modal.destroy();
          });
        };
      })(this),
      pane: {
        "class": "pdf-creator",
        header_left: new CUI.Label({
          text: $$("pdf-creator.title")
        }),
        content: content,
        footer_right: this.__saveButton,
        footer_left: new CUI.HorizontalList({
          content: new CUI.Buttonbar({
            buttons: [this.__printPreviewButton, this.__searchPopoverButton, this.__maskSelector]
          })
        })
      }
    });
    return this;
  };

  Modal.prototype.__printPreview = function() {
    var pdfCreatorTemplate;
    pdfCreatorTemplate = new ez5.PdfCreator.Template({
      data: this._data
    });
    return pdfCreatorTemplate.print(this.__previewObjects);
  };

  Modal.prototype.__checkSaveData = function() {
    var ref, saveData;
    saveData = this.__getSaveData();
    if (CUI.util.isEqual((ref = this._data) != null ? ref.documentData : void 0, saveData.documentData)) {
      this.__saveButton.disable();
    } else {
      this.__saveButton.enable();
    }
  };

  Modal.prototype.__getSaveData = function() {
    var saveData;
    saveData = {
      documentData: this.__pdfDocumentNode.getSaveData(),
      zoom: this.__currentZoom,
      name: this.__pdfDocumentNode.getTemplateName()
    };
    return saveData;
  };

  Modal.prototype.__save = function() {
    var date, saveData;
    date = CUI.util.moment().format();
    saveData = this.__getSaveData();
    this._data.documentData = saveData.documentData;
    this._data.zoom = saveData.zoom;
    this._data.name = saveData.name;
    this._data.date_last_modified = date;
    this._data.id_objecttype = this._idObjecttype;
    this._data.user_last_modify = ez5.session.user.getDisplayText();
    if (!this._data.user_create) {
      this._data.user_create = this._data.user_last_modify;
    }
    if (!this._data.date_created) {
      this._data.date_created = date;
    }
  };

  Modal.prototype.__loadData = function() {
    var documentData, saveData, tree, waitBlock;
    if (CUI.util.isEmpty(this._data)) {
      this.__pdfDocumentNode.select();
      return;
    }
    waitBlock = new CUI.WaitBlock({
      element: this.__treePane.center()
    }).show();
    saveData = CUI.util.copyObject(this._data, true);
    if (saveData.zoom) {
      this.__currentZoom = saveData.zoom;
    }
    documentData = ez5.PdfCreatorUtils.initDocumentData(saveData.documentData);
    tree = this.__buildTree(documentData);
    this.__treePane.append(tree, "center");
    this.__pdfDocumentNode.open();
    this.__pdfDocumentNode.select().done((function(_this) {
      return function() {
        _this.__updatePreview();
        return waitBlock.destroy();
      };
    })(this));
  };

  Modal.prototype.open = function() {
    this.__modal.show();
    ez5.PdfCreator.fetchPrintCSSPromise.done((function(_this) {
      return function() {
        _this.__loadData();
        return _this.__updatePreview();
      };
    })(this));
  };

  Modal.prototype.__updateSettingsForm = function() {
    var label, onDataChanged, opts, selectedNode;
    if (this.__settingsForm) {
      this.__settingsForm.destroy();
    }
    selectedNode = this.__tree.getSelectedNode();
    if (!selectedNode) {
      label = new EmptyLocaLabel({
        text: $$("pdf-creator.settings.node-not-selected"),
        centered: true
      });
      this.__settingsPane.replace(label);
      return;
    }
    onDataChanged = (function(_this) {
      return function() {
        return _this.__updatePreview();
      };
    })(this);
    opts = {
      onDataChanged: (function(_this) {
        return function() {
          return CUI.scheduleCallback({
            ms: 200,
            call: onDataChanged
          });
        };
      })(this)
    };
    this.__settingsForm = selectedNode.getSettingsForm(opts);
    this.__settingsPane.replace(this.__settingsForm);
    this.__settingsLabel.setText($$("pdf-creator.settings.title", {
      name: selectedNode.getDisplayName()
    }));
  };

  Modal.prototype.__updatePreviewNavigation = function() {
    var maxCountPerPage;
    maxCountPerPage = this.__pdfDocumentNode.getMaxCountPerPage();
    this.__previewObjectOffset = this.__previewObjectPage * maxCountPerPage;
    if (this.__previewObjectOffset > this.__previewObjects.length) {
      this.__previewObjectPage = 0;
      this.__previewObjectOffset = 0;
    }
    this.__previewObjectNavigation.update({
      count: this.__previewObjects.length,
      offset: this.__previewObjectOffset,
      limit: maxCountPerPage
    });
  };

  Modal.prototype.__updatePreview = function() {
    var count, height, html, noPreviewObjectsLabel, opts, ref, width;
    opts = {
      preview: true,
      objects: [],
      selectedNode: this.__tree.getSelectedNode(),
      styles: ez5.PdfCreator.printSyles,
      custom_css_url: (ref = ez5.session.getBaseConfig("plugin", "pdf-creator")) != null ? ref.custom_css_url : void 0
    };
    if (CUI.util.isEmpty(this.__previewObjects)) {
      noPreviewObjectsLabel = new EmptyLocaLabel({
        "class": "pdf-creator-preview-no-objects-label",
        text: $$("pdf-creator.preview.subtitle.md"),
        centered: true,
        markdown: true
      });
      CUI.dom.replace(this.__iframeWrapper, noPreviewObjectsLabel);
      this.__zoomButtonbar.disable();
      this.__checkSaveData();
      return;
    }
    if (this.__iframeWrapper.children[0] !== this.__zoomWrapper) {
      CUI.dom.replace(this.__iframeWrapper, this.__zoomWrapper);
      this.__zoomButtonbar.enable();
    }
    this.__updatePreviewNavigation();
    count = this.__pdfDocumentNode.getMaxCountPerPage();
    opts.objects = this.__previewObjects.slice(this.__previewObjectOffset, this.__previewObjectOffset + count);
    width = this.__pdfDocumentNode.getWidth();
    height = this.__pdfDocumentNode.getHeight();
    if (width !== this.__documentWidth || height !== this.__documentHeight) {
      this.__documentWidth = width;
      this.__documentHeight = height;
      CUI.dom.setStyle(this.__iframe, {
        width: this.__documentWidth + "cm",
        height: this.__documentHeight + "cm"
      });
    }
    html = this.__pdfDocumentNode.renderPdf(opts);
    this.__iframe.contentDocument.children[0].replaceWith(html);
    this.__setZoom();
    html.children[1].addEventListener("wheel", (function(_this) {
      return function(ev) {
        _this.__onWheel(ev.deltaY);
        ev.preventDefault();
      };
    })(this), {
      passive: false
    });
    this.__checkSaveData();
  };

  Modal.prototype.__buildModalContent = function() {
    var content, previewPane, tree;
    tree = this.__buildTree({
      open: true
    });
    this.__addButton = new CUI.Button({
      group: "tree_actions",
      icon: "plus",
      disabled: true,
      menu: {
        items: (function(_this) {
          return function() {
            var _, fn, items, plugin, pluginNode, ref, selectedNode;
            selectedNode = _this.__tree.getSelectedNode();
            items = [];
            ref = ez5.PdfCreator.nodePlugins;
            fn = function(pluginNode) {
              return items.push({
                text: pluginNode.getDisplayName(),
                disabled: !pluginNode.isParentAllowed(selectedNode),
                onClick: function() {
                  return _this.__tree.getSelectedNode().addNode(pluginNode).done(function() {
                    return pluginNode.select().done(function() {
                      return _this.__updatePreview();
                    });
                  });
                }
              });
            };
            for (_ in ref) {
              plugin = ref[_];
              pluginNode = new plugin();
              fn(pluginNode);
            }
            return items;
          };
        })(this)
      }
    });
    this.__removeButton = new CUI.Button({
      group: "tree_actions",
      icon: "minus",
      disabled: true,
      onClick: (function(_this) {
        return function() {
          return CUI.confirm({
            text: $$("pdf-creator.elements.buttons.remove.confirmation")
          }).done(function() {
            _this.__tree.getSelectedNode().remove();
            return _this.__updatePreview();
          });
        };
      })(this)
    });
    this.__moveToBottomButton = new CUI.Button({
      icon: $$("tool.mask_editor.move_to_bottom|icon"),
      group: "tree_actions",
      disabled: true,
      onClick: (function(_this) {
        return function() {
          return _this.__moveSelectedNodeToBottom();
        };
      })(this)
    });
    this.__moveToTopButton = new CUI.Button({
      icon: $$("tool.mask_editor.move_to_top|icon"),
      group: "tree_actions",
      disabled: true,
      onClick: (function(_this) {
        return function() {
          return _this.__moveSelectedNodeToTop();
        };
      })(this)
    });
    this.__moveUpButton = new CUI.Button({
      group: "tree_actions",
      icon: "fa-angle-up",
      disabled: true,
      onClick: (function(_this) {
        return function() {
          return _this.__moveSelectedNode(false);
        };
      })(this)
    });
    this.__moveDownButton = new CUI.Button({
      group: "tree_actions",
      icon: "fa-angle-down",
      disabled: true,
      onClick: (function(_this) {
        return function() {
          return _this.__moveSelectedNode(true);
        };
      })(this)
    });
    this.__copyButton = new CUI.Button({
      group: "tree_more_actions",
      icon: "copy",
      disabled: true,
      onClick: (function(_this) {
        return function() {
          var node, ref, selectedNode;
          selectedNode = _this.__tree.getSelectedNode();
          node = selectedNode.copy();
          if (!node) {
            return;
          }
          if ((ref = selectedNode.getFather()) != null) {
            ref.addChild(node);
          }
          return _this.__updatePreview();
        };
      })(this)
    });
    this.__zoomLabel = new CUI.Label({
      text: "",
      appearance: "secondary"
    });
    this.__zoomButtonbar = new CUI.Buttonbar({
      buttons: [
        this.__zoomLabel, {
          icon: "zoom_out",
          group: "zoom",
          onClick: (function(_this) {
            return function() {
              return _this.__setZoom(-2);
            };
          })(this)
        }, {
          loca_key: "pdf-creator.zoom.fit-view",
          group: "zoom",
          onClick: (function(_this) {
            return function() {
              var heightZoom, widthZoom, zoom;
              heightZoom = _this.__iframeWrapper.clientHeight / _this.__zoomWrapper.clientHeight;
              widthZoom = _this.__iframeWrapper.clientWidth / _this.__zoomWrapper.clientWidth;
              zoom = heightZoom < widthZoom ? heightZoom : widthZoom;
              _this.__currentZoom = Math.floor(zoom * 100);
              _this.__setZoom();
              _this.__zoomWrapper.scrollIntoView();
              return _this.__iframeWrapper.scrollLeft = CUI.dom.getDimension(_this.__iframeWrapper, "paddingLeft");
            };
          })(this)
        }, {
          icon: "zoom_in",
          group: "zoom",
          onClick: (function(_this) {
            return function() {
              return _this.__setZoom(2);
            };
          })(this)
        }
      ]
    });
    this.__iframeWrapper = CUI.dom.div("pdf-creator-iframe-wrapper");
    this.__zoomWrapper = CUI.dom.div("pdf-creator-iframe-wrapper-zoom");
    this.__iframe = CUI.dom.$element("iframe", "pdf-creator-iframe-preview");
    CUI.dom.append(this.__zoomWrapper, this.__iframe);
    CUI.dom.append(this.__iframeWrapper, this.__zoomWrapper);
    this.__previewLabel = new CUI.Label({
      text: $$("pdf-creator.preview.title")
    });
    previewPane = new CUI.SimplePane({
      header_left: this.__previewLabel,
      header_right: this.__zoomButtonbar,
      content: this.__iframeWrapper,
      footer_center: this.__previewObjectNavigation
    });
    CUI.Events.listen({
      node: this.__iframeWrapper,
      type: "wheel",
      call: (function(_this) {
        return function(ev) {
          _this.__onWheel(ev.wheelDeltaY());
          ev.preventDefault();
        };
      })(this)
    });
    this.__settingsLabel = new CUI.Label({
      text: $$("pdf-creator.settings.title.node-not-selected")
    });
    this.__settingsPane = new CUI.SimplePane({
      header_left: this.__settingsLabel
    });
    this.__updateSettingsForm();
    this.__treePane = new CUI.SimplePane({
      header_left: new CUI.Label({
        text: $$("pdf-creator.elements.title")
      }),
      content: tree,
      footer_left: new CUI.Buttonbar({
        buttons: [this.__addButton, this.__removeButton, this.__copyButton, this.__moveToTopButton, this.__moveUpButton, this.__moveDownButton, this.__moveToBottomButton]
      })
    });
    content = new CUI.HorizontalLayout({
      left: {
        "class": "pdf-creator-tree",
        flexHandle: {
          state_name: "pdf-creator-left",
          hidden: false
        },
        content: this.__treePane
      },
      center: {
        "class": "pdf-creator-preview",
        content: previewPane
      },
      right: {
        "class": "pdf-creator-settings",
        flexHandle: {
          state_name: "pdf-creator-right",
          hidden: false
        },
        content: this.__settingsPane
      }
    });
    return content;
  };

  Modal.prototype.__onWheel = function(deltaY) {
    if (deltaY > 0) {
      this.__setZoom(-2);
    } else {
      this.__setZoom(2);
    }
  };

  Modal.prototype.__buildTree = function(opts) {
    var ref, updatePreview;
    if (opts == null) {
      opts = {};
    }
    if (this.__tree) {
      this.__tree.destroy();
      if ((ref = this.__pdfDocumentNode) != null) {
        ref.destroy();
      }
    }
    if (!opts.idObjecttype) {
      opts.idObjecttype = this._idObjecttype;
    }
    if (!opts.idMask) {
      opts.idMask = this._idMask;
    }
    updatePreview = (function(_this) {
      return function() {
        return _this.__updatePreview();
      };
    })(this);
    this.__pdfDocumentNode = new ez5.PdfCreator.Node.Document(opts);
    this.__tree = new CUI.ListViewTree({
      selectableRows: true,
      rowMove: true,
      root: new CUI.ListViewTreeNode({
        children: [this.__pdfDocumentNode]
      }),
      cols: ["maximize"],
      onSelect: (function(_this) {
        return function() {
          var selectedNode;
          _this.__updateSettingsForm();
          selectedNode = _this.__tree.getSelectedNode();
          if (!selectedNode) {
            return;
          }
          _this.__addButton.disable();
          _this.__addButton.getMenu().getItemList().getItems().done(function(items) {
            if (items.some(function(item) {
              return !item.disabled;
            })) {
              return _this.__addButton.enable();
            } else {
              return _this.__addButton.disable();
            }
          });
          if (selectedNode === _this.__pdfDocumentNode) {
            _this.__removeButton.disable();
            _this.__moveToTopButton.disable();
            _this.__moveToBottomButton.disable();
            _this.__moveUpButton.disable();
            _this.__moveDownButton.disable();
          } else {
            _this.__removeButton.enable();
            _this.__moveToTopButton.enable();
            _this.__moveToBottomButton.enable();
            _this.__moveUpButton.enable();
            _this.__moveDownButton.enable();
          }
          if (selectedNode.isCopyAllowed()) {
            _this.__copyButton.enable();
          } else {
            _this.__copyButton.disable();
          }
          CUI.scheduleCallback({
            ms: 200,
            call: updatePreview
          });
        };
      })(this),
      onRowMove: (function(_this) {
        return function() {
          return CUI.scheduleCallback({
            ms: 200,
            call: updatePreview
          });
        };
      })(this),
      onDeselect: (function(_this) {
        return function() {
          _this.__updateSettingsForm();
          _this.__removeButton.disable();
          _this.__copyButton.disable();
          _this.__addButton.disable();
          _this.__moveUpButton.disable();
          _this.__moveDownButton.disable();
          _this.__moveToTopButton.disable();
          _this.__moveToBottomButton.disable();
          CUI.scheduleCallback({
            ms: 200,
            call: updatePreview
          });
        };
      })(this)
    });
    this.__tree.render();
    this.__tree.root.open();
    return this.__tree;
  };

  Modal.prototype.__setZoom = function(zoomOffset) {
    var iframeWrapperWidth, leftWidth, scale, zoomWrapperWidth;
    if (zoomOffset && (this.__currentZoom + zoomOffset) > 0) {
      this.__currentZoom += zoomOffset;
    }
    scale = this.__currentZoom / 100;
    CUI.dom.setStyle(this.__zoomWrapper, {
      transform: "scale(" + scale + ", " + scale + ")",
      left: 0
    });
    this.__zoomLabel.setText($$("pdf-creator.zoom|label", {
      zoom: this.__currentZoom
    }));
    iframeWrapperWidth = this.__iframeWrapper.clientWidth;
    zoomWrapperWidth = this.__zoomWrapper.clientWidth * scale;
    leftWidth = (iframeWrapperWidth - zoomWrapperWidth) / 2;
    if (leftWidth > 0) {
      CUI.dom.setStyle(this.__zoomWrapper, {
        left: leftWidth + "px"
      });
    }
  };

  Modal.prototype.__moveSelectedNode = function(after) {
    var nextRowIndex, selectedNode;
    selectedNode = this.__tree.getSelectedNode();
    if (selectedNode.isOpen()) {
      selectedNode.close();
    }
    nextRowIndex = this.__getNextRowIndexForMove(selectedNode, after);
    if (!nextRowIndex) {
      return;
    }
    this.__tree.moveRow(selectedNode.getRowIdx(), nextRowIndex, after);
  };

  Modal.prototype.__moveSelectedNodeToTop = function() {
    var fatherChildren, selectedNode, topIndex;
    selectedNode = this.__tree.getSelectedNode();
    fatherChildren = selectedNode.father.children;
    topIndex = fatherChildren[0].getRowIdx();
    if (fatherChildren === this.__pdfDocumentNode) {
      topIndex++;
    }
    return this.__tree.moveRow(selectedNode.getRowIdx(), topIndex, false);
  };

  Modal.prototype.__moveSelectedNodeToBottom = function() {
    var fatherChildren, lastIdx, lastNode, selectedNode;
    selectedNode = this.__tree.getSelectedNode();
    fatherChildren = selectedNode.father.children;
    lastNode = fatherChildren[fatherChildren.length - 1];
    if (lastNode.children) {
      lastNode.close();
    }
    lastIdx = lastNode.getRowIdx();
    return this.__tree.moveRow(selectedNode.getRowIdx(), lastIdx, true);
  };

  Modal.prototype.__getNextRowIndexForMove = function(node, after) {
    var fatherChildren, getNextRowIndex, quantity, rowIndexInArray;
    quantity = after ? 1 : -1;
    fatherChildren = node.father.children;
    rowIndexInArray = CUI.util.idxInArray(node, fatherChildren);
    getNextRowIndex = (function(_this) {
      return function(_quantity) {
        var nextListViewRow;
        nextListViewRow = fatherChildren[rowIndexInArray + _quantity];
        if (!nextListViewRow) {
          return;
        }
        if (!node.allowRowMove(nextListViewRow, null, after)) {
          return getNextRowIndex(_quantity + quantity);
        }
        return nextListViewRow.getRowIdx();
      };
    })(this);
    return getNextRowIndex(quantity);
  };

  return Modal;

})(CUI.Element);
