class ez5.PdfCreator.Template extends CUI.Element

	initOpts: ->
		super()
		@addOpts
			data:
				check: "PlainObject"
		return @

	getDisplayName: ->
		return ez5.loca.getBestFrontendValue(@_data.name) or $$("pdf-creator.list.template-name.default-value")

	getData: ->
		return @_data

	print: (objects, idMask) ->
		data = CUI.util.copyObject(@_data.documentData, true)
		documentData = ez5.PdfCreatorUtils.initDocumentData(data)
		documentData.idMask = idMask
		pdfDocumentNode = new ez5.PdfCreator.Node.Document(documentData)
		printPromise = ez5.PdfCreatorUtils.print(objects, pdfDocumentNode).fail((errorMessage) ->
			if CUI.util.isString(errorMessage)
				CUI.problem(text: errorMessage)
		)
		return printPromise