// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node.Body = (function(superClass) {
  extend(Body, superClass);

  function Body() {
    return Body.__super__.constructor.apply(this, arguments);
  }

  Body.prototype.__renderPdfContent = function(opts) {
    var body, chunkSize, div, grid, i, layoutData, len, object, objects, offset, ref;
    body = CUI.dom.$element("body");
    layoutData = this.__getLayoutData();
    if (!opts.preview && layoutData.outerBorder) {
      CUI.dom.addClass(body, "outer-border");
    }
    if (!this.children || !opts.objects) {
      return body;
    }
    if (layoutData.mode === "one_object") {
      if (opts.preview) {
        this.__renderObject(opts.objects[0], body, opts);
      } else {
        ref = opts.objects;
        for (i = 0, len = ref.length; i < len; i++) {
          object = ref[i];
          div = CUI.dom.div("pdf-break-page pdf-node-body-single");
          this.__renderObject(object, div, opts);
          CUI.dom.append(body, div);
        }
      }
      return body;
    }
    chunkSize = layoutData.rows * layoutData.columns;
    offset = 0;
    while (opts.objects.length > offset) {
      objects = opts.objects.slice(offset, offset + chunkSize);
      grid = this.__renderPage(objects, opts);
      CUI.dom.append(body, grid);
      offset = offset + chunkSize;
    }
    return body;
  };

  Body.prototype.__renderPage = function(objects, opts) {
    var column, columnGap, columnIndex, columnWidth, div, grid, i, j, layoutData, objectIndex, ref, ref1, row, rowGap, rowHeight, rowIndex;
    grid = CUI.dom.div("pdf-node-body-grid");
    CUI.dom.addClass(grid, "pdf-break-page");
    layoutData = this.__getLayoutData();
    rowHeight = 100 / layoutData.rows;
    columnWidth = 100 / layoutData.columns;
    rowGap = layoutData.rowGap / 2;
    columnGap = layoutData.columnGap / 2;
    objectIndex = 0;
    for (rowIndex = i = 0, ref = layoutData.rows; 0 <= ref ? i < ref : i > ref; rowIndex = 0 <= ref ? ++i : --i) {
      row = CUI.dom.div("pdf-node-body-row");
      CUI.dom.setStyle(row, {
        height: rowHeight + "%"
      });
      if (layoutData.innerBorder) {
        CUI.dom.addClass(row, "inner-border");
      }
      for (columnIndex = j = 0, ref1 = layoutData.columns; 0 <= ref1 ? j < ref1 : j > ref1; columnIndex = 0 <= ref1 ? ++j : --j) {
        column = CUI.dom.div("pdf-node-body-column");
        CUI.dom.append(row, column);
        CUI.dom.setStyle(column, {
          width: columnWidth + "%",
          "padding": rowGap + "mm " + columnGap + "mm " + rowGap + "mm " + columnGap + "mm"
        });
        if (layoutData.innerBorder) {
          CUI.dom.addClass(column, "inner-border");
        }
        div = CUI.dom.div("pdf-node-body-column-inner");
        this.__renderObject(objects[objectIndex], div, opts);
        objectIndex++;
        CUI.dom.append(column, div);
      }
      CUI.dom.append(grid, row);
    }
    return grid;
  };

  Body.prototype.__renderObject = function(object, container, opts) {
    var contentOpts, i, len, node, ref;
    if (!container) {
      return;
    }
    ref = this.children;
    for (i = 0, len = ref.length; i < len; i++) {
      node = ref[i];
      contentOpts = {
        object: object,
        selectedNode: opts.selectedNode,
        preview: opts.preview,
        head: opts.head
      };
      CUI.dom.append(container, node.renderPdfContent(contentOpts));
    }
  };

  return Body;

})(ez5.PdfCreator.Node);
