// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node.Field = (function(superClass) {
  extend(Field, superClass);

  function Field() {
    return Field.__super__.constructor.apply(this, arguments);
  }

  Field.getName = function() {
    return "field";
  };

  Field.prototype.__renderPdfContent = function(_opts) {
    var data, element, fieldsRendererPlain, getFieldData, mask, objecttypeName, opts, selectedFields, span;
    data = this.getData();
    mask = this.__getMask();
    if (CUI.util.isEmpty(_opts.object)) {
      return;
    }
    selectedFields = ez5.PdfCreator.Node.Field.getSelectedFields(data);
    if (CUI.util.isEmpty(selectedFields)) {
      span = CUI.dom.span();
      span.textContent = $$("pdf-creator.settings.node.field.empty-fields");
      return span;
    }
    getFieldData = function(field, opts) {
      var fieldName;
      if (opts == null) {
        opts = {};
      }
      fieldName = ez5.PdfCreator.Node.Field.getFieldName(field, opts);
      if (!fieldName) {
        return;
      }
      return selectedFields[fieldName];
    };
    fieldsRendererPlain = new FieldsRendererPlain();
    mask.invokeOnFields("all", true, (function(_this) {
      return function(field) {
        if (!getFieldData(field)) {
          return;
        }
        return fieldsRendererPlain.addField(field);
      };
    })(this));
    objecttypeName = this.__getObjecttypeName();
    opts = {
      mode: _opts.mode || "detail",
      data: _opts.object[objecttypeName],
      top_level_data: _opts.object,
      inline_mode: data.linked_object_mode,
      nested_condensed_output: data.nested_condensed_output,
      for_print: true,
      removeBlockWidth: true,
      nested_only_first_row: data.nested_only_first_row,
      nested_display_as_table: data.nested_display_as_table,
      getLabel: (function(_this) {
        return function(field, _, opts) {
          var displayName, fieldData, label;
          fieldData = getFieldData(field, opts);
          displayName = ez5.loca.getBestFrontendValue(fieldData != null ? fieldData.label : void 0);
          label = new CUI.Label({
            "class": "ez5-field-label",
            text: displayName,
            multiline: true
          });
          return label;
        };
      })(this),
      isVisible: (function(_this) {
        return function(field, _, opts) {
          return !CUI.util.isEmpty(getFieldData(field, opts));
        };
      })(this)
    };
    element = fieldsRendererPlain.render(opts);
    if (data.row_format) {
      CUI.dom.addClass(element, "row-format");
    }
    if (data.hide_labels) {
      CUI.dom.addClass(element, "hide-labels");
    }
    return element;
  };

  Field.prototype.__getSettingsFields = function() {
    var fields, onHideLabelsChanged;
    this.__fieldSelectorButton = new CUI.FormButton({
      form: {
        label: $$("pdf-creator.settings.node.field.fields|label")
      },
      text: $$("pdf-creator.settings.node.field.select-fields.button"),
      disabled: !this.__getMask(),
      onClick: (function(_this) {
        return function() {
          return _this.__showFieldSelector();
        };
      })(this)
    });
    this.__fieldsSelectedLabel = new CUI.Label({
      text: ""
    });
    onHideLabelsChanged = function(data, field) {
      var rowFormatField;
      rowFormatField = field.getForm().getFieldsByName("row_format")[0];
      if (data.hide_labels) {
        rowFormatField.disable();
      } else {
        rowFormatField.enable();
      }
    };
    fields = [
      this.__fieldSelectorButton, new CUI.DataFieldProxy({
        element: (function(_this) {
          return function() {
            _this.__showSelectedFields();
            return _this.__fieldsSelectedLabel;
          };
        })(this)
      }), {
        type: CUI.Select,
        name: "linked_object_mode",
        form: {
          label: $$("pdf-creator.settings.node.field.linked-object-mode|label"),
          hint: $$("pdf-creator.settings.node.field.linked-object-mode|hint")
        },
        options: (function(_this) {
          return function() {
            return ["text", "short", "standard"].map(function(value) {
              return {
                text: $$("pdf-creator.settings.node.field.linked-object-mode.option." + value),
                value: value
              };
            });
          };
        })(this)
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.field.nested-condensed-output|label")
        },
        name: "nested_condensed_output"
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.field.nested_display_as_table|label")
        },
        name: "nested_display_as_table"
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.field.hide_labels|label")
        },
        name: "hide_labels",
        onDataChanged: onHideLabelsChanged
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.field.row_format|label")
        },
        name: "row_format",
        onDataInit: function(field, data) {
          return onHideLabelsChanged(data, field);
        }
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.field.nested_only_first_row|label")
        },
        name: "nested_only_first_row"
      }
    ];
    return fields;
  };

  Field.prototype.__getStyleSettings = function() {
    return ["class-name"];
  };

  Field.prototype.__showSelectedFields = function() {
    var data, selectedFields, selectedFieldsCount;
    data = this.getData();
    selectedFields = ez5.PdfCreator.Node.Field.getSelectedFields(data);
    selectedFieldsCount = Object.keys(selectedFields).length;
    if (selectedFieldsCount === 0) {
      this.__fieldsSelectedLabel.setText($$("pdf-creator.settings.node.field.select-fields.no-fields-selected|label"));
    } else {
      this.__fieldsSelectedLabel.setText($$("pdf-creator.settings.node.field.select-fields.count|label", {
        count: selectedFieldsCount
      }));
    }
  };

  Field.prototype.__showFieldSelector = function() {
    var data, fieldsForm, fieldsFormDiv, hideSystemFieldsCheckbox, mask, objecttypeManager, ref;
    mask = this.__getMask();
    this.__currentMask = mask;
    data = this.getData();
    data.dataFields = data.dataFields || {};
    objecttypeManager = new ObjecttypeManager();
    objecttypeManager.addMask(this.__getMask());
    objecttypeManager.initCommonFields("all");
    fieldsForm = new FieldsForm({
      otm: objecttypeManager,
      data: data.dataFields,
      treeNodeClass: PdfFieldsFormNode,
      acceptField: function(field, fieldsFormNodeFather) {
        if (!field.mask) {
          return false;
        }
        if (field instanceof CustomDataType && !field.isVisible("detail", {
          for_print: true
        })) {
          return false;
        }
        if (field instanceof CustomDataTypeMappingField) {
          return false;
        }
        return true;
      },
      treeOpts: {
        "class": 'cui-lv--has-datafields',
        maximize: false,
        rowMove: false,
        cols: ["auto"],
        fixedRows: 0
      }
    });
    fieldsFormDiv = fieldsForm.renderForm();
    fieldsForm.open();
    hideSystemFieldsCheckbox = new CUI.Checkbox({
      text: $$("pdf-creator.settings.node.field.select-fields.modal.checkbox.hide-system-fields"),
      onClick: function() {
        var hideShowColumns;
        hideShowColumns = function(nodes) {
          var i, len, node;
          for (i = 0, len = nodes.length; i < len; i++) {
            node = nodes[i];
            if (hideSystemFieldsCheckbox.isActive() && node.field.isTopLevelField()) {
              node.hide();
            } else {
              node.show();
            }
            if (node.children) {
              hideShowColumns(node.children);
            }
          }
        };
        hideShowColumns(fieldsForm.getNodes());
      }
    });
    hideSystemFieldsCheckbox.start();
    if ((ref = this.__fieldSelectorModal) != null) {
      ref.destroy();
    }
    this.__fieldSelectorModal = new CUI.Modal({
      "class": "pdf-creator-field-selector",
      pane: {
        header_left: new CUI.Label({
          text: $$("pdf-creator.settings.node.field.select-fields.modal.header")
        }),
        content: fieldsFormDiv,
        footer_left: hideSystemFieldsCheckbox,
        footer_right: new CUI.Button({
          text: $$("pdf-creator.settings.node.field.select-fields.modal.button"),
          primary: true,
          onClick: (function(_this) {
            return function() {
              _this.__showSelectedFields();
              CUI.Events.trigger({
                node: _this.__fieldSelectorButton,
                type: "data-changed",
                info: {
                  element: _this.__fieldSelectorButton
                }
              });
              _this.__fieldSelectorModal.hide();
            };
          })(this)
        })
      }
    });
    this.__fieldSelectorModal.show();
  };

  Field.prototype.getData = function(isForSaving) {
    var data, key, ref, value;
    if (isForSaving == null) {
      isForSaving = false;
    }
    data = Field.__super__.getData.call(this);
    if (!isForSaving) {
      return data;
    }
    if (data.dataFields) {
      ref = data.dataFields;
      for (key in ref) {
        value = ref[key];
        if (value._enabled) {
          continue;
        }
        delete data.dataFields[key];
      }
    }
    return data;
  };

  Field.getFieldName = function(field, opts) {
    var fieldName;
    if (opts == null) {
      opts = {};
    }
    if (!field.mask) {
      return;
    }
    if (opts._path) {
      fieldName = opts._path + "." + field.fullName(false);
    } else {
      fieldName = field.fullName();
    }
    return fieldName;
  };

  Field.getSelectedFields = function(data) {
    var fields, key, ref, value;
    if (!data.dataFields) {
      return {};
    }
    fields = {};
    ref = data.dataFields;
    for (key in ref) {
      value = ref[key];
      if (!value._enabled) {
        continue;
      }
      fields[key] = value;
    }
    return fields;
  };

  return Field;

})(ez5.PdfCreator.Node);

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.Field);
