// Generated by CoffeeScript 1.12.7
var PresentationPowerpointDownloadManager,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

PresentationPowerpointDownloadManager = (function(superClass) {
  extend(PresentationPowerpointDownloadManager, superClass);

  function PresentationPowerpointDownloadManager() {
    return PresentationPowerpointDownloadManager.__super__.constructor.apply(this, arguments);
  }

  PresentationPowerpointDownloadManager.prototype.readOpts = function() {
    this.version_ids = {};
    this.placeholder_infos = {};
    return PresentationPowerpointDownloadManager.__super__.readOpts.call(this);
  };

  PresentationPowerpointDownloadManager.prototype.loca_key = function(key) {
    return CUI.util.toDot(this.__cls) + "." + key;
  };

  PresentationPowerpointDownloadManager.prototype.getMenuButton = function() {
    return {
      loca_key: this.loca_key("button.menu"),
      ui: "presentation.powerpoint.download.manager.button",
      onClick: (function(_this) {
        return function() {
          return _this.startExport();
        };
      })(this)
    };
  };

  PresentationPowerpointDownloadManager.prototype.getTitle = function() {
    return $$(this.loca_key("dialog.title"));
  };

  PresentationPowerpointDownloadManager.prototype.getAssetVersionsToExport = function(asset, gid) {
    var _eas_id, allowed_extensions, found, ref, ref1, ref2, v, v_name, version;
    if (!asset) {
      [];
    }
    version = Asset.getBestImageForViewport(asset, this.pptx_form.quality, this.pptx_form.quality);
    if (version) {
      allowed_extensions = ["png", "jpg", "jpeg", "ppm", "gif", "tif", "tiff", "bmp"];
      if (ref = version.extension, indexOf.call(allowed_extensions, ref) < 0) {
        found = false;
        ref1 = asset.value.versions;
        for (v_name in ref1) {
          v = ref1[v_name];
          if (ref2 = v.extension, indexOf.call(allowed_extensions, ref2) >= 0) {
            version = v;
            found = true;
            break;
          }
        }
        if (!found) {
          version = null;
        }
      }
    }
    if (!version) {
      this.placeholder_infos[asset.value._id] = asset.value.compiled;
      return [];
    } else {
      _eas_id = version._id;
      if (!_eas_id) {
        _eas_id = asset.value._id;
      }
      if (_eas_id) {
        this.version_ids[asset.value._id] = _eas_id;
      }
      return [version];
    }
  };

  PresentationPowerpointDownloadManager.prototype.filterDownloadableFiles = function(files) {
    var f, i, len;
    for (i = 0, len = files.length; i < len; i++) {
      f = files[i];
      if (f.path.endsWith(".pptx")) {
        return [f];
      }
    }
    return [];
  };

  PresentationPowerpointDownloadManager.prototype.__enrich_slide = function(s) {
    var k, ref, ref1, v;
    if (s.global_object_id) {
      if ((ref = this.data_by_gid[s.global_object_id]) != null ? ref.standard_info : void 0) {
        s.standard_info = {};
        ref1 = this.data_by_gid[s.global_object_id].standard_info;
        for (k in ref1) {
          v = ref1[k];
          if (!v || v === '') {
            continue;
          }
          s.standard_info[k] = v;
        }
      }
    }
    if (s.asset_id) {
      if (this.version_ids[s.asset_id]) {
        s.version_id = this.version_ids[s.asset_id];
      } else if (this.placeholder_infos[s.asset_id]) {
        s.placeholder_info = this.placeholder_infos[s.asset_id];
      }
    }
    return s;
  };

  PresentationPowerpointDownloadManager.prototype.getExportSaveData = function() {
    var data, i, len, ref, s;
    data = PresentationPowerpointDownloadManager.__super__.getExportSaveData.call(this);
    data["export"].produce_options.pptx_form = CUI.util.copyObject(this.pptx_form, true);
    data["export"].produce_options.plugin = "easydb-presentation-pptx-plugin:create_pptx";
    ref = data["export"].produce_options.presentation.slides;
    for (i = 0, len = ref.length; i < len; i++) {
      s = ref[i];
      if (s.center) {
        s.center = this.__enrich_slide(s.center);
      }
      if (s.left) {
        s.left = this.__enrich_slide(s.left);
      }
      if (s.right) {
        s.right = this.__enrich_slide(s.right);
      }
    }
    delete data["export"].produce_options.presentation.data_by_gid;
    delete data["export"].produce_options.pptx_form._undo;
    return data;
  };

  PresentationPowerpointDownloadManager.prototype.getContent = function() {
    var fields, i, j, len, len1, pptx_config, quality, quality_opts, ref, ref1, ref2, ref3, template_opts, tmpl;
    pptx_config = ez5.pluginManager.getPlugin("easydb-presentation-pptx-plugin").getOpts();
    this.pptx_form = {};
    fields = [];
    template_opts = [];
    ref1 = ((ref = pptx_config["custom"]) != null ? ref.templates : void 0) || [];
    for (i = 0, len = ref1.length; i < len; i++) {
      tmpl = ref1[i];
      if (!this.pptx_form.template) {
        this.pptx_form.template = tmpl;
      }
      template_opts.push({
        text: $$(this.loca_key("form.template." + tmpl.name)),
        value: tmpl
      });
    }
    fields.push({
      form: {
        label: $$(this.loca_key("form.label.template"))
      },
      type: CUI.Options,
      name: "template",
      options: template_opts,
      radio: true,
      horizontal: false
    });
    quality_opts = [];
    ref3 = ((ref2 = pptx_config["custom"]) != null ? ref2.qualities : void 0) || [];
    for (j = 0, len1 = ref3.length; j < len1; j++) {
      quality = ref3[j];
      if (!this.pptx_form.quality) {
        this.pptx_form.quality = parseInt(quality);
      }
      quality_opts.push({
        text: $$(this.loca_key("form.quality." + quality)),
        value: parseInt(quality)
      });
    }
    fields.push({
      form: {
        label: $$(this.loca_key("form.label.quality"))
      },
      type: CUI.Select,
      name: "quality",
      options: quality_opts
    });
    fields.push({
      type: CUI.Output,
      placeholder: $$(this.loca_key("form.hint"))
    });
    return new CUI.Form({
      data: this.pptx_form,
      fields: fields
    }).start();
  };

  return PresentationPowerpointDownloadManager;

})(PresentationDownloadManager);

Presentation.registerDownloadManager(PresentationPowerpointDownloadManager);
