# -*- coding: utf-8 -*-

from context import get_json_value

def make_map(name, data):
    return {
        'type': 'map',
        'name': name,
        'data': data
    }

def make_data(dtype, name, value, unit=None):
    data = {
        'type': dtype,
        'name': name
    }
    if (isinstance(value, list)):
        data['values'] = value
    else:
        data['value'] = value
    if unit != None:
        data['unit'] = unit
    return data

def make_error(name, key, message = {}):
    return {
        'error': {
            'code': key,
            'parameters': {
                "msg": message
            }
        },
        'type': 'error',
        'name': name
    }

def make_table(name, header_name, header_values, data):
    return {
        'type': '2d-map',
        'name': name,
        'headers': {
            'name': header_name,
            'values': header_values
        },
        'data': data
    }

def get_config(config, variable, default_value=None):
    path = variable.split('/')
    return _get_config(config, path, default_value)

def _get_config(current, path, default_value):
    if len(path) == 0:
        return current
    if path[0] not in current:
        return default_value
    return _get_config(current[path[0]], path[1:], default_value)
