// Generated by CoffeeScript 1.12.7
var BaseConfigWordpress,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

BaseConfigWordpress = (function(superClass) {
  extend(BaseConfigWordpress, superClass);

  function BaseConfigWordpress() {
    return BaseConfigWordpress.__super__.constructor.apply(this, arguments);
  }

  BaseConfigWordpress.prototype.getFieldDefFromParm = function(baseConfig, pname, def, parent_def) {
    var field, http_auth_fields, oauth_fields, set_visibility;
    if (def.plugin_type !== "wordpress-auth") {
      return;
    }
    console.debug("BaseConfigWordpress.getFieldDefFromParm:", this.data, pname, def, baseConfig.locaKey("parameter"));
    field = {
      type: CUI.Form,
      name: "auth",
      form: {
        column: "maximize"
      },
      onDataInit: (function(_this) {
        return function(_form, _data) {
          if (!_data.uuid) {
            _data.uuid = ez5.generateUUID();
          }
          set_visibility(_form);
        };
      })(this),
      onDataChanged: (function(_this) {
        return function(data, df) {
          return set_visibility(df.getForm());
        };
      })(this),
      fields: [
        {
          type: CUI.Select,
          name: "auth_type",
          form: {
            label: $$("wordpress.config.auth_type.label")
          },
          options: [
            {
              text: $$("wordpress.config.auth_type.option.http-auth"),
              value: "http-auth"
            }, {
              text: $$("wordpress.config.auth_type.option.oauth-1"),
              value: "oauth-1"
            }
          ]
        }, {
          form: {
            label: $$("wordpress.config.http_auth_login.label")
          },
          type: CUI.Input,
          name: "http_auth_login"
        }, {
          form: {
            label: $$("wordpress.config.http_auth_password.label")
          },
          type: CUI.Input,
          name: "http_auth_password"
        }, {
          form: {
            label: $$("wordpress.config.oauth_client_key.label")
          },
          type: CUI.Input,
          regexp: "^[a-z0-9]*$",
          regexp_flags: "i",
          prevent_invalid_input: true,
          name: "oauth_client_key"
        }, {
          form: {
            label: $$("wordpress.config.oauth_client_secret.label")
          },
          type: CUI.Input,
          regexp: "^[a-z0-9]*$",
          regexp_flags: "i",
          prevent_invalid_input: true,
          name: "oauth_client_secret"
        }, {
          type: CUI.FormButton,
          name: "oauth_btn_generate",
          text: $$("wordpress.config.oauth_client_secret.button.generate"),
          onClick: (function(_this) {
            return function(ev, df) {
              var access_token, baseUrl, check_win, data, form, msg_listener, new_window, parent_data, url;
              form = df.getForm();
              data = form.getData();
              parent_data = form.getParentData();
              if (ez5.version("6")) {
                baseUrl = CUI.parseLocation(ez5.pluginManager.getPlugin("easydb-wordpress-plugin").getPluginURL()).path;
              } else {
                baseUrl = "/api/v1/plugin/base/easydb-wordpress-plugin";
              }
              url = baseUrl + "/oauth1?" + CUI.encodeUrlData({
                wp_url: parent_data.url,
                client_key: data.oauth_client_key,
                client_secret: data.oauth_client_secret
              });
              if (window.easydb_server_url && ez5.session.getPref("plugins_load_from_remote")) {
                url = window.easydb_server_url + url;
              }
              if (ez5.session["data"]) {
                access_token = ez5.session["data"]["access_token"];
                if (access_token) {
                  url += "&access_token=" + access_token;
                }
              }
              console.debug("opening:", url, data, parent_data);
              new_window = window.open(url, "_blank", "width=500,height=500,top=50%,left=50%,menubar=0");
              check_win = function() {
                if (new_window.closed) {
                  console.debug("ignore listener", msg_listener);
                  return CUI.Events.ignore(msg_listener);
                } else {
                  return CUI.setTimeout({
                    ms: 100,
                    call: check_win
                  });
                }
              };
              check_win();
              return msg_listener = CUI.Events.listen({
                type: "message",
                node: window,
                call: function(ev) {
                  var adata, i, key, len, ref;
                  adata = ev.getNativeEvent().data;
                  console.error("Message received:", adata);
                  new_window.close();
                  if (adata.error) {
                    CUI.problem({
                      text: $$(adata.error.code, adata.error.parameters)
                    });
                  } else {
                    ref = ["oauth_token", "oauth_token_secret"];
                    for (i = 0, len = ref.length; i < len; i++) {
                      key = ref[i];
                      form.getFieldsByName(key)[0].setValue(adata[key], {
                        no_trigger: false
                      });
                    }
                  }
                }
              });
            };
          })(this)
        }, {
          form: {
            label: $$("wordpress.config.oauth_token.label")
          },
          type: CUI.Input,
          name: "oauth_token"
        }, {
          form: {
            label: $$("wordpress.config.oauth_token_secret.label")
          },
          type: CUI.Input,
          name: "oauth_token_secret"
        }
      ]
    };
    oauth_fields = ["oauth_client_key", "oauth_client_secret", "oauth_btn_generate", "oauth_token", "oauth_token_secret"];
    http_auth_fields = ["http_auth_login", "http_auth_password"];
    set_visibility = (function(_this) {
      return function(form) {
        var hide, i, j, key, len, len1, show;
        show = [];
        hide = [];
        console.debug("auth type: ", form.getData().auth_type);
        switch (form.getData().auth_type) {
          case "oauth-1":
            show = oauth_fields;
            hide = http_auth_fields;
            break;
          case "http-auth":
            hide = oauth_fields;
            show = http_auth_fields;
        }
        for (i = 0, len = show.length; i < len; i++) {
          key = show[i];
          form.getFieldsByName(key)[0].show(true);
        }
        for (j = 0, len1 = hide.length; j < len1; j++) {
          key = hide[j];
          form.getFieldsByName(key)[0].hide(true);
        }
        return CUI.Events.trigger({
          type: "content-resize",
          node: form
        });
      };
    })(this);
    return field;
  };

  return BaseConfigWordpress;

})(BaseConfigPlugin);

CUI.ready((function(_this) {
  return function() {
    return BaseConfig.registerPlugin(new BaseConfigWordpress());
  };
})(this));
