class AutoKeyworder extends BaseConfigPlugin
	getFieldDefFromParm: (baseConfig, fieldName, def) ->
		sort = (a, b) ->
			return a.text.localeCompare(b.text)

		switch def.plugin_type
			when "auto_keyworder_objecttype"
				field = new ez5.ObjecttypeSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.objecttype.label")
					name: fieldName
					show_name: true
					store_value: "fullname"
					filter: (objecttype) =>
						id = objecttype.table.id()
						if CUI.util.isString(id)
							return false
						mask = Mask.getMaskByMaskName("_all_fields", objecttype.table.id())
						if not mask
							return false

						objecttype.addMask(mask)

						data = objecttype: objecttype.table.name()

						# objecttype must have an asset and datetime field
						if not objecttype.getFields().some((field) => @__filterByAssetField(field, data))
							return false
						if not objecttype.getFields().some((field) => @__filterByDateTimeField(field, data))
							return false

						# objecttype must have a text field or linked object(s) with a text field
						if objecttype.getFields().some((field) => @__filterByTextField(field, data))
							return true
						if objecttype.getFields().some((field) => @__filterByKeywordField(field, data))
							return true

						return false

			when "auto_keyworder_asset_version"
				options = [
					text: $$("server.config.parameter.system.auto_keyworder.asset_version.placeholder")
					value: null
					disabled: true
				,
					value: "original"
				]
				for version in ez5.session.config.eas?.image?.versions
					options.push(value: version.version)

				field = new CUI.Select
					form: label: $$("server.config.parameter.system.auto_keyworder.asset_version.label")
					name: fieldName
					options: options
			when "auto_keyworder_asset_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.asset_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByAssetField
					sort: sort
			when "auto_keyworder_timestamp_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.timestamp_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByDateTimeField
					sort: sort
			when "cloudsight_subject_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.subject_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByTextField
					sort: sort
			when "cloudsight_keyword_categories_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.categories_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "cloudsight_keyword_similar_objects_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.similar_objects_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "cloudsight_keyword_quantity_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.quantity_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "clousight_keyword_gender_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.gender_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "clousight_keyword_material_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.material_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "cloudsight_keyword_color_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_cloudsight.color_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "imagga_tag_target_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_imagga.target_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
			when "deepva_type_target_field"
				field = new ez5.FieldSelector
					form: label: $$("server.config.parameter.system.auto_keyworder.configs_deepva.target_field.label")
					name: fieldName
					objecttype_data_key: "objecttype"
					store_value: "fullname"
					show_name: true
					deep_linked_objects: true
					placeholder: $$("server.config.parameter.system.auto_keyworder.no_field_selected")
					filter: @__filterByKeywordField
					sort: sort
		return field

	__filterByAssetField: (field, data) ->
		# filter for a asset field in top level
		if field.table.name() != data.objecttype
			return false
		if field.insideNested()
			return false
		return field.__cls == "ez5-eas-column"

	__filterByTextField: (field, data) ->
		# filter for a text field in top level
		if field.table.name() != data.objecttype
			return false
		if field.insideNested()
			return false
		return field.__cls == "ez5-text-column"

	__filterByDateTimeField: (field, data) ->
		# filter for a datetime field in top level
		if field.table.name() != data.objecttype
			return false
		if field.insideNested()
			return false
		return field.__cls == "ez5-date-time-column"

	__filterByKeywordField: (field, data) ->
		if field instanceof MaskSplitter
			return false

		if field.isSystemField()
			return false
		if field.isTopLevelField()
			return false

		if not field instanceof TextColumn
			return false
		if field instanceof NumberColumn
			return false
		if field instanceof EASColumn
			return false
		if field instanceof DateColumn
			return false
		if field instanceof BooleanColumn
			return false

		return true

ez5.session_ready =>
	BaseConfig.registerPlugin(new AutoKeyworder())

