class BaseMigrationNodePool extends BaseMigrationNodeData

	getDisplayText: ->
		ez5.loca.getBestFrontendValue(@getData().pool.name)

	hasRightPane: ->
		true

	getActionPane: ->
		pane = @getActionPaneBase()

		ez5.api.pool().done (pools) =>
			target_pools = BaseMigrationNodePool.buildPoolTree(@getMigration(), pools)
			target_pools.sort((poolNode, nextPoolNode) ->
				return poolNode.getDisplayText().localeCompare(nextPoolNode.getDisplayText())
			)


			@__targetTree = new CUI.ListViewTree
				cols: ["maximize"]
				selectableRows: true
				header_left: new CUI.Label(text: $$("base.migration.node.pool.target.text"))
				children: target_pools
				onSelect: =>
					@checkMigrateButton()
				onDeselect: =>
					@checkMigrateButton()

			@getLayout().replace(@__targetTree.render(), "right")
			@__targetTree.root.open()

		pane

	getActionFields: ->
		[
			type: CUI.Output
			form:
				label: $$("base.migration.node.pool.text")
			text: @getDisplayText()
		,
			type: CUI.Options
			name: "migrate"
			form:
				label: $$("base.migration.common.selection")
			options: [
				text: $$("base.migration.node.pool.check_acl", acl_count: @getData()._acl.length)
				disabled: @getData()._acl.length == 0
				value: "acl"
			]
		,
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$("base.migration.common.options")
			options: [
				text: $$("base.migration.common.replace")
				value: "replace"
			,
				text: $$("base.migration.common.add")
				value: "add"
			]
		]



	migrate: (ev, action_data) ->
		console.debug "migrate Pool:", @getDisplayText()

		target_pool_node = @__targetTree.getSelectedNode()
		target_pool = target_pool_node.getData()

		source_pool = @getData()
		migration = @getMigration()

		save_pool =
			_basetype: "pool"
			pool:
				_id: target_pool.pool._id
				_id_parent: target_pool.pool._id_parent
				_version: target_pool.pool._version + 1

		if target_pool.pool.is_system_pool
			# we are not allowed to send _id_parent
			# for system pools
			delete(save_pool.pool._id_parent)

		do_save = false

		if "acl" in action_data.migrate
			new_acl = migration.migrateACL(source_pool._acl)
			if new_acl.length > 0
				save_pool._acl = []
				if action_data.mode == "add"
					save_pool._acl.push.apply(save_pool._acl, target_pool._acl)

				save_pool._acl.push.apply(save_pool._acl, new_acl)
				save_pool._private_acl = source_pool._private_acl
				do_save = true

		if not do_save
			console.debug "no migratable data."
			return CUI.resolvedPromise()


		if ev.hasModifierKey()
			console.debug "pool save:", CUI.util.dump(save_pool)
			return CUI.resolvedPromise()

		@log($$("base.migration.console.log.pool.saving.md", name: @getDisplayText()))

		ez5.api.pool
			type: "POST"
			json_data: [ save_pool ]
		.done (pool_data) =>
			@log($$("base.migration.console.log.pool.saved.md",
				name: @getDisplayText()
				count_acl: save_pool._acl.length
			))
			console.debug "pool_data", pool_data
			target_pool_node.setData(pool_data[0])


	checkMigrateButton: ->
		@__migrateBtn.disable()
		if not @__targetTree?.getSelectedNode()
			return
		if @__actionData.migrate.length == 0
			return
		@__migrateBtn.enable()
		return

	@buildPoolTree: (migration, data) ->
		console.debug "building pool tree", data
		ez5.buildObjectTree
			objects: data
			objectKey: "pool"
			doOpen: false
			newInstanceFunc: (o) ->
				new BaseMigrationNodePool(migration: migration, data: o)

	@getSourceNodesFromData: (migration, data) ->
		pools = BaseMigrationNodePool.buildPoolTree(migration, data)
		pools.sort (a, b) =>
			a.getDisplayText().localeCompare(b.getDisplayText())

		[new BaseMigrationNodeStructure(migration: migration, name: $$("base.migration.node.pool.pools.text"), children: pools)]



