class BaseMigrationNodePreset extends BaseMigrationNodeData

	initOpts: ->
		super()
		@addOpts
			context:
				mandatory: true

	getDisplayText: ->
		ez5.loca.getBestFrontendValue(@getData().right_preset.displayname)

	@getSourceNodesFromData: (migration, data) ->
		children = []

		for context, contextData of data
			contextChildren = []
			for preset in contextData
				contextChildren.push(new BaseMigrationNodePreset(migration: migration, data: preset, context: context))
			children.push(new BaseMigrationNodePresetContext(migration: migration, context: context, children: contextChildren))

		[new BaseMigrationNodePresets(migration: migration, children: children)]

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	checkMigrateButton: ->
		@__migrateBtn.enable()

	getActionFields: ->
		[
			type: CUI.Output
			form:
				label: if @children then $$("base.migration.node.presets.text") else $$("base.migration.node.preset.text")
			text: @getDisplayText()
		]

	migrate: ->
		position = BaseMigrationNodePresetContext::getNextPresetPosition.apply(@)
		presetData = @getPreset(position)
		BaseMigrationNodePresetContext::savePresets.apply(@, [[presetData]])

	getPreset: (position) ->
		data = @getData()
		data.right_preset._position = position
		data.right_preset._version = 1
		delete data.right_preset._id
		return data

