// Generated by CoffeeScript 1.12.7
var BaseMigrationNodePresetContext,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

BaseMigrationNodePresetContext = (function(superClass) {
  extend(BaseMigrationNodePresetContext, superClass);

  function BaseMigrationNodePresetContext() {
    return BaseMigrationNodePresetContext.__super__.constructor.apply(this, arguments);
  }

  BaseMigrationNodePresetContext.prototype.initOpts = function() {
    BaseMigrationNodePresetContext.__super__.initOpts.call(this);
    return this.addOpts({
      context: {
        mandatory: true
      }
    });
  };

  BaseMigrationNodePresetContext.prototype.getDisplayText = function() {
    return $$("acl.rights.context." + this._context);
  };

  BaseMigrationNodePresetContext.prototype.getActionPane = function() {
    var pane;
    pane = this.getActionPaneBase();
    return pane;
  };

  BaseMigrationNodePresetContext.prototype.checkMigrateButton = function() {
    return this.__migrateBtn.enable();
  };

  BaseMigrationNodePresetContext.prototype.getActionFields = function() {
    return [
      {
        type: CUI.Output,
        form: {
          label: $$("base.migration.node.presets.text")
        },
        text: this.getDisplayText()
      }, {
        type: CUI.Options,
        name: "mode",
        radio: true,
        form: {
          label: $$("base.migration.common.options")
        },
        options: [
          {
            text: $$("base.migration.common.replace"),
            value: "replace"
          }, {
            text: $$("base.migration.common.add"),
            value: "add"
          }
        ]
      }
    ];
  };

  BaseMigrationNodePresetContext.prototype.migrate = function(ev, actionData) {
    var child, deferred, i, len, position, presets, ref;
    position = actionData.mode === "add" ? this.getNextPresetPosition() : 0;
    presets = [];
    ref = this.children;
    for (i = 0, len = ref.length; i < len; i++) {
      child = ref[i];
      presets.push(child.getPreset(position));
      position++;
    }
    if (actionData.mode === "add") {
      return this.savePresets(presets);
    } else {
      deferred = new CUI.Deferred();
      this.deleteCurrentPresets().done((function(_this) {
        return function() {
          return _this.savePresets(presets).done(deferred.resolve).fail(deferred.reject);
        };
      })(this)).fail(deferred.reject);
      return deferred.promise();
    }
  };

  BaseMigrationNodePresetContext.prototype.getNextPresetPosition = function() {
    var presets, ref;
    presets = this.getMigration().getBaseData().preset[this._context] || [];
    return (((ref = presets[presets.length - 1]) != null ? ref.right_preset._position : void 0) + 1) || 0;
  };

  BaseMigrationNodePresetContext.prototype.savePresets = function(presets) {
    this.log($$("base.migration.console.log.presets.saving.md", {
      count: presets.length,
      context: this.getDisplayText()
    }));
    return ez5.api.right({
      type: "POST",
      api: "/" + this._context + "/presets",
      json_data: presets
    }).done((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.presets.migrated.md", {
          count: presets.length,
          context: _this.getDisplayText()
        }));
      };
    })(this)).fail((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.presets.saving-failed.md", {
          count: presets.length,
          context: _this.getDisplayText()
        }));
      };
    })(this));
  };

  BaseMigrationNodePresetContext.prototype.deleteCurrentPresets = function() {
    var deletePromises, i, len, preset, presets;
    deletePromises = [];
    presets = this.getMigration().getBaseData().preset[this._context] || [];
    this.log($$("base.migration.console.log.presets.removing.md", {
      count: presets.length,
      context: this.getDisplayText()
    }));
    for (i = 0, len = presets.length; i < len; i++) {
      preset = presets[i];
      deletePromises.push(this.__deletePreset(preset));
    }
    return CUI.when(deletePromises).done((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.presets.removed.md", {
          count: presets.length,
          context: _this.getDisplayText()
        }));
      };
    })(this)).fail((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.presets.removing-failed.md", {
          count: presets.length,
          context: _this.getDisplayText()
        }));
      };
    })(this));
  };

  BaseMigrationNodePresetContext.prototype.__deletePreset = function(preset) {
    var id;
    id = preset.right_preset._id;
    return ez5.api.right({
      type: "DELETE",
      api: "/" + this._context + "/presets/" + id
    });
  };

  return BaseMigrationNodePresetContext;

})(BaseMigrationNodeData);
