class BaseMigrationNodeTagGroup extends BaseMigrationNodeData
	readOpts: ->
		super()
		@children = []
		for tag in @getData()._tags
			@children.push(new BaseMigrationNodeTag(migration: @_migration, data: tag))

		return

	getDisplayText: ->
		ez5.loca.getBestFrontendValue(@getData().taggroup.displayname)

	getActionPane: ->
		pane = @getActionPaneBase()
		pane

	getActionFields: ->
		[
			type: CUI.Output
			form:
				label: $$("base.migration.node.tag.group.text")
			text: @getDisplayText()
		,
			type: CUI.Options
			name: "migrate"
			form:
				label: $$("base.migration.common.selection")
			options: [
				text: $$("base.migration.node.tag.group.migrate_acl")
				value: "acl"
			]
		,
			type: CUI.Options
			name: "mode"
			radio: true
			form:
				label: $$("base.migration.common.options")
			options: [
				text: $$("base.migration.common.replace")
				value: "replace"
			,
				text: $$("base.migration.common.add")
				value: "add"
			]
		]

	checkMigrateButton: ->
		@__migrateBtn.enable()


	migrate: (ev, action_data) ->
		target = CUI.util.copyObject(@getMigration().getBaseData().tags, true)

		@migrateTagGroup(target, action_data)

		if ev.hasModifierKey()
			console.debug "migrate TagGroup:", CUI.util.dump(target), target
			return CUI.resolvedPromise()

		@saveTags(target)

	saveTags: (tags) ->
		@log($$("base.migration.console.log.tag.saving.md", count: tags.length))

		ez5.api.tags
			type: "POST"
			json_data: tags
		.done (tags) =>
			for taggroup in tags
				_tags = []
				for tag in taggroup._tags
					_tags.push("**"+CUI.MarkdownInput.escape(ez5.loca.getBestFrontendValue(tag.tag.displayname))+"**")

				@log($$("base.migration.console.log.tag.migrated.md",
					name: CUI.MarkdownInput.escape(ez5.loca.getBestFrontendValue(taggroup.taggroup.displayname))
					tags: _tags.join(", ")
				))

			console.debug "updating base data:", tags
			@getMigration().getBaseData().tags = tags
		.fail =>
			@log($$("base.migration.console.log.tag.failed"))

	migrateTagGroup: (target, action_data) ->

		source_tg = CUI.util.copyObject(@getData(), true)
		migration = @getMigration()

		# finds the given tag in the list of "tags"
		find_tags = (search_tag, tags) ->
			dn_search_tag = ez5.loca.getBestFrontendValue(search_tag.tag.displayname).trim()
			return tags.filter(({ tag }) => ez5.loca.getBestFrontendValue(tag.displayname).trim() == dn_search_tag)

		# target already holds the full tags structure, we
		# modifiy it
		add = true
		dn_source = ez5.loca.getBestFrontendValue(source_tg.taggroup.displayname).trim()

		if action_data.mode == "replace"
			if not CUI.util.isEmpty(dn_source)
				# find tag group in source and update
				for tg, idx in target

					if ez5.loca.getBestFrontendValue(tg.taggroup.displayname).trim() != dn_source
						continue

					if not tg.taggroup._id
						# new by migration
						continue

					if tg.__update
						# already updated by migration
						continue

					new_taggroup =
						_basetype: "taggroup"
						__update: true
						taggroup:
							_id: tg.taggroup._id  # keep id
							type: source_tg.taggroup.type
							displayname: source_tg.taggroup.displayname
						_tags: []

					newTags = new Set()

					# copy tags
					for source_tag in source_tg._tags
						target_tags = find_tags(source_tag, tg._tags)
						new_tag = source_tag

						if target_tags.length <= 1
							if target_tags[0]?.tag._id != new_tag.tag._id
								delete new_tag.tag._id
							newTags.add(new_tag)
						else
							for tag in target_tags
								newTags.add(tag)

							@log("
								Found multiple tags with name '#{ez5.loca.getBestFrontendValue(target_tags[0].tag.displayname).trim()}'.
								Can't safely distinguish which to update, needs to be fixed manually!
							")

					new_taggroup._tags = Array.from(newTags)

					add = false
					target[idx] = new_taggroup
					console.info("Taggroup:", dn_source, "updated.")
					break

		if add
			new_taggroup = source_tg
			delete(new_taggroup.taggroup._id)
			delete(new_taggroup._tag_identifier)
			for tag in new_taggroup._tags
				delete(tag.tag._id)

			target.push(new_taggroup)
			console.info("Taggroup:", dn_source, "added.")


		if "acl" not in action_data.migrate
			# remove ACL
			for tag in new_taggroup._tags
				tag._acl = []
		else
			for tag in new_taggroup._tags
				new_acl = migration.migrateACL(tag._acl)
				tag._acl = new_acl

		@

	@getSourceNodesFromData: (migration, data) ->

		taggroups = []
		for taggroup in data
			taggroups.push(new BaseMigrationNodeTagGroup(migration: migration, data: taggroup))

		[new BaseMigrationNodeTagGroups(migration: migration, children: taggroups)]

