class Easydb4MigrationPlugin.BurgHalle extends Easydb4MigrationPlugin
	name: ->
		"burg-halle"

	payload: (filename, json, update, store_file) ->
		if json.import_type == "tags"
			# add the tag "name_verbergen"

			json.tags.push
				taggroup:
					reference: "easydb4:person_kustodie"
					type: "checkbox"
					displayname:
						"de-DE": "Sichtbarkeit"
				_tags: [
					tag:
						shortname: "name_verbergen"
						displayname:
							"de-DE": "Name verbergen"
						is_default: false
						enabled: true
						displaytype: "search"
						type: "individual"
				]

			return

		if json.objecttype == "person_kustodie"
			for obj in json.objects
				if not obj.person_kustodie.namen_verbergen
					continue

				# set tag
				obj._tags = [
					"lookup:_id":
						shortname: "name_verbergen"
				]


		if json.objecttype == "mat_attribute"
			return @splitByType(filename, json, update, store_file, "mat_attribute", "typus")

ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.BurgHalle)
