// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

Easydb4Migration.SyrianWeber = (function(superClass) {
  extend(SyrianWeber, superClass);

  function SyrianWeber() {
    return SyrianWeber.__super__.constructor.apply(this, arguments);
  }

  SyrianWeber.prototype.name = function() {
    return "syrian-weber";
  };

  SyrianWeber.prototype.rpad = function(s, len, pad) {
    while (s.length < len) {
      s = pad + s;
    }
    return s;
  };

  SyrianWeber.prototype.run = function(save_payload_func) {
    var CenturyID, CenturyPosition, CenturyPositionID, _tb, all_data, do_map, fn, get_target, i, id, j, l, len1, len2, map, master_dfr, parts, payloads, promises, ref1, ref2, set_value, target_map;
    all_data = {};
    promises = [];
    ref1 = ["property.RealEstateNo", "photos.PhotoID", "photothematicblocs.PhotoID", "photosdetails.PhotoID", "propertyrealestatetype.RealEstateNo", "realestatestatetbl.ID", "architecttbl.ID", "centurypositiontbl.ID", "countriestbl.ID", "constructionphasestbl.ID", "elementstbl.ID", "functionofunittbl.ID", "importancetbl.ID", "locationtbl.ID", "materialstbl.ID", "numberoffloorstbl.ID", "periodtbl.ID", "photographertbl.ID", "photoqualitytbl.ID", "photos_to_unit.Unit", "photosourcetbl.ID", "phototypestbl.ID", "propertyownershiptbl.ID", "realestatestatetbl.ID", "realestatetypestbl.ID", "regionstbl.ID", "specificationtbl.ID", "thematicblocstbl.ID"];
    fn = (function(_this) {
      return function(parts) {
        var limit, promise, tb, tb_key;
        tb = parts[0];
        tb_key = parts[1];
        if (tb === "photosWEG") {
          limit = "WHERE PhotographerID = '3'";
        } else {
          limit = "";
        }
        promise = _this._migration.query('SELECT * FROM "source.' + tb + '.csv" ' + limit).done(function(data) {
          var j, key, len2, ref2, results, row;
          ref2 = data.rows;
          results = [];
          for (j = 0, len2 = ref2.length; j < len2; j++) {
            row = ref2[j];
            if (!all_data[tb]) {
              all_data[tb] = {};
            }
            key = row[tb_key];
            if (!all_data[tb][key]) {
              all_data[tb][key] = [];
            }
            results.push(all_data[tb][key].push(row));
          }
          return results;
        });
        return promises.push(promise);
      };
    })(this);
    for (i = 0, len1 = ref1.length; i < len1; i++) {
      _tb = ref1[i];
      parts = _tb.split(".");
      fn(parts);
    }
    target_map = {
      ortsthesaurus: {
        easydb4_reference: {
          type: "text",
          type: "text"
        },
        es_architekt_id: {
          table: "person",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "l10n"
          },
          lookup: {
            column: "easydb4_reference"
          },
          type: "text"
        },
        notes: {
          type: "l10n"
        },
        beschreibung: {
          type: "l10n"
        },
        es_beschreibung: {
          type: "l10n"
        },
        namensnutzungsgeschichte: {
          type: "l10n"
        },
        es_datierung_hijri_bereich: {
          type: "date_range"
        },
        es_datierung_gregorian_bereich: {
          type: "date_range"
        },
        gazetteerid: {
          type: "text"
        },
        immobilie_ownership_specs: {
          type: "l10n"
        },
        lk_ownership_id: {
          table: "ortsthesaurus_ownership",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "l10n"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        action: {
          lk_action_id: {
            table: "action",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "l10n"
            }
          }
        },
        bedeutung: {
          bedeutung_id: {
            table: "bedeutung",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "l10n"
            },
            db_column: "lk_bedeutung_id"
          }
        },
        epoche: {
          es_epoche_id: {
            table: "epoche",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "l10n"
            },
            db_column: "lk_epoche_id"
          }
        }
      },
      pool: {
        lk_pool_id: {
          type: "pool"
        }
      },
      bilder: {
        easydb4_reference: {
          type: "text"
        },
        beschreibung: {
          type: "text"
        },
        ueberschrift: {
          type: "l10n"
        },
        original_datum: {
          type: "date"
        },
        quelle: {
          type: "text"
        },
        material_der_vorlage_id: {
          table: "material_der_vorlage",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "l10n"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        ersteller_der_vorlage_id: {
          table: "person",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "l10n"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        lk_schlagwort_id: {
          table: "schlagwort",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "text"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        szene_der_vorlage_id: {
          table: "szene_der_vorlage",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "l10n"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        art_der_vorlage_id: {
          table: "art_der_vorlage",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        art_des_motivs_id: {
          table: "art_des_motivs",
          create: {
            reference: {
              column: "easydb4_reference"
            },
            column: "name",
            type: "l10n"
          },
          lookup: {
            column: "easydb4_reference"
          }
        },
        ebene: {
          lk_ebene_id: {
            table: "ebene",
            create: {
              reference: {
                column: "easydb4_reference",
                value_template: "weber:%value%"
              },
              column: "name",
              type: "l10n"
            },
            lookup: {
              column: "easydb4_reference"
            }
          }
        },
        element: {
          lk_element_id: {
            table: "element",
            create: {
              reference: {
                column: "easydb4_reference",
                value_template: "weber:%value%"
              },
              column: "name",
              type: "l10n"
            },
            lookup: {
              column: "easydb4_reference"
            }
          }
        },
        technik: {
          lk_technik_id: {
            table: "technik",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "l10n"
            }
          }
        },
        material: {
          lk_material_id: {
            table: "material",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "l10n"
            }
          }
        },
        stilmerkmal: {
          lk_stilmerkmal_id: {
            table: "stilmerkmal",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "text"
            }
          }
        },
        teilelement: {
          lk_teilelement_id: {
            table: "teilelement",
            lookup: {
              column: "easydb4_reference"
            },
            create: {
              reference: {
                column: "easydb4_reference"
              },
              column: "name",
              type: "l10n"
            }
          }
        }
      }
    };
    map = {
      property: {
        construction_phase: {
          "Gazetteer ID": {
            mapFunc: function(source, dest) {
              return dest["lookup:_id_parent"] = {
                gazetteerid: source["Gazetteer ID"]
              };
            }
          },
          RealEstateNo: {
            mapFunc: (function(_this) {
              return function(source, dest) {
                dest.__RealEstateNo = source.RealEstateNo;
                return dest.name = source.RealEstateNo;
              };
            })(this),
            copy: {
              table: "ortsthesaurus",
              column: "easydb4_reference",
              value_template: "weber:property:construction_phase:%value%"
            }
          },
          CenturyID: {
            mapFunc: (function(_this) {
              return function(source, dest) {
                var nesobj, nested, ref2;
                nested = "_nested:ortsthesaurus__periode";
                if (!dest[nested]) {
                  dest[nested] = [];
                }
                nesobj = {
                  lk_attribute_zahl_id: {
                    _objecttype: "attribute",
                    _mask: "_all_fields",
                    attribute: {
                      "lookup:_id": {
                        easydb4_reference: "weber:Century:" + source.CenturyID
                      }
                    }
                  }
                };
                if ((ref2 = source.CenturyPositionID) === "2" || ref2 === "3" || ref2 === "4") {
                  nesobj.lk_periode_id = {
                    _objecttype: "periode",
                    _mask: "_all_fields",
                    periode: {
                      "lookup:_id": {
                        easydb4_reference: "weber:CenturyPosition:" + source.CenturyPositionID
                      }
                    }
                  };
                }
                if (source.EstimatedCentury === "WAHR") {
                  nesobj.lk_attribute_id = {
                    _objecttype: "attribute",
                    _mask: "_all_fields",
                    attribute: {
                      "lookup:_id": {
                        easydb4_reference: "weber:EstimatedCentury:approx"
                      }
                    }
                  };
                }
                dest[nested].push(nesobj);
              };
            })(this)
          },
          CenturyPositionID: null,
          EstimatedCentury: null,
          PeriodID: {
            use_table: {
              csv: "periodtbl",
              table: "Table",
              column: "Feld",
              value_column: "Value"
            }
          },
          ArchitectID: {
            use_table: {
              csv: "architecttbl",
              table: "Table",
              column: "Feld",
              value_column: "Value"
            }
          },
          HijriYear: {
            date: {
              table: "ortsthesaurus",
              column: "es_datierung_hijri_bereich",
              month: "HijriMonth",
              day: "HijriDay"
            }
          },
          GregorianYear: {
            date: {
              table: "ortsthesaurus",
              column: "es_datierung_gregorian_bereich",
              month: "GregorianMonth",
              day: "GregorianDay"
            }
          },
          Notes2: {
            copy: {
              table: "ortsthesaurus",
              column: "beschreibung",
              value_template: "[ Stefan Weber: %value% ]"
            }
          },
          ConstructionPhases: {
            use_table: {
              csv: "constructionphasestbl",
              table: "Tabelle",
              column: "Feld",
              value_column: "Value",
              value_template: "[ Weber: %value% ]"
            }
          }
        },
        location: {
          "Gazetteer ID": {
            mapFunc: (function(_this) {
              return function(source, dest) {
                return dest.gazetteerid = source["Gazetteer ID"];
              };
            })(this)
          },
          Notes: {
            copy: {
              table: "ortsthesaurus",
              column: "notes",
              value_template: "[ SHAP: %value% ]"
            }
          },
          RealEstateNo: {
            mapFunc: (function(_this) {
              return function(source, dest) {
                if (!dest.__RealEstateNo) {
                  dest.__RealEstateNo = [];
                }
                dest.__RealEstateNo.push(source.RealEstateNo);
                dest.name = source["Gazetteer ID"] + " [" + dest.__RealEstateNo.join(",") + "]";
              };
            })(this)
          },
          UsedByNameL: {
            copy: {
              table: "ortsthesaurus",
              column: "namensnutzungsgeschichte",
              value_template: "[ original: %value% ]"
            }
          },
          UserSpecification: {
            copy: {
              table: "ortsthesaurus",
              column: "namensnutzungsgeschichte",
              value_template: "[ user specification: %value% ]"
            },
            mapFunc: function(source, dest) {
              var nesobj, nested;
              nested = "_nested:ortsthesaurus__autornamensnutzungsgeschichte_neu";
              if (!dest[nested]) {
                dest[nested] = [];
              }
              nesobj = {
                autornamensnutzungsgeschichte_id: {
                  _objecttype: "person",
                  _mask: "_all_fields",
                  person: {
                    "lookup:_id": {
                      easydb4_reference: "weber:Person:Weber"
                    }
                  }
                }
              };
              dest[nested].push(nesobj);
              return dest[nested + ":group_mode"] = "append";
            }
          },
          RegionID: null,
          PropertyOwnershipID: {
            use_table: {
              csv: "propertyownershiptbl",
              table: "Table",
              column: "Feld",
              value_column: "Value"
            }
          },
          EstimatedCadastreNumber: {
            boolean: {
              table: "ortsthesaurus",
              column: "beschreibung",
              value: "[ Weber: estimated cadastral number, becaused vanished or a later division. ]"
            }
          },
          OwnershipSpecification: {
            copy: {
              table: "ortsthesaurus",
              column: "immobilie_ownership_specs",
              value_template: "[Original: %value%]"
            }
          },
          RealEstateStateID: {
            use_table: {
              csv: "realestatestatetbl",
              table: "Table",
              column: "Feld",
              value_column: "Value",
              map: {
                registerno: "Value 1",
                datum: "Value 2"
              }
            }
          },
          StructuralFabric: {
            copy: {
              table: "ortsthesaurus",
              column: "beschreibung",
              value_template: "[ structual fabric: %value% ]"
            }
          },
          Importance: {
            use_table: {
              csv: "importancetbl",
              table: "Table",
              column: "Feld",
              value_column: "Value"
            }
          }
        }
      },
      photos: {
        RealEstateNo: {
          mapFunc: (function(_this) {
            return function(source, dest) {
              var gaz_id, ref2;
              gaz_id = (ref2 = all_data.property[source.RealEstateNo]) != null ? ref2[0]["Gazetteer ID"] : void 0;
              if (!gaz_id) {
                _this._migration.logerror("Gazetteer ID not found for PhotoID: " + source.PhotoID + " RealEstateNo: " + source.RealEstateNo);
                return;
              }
              dest.erstellungsphase_id = {
                _objecttype: "ortsthesaurus",
                _mask: "_all_fields",
                ortsthesaurus: {
                  "lookup:_id": {
                    easydb4_reference: "weber:property:construction_phase:" + source.RealEstateNo
                  }
                }
              };
              dest.ort_des_motivs_id = {
                _objecttype: "ortsthesaurus",
                _mask: "_all_fields",
                ortsthesaurus: {
                  "lookup:_id": {
                    gazetteerid: gaz_id
                  }
                }
              };
            };
          })(this)
        },
        PhotoID: {
          copy: {
            table: "bilder",
            column: "easydb4_reference",
            value_template: "weber:photos:%value%"
          }
        },
        FunctionOfUnitID: {
          use_table: {
            csv: "functionofunittbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        },
        HistoricalPhotograph: {
          boolean: {
            table: "bilder",
            column: "art_der_vorlage_id",
            value: "Vintage print"
          }
        },
        MuseumDatabase: {
          boolean: {
            table: "bilder",
            column: "art_der_vorlage_id",
            value: "[Digital source]"
          }
        },
        Notes: {
          copy: {
            table: "bilder",
            column: "beschreibung",
            value_template: "[ Weber: %value% ]"
          }
        },
        PhotoYear: {
          date: {
            table: "bilder",
            column: "original_datum",
            month: "PhotoMonth",
            day: "PhotoDay"
          }
        },
        PhotoQualityID: {
          use_table: {
            csv: "photoqualitytbl",
            table: "Table",
            column: "Field",
            value_column: "Value"
          }
        },
        PropertyOwnershipID: null,
        PhotoSource: {
          use_table: {
            csv: "photosourcetbl",
            table: "Table",
            column: "Feld",
            pool_column: "Pool > collection id",
            value_column: "Value"
          }
        },
        PhotoRefNo: {
          eas: {
            column: "bild",
            path: "PhotoRefNo",
            ext: "PhotoRefNoExt"
          }
        },
        MapRefNo: {
          eas: {
            column: "bild",
            path: "MapRefNo",
            ext: "MapRefNoExt"
          }
        },
        PhotoTypeID: {
          use_table: {
            csv: "phototypestbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        },
        PhotographerID: {
          use_table: {
            csv: "photographertbl",
            table: "Table",
            column: "Feld",
            value_column: "Value",
            pool_column: "Pool > collection id"
          }
        },
        Unit: {
          use_table: {
            csv: "photos_to_unit",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        },
        RealEstateTypeID: {
          use_table: {
            csv: "realestatetypestbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        }
      },
      photosdetails: {
        SpecificationID: {
          use_table: {
            csv: "specificationtbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        },
        ElementID: {
          use_table: {
            csv: "elementstbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        },
        MaterialID: {
          use_table: {
            csv: "materialstbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        },
        PeriodID: {
          use_table: {
            csv: "periodtbl",
            table: "Table",
            column: "Feld",
            value_column: "Value"
          }
        }
      }
    };
    get_target = (function(_this) {
      return function(dest) {
        var dest_column, dest_table, ref2, ref3, ref4, ref5, row, source_col, table, target, target_col;
        target = {
          info: null,
          nested: null,
          ignore: false,
          nested_object: {}
        };
        if (dest.csv) {
          row = dest.row;
          if (!row) {
            console.warn("Target not found:", dest.csv, "Row:", row);
            return null;
          }
          dest_table = row[dest.table];
          table = (dest_table != null ? dest_table.split(" > ") : void 0) || [];
          dest_column = row[dest.column];
          target.source_table = dest.csv;
          target.source_value = row.__source_unique_id;
          target.value = row[dest.value_column];
          target.pool = row[dest.pool_column];
          if (target.pool) {
            return target;
          }
          if (dest_table === "ignore" || table[0] !== dest.__objecttype || (target.value === "ignore" && !dest_table && !dest_column)) {
            target.ignore = true;
            return target;
          }
          if (!dest_table || !dest_column || CUI.util.isEmpty(target.value)) {
            console.warn("Target not found:", dest.csv, "Row:", row, "Dest Column:", dest_column, "Dest Table:", dest_table, "Row:", row, "Dest:", dest, "Value:", target.value);
            return null;
          }
          if (dest.value_template) {
            target.value = dest.value_template.replace(/%value%/, target.value);
          }
          if (dest.map) {
            target.nested_object = {};
            ref2 = dest.map;
            for (source_col in ref2) {
              target_col = ref2[source_col];
              target.nested_object[target_col] = row[source_col];
            }
          }
        } else {
          dest_table = dest.table;
          table = dest_table.split(" > ");
          dest_column = dest.column;
        }
        if (dest.db_column) {
          target.column = dest.db_colum;
        } else {
          target.column = dest_column;
        }
        if (!dest_table) {
          console.warn("Target not found:", dest_table, dest_column);
          return null;
        }
        target.table = table[0];
        if (table.length === 2) {
          target.info = (ref3 = target_map[target.table]) != null ? (ref4 = ref3[table[1]]) != null ? ref4[dest_column] : void 0 : void 0;
          target.nested = "_nested:" + target.table + "__" + table[1];
        } else {
          target.info = (ref5 = target_map[target.table]) != null ? ref5[dest_column] : void 0;
          target.nested = null;
        }
        if (!target.info) {
          console.warn("Target Info not found: Table:", table, "Column:", dest_column);
          return null;
        }
        return target;
      };
    })(this);
    set_value = (function(_this) {
      return function(dest, target, value) {
        var c, found, get_value_by_type, info, j, len2, nesobj, obj, pl, ref, ref2, set, topobj;
        info = target.info;
        get_value_by_type = function(value, type) {
          var d, date, m, ref2, ref3, set, y;
          switch (type) {
            case "date_range":
              date = value.trim();
              ref2 = date.split("-"), y = ref2[0], m = ref2[1], d = ref2[2];
              set = {
                from: _this.parse_date(y, m, d),
                to: _this.parse_date(y, m, d)
              };
              break;
            case "date":
              date = value.trim();
              ref3 = date.split("-"), y = ref3[0], m = ref3[1], d = ref3[2];
              set = {
                value: _this.parse_date(y, m, d)
              };
              break;
            case "text":
              set = value.trim();
              break;
            case "l10n":
              set = {
                "en-US": value.trim()
              };
              break;
            default:
              set = value.trim();
          }
          return set;
        };
        set = get_value_by_type(value, info != null ? info.type : void 0);
        if (info != null ? info.table : void 0) {
          ref = value;
          if (info.create) {
            c = info.create;
            pl = payloads[info.table];
            if (!pl) {
              pl = payloads[info.table] = {
                import_type: "db",
                objecttype: info.table,
                objects: []
              };
            }
            ref = "weber:" + target.source_table + ":" + target.source_value;
            found = false;
            ref2 = pl.objects;
            for (j = 0, len2 = ref2.length; j < len2; j++) {
              obj = ref2[j];
              if (obj[obj._objecttype][c.reference.column] === ref) {
                found = true;
              }
            }
            if (!found) {
              topobj = {
                _objecttype: info.table,
                _mask: "_all_fields"
              };
              obj = {
                _version: 1
              };
              obj[c.column] = get_value_by_type(value, info.create.type);
              obj[c.reference.column] = ref;
              topobj[topobj._objecttype] = obj;
              pl.objects.push(topobj);
            }
          }
          if (info.lookup) {
            set = {
              _objecttype: info.table,
              _mask: "_all_fields"
            };
            set[info.table] = {
              "lookup:_id": {}
            };
            set[info.table]["lookup:_id"][info.lookup.column] = (info.lookup.value_template || "%value%").replace(/%value%/, ref);
          }
        }
        if (target.nested) {
          if (!dest[target.nested]) {
            dest[target.nested] = [];
          }
          nesobj = target.nested_object;
          nesobj[target.column] = set;
          dest[target.nested].push(nesobj);
          if (dest.__objecttype === "ortsthesaurus") {
            dest[target.nested + ":group_mode"] = "append";
          }
        } else {
          if (CUI.util.isString(dest[target.column])) {
            dest[target.column] = dest[target.column] + "\n" + set;
          } else {
            dest[target.column] = set;
          }
        }
      };
    })(this);
    do_map = (function(_this) {
      return function(source, dest, rules) {
        var data, date, ext, idx, j, key, len2, ref2, ref3, ref4, results, row, rows, rule, target, tinfo, tmpl, value;
        results = [];
        for (key in rules) {
          rule = rules[key];
          value = source[key];
          if (value === void 0) {
            console.error("do_map: Key not in source:", key, rule, source);
          }
          if (CUI.util.isEmpty(value)) {
            continue;
          }
          if (rule === null) {
            continue;
          }
          if (rule.mapFunc) {
            rule.mapFunc(source, dest);
          }
          if (rule.use_table) {
            data = all_data[rule.use_table.csv];
            if (!data) {
              console.warn("CSV ", rule.use_table.csv, "not found: ", source, dest, rule);
              continue;
            }
            if (value === "0") {
              continue;
            }
            rows = data[value];
            if (rows === void 0) {
              _this._migration.logwarn("Value \"" + value + "\" in CSV \"" + rule.use_table.csv + "\" not found.");
              continue;
            }
            tinfo = rule.use_table;
            tinfo.__objecttype = dest.__objecttype;
            for (idx = j = 0, len2 = rows.length; j < len2; idx = ++j) {
              row = rows[idx];
              tinfo.row = row;
              target = get_target(tinfo);
              if (!target) {
                console.warn("rule:", rule, "key:", key, "value:", value);
                continue;
              }
              if (target.ignore) {
                continue;
              }
              if (target.pool) {
                dest._pool = {
                  pool: {
                    "lookup:_id": {
                      shortname: target.pool
                    }
                  }
                };
                continue;
              }
              set_value(dest, target, target.value);
            }
            continue;
          }
          if (rule.boolean) {
            if (value === "FALSCH") {
              continue;
            }
            target = rule.boolean;
            target.info = (ref2 = target_map[target.table]) != null ? ref2[target.column] : void 0;
            target.source_table = "boolean";
            target.source_value = target.value;
            set_value(dest, target, target.value);
            continue;
          }
          if (rule.date) {
            target = get_target(rule.date);
            if (!target) {
              console.warn("rule:", rule, "key:", key, "value:", value);
              continue;
            }
            date = value;
            if (value === "0") {
              continue;
            }
            date = _this.parse_date(value, (ref3 = source[rule.date.month]) != null ? ref3.trim() : void 0, (ref4 = source[rule.date.day]) != null ? ref4.trim() : void 0);
            set_value(dest, target, date);
            continue;
          }
          if (rule.eas) {
            if (!dest[rule.eas.column]) {
              dest[rule.eas.column] = [];
            }
            ext = source[rule.ext] || "";
            dest[rule.eas.column].push({
              "eas:url": "http://irgendwo/" + rule.eas.path + "/" + value + "." + ext
            });
            if (dest[rule.eas.column].length === 1) {
              dest[rule.eas.column][0].preferred = true;
            }
            continue;
          }
          if (rule.link) {
            target = get_target(rule.link);
            if (!target) {
              console.warn("rule:", rule, "key:", key, "value:", value);
              continue;
            }
            set_value(dest, target, value);
            continue;
          }
          if (rule.copy) {
            target = get_target(rule.copy);
            if (!target) {
              console.warn("rule:", rule, "key:", key, "value:", value);
              continue;
            }
            if (!rule.copy.value_template) {
              tmpl = "%value%";
            } else {
              tmpl = rule.copy.value_template;
            }
            set_value(dest, target, tmpl.replace(/%value%/, value));
            continue;
          }
          if (rule.mapFunc) {
            continue;
          }
          results.push(console.error("do_map: Unknown rule:", key, rule, source, dest));
        }
        return results;
      };
    })(this);
    payloads = {
      bilder: {
        import_type: "db",
        objecttype: "bilder",
        objects: []
      },
      location: {
        import_type: "db",
        objecttype: "ortsthesaurus",
        objects: []
      },
      construction_phase: {
        import_type: "db",
        objecttype: "ortsthesaurus",
        objects: []
      },
      person: {
        import_type: "db",
        objecttype: "person",
        objects: []
      },
      periode: {
        import_type: "db",
        objecttype: "periode",
        objects: []
      },
      attribute: {
        import_type: "db",
        objecttype: "attribute",
        objects: []
      }
    };
    payloads.person.objects.push({
      _objecttype: "person",
      _mask: "_all_fields",
      person: {
        _version: 1,
        name: {
          "en-US": "Stefan Weber"
        },
        easydb4_reference: "weber:Person:Weber"
      }
    });
    ref2 = ["early", "mid", "late"];
    for (CenturyPositionID = j = 0, len2 = ref2.length; j < len2; CenturyPositionID = ++j) {
      CenturyPosition = ref2[CenturyPositionID];
      payloads.periode.objects.push({
        _objecttype: "periode",
        _mask: "_all_fields",
        periode: {
          _version: 1,
          name: {
            "en-US": CenturyPosition
          },
          easydb4_reference: "weber:CenturyPosition:" + (CenturyPositionID + 2)
        }
      });
    }
    for (CenturyID = l = 1; l <= 22; CenturyID = ++l) {
      if (CenturyID < 10) {
        id = "0" + CenturyID;
      } else {
        id = "" + CenturyID;
      }
      payloads.attribute.objects.push({
        _objecttype: "attribute",
        _mask: "_all_fields",
        attribute: {
          _version: 1,
          name: {
            "en-US": id
          },
          easydb4_reference: "weber:Century:" + CenturyID
        }
      });
    }
    payloads.attribute.objects.push({
      _objecttype: "attribute",
      _mask: "_all_fields",
      attribute: {
        _version: 1,
        name: {
          "en-US": "<approx>"
        },
        easydb4_reference: "weber:EstimatedCentury:approx"
      }
    });
    master_dfr = new CUI.Deferred();
    CUI.when(promises).done((function(_this) {
      return function() {
        var PhotoID, RealEstateNo, bild, from, gaz_id, idx, isInt, json, json_copy, len, len3, len4, len5, len6, n, name, names, o, ort, ort_con, ort_loc, p, p0, pdetail, pdetails, pl, pl_con, pl_loc, prop, q, r, ref3, ref4, ref5, ref6, ref7, ref8, t, to;
        isInt = function(k) {
          if (CUI.util.getInt(k) === null) {
            return false;
          } else {
            return true;
          }
        };
        console.debug("Loaded all data", all_data, "Target Map:", target_map, "Map:", map);
        pl_loc = payloads.location;
        pl_con = payloads.construction_phase;
        ref3 = all_data.property;
        for (RealEstateNo in ref3) {
          p = ref3[RealEstateNo];
          if (p.length > 1) {
            _this._migration.logwarn("Property: " + RealEstateNo + " exists " + p.length + " times. Skipping > 1.");
          }
          prop = p[0];
          gaz_id = prop["Gazetteer ID"].trim();
          if (!gaz_id) {
            _this._migration.logerror("Property: " + RealEstateNo + " has no Gazetteer ID. Skipping.");
            continue;
          }
          prop["Gazetteer ID"] = gaz_id;
          ort_con = {
            __objecttype: "ortsthesaurus",
            _version: 1
          };
          pl_con.objects.push({
            _objecttype: "ortsthesaurus",
            _mask: "_all_fields",
            _tags: [
              {
                "lookup:_id": {
                  shortname: "construction_phase"
                }
              }
            ],
            ortsthesaurus: ort_con
          });
          do_map(prop, ort_con, map.property.construction_phase);
          ort_loc = null;
          ref4 = pl_loc.objects;
          for (n = 0, len3 = ref4.length; n < len3; n++) {
            ort = ref4[n];
            if (gaz_id !== ort.ortsthesaurus.gazetteerid) {
              continue;
            }
            ort_loc = ort.ortsthesaurus;
            console.debug("FOUND gaz_id", gaz_id, ort);
            break;
          }
          if (!ort_loc) {
            ort_loc = {
              __objecttype: "ortsthesaurus",
              _version: 1
            };
            pl_loc.objects.push({
              _objecttype: "ortsthesaurus",
              _mask: "_all_fields",
              ortsthesaurus: ort_loc
            });
          }
          do_map(prop, ort_loc, map.property.location);
        }
        pl = payloads.bilder;
        ref5 = all_data.photos;
        for (PhotoID in ref5) {
          p = ref5[PhotoID];
          if (p.length > 1) {
            _this._migration.logerror("More than one photo with PhotoID: " + PhotoID);
          }
          for (o = 0, len4 = p.length; o < len4; o++) {
            p0 = p[o];
            bild = {
              __objecttype: "bilder",
              _version: 1
            };
            p0.RealEstateTypeID = ((ref6 = all_data.propertyrealestatetype[p.RealEstateNo]) != null ? ref6.RealEstateTypeID : void 0) || "";
            do_map(p0, bild, map.photos);
            pdetails = all_data.photosdetails[PhotoID];
            ref7 = pdetails || [];
            for (q = 0, len5 = ref7.length; q < len5; q++) {
              pdetail = ref7[q];
              do_map(pdetail, bild, map.photosdetails);
            }
            if (!bild._pool) {
              bild._pool = {
                pool: {
                  "lookup:_id": {
                    shortname: "weber_db"
                  }
                }
              };
            }
            pl.objects.push({
              _objecttype: "bilder",
              _mask: "_all_fields",
              bilder: bild
            });
          }
        }
        console.debug("payloads:", payloads);
        names = (function() {
          var results;
          results = [];
          for (name in payloads) {
            results.push(name);
          }
          return results;
        })();
        names.sort(function(a, b) {
          var end;
          end = ["location", "construction_phase", "bilder"];
          if (indexOf.call(end, a) >= 0) {
            a = "ZZ" + end.indexOf(a);
          }
          if (indexOf.call(end, b) >= 0) {
            b = "ZZ" + end.indexOf(b);
          }
          return a.localeCompare(b);
        });
        promises = [];
        for (r = 0, len6 = names.length; r < len6; r++) {
          name = names[r];
          json = payloads[name];
          len = json.objects.length;
          if (len <= 1000) {
            promises.push(save_payload_func(name + "-" + json.objects.length + ".json", json));
          } else {
            for (idx = t = 0, ref8 = len; t < ref8; idx = t += 1000) {
              json_copy = CUI.util.copyObject(json, false);
              json_copy.objects = json.objects.slice(idx, idx + 1000);
              from = idx + 1;
              to = Math.min(len, idx + 1000);
              promises.push(save_payload_func(name + "-" + from + "-" + to + ".json", json_copy));
            }
          }
        }
        return CUI.when(promises).done(master_dfr.resolve).fail(master_dfr.reject);
      };
    })(this));
    return master_dfr.promise();
  };

  SyrianWeber.prototype.parse_date = function(year, month, day) {
    var date, day_int, days_per_month, month_int;
    days_per_month = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    date = this.rpad(year, 4, "0");
    if (month === "0" || !month) {
      month = "";
    }
    if (day === "0" || !day) {
      day = "";
    }
    if (month.length > 0) {
      if (month.length === 1) {
        date = date + "-0" + month;
      }
      if (month.length === 2) {
        date = date + "-" + month;
      }
      if (day.length > 0) {
        day_int = parseInt(day);
        month_int = parseInt(month);
        if (day_int > days_per_month[month_int]) {
          this._migration.logwarn("Corrected date: " + year + "-" + month + "-" + day);
          day = days_per_month[month_int] + "";
        }
        if (day.length === 1) {
          date = date + "-0" + day;
        }
        if (day.length === 2) {
          date = date + "-" + day;
        }
      }
    }
    return date;
  };

  return SyrianWeber;

})(Easydb4MigrationTool);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.tools.registerPlugin(Easydb4Migration.SyrianWeber);
  };
})(this));
