class Easydb4Migration.UniBern extends Easydb4MigrationPlugin

	name: ->
		"uni-bern"

	payload: (filename, json, update) ->
		if json.objecttype != "bilder"
			return

		console.debug "payload:", json
		dfr = new CUI.Deferred()
		@_migration.query('SELECT * FROM "source.public.pool"')
		.fail(dfr.reject)
		.done (result) =>
			antik_pool_refs = []
			for row in result.rows
				if row.editmask?.match(/Antik/)
					antik_pool_refs.push("pool:"+row.id)

			for obj in json.objects
				if obj.bilder._pool.pool["lookup:_id"].reference not in antik_pool_refs
					continue

				if obj.bilder.lk_aufbewahrungsort_lehre_id
					obj.bilder["lk_aufbewahrungsort_lehre_id_antik:source_name"] =
						obj.bilder["lk_aufbewahrungsort_lehre_id:source_name"]

					obj.bilder.lk_aufbewahrungsort_lehre_id_antik = obj.bilder.lk_aufbewahrungsort_lehre_id

					delete(obj.bilder.lk_aufbewahrungsort_lehre_id)
					delete(obj.bilder["lk_aufbewahrungsort_lehre_id:source_name"])

				if obj.bilder.aufbewahrungsort_remark
					obj.bilder.aufbewahrungsort_remark_antik = obj.bilder.aufbewahrungsort_remark
					delete(obj.bilder.aufbewahrungsort_remark)

			dfr.resolve()

		dfr.promise()


ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4Migration.UniBern)
