class FalconIODownloadManager extends FilepickerDownloadManager
	type: ->
		"falconio"

	getType: ->
		"falconio"


	acceptVersionForDownload: (version) ->
		true

	sendData: (form_data, filepicker_files) ->
		deferred = new CUI.Deferred

		baseConfig = ez5.session.getBaseConfig("plugin", "easydb-falconio-plugin")
		baseConfig = baseConfig.system or baseConfig # TODO: Remove this after #64076 is merged.
		base_conf = baseConfig[@type()] or {}

		preflighturl = "https://cors-anywhere.herokuapp.com/"
		url = ""


		xhr2 = new CUI.XHR
			method: "POST"
			headers: {'Content-Type':'application/json;charset=utf-8',}
			#headers: {'Content-Type':'application'}
			url: preflighturl + base_conf.falconio_url + @_collection.auth
			body: (JSON.stringify(form_data))

		xhr2.start()
		.done (data) =>
			# console.debug "data recevied:", dump(data)

			event = filepicker_files.event
			event.info[@__type] = data
			event.type = @__TYPE+'_FILE_COPY'

			EventPoller.saveEvent(event)

			deferred.resolve()
		.fail =>
			_xhr = xhr2.getXHR()

			event = filepicker_files.event
			event.type = @__TYPE+'_FILE_COPY_ERROR'


			if _xhr.responseJSON
				event.info.error = _xhr.responseJSON
			else
				event.info.error = xhr2.statusText()+":"+(_xhr.response or "<Empty Response>")
			fault =  _xhr.response.fault.faultstring
			@__upload_errors = @__upload_errors + 1
			if (fault.includes("ApiKey") )
				text = "" + fault + ". API Key '" + @_collection.auth + "' is unreachable. Request is " + _xhr.statusText
			else
				text = fault
			@__upload_error =
				title: fault
				text: text
			EventPoller.saveEvent(event)
			deferred.reject()

		return deferred.promise()

	sendFiles: (filepicker_files, blobs) ->

		dfr = new CUI.Deferred()

		send_data = true

		overwrite_files = []
		overwrite = null

		@__upload_errors = null


		# console.error "existing files", Typo3Filepicker.conf.existing_files, filepicker_files, overwrite_files, blobs

		get_form_data = (files, blobs) =>

			files = files[0]
			if blobs[files.path]["type"].indexOf("image") != -1


				form_data =
					'content' :
						'picture' :
							message : "Sent on " + new Date().toLocaleDateString()
							url : files.url
							originalPicture : files.url
							fileName : files.title + files.filename.substring(files.filename.indexOf("."))
					'tags' : [
						"easydb"
					]

				form_data

			else if blobs[files.path]["type"].indexOf("stream") != -1


				form_data =
					'content' :
						'video' :
							message : "Sent on " + new Date().toLocaleDateString()
							url : files.url
							fileName : files.title + files.filename.substring(files.filename.indexOf("."))
					'tags' : [
						"easydb"
					]

				form_data

		show_report = =>
			attrs =
				errors: @__upload_errors
				count: filepicker_files.length
				success: filepicker_files.length - @__upload_errors

			if attrs.errors > 0
				loca = 'error'
				type = 'problem'
			else
				loca = 'success'
				type = 'alert'



			CUI[type](text:  @__upload_error.text)
			# tell TYPO3 to reload
			window.opener?.postMessage(easydb: action: 'reload', '*')


		dfr.always =>
			@hideProgress()

		dfr.done =>
			# store new files, in case we leave the dialog open


		dfr.fail =>
			if @__upload_errors == null # upload never started
				return

			#new CUI.Alert( @__upload_error ).open()

			show_report()

		go_on = =>
			@__upload_errors = 0



			# send one by one
			CUI.chunkWork.call @,
				items: filepicker_files
				chunk_size: 1
				timeout: 0
				call: (items, idx, len) =>
					@showProgress(@__type+'.download.manager.sending_files', number: (idx+1), count: len)
					file = items[0]
					form_data = get_form_data([file], blobs)
					console.debug "appending file", blobs[file.path], file
					#form_data.append("files[]", new File([blobs[file.path]], file.filename))
					@sendData(form_data, file)


			.done(dfr.resolve)
			.fail(dfr.reject)

		if overwrite_files.length > 0
			new CUI.ConfirmationChoice
				text: $$(@__type+'.download.manager.ask_overwrite_files.msg.md', count: overwrite_files.length)
				choices: [
					loca_key: @__type+'.download.manager.ask_overwrite_files.button.cancel'
					cancel: true
				,
					if overwrite_files.length < filepicker_files.length
						loca_key: @__type+'.download.manager.ask_overwrite_files.button.skip'
						choice: 'skip'
				,
					loca_key: @__type+'.download.manager.ask_overwrite_files.button.overwrite'
					choice: 'overwrite'
					primary: true
				]
			.open()
			.done (choice) =>
				switch choice.choice
					when 'skip'
						for overwrite_file in overwrite_files
							removeFromArray(overwrite_file, filepicker_files)
					when 'overwrite'
						; # nothing to do
				go_on()
			.fail(dfr.reject)
		else
			go_on()

		dfr.promise()


	startExport: ->

		dfr = new CUI.Deferred() # new CUI.Deferred()
		@init()
		.fail(dfr.reject)
		.done =>
			@gatherBaseData()
			.fail(dfr.reject)
			.done =>
				@showUserAdminMessages()
				.fail(dfr.reject)
				.done =>
					mod = null
					# console.error CUI.util.dump(@getEASColumnsInfo())
					@saveButton = new LocaButton
						loca_key: @getButtonStartLocaKey()
						left: true # reserve for spinning icon
						onClick: (ev) =>
							mod.disableAllButtons()
							@saveButton.setIcon("spinner")
							@saveExport(ev)
							.done =>
								dfr.resolve()
								mod.destroy()
							.fail =>
								@saveButton.setIcon()
								mod.enableAllButtons()

					content = @getContent()

					alert = null
					if content.length == 3
    					alert = content[2]
    					content.splice(2,1)

					show_error = =>
						CUI.problem
							text: @getDownloadPrepareError()
						.done(dfr.reject)

					if not content[0] and !alert
						show_error()
						return

					if content[0]
						CUI.chainedCall(content)
						.done (_content) =>
							mod = new CUI.ConfirmationDialog
								icon: $$("download.manager.modal.icon")
								title: @getTitle()
								class: "ez5-download-manager-confirmation-dialog ez5-event-poller"
								cancel: true
								onCancel: ->
									dfr.reject("user_rejected")
									return
								content: _content
								buttons: =>
									[ @saveButton ]
							.show()
							dfr.notify("modal_open")
						.fail =>
							show_error()

					if alert

						if (alert == "too_many_files")
							text= $$("falconio.too_many_files.text")
							title = $$("falconio.too_many_files.title")
						else
							title = $$("falconio.unsupported_filetype.title")
							text = $$("falconio.unsupported_filetype.text") + " " + alert

						new CUI.Alert( {
							title: title
							text: text
							}
						).open()
						if !content[0]
							dfr.reject("user_rejected")
						return

		dfr.promise()


	getContent: ->
		@form_fields = []
		label_txt = []
		eas_info = @getEASColumnsInfo()
		stats = eas_info.counts
		stat_warning = false
		alert = null

		if eas_info.total > 150
			return [null, null, "too_many_files"]

		for cls, stat of stats.by_class


			if cls in ["3d", "audio", "archive"]
				if alert != null
					alert += ", " + cls
				else
					alert = cls
				continue

			if not stat.total
				continue

			if cls in ["image", "audio", "video"]
				add_metadata = true

			label_txt.push(stat.total+"x "+$$("server.eas.fileclass.#{cls}"))

			opts = []
			for vn in Asset.getExportVersionNamesForClass(cls, true)
				# ExportManagerResultForm does not return information "by version"
				# we only get a statistic for "original"
				if stat.versions
					version_stat = stat.versions[vn]
					if not version_stat?.total
						continue
				else
					stat_warning = true
					if vn == "original"
						version_stat = stat
					else
						version_stat = null

				if not @form_data[cls]
					@form_data[cls] = vn

				if version_stat
					size = ez5.format_filesize(version_stat.acc_filesize)
					loca_key = "download.manager.version.with_size"
				else
					loca_key = "download.manager.version.without_size"

				if vn == "original"
					vprint = $$("download.manager.format.original")
				else
					vprint = Asset.getPrintSizeForVersion(cls, vn)

				opts.push
					text: $$(loca_key, size: size, version: vprint, count: version_stat?.total)
					value: vn

			if cls in ["office"]
				opts.splice(0,1) #Falcon.io does not support office files, must send jpg.
				label_txt.push($$("falconio.no_office_support.text"))



			@form_fields.push
				form:
					label: $$("server.eas.fileclass.#{cls}")
				name: cls
				type: CUI.Options
				radio: true
				min_checked: 0
				options: opts
				undo_support: false

		if @form_fields.length == 0
			return [null, null, alert]

		mf = @getMetadataField()

		if add_metadata and mf
			@form_fields.push(mf)
		else
			@form_data._metadata = "standard"

		@form_fields.push(@getFilenameTemplateField())
		label = new CUI.Label(class: "ez5-download-manager-status", text: "Status", multiline: true )
		label.setText(label_txt.join(", ") )

		bottom = CUI.dom.space()
		bottom.appendChild(label.DOM)

		if stat_warning
			bottom.appendChild(new CUI.EmptyLabel(text: $$("download.manager.no_stats_hint")).DOM)

		[
			new CUI.Form
				fields: @form_fields
				onDataChanged: =>
					for cls, v of @form_data
						if cls.startsWith("_") # ignore _metadata and _template
							continue
						if v != false
							@saveButton.enable()
							return
					@saveButton.disable()
				data: @form_data
			.start()
		,
			bottom
		,
			alert
		]
