class ez5.PdfCreator.Node.Asset extends ez5.PdfCreator.Node

	@getName: ->
		"asset"

	__renderPdfContent: (opts) ->
		if not opts.object
			return

		mask = @__getMask()
		data = @getData()
		easFieldsData = data.easFields

		fieldsToReset = []

		if mask.name() == "_all_fields"
			# Change standard_eas to all linked objects so they are available as assets.
			mask.invokeOnFields("all", true, ((f, _, depth) =>
				if f not instanceof LinkedObject or depth > 1 or not f.FieldSchema?.output
					return
				f.FieldSchema.output.__standard_eas = f.FieldSchema.output.standard_eas
				f.FieldSchema.output.standard_eas = order: 1
				fieldsToReset.push(f)
			))

		assets = mask.getAssetsForBrowser(opts.object, "all") or []
		assets = assets.filter((asset) =>
			if asset.value._linked_object
				name = asset.value._linked_object.fullName()
			else
				name = asset.field.fullName()
			return easFieldsData[name]
		)

		# Put the value back of standard_eas to linked object fields.
		for f in fieldsToReset
			f.FieldSchema.output.standard_eas = f.FieldSchema.output.__standard_eas
			delete f.FieldSchema.output.__standard_eas

		if data.range
			assets.splice(data.range)

		if assets.length == 0
			if not data.show_placeholder
				return
			placeholder = CUI.dom.div("pdf-node-asset-placeholder")
			icon = new CUI.Icon(icon: "fa-file-o")
			CUI.dom.append(placeholder, icon)
			if data.placeholder_text
				span = CUI.dom.span()
				span.textContent = data.placeholder_text
				CUI.dom.append(placeholder, span)
			return placeholder

		div = CUI.dom.div()

		rows = Math.ceil(assets.length / data.columns)
		width = 100 / data.columns

		assetsOffset = 0
		columnsOffset = data.columns
		for rowIndex in [0...rows]
			_assets = assets.slice(assetsOffset, columnsOffset)
			if _assets.length == 0
				break
			assetsOffset += data.columns
			columnsOffset += data.columns
			assetBrowser = new AssetBrowser
				assets: _assets
				for_print: true
				printLowRes: data.low_resolution

			for asset in assetBrowser.getAssets()
				CUI.dom.setStyle(asset.getElement(),
					width: "#{width}%"
				)

			CUI.dom.append(div, assetBrowser)

		if data.show_info
			CUI.dom.addClass(div, "pdf-node-asset-show-info")

		return div

	__getSettingsFields: ->
		mask = @__getMask()
		easFields = []

		mask.invokeOnFields("all", true, ((f, _, depth) =>
			if depth > 1
				return
			# Only EAS Columns or linked objects with depth 0 or 1. Linked objects could have standard_eas feature.

			if f instanceof EASColumn or (f instanceof LinkedObject and depth <= 1)
				if f instanceof LinkedObject
					easField = f.linkMask().getEASFields("all")[0]
					if not easField
						return

				easFields.push
					type: CUI.Checkbox
					text: f.fullNameLocalized()
					form:
						hint: f.fullName()
					name: f.fullName()
		))

		if easFields.length == 0
			easFields.push
				type: CUI.DataFieldProxy
				element: ->
					return new CUI.Label(text: $$("pdf-creator.settings.node.assets.no-eas-fields-available|label"))

		form = new CUI.Form
			form: label: $$("pdf-creator.settings.node.assets.eas-fields|label")
			name: "easFields"
			fields: easFields

		fields = [
			form
		,
			type: CUI.Select
			form: label: $$("pdf-creator.settings.node.assets.columns|label")
			name: "columns"
			options: [
				value: 1
			,
				value: 2
			,
				value: 3
			,
				value: 4
			,
				value: 5
			]
		,
			type: CUI.Select
			form: label: $$("pdf-creator.settings.node.assets.range|label")
			name: "range"
			options: [
				text: $$("pdf-creator.settings.node.assets.range.option-all|label")
				value: null
			,
				text: $$("pdf-creator.settings.node.assets.range.option-first|label")
				value: 1
			]
		,
			type: CUI.Checkbox
			form: label: $$("pdf-creator.settings.node.assets.low-resolution|label")
			name: "low_resolution"
		,
			type: CUI.Checkbox
			form: label: $$("pdf-creator.settings.node.assets.show-info|label")
			name: "show_info"
		,
			type: CUI.Checkbox
			form: label: $$("pdf-creator.settings.node.assets.show-placeholder|label")
			name: "show_placeholder"
		,
			type: CUI.Input
			form: label: $$("pdf-creator.settings.node.assets.placeholder-text|label")
			name: "placeholder_text"
		]
		return fields

	setData: (data) ->
		super(data)
		if not @__data.easFields
			@__data.easFields = {}
		return @

	__getStyleSettings: ->
		return ["class-name"]

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.Asset)