from server_modules.util import *

def get_info(easydb_context, db_cursor, config, instance, loggername):
    parts = [
        get_process_information,
        get_indexer_stats_by_status,
        get_indexer_stats_by_type,
        get_indexer_stats_by_priority
    ]
    return list([part(db_cursor, config) for part in parts])

def get_process_information(db_cursor, config):
    num_processes = [
        get_config(config, 'system/server/dirty_queuer/num_processes', 0),
        get_config(config, 'system/server/indexer/num_processes', 0),
        get_config(config, 'system/server/preindexer/num_processes', 0),
    ]
    objects_per_batch = [
        'N/A',
        get_config(config, 'system/server/indexer/objects_per_batch', 0),
        get_config(config, 'system/server/preindexer/objects_per_batch', 0)
    ]
    keep_files = [
        'N/A',
        'yes' if get_config(config, 'system/server/indexer/keep_files', False) else 'no',
        'N/A'
    ]
    data = [
        make_data('integer', 'number_of_processes', num_processes),
        make_data('integer', 'objects_per_batch', objects_per_batch),
        make_data('string', 'keep_files', keep_files)
    ]
    return make_table('process_information', 'name', ['dirty_queuer', 'indexer', 'preindexer'], data)

def get_indexer_stats_by_status(db_cursor, config):
    status_info = {}
    db_cursor.execute('select case when not_before is not null then \'deferred\' else type end as status, count(*) as count from ez_object_job group by 1')
    rows = db_cursor.fetchall()
    for row in rows:
        status_info[row['status']] = int(row['count'])
    names = []
    counts = []
    for value in ['dirty', 'preindex', 'index', 'deferred']:
        if value in status_info:
            names.append(value)
            counts.append(status_info[value])
    total = sum(counts)
    names.append('total')
    counts.append(total)
    if total > 0:
        percents = list(['{0:05.2f}'.format(float(count * 100) / total) for count in counts])
    else:
        percents = [0] * len(counts)
    data = [
        make_data('integer', 'count', counts),
        make_data('string', 'percent', percents)
    ]
    return make_table('indexer_stats_by_status', 'status', names, data)

def get_indexer_stats_by_type(db_cursor, config):
    schemas = []
    names = []
    counts = []
    db_cursor.execute('select base_type, name, count(*) as count from ez_object_job left join ez_objecttype using ("ez_objecttype:id") group by 1,2 order by count(*) desc')
    rows = db_cursor.fetchall()
    for row in rows:
        base_type = row['base_type']
        if base_type is not None:
            schemas.append('base')
            names.append(base_type)
        else:
            schemas.append('user')
            names.append(row['name'])
        counts.append(int(row['count']))
    total = sum(counts)
    schemas.append('all')
    names.append('total')
    counts.append(total)
    if total > 0:
        percents = list(['{0:05.2f}'.format(float(count * 100) / total) for count in counts])
    else:
        percents = [0] * len(counts)
    data = [
        make_data('string', 'name', names),
        make_data('integer', 'count', counts),
        make_data('string', 'percent', percents)
    ]
    return make_table('indexer_stats_by_type', 'schema', schemas, data)

def get_indexer_stats_by_priority(db_cursor, config):
    priorities = []
    counts = []
    db_cursor.execute('select priority, count(*) as count from ez_object_job group by 1 order by priority desc')
    rows = db_cursor.fetchall()
    for row in rows:
        priorities.append(row['priority'])
        counts.append(int(row['count']))
    total = sum(counts)
    priorities.append('total')
    counts.append(total)
    if total > 0:
        percents = list(['{0:05.2f}'.format(float(count * 100) / total) for count in counts])
    else:
        percents = [0] * len(counts)
    data = [
        make_data('string', 'count', counts),
        make_data('string', 'percent', percents)
    ]
    return make_table('indexer_stats_by_priority', 'priority', priorities, data)
