class ExportTransportWordpress extends ExportTransportPlugin
	getType: ->
		if ez5.version("6")
			"easydb-wordpress-plugin:transport_wp"
		else
			return "wordpress"

	isAllowed: ->
		ez5.session.hasSystemRight("root", "plugin.easydb-wordpress-plugin.wordpress")

	getDisplayType: ->
		$$("export.transport.wordpress.type|text")

	getDisplayIcon: ->
		$$("export.transport.wordpress.type|icon")

	getOptionsDisplay: (data) ->
		if not data.options?.wp_inst_uuid
			return

		baseConfig = ez5.session.getBaseConfig("plugin", "easydb-wordpress-plugin")

		for wp_inst in baseConfig.wordpress?.wp_instances or []
			wp_inst_auth = JSON.parse(wp_inst.auth)
			if wp_inst_auth.uuid == data.options.wp_inst_uuid
				return [ wp_inst.name ]

		return

	getOptions: ->
		# pick wp instance, save uuid
		fields = []

		wp_inst_opts = [
			text: $$("export.transport.wordpress.options.none")
			value: null
		]

		baseConfig = ez5.session.getBaseConfig("plugin", "easydb-wordpress-plugin")

		for wp_inst in baseConfig.wordpress?.wp_instances or []
			wp_inst_auth = JSON.parse(wp_inst.auth)

			wp_inst_opts.push
				text: wp_inst.name+" / "+wp_inst.url
				value: wp_inst_auth.uuid

		if wp_inst_opts.length == 0
			fields.push
				type: CUI.Output
				undo_and_changed_support: false
				placeholder: $$("export.transport.wordpress.base_config_missing")
		else
			fields.push
				type: CUI.Select
				undo_and_changed_support: false
				name: "wp_inst_uuid"
				options: wp_inst_opts

		fields

	getSaveData: (data) ->
		console.debug "getSaveData", CUI.util.dump(data)
		if not data.options?.wp_inst_uuid
			throw new InvalidSaveDataException()
		data.options.user_generated_displayname = ez5.session.user.getDisplayText()
		return

CUI.ready =>
	TransportsEditor.registerPlugin(new ExportTransportWordpress())
