# DeepVA

* https://deepva.ai/de/

## API

* Docu:         https://docs.deepva.com/
* Dashboard:    https://api.deepva.com/login
* API Def:      https://api.deepva.com/swagger/
* API Endpoint: https://api.deepva.com/api/v1/jobs/
* Account:      `programmfabrik.dev`
* Auth:         `curl -v -H "Authorization: Key {your-api-key}" https://api.deepva.com/api/v1/jobs/`

## Configuration

* Customer configures dictionaries etc in dashboard
* enters API Key in base config

## Examples

### Basic Request:

**Upload image (POST)**

```json
{
    "modules": {
        "face_recognition": {
            "model": "celebrities"
        }
    },
    "sources": [
        "{url-to-your-image}"
    ]
}
```

**Check job (GET)**

```json
{
    "duration": 0,
    "id": "6b5195d6-cc05-4a99-a293-8d73be0aa37f",
    "modules": {
        "object_scene_recognition": {
            "model": "general-c"
        }
    },
    "progress": 0,
    "result": {
        "detailed_link": "https://api.deepva.com/v1/jobs/6b5195d6-cc05-4a99-a293-8d73be0aa37f/detailed-results",
        "summary": [
            {
                "info": {
                },
                "items": [
                    {
                        "label": "Cat",
                        "module": "object_scene_recognition",
                        "type": "object"
                    },
                    {
                        "label": "Blossom",
                        "module": "object_scene_recognition",
                        "type": "object"
                    },
                    {
                        "label": "Outdoor",
                        "module": "object_scene_recognition",
                        "type": "object"
                    },
                    {
                        "label": "Common sunflower",
                        "module": "object_scene_recognition",
                        "type": "object"
                    },
                    {
                        "label": "Day",
                        "module": "object_scene_recognition",
                        "type": "object"
                    }
                ],
                "media_type": "image",
                "source": "https://demo.deepva.com/assets/image1.jpg"
            }
        ]
    },
    "sources": [
        "https://demo.deepva.com/assets/image1.jpg"
    ],
    "state": "waiting",
    "tag": "",
    "time_completed": null,
    "time_created": "2019-08-12 08:14:28.430144",
    "time_started": null
}
```
