// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.Barcode = (function(superClass) {
  extend(Barcode, superClass);

  Barcode.TYPE_QR = "QR code";

  Barcode.TYPE_BAR = "Barcode";

  Barcode.DEFAULT_BARCODE_TYPE = "CODE128";

  Barcode.prototype.initOpts = function() {
    Barcode.__super__.initOpts.call(this);
    return this.addOpts({
      type: {
        check: [ez5.Barcode.TYPE_BAR, ez5.Barcode.TYPE_QR],
        "default": ez5.Barcode.TYPE_BAR
      },
      barcode_type: {
        check: String,
        "default": ez5.Barcode.DEFAULT_BARCODE_TYPE
      },
      mode: {
        check: String
      }
    });
  };

  function Barcode(opts) {
    Barcode.__super__.constructor.call(this, opts);
    this.registerDOMElement(CUI.dom.div());
    this.__ratio = CUI.dom.div("cui-barcode-ratio");
    CUI.dom.append(this.DOM, this.__ratio);
    return this;
  }

  Barcode.prototype.render = function(data, arg1) {
    var canvas, displayName, downloadButton, downloadLink, element, fieldName, fileName, img, isQR, objectType, ref, ref1, url;
    ref = arg1 != null ? arg1 : {}, displayName = (ref1 = ref.displayName) != null ? ref1 : "", fieldName = ref.fieldName, objectType = ref.objectType;
    isQR = this._type === ez5.Barcode.TYPE_QR;
    if (isQR) {
      this.addClass("cui-barcode--square");
    }
    if (!data || !(CUI.util.isString(data) || CUI.util.isNumber(data))) {
      if (this._mode === "editor") {
        this.__replaceWithLabel("barcode.label.empty-data." + (this.__getLocaType()), displayName);
        return this;
      }
      CUI.dom.empty(this.__ratio);
      return this;
    }
    try {
      if (isQR) {
        data = data.toString();
        if (data.length >= 1056) {
          this.__replaceWithLabel("barcode.label.qr-data-too-long");
          return this;
        }
        element = CUI.dom.div();
        new QRCode(element, data);
        img = CUI.dom.findElement(element, "img");
        CUI.dom.remove(img);
        canvas = CUI.dom.findElement(element, "canvas");
      } else {
        canvas = CUI.dom.$element("canvas");
        JsBarcode(canvas, data, {
          format: this._barcode_type
        });
      }
    } catch (error) {
      this.__replaceWithLabel("barcode.label.wrong-data." + (this.__getLocaType()));
      return this;
    }
    url = canvas.toDataURL();
    img = CUI.dom.element("img", {
      src: url
    });
    if (this._mode !== "pdf") {
      fileName = objectType + " - " + fieldName + " - " + this._type + (this._type === ez5.Barcode.TYPE_BAR ? " " + this._barcode_type : "");
      downloadLink = CUI.dom.element("a", {
        href: url,
        download: fileName
      });
      downloadButton = new CUI.Button({
        text: $$("barcode.download|text"),
        icon: $$("barcode.download|icon")
      });
      element = CUI.dom.element("div");
      CUI.dom.append(downloadLink, downloadButton);
      CUI.dom.append(this.DOM, downloadLink);
    }
    CUI.dom.replace(this.__ratio, img);
    return this;
  };

  Barcode.prototype.__replaceWithLabel = function(locaKey, arg) {
    var label;
    label = new CUI.Label({
      text: $$(locaKey, {
        arg: arg
      }),
      centered: true,
      appearance: "secondary",
      size: "mini",
      multiline: true
    });
    CUI.dom.replace(this.__ratio, label);
  };

  Barcode.prototype.__getLocaType = function() {
    return this._type.replace(/\s/g, "_").toLowerCase();
  };

  return Barcode;

})(CUI.DOMElement);
