class BaseMigrationNodeData extends BaseMigrationNode
	initOpts: ->
		super()
		@addOpts
			data:
				mandatory: true
				default: {}
				check: "PlainObject"

	readOpts: ->
		super()
		@setData(@_data)

	hasRightPane: ->
		false

	getActionPaneBase: ->
		@__actionData =
			mode: "replace"

		fields = @getActionFields()

		if @hasRightPane()
			right_pane =
				class: "ez5-base-migration-center-right"
				flexHandle:
					hidden: false
					closed: false
					state_name: "base-migration-right"
		else
			right_pane = undefined

		@__layout = new CUI.HorizontalLayout
			center:
				class: "ez5-base-migration-center-center"
				content: =>
					new CUI.Form
						padded: true
						data: @__actionData
						fields: fields
						onDataChanged: =>
							@checkMigrateButton()

					.start()
			right: right_pane

		@__migrateBtn = new LocaButton
			loca_key: "base.migration.node.pool.button.migrate"
			primary: true
			disabled: true
			onClick: (ev, btn) =>
				btn.startSpinner()
				@migrate(ev, @__actionData)
				.always =>
					btn.stopSpinner()
				.done =>
					if ev.hasModifierKey()
						return
					@getMigration().loadBaseData()
					.done =>
						CUI.alert(text: $$("base.migration.node.pool.success.text"))
				.fail =>
					if ev.hasModifierKey()
						return
					CUI.problem(text: $$("base.migration.node.pool.error.text"))


		@checkMigrateButton()

		new CUI.SimplePane
			header_left: new CUI.Label(text: $$("base.migration.node.pool.pane.text"))
			content: @__layout
			footer_right: [
				@__migrateBtn
			]

	getLayout: ->
		@__layout

	setData: (@__data) ->

	getData: ->
		@__data

	renderContent: ->
		new CUI.Label(multiline: true, text: @getDisplayText())

