// Generated by CoffeeScript 1.12.7
var BaseMigrationNodeTransition,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

BaseMigrationNodeTransition = (function(superClass) {
  extend(BaseMigrationNodeTransition, superClass);

  function BaseMigrationNodeTransition() {
    return BaseMigrationNodeTransition.__super__.constructor.apply(this, arguments);
  }

  BaseMigrationNodeTransition.prototype.getDisplayText = function() {
    return this.getData().operations.join(", ");
  };

  BaseMigrationNodeTransition.prototype.getActionPane = function() {
    var pane;
    pane = this.getActionPaneBase();
    return pane;
  };

  BaseMigrationNodeTransition.prototype.getActionFields = function() {
    return [
      {
        type: CUI.Output,
        placeholder: $$("base.migration.node.transition.no-settings")
      }
    ];
  };

  BaseMigrationNodeTransition.prototype.checkMigrateButton = function() {
    return this.__migrateBtn.enable();
  };

  BaseMigrationNodeTransition.prototype.migrate = function(ev, action_data) {
    var copied_transition, migration, target;
    migration = this.getMigration();
    target = CUI.util.copyObject(migration.getBaseData().transitions, true);
    copied_transition = migration.migrateTransition(this.getData());
    if (copied_transition) {
      target.push(copied_transition);
    }
    if (ev.hasModifierKey()) {
      console.debug("migrate Transition:", copied_transition, CUI.util.dump(target), target);
      return CUI.resolvedPromise();
    }
    return CUI.rejectedPromise();
  };

  BaseMigrationNodeTransition.prototype.saveTransitions = function(transitions) {
    this.log($$("base.migration.console.log.transition.saving.md", {
      count: transitions.length
    }));
    return ez5.api.transitions({
      type: "POST",
      json_data: transitions
    }).done((function(_this) {
      return function(transitions) {
        _this.log($$("base.migration.console.log.transition.migrated.md", {
          count: transitions.length
        }));
        console.debug("updating base data:", transitions);
        return _this.getMigration().getBaseData().transitions = transitions;
      };
    })(this)).fail((function(_this) {
      return function() {
        return _this.log($$("base.migration.console.log.transition.failed"));
      };
    })(this));
  };

  BaseMigrationNodeTransition.getSourceNodesFromData = function(migration, data) {
    var i, len, transition, transitions;
    transitions = [];
    for (i = 0, len = data.length; i < len; i++) {
      transition = data[i];
      transitions.push(new BaseMigrationNodeTransition({
        migration: migration,
        data: transition
      }));
    }
    return [
      new BaseMigrationNodeTransitions({
        migration: migration,
        children: transitions
      })
    ];
  };

  return BaseMigrationNodeTransition;

})(BaseMigrationNodeData);
