// Generated by CoffeeScript 1.12.7
var CustomDataTypeCommonFacet, CustomDataTypeWithCommons,
  bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeWithCommons = (function(superClass) {
  extend(CustomDataTypeWithCommons, superClass);

  function CustomDataTypeWithCommons() {
    this.getQueryFieldBadge = bind(this.getQueryFieldBadge, this);
    return CustomDataTypeWithCommons.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeWithCommons.prototype.initData = function(data) {
    var cdata;
    if (!data[this.name()]) {
      cdata = null;
      data[this.name()] = cdata;
    } else {
      cdata = data[this.name()];
    }
    if (!cdata.url) {
      cdata.url = "";
    }
    return cdata;
  };

  CustomDataTypeWithCommons.prototype.renderFieldAsGroup = function() {
    return false;
  };

  CustomDataTypeWithCommons.prototype.renderRowAsBlock = function(data, top_level_data, opts) {
    return false;
  };

  CustomDataTypeWithCommons.prototype.getQueryFieldBadge = function(data) {
    var value;
    if (data[(this.name()) + ":unset"]) {
      value = $$("text.column.badge.without");
    } else {
      value = data[this.name()];
    }
    return {
      name: this.nameLocalized(),
      value: value
    };
  };

  CustomDataTypeWithCommons.prototype.supportsStandard = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.supportsPrinting = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.supportsFacet = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.getFacet = function(opts) {
    opts.field = this;
    return new CustomDataTypeCommonFacet(opts);
  };

  CustomDataTypeWithCommons.prototype.getSortFunction = function() {
    return (function(_this) {
      return function(a, b) {
        var ref, ref1;
        return CUI.util.compareIndex(((ref = a[_this.name()]) != null ? ref.conceptName : void 0) || 'zzz', ((ref1 = b[_this.name()]) != null ? ref1.conceptName : void 0) || 'zzz');
      };
    })(this);
  };

  CustomDataTypeWithCommons.prototype.hasRenderForSort = function() {
    return true;
  };

  CustomDataTypeWithCommons.prototype.sortExtraOpts = function() {
    return [
      {
        text: "conceptName",
        value: "conceptName"
      }, {
        text: "conceptURI",
        value: "conceptURI"
      }
    ];
  };

  CustomDataTypeWithCommons.prototype.renderSearchInput = function(data, opts) {
    var search_token;
    if (opts == null) {
      opts = {};
    }
    return search_token = new SearchToken({
      column: this,
      data: data,
      fields: opts.fields
    }).getInput().DOM;
  };

  CustomDataTypeWithCommons.prototype.getFieldNamesForSearch = function() {
    return this.getFieldNames();
  };

  CustomDataTypeWithCommons.prototype.getFieldNamesForSuggest = function() {
    return this.getFieldNames();
  };

  CustomDataTypeWithCommons.prototype.getFieldNames = function() {
    var field_names;
    field_names = [this.fullName() + ".conceptURI", this.fullName() + ".conceptName"];
    return field_names;
  };

  CustomDataTypeWithCommons.prototype.getSearchFilter = function(data, key) {
    var filter, phrase, ref, str, val;
    if (key == null) {
      key = this.name();
    }
    if (data[key + ":unset"]) {
      filter = {
        type: "in",
        fields: [this.fullName() + ".conceptName"],
        "in": [null]
      };
      filter._unnest = true;
      filter._unset_filter = true;
      return filter;
    }
    filter = CustomDataTypeWithCommons.__super__.getSearchFilter.call(this, data, key);
    if (filter) {
      return filter;
    }
    if (CUI.util.isEmpty(data[key])) {
      return;
    }
    val = data[key];
    ref = Search.getPhrase(val), str = ref[0], phrase = ref[1];
    switch (data[key + ":type"]) {
      case "token":
      case "fulltext":
      case void 0:
        filter = {
          type: "match",
          mode: data[key + ":mode"],
          fields: this.getFieldNamesForSearch(),
          string: str,
          phrase: phrase
        };
        break;
      case "field":
        filter = {
          type: "in",
          fields: this.getFieldNamesForSearch(),
          "in": [str]
        };
    }
    return filter;
  };

  CustomDataTypeWithCommons.prototype.renderEditorInput = function(data, top_level_data, opts) {
    var name;
    name = this.name(opts);
    if (!data[name]) {
      data[name] = {
        conceptName: '',
        conceptURI: ''
      };
    }
    return this.__renderEditorInputPopover(data, data[name], opts);
  };

  CustomDataTypeWithCommons.prototype.__renderEditorInputPopover = function(data, cdata, opts, customButtonBarEntrys) {
    var classNameForBurgerMenuButton, layout, that;
    if (opts == null) {
      opts = {};
    }
    if (customButtonBarEntrys == null) {
      customButtonBarEntrys = false;
    }
    that = this;
    this.dotsButtonMenu = {};
    layout = {};
    classNameForBurgerMenuButton = 'pluginDirectSelectEditSearch';
    if (ez5.version("6")) {
      classNameForBurgerMenuButton = 'pluginDirectSelectEditSearchFylr';
    } else if (ez5.version("5")) {
      classNameForBurgerMenuButton = 'pluginDirectSelectEditSearch';
    }
    layout = new CUI.HorizontalLayout({
      "class": 'customPluginEditorLayout',
      center: {
        "class": ''
      },
      right: {
        content: new CUI.Buttonbar({
          buttons: [
            new CUI.Button({
              text: '',
              icon: new CUI.Icon({
                "class": "fa-ellipsis-v"
              }),
              "class": classNameForBurgerMenuButton,
              onClick: (function(_this) {
                return function(e, dotsButton) {
                  var deleteClear, detailinfo, itemList, menu_items, uriCall;
                  that.dotsButtonMenu = new CUI.Menu({
                    "class": "customDataTypeCommonsMenu",
                    element: dotsButton
                  }, menu_items = [
                    {
                      text: $$('custom.data.type.commons.controls.search.label'),
                      value: 'search',
                      icon_left: new CUI.Icon({
                        "class": "fa-search"
                      }),
                      onClick: function(e2, btn2) {
                        that.showEditPopover(dotsButton, data, cdata, layout, opts);
                        return that.dotsButtonMenu.hide();
                      }
                    }
                  ], typeof that.__getAdditionalTooltipInfo === "function" ? (detailinfo = {
                    text: $$('custom.data.type.commons.controls.detailinfo.label'),
                    value: 'detail',
                    icon_left: new CUI.Icon({
                      "class": "fa-info-circle"
                    }),
                    disabled: that.isEmpty(data, 0, opts),
                    onClick: function(eDetailInfo, btnDetailInfo) {
                      var tooltip;
                      tooltip = new CUI.Tooltip({
                        element: btnDetailInfo,
                        placement: 'w',
                        markdown: true,
                        show_ms: 1000,
                        hide_ms: 200,
                        content: function(tooltip) {
                          var encodedURI, extendedInfo_xhr;
                          if (!that.isEmpty(data, 0, opts)) {
                            encodedURI = encodeURIComponent(cdata.conceptURI);
                            extendedInfo_xhr = {
                              "xhr": void 0
                            };
                            that.__getAdditionalTooltipInfo(encodedURI, tooltip, extendedInfo_xhr);
                            return new CUI.Label({
                              icon: "spinner",
                              text: $$('custom.data.type.commons.modal.form.popup.loadingstring')
                            });
                          }
                        }
                      });
                      tooltip.show();
                      return CUI.Events.listen({
                        type: ["click", "dblclick", "mouseout"],
                        capture: true,
                        node: btnDetailInfo,
                        only_once: true,
                        call: (function(_this) {
                          return function(ev) {
                            return that.dotsButtonMenu.hide();
                          };
                        })(this)
                      });
                    }
                  }, menu_items.push(detailinfo)) : void 0, uriCall = {
                    text: $$('custom.data.type.commons.controls.calluri.label'),
                    value: 'uri',
                    icon_left: new CUI.Icon({
                      "class": "fa-external-link"
                    }),
                    disabled: that.isEmpty(data, 0, opts) || !CUI.parseLocation(cdata.conceptURI),
                    onClick: function() {
                      window.open(cdata.conceptURI, "_blank");
                      return that.dotsButtonMenu.hide();
                    }
                  }, menu_items.push(uriCall), deleteClear = {
                    text: $$('custom.data.type.commons.controls.delete.label'),
                    value: 'delete',
                    name: 'deleteValueFromDANTEPlugin',
                    "class": 'deleteValueFromDANTEPlugin',
                    icon_left: new CUI.Icon({
                      "class": "fa-trash"
                    }),
                    disabled: that.isEmpty(data, 0, opts),
                    onClick: function() {
                      cdata = {
                        conceptName: '',
                        conceptURI: ''
                      };
                      data[that.name(opts)] = cdata;
                      that.__updateResult(cdata, layout, opts);
                      return that.dotsButtonMenu.hide();
                    }
                  }, menu_items.push(deleteClear), (customButtonBarEntrys != null ? customButtonBarEntrys.length : void 0) > 0 ? menu_items.push.apply(menu_items, customButtonBarEntrys) : void 0, itemList = {
                    items: menu_items
                  });
                  that.dotsButtonMenu._auto_close_after_click = false;
                  that.dotsButtonMenu.setItemList(itemList);
                  return that.dotsButtonMenu.show();
                };
              })(this)
            })
          ]
        })
      }
    });
    this.layout = layout;
    CUI.Events.registerEvent({
      type: "custom-deleteDataFromPlugin",
      bubble: false
    });
    CUI.Events.listen({
      type: "custom-deleteDataFromPlugin",
      instance: that,
      node: layout,
      call: (function(_this) {
        return function() {
          var key;
          for (key in cdata) {
            delete cdata[key];
          }
          data[that.name(opts)] = cdata;
          opts.deleteDataFromPlugin = true;
          return that.__updateResult(cdata, layout, opts);
        };
      })(this)
    });
    this.__updateResult(cdata, layout, opts);
    opts.initialcallfrompoolmanager = false;
    return layout;
  };

  CustomDataTypeWithCommons.prototype.showEditPopover = function(btn, data, cdata, layout, opts) {
    var cdata_form, searchsuggest_xhr, suggest_Menu, that;
    that = this;
    suggest_Menu;
    searchsuggest_xhr = {
      "xhr": void 0
    };
    cdata.countOfSuggestions = 50;
    cdata_form = new CUI.Form({
      "class": 'cdtFormWithPadding',
      data: cdata,
      fields: that.__getEditorFields(cdata),
      onDataChanged: (function(_this) {
        return function(data, elem) {
          _this.__updateResult(cdata, layout, opts);
          _this.__setEditorFieldStatus(cdata, layout);
          return _this.__updateSuggestionsMenu(cdata, cdata_form, data.searchbarInput, elem, suggest_Menu, searchsuggest_xhr, layout, opts);
        };
      })(this)
    }).start();
    suggest_Menu = new CUI.Menu({
      element: cdata_form.getFieldsByName("searchbarInput")[0],
      use_element_width_as_min_width: true,
      "class": "customDataTypeCommonsMenu"
    });
    return this.popover = new CUI.Popover({
      element: btn,
      placement: "wn",
      "class": "commonPlugin_Popover",
      pane: {
        header_left: new CUI.Label({
          text: $$('custom.data.type.commons.popover.choose.label')
        }),
        content: cdata_form
      }
    }).show();
  };

  CustomDataTypeWithCommons.prototype.isEmpty = function(data, top_level_data, opts) {
    var ref, ref1;
    if (opts == null) {
      opts = {};
    }
    if ((opts != null ? opts.mode : void 0) === "expert") {
      if (typeof data[this.name(opts)] === 'object') {
        return CUI.util.isEmpty(data[this.name(opts)] != null);
      } else {
        return CUI.util.isEmpty((ref = data[this.name(opts)]) != null ? ref.trim() : void 0);
      }
    }
    return !((ref1 = data[this.name(opts)]) != null ? ref1.conceptName : void 0);
  };

  CustomDataTypeWithCommons.prototype.getSaveData = function(data, save_data, opts) {
    var cdata, conceptFulltext, conceptNameChosenByHand, conceptNameWithHierarchie, conceptStandard, frontendLanguage, frontendLanguages, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, that;
    that = this;
    if (opts.demo_data) {
      return {
        conceptName: 'Example',
        conceptURI: 'https://example.com'
      };
    }
    cdata = data[this.name(opts)] || ((ref = data._template) != null ? ref[this.name(opts)] : void 0);
    switch (this.getDataStatus(cdata)) {
      case "invalid":
        if (opts.copy) {
          return save_data[this.name(opts)] = null;
        } else {
          throw new InvalidSaveDataException();
        }
        break;
      case "empty":
        return save_data[this.name(opts)] = null;
      case "ok":
        conceptFulltext = {};
        if (cdata != null ? cdata._fulltext : void 0) {
          if ((ref1 = cdata._fulltext) != null ? ref1.string : void 0) {
            if (((ref2 = cdata._fulltext) != null ? ref2.string : void 0) !== '') {
              conceptFulltext.string = cdata._fulltext.string;
            }
          }
          if ((ref3 = cdata._fulltext) != null ? ref3.l10ntext : void 0) {
            if (cdata._fulltext.l10ntext) {
              conceptFulltext.l10ntext = cdata._fulltext.l10ntext;
            }
          }
          if ((ref4 = cdata._fulltext) != null ? ref4.text : void 0) {
            if (cdata._fulltext.text) {
              conceptFulltext.text = cdata._fulltext.text;
            }
          }
        } else {
          conceptFulltext.text = cdata.conceptName.trim();
        }
        conceptStandard = {};
        if (cdata != null ? cdata._standard : void 0) {
          if ((ref5 = cdata._standard) != null ? ref5.l10ntext : void 0) {
            if (cdata._standard.l10ntext) {
              conceptStandard.l10ntext = cdata._standard.l10ntext;
            }
          } else {
            if ((ref6 = cdata._standard) != null ? ref6.text : void 0) {
              if (((ref7 = cdata._standard) != null ? ref7.text : void 0) !== '') {
                conceptStandard.text = cdata._standard.text;
              }
            }
          }
          if ((ref8 = cdata._standard) != null ? ref8.geo : void 0) {
            if (cdata._standard.geo) {
              conceptStandard.geo = cdata._standard.geo;
            }
          }
        }
        frontendLanguages = ez5.loca.getLanguage();
        frontendLanguages = frontendLanguages.split('-');
        frontendLanguage = frontendLanguages[0];
        conceptNameChosenByHand = false;
        if (cdata != null ? cdata.conceptNameChosenByHand : void 0) {
          if (cdata.conceptNameChosenByHand === true) {
            conceptNameChosenByHand = true;
          }
        }
        conceptNameWithHierarchie = false;
        if (cdata != null ? cdata.conceptNameWithHierarchie : void 0) {
          if (cdata.conceptNameWithHierarchie === true) {
            conceptNameWithHierarchie = true;
          }
        }
        save_data[this.name(opts)] = {
          conceptName: cdata.conceptName.trim(),
          conceptURI: cdata.conceptURI.trim(),
          frontendLanguage: frontendLanguage,
          _fulltext: conceptFulltext,
          _standard: conceptStandard
        };
        if (cdata != null ? cdata.conceptAncestors : void 0) {
          if (cdata.conceptAncestors.length > 0) {
            if (Array.isArray(cdata.conceptAncestors)) {
              cdata.conceptAncestors = cdata.conceptAncestors.join(' ');
            }
            save_data[this.name(opts)]['conceptAncestors'] = cdata.conceptAncestors;
          }
        }
        if (cdata != null ? cdata.conceptSource : void 0) {
          if (typeof cdata.conceptSource === 'string') {
            if (cdata.conceptSource.length > 0) {
              save_data[this.name(opts)]['conceptSource'] = cdata.conceptSource;
            }
          }
        }
        if (cdata != null ? cdata.conceptGeoJSON : void 0) {
          if (typeof cdata.conceptGeoJSON === 'object') {
            if (Object.keys(cdata.conceptGeoJSON).length > 0) {
              save_data[this.name(opts)]['conceptGeoJSON'] = cdata.conceptGeoJSON;
            }
          }
        }
        if (cdata != null ? cdata.conceptNameChosenByHand : void 0) {
          if (cdata.conceptNameChosenByHand === true) {
            save_data[this.name(opts)]['conceptNameChosenByHand'] = true;
          }
        }
        if (cdata != null ? cdata.conceptNameWithHierarchie : void 0) {
          if (cdata.conceptNameWithHierarchie === true) {
            save_data[this.name(opts)]['conceptNameWithHierarchie'] = true;
          }
        }
        if (cdata != null ? cdata.facetTerm : void 0) {
          return save_data[this.name(opts)]['facetTerm'] = cdata.facetTerm;
        }
    }
  };

  CustomDataTypeWithCommons.prototype.__updateResult = function(cdata, layout, opts) {
    var displayURI, info, inputX, onelineButtonbar, onelineDisplay, options, ref, ref1, ref2, ref3, ref4, rendered, searchsuggest_xhr, suggest_Menu_directInput, that, topContent;
    that = this;
    if (opts.data) {
      opts.data[that.name(opts)] = cdata;
    }
    onelineDisplay = false;
    if (((ref = this.FieldSchema) != null ? (ref1 = ref.custom_settings) != null ? (ref2 = ref1.editor_display) != null ? ref2.value : void 0 : void 0 : void 0) === 'condensed' || (opts != null ? (ref3 = opts.custom_settings) != null ? (ref4 = ref3.editor_display) != null ? ref4.value : void 0 : void 0 : void 0) === 'condensed') {
      onelineDisplay = true;
    }
    if (cdata != null ? cdata.conceptURI : void 0) {
      displayURI = cdata.conceptURI;
      if (displayURI.length > 20) {
        displayURI = displayURI.replace('http://', '');
        displayURI = displayURI.replace('https://', '');
      }
      if (displayURI.length > 30) {
        displayURI = displayURI.replace('uri.gbv.de/terminology/', '…/');
      }
      topContent = {
        content: new CUI.Label({
          text: cdata.conceptName,
          multiline: true
        })
      };
      if (onelineDisplay && typeof that.__getAdditionalTooltipInfo === "function") {
        onelineButtonbar = new CUI.Buttonbar({
          buttons: [
            new CUI.Label({
              centered: false,
              text: cdata.conceptName,
              multiline: true
            }), new CUI.ButtonHref({
              name: "outputButtonHref",
              "class": "pluginResultButton",
              appearance: "link",
              size: "normal",
              href: cdata.conceptURI,
              target: "_blank",
              tooltip: {
                markdown: true,
                placement: 'nw',
                content: function(tooltip) {
                  var encodedURI, extendedInfo_xhr;
                  extendedInfo_xhr = {
                    "xhr": void 0
                  };
                  encodedURI = encodeURIComponent(cdata.conceptURI);
                  that.__getAdditionalTooltipInfo(encodedURI, tooltip, extendedInfo_xhr);
                  return new CUI.Label({
                    icon: "spinner"
                  });
                }
              }
            })
          ]
        });
        onelineButtonbar.DOM.style.maxWidth = '92%';
        topContent = {
          content: onelineButtonbar
        };
      }
      info = new CUI.VerticalLayout({
        "class": 'ez5-info_commonPlugin',
        top: topContent,
        bottom: !onelineDisplay ? {
          content: new CUI.Button({
            name: "outputButtonHref",
            appearance: "flat",
            size: "normal",
            text: displayURI,
            tooltip: {
              markdown: true,
              placement: 'w',
              content: function(tooltip) {
                var encodedURI, extendedInfo_xhr;
                encodedURI = encodeURIComponent(cdata.conceptURI);
                extendedInfo_xhr = {
                  "xhr": void 0
                };
                if (typeof that.__getAdditionalTooltipInfo === "function") {
                  that.__getAdditionalTooltipInfo(encodedURI, tooltip, extendedInfo_xhr);
                  return new CUI.Label({
                    icon: "spinner",
                    text: $$('custom.data.type.commons.modal.form.popup.loadingstring')
                  });
                }
              }
            },
            onClick: (function(_this) {
              return function(evt, button) {
                return window.open(cdata.conceptURI, "_blank");
              };
            })(this)
          })
        } : void 0
      });
      layout.replace(info, 'center');
      layout.addClass('ez5-linked-object-edit');
      options = {
        "class": 'ez5-linked-object-container'
      };
      layout.__initPane(options, 'center');
    }
    if (!(cdata != null ? cdata.conceptURI : void 0)) {
      suggest_Menu_directInput;
      inputX = new CUI.Input({
        "class": "pluginDirectSelectEditInput",
        undo_and_changed_support: false,
        name: "directSelectInput",
        content_size: false,
        onKeyup: (function(_this) {
          return function(input) {
            var searchstring;
            searchstring = input.getValueForInput();
            if (typeof that.__updateSuggestionsMenu === "function") {
              return _this.__updateSuggestionsMenu(cdata, 0, searchstring, input, suggest_Menu_directInput, searchsuggest_xhr, layout, opts);
            }
          };
        })(this)
      });
      rendered = false;
      if (!(opts != null ? opts.callfrompoolmanager : void 0)) {
        rendered = true;
        inputX.render();
      }
      if (opts.initialcallfrompoolmanager === false && rendered === false) {
        inputX.render();
      }
      opts.initialcallfrompoolmanager = false;
      suggest_Menu_directInput = new CUI.Menu({
        element: inputX,
        use_element_width_as_min_width: true,
        "class": "customDataTypeCommonsMenu"
      });
      searchsuggest_xhr = {
        "xhr": void 0
      };
      layout.replace(inputX, 'center');
      layout.removeClass('ez5-linked-object-edit');
      options = {
        "class": ''
      };
      layout.__initPane(options, 'center');
    }
    if (!opts.deleteDataFromPlugin) {
      return that.__setEditorFieldStatus(cdata, layout);
    }
  };

  CustomDataTypeWithCommons.prototype.__setEditorFieldStatus = function(cdata, element) {
    switch (this.getDataStatus(cdata)) {
      case "invalid":
        element.addClass("cui-input-invalid");
        break;
      default:
        element.removeClass("cui-input-invalid");
    }
    CUI.Events.trigger({
      node: element,
      type: "editor-changed"
    });
    CUI.Events.trigger({
      node: element,
      type: "data-changed"
    });
    return this;
  };

  CustomDataTypeWithCommons.prototype.renderDetailOutput = function(data, top_level_data, opts) {
    return this.__renderButtonByData(data[this.name(opts)]);
  };

  CustomDataTypeWithCommons.prototype.getDataStatus = function(cdata) {
    var nameCheck, uriCheck;
    if (cdata) {
      if (cdata.conceptURI && cdata.conceptName) {
        uriCheck = CUI.parseLocation(cdata.conceptURI);
        nameCheck = cdata.conceptName ? cdata.conceptName.trim() : void 0;
        if (uriCheck && nameCheck) {
          return "ok";
        }
        if (cdata.conceptURI.trim() === '' && cdata.conceptName.trim() === '') {
          return "empty";
        }
        return "invalid";
      }
    }
    return "empty";
  };

  return CustomDataTypeWithCommons;

})(CustomDataType);

CustomDataTypeCommonFacet = (function(superClass) {
  extend(CustomDataTypeCommonFacet, superClass);

  function CustomDataTypeCommonFacet() {
    return CustomDataTypeCommonFacet.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeCommonFacet.prototype.initOpts = function() {
    CustomDataTypeCommonFacet.__super__.initOpts.call(this);
    return this.addOpts({
      field: {
        mandatory: true,
        check: Field
      }
    });
  };

  CustomDataTypeCommonFacet.prototype.requestFacetWithLimit = function(obj) {
    return {
      limit: this.getLimit(),
      field: this._field.fullName() + ".conceptName",
      sort: "count",
      type: "term"
    };
  };

  CustomDataTypeCommonFacet.prototype.getObjects = function(key, data) {
    var ref;
    if (key == null) {
      key = this.name();
    }
    if (data == null) {
      data = this.data();
    }
    return ((ref = data[key]) != null ? ref.terms : void 0) || [];
  };

  CustomDataTypeCommonFacet.prototype.renderObjectText = function(object) {
    return object.term;
  };

  CustomDataTypeCommonFacet.prototype.getObjectPath = function(obj) {
    return [obj.term];
  };

  CustomDataTypeCommonFacet.prototype.name = function() {
    return this._field.fullName() + ".conceptName";
  };

  CustomDataTypeCommonFacet.prototype.requestSearchFilter = function(obj) {
    return {
      bool: "must",
      fields: [this._field.fullName() + ".conceptName"],
      type: "in",
      "in": [obj.term]
    };
  };

  CustomDataTypeCommonFacet.prototype.getObjectsSorted = function(objects) {
    return CustomDataTypeCommonFacet.__super__.getObjectsSorted.call(this, objects);
  };

  CustomDataTypeCommonFacet.prototype.__isAndButtonAvailable = function() {
    return this._field.insideNested();
  };

  return CustomDataTypeCommonFacet;

})(FieldFacet);
// Generated by CoffeeScript 1.12.7
var CustomDataTypeGND,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

CustomDataTypeGND = (function(superClass) {
  extend(CustomDataTypeGND, superClass);

  function CustomDataTypeGND() {
    return CustomDataTypeGND.__super__.constructor.apply(this, arguments);
  }

  CustomDataTypeGND.prototype.getCustomDataTypeName = function() {
    return "custom:base.custom-data-type-gnd.gnd";
  };

  CustomDataTypeGND.prototype.getCustomDataTypeNameLocalized = function() {
    return $$("custom.data.type.gnd.name");
  };

  CustomDataTypeGND.prototype.__getAdditionalTooltipInfo = function(uri, tooltip, extendedInfo_xhr) {
    var gndID, gndIDTest, xurl;
    gndID = uri;
    gndIDTest = gndID.split("/");
    if (gndIDTest.length === 1) {
      gndID = gndID.split("%2F");
    } else {
      gndID = gndIDTest;
    }
    gndID = gndID.pop();
    if (extendedInfo_xhr.xhr !== void 0) {
      extendedInfo_xhr.abort();
    }
    xurl = location.protocol + '//jsontojsonp.gbv.de/?url=http://hub.culturegraph.org/entityfacts/' + gndID;
    extendedInfo_xhr = new CUI.XHR({
      url: xurl
    });
    extendedInfo_xhr.start().done(function(data, status, statusText) {
      var biographicalOrHistoricalInformation, dateOfBirth, dateOfDeath, dateOfEstablishment, depiction, hierarchicallySuperiorOrganisation, htmlContent, i, j, k, l, len, len1, len2, len3, len4, m, organisation, organisations, place, placeOfBirth, placeOfBusiness, placeOfDeath, placeOfEvent, places, profession, professionOrOccupation, professions, t, topic, topics, variantName, variantNames;
      if (!data.preferredName) {
        return tooltip.hide();
      } else {
        htmlContent = '';
        htmlContent += '<table style="border-spacing: 10px; border-collapse: separate;">';
        htmlContent += '<tr><td colspan="2"><h4>Informationen über den Eintrag</h4></td></tr>';
        htmlContent += "<tr><td>Name:</td><td>" + data.preferredName + "</td></tr>";
        depiction = data.depiction;
        if (depiction) {
          if (depiction.thumbnail) {
            htmlContent += '<tr><td>Abbildung:</td><td><img src="' + depiction.thumbnail['@id'] + '" style="border: 0; max.width:120px; max-height:150px;" /></td></tr>';
          }
        }
        dateOfBirth = data.dateOfBirth;
        dateOfDeath = data.dateOfDeath;
        if (dateOfBirth || dateOfDeath) {
          htmlContent += "<tr><td>Lebensdaten:</td><td>";
          if (dateOfBirth && dateOfDeath) {
            htmlContent += dateOfBirth + " bis " + dateOfDeath;
          } else if (dateOfBirth && !dateOfDeath) {
            htmlContent += dateOfBirth + " bis unbekannt";
          } else if (!dateOfBirth && dateOfDeath) {
            htmlContent += "unbekannt bis " + dateOfDeath;
          }
          htmlContent += "</td></tr>";
        }
        dateOfEstablishment = data.dateOfEstablishment;
        if (dateOfEstablishment) {
          htmlContent += "<tr><td>Gründung:</td><td>" + dateOfEstablishment[0] + "</td></tr>";
        }
        placeOfBusiness = data.placeOfBusiness;
        places = [];
        if (placeOfBusiness) {
          if (placeOfBusiness.length > 0) {
            for (i = 0, len = placeOfBusiness.length; i < len; i++) {
              place = placeOfBusiness[i];
              places.push(place.preferredName);
            }
            htmlContent += "<tr><td>Niederlassung(en):</td><td>" + places.join("<br />") + "</td></tr>";
          }
        }
        placeOfEvent = data.placeOfEvent;
        places = [];
        if (placeOfEvent) {
          if (placeOfEvent.length > 0) {
            for (j = 0, len1 = placeOfEvent.length; j < len1; j++) {
              place = placeOfEvent[j];
              places.push(place.preferredName);
            }
            htmlContent += "<tr><td>Veranstaltungsort(e):</td><td>" + places.join("<br />") + "</td></tr>";
          }
        }
        hierarchicallySuperiorOrganisation = data.hierarchicallySuperiorOrganisation;
        organisations = [];
        if (hierarchicallySuperiorOrganisation) {
          if (hierarchicallySuperiorOrganisation.length > 0) {
            for (k = 0, len2 = hierarchicallySuperiorOrganisation.length; k < len2; k++) {
              organisation = hierarchicallySuperiorOrganisation[k];
              organisations.push(organisation.preferredName);
            }
            htmlContent += "<tr><td>Übergeordnete Körperschaft(en):</td><td>" + organisations.join("<br />") + "</td></tr>";
          }
        }
        placeOfBirth = data.placeOfBirth;
        if (placeOfBirth) {
          htmlContent += "<tr><td>Geburtsort:</td><td>" + placeOfBirth[0].preferredName + "</td></tr>";
        }
        placeOfDeath = data.placeOfDeath;
        if (placeOfDeath) {
          htmlContent += "<tr><td>Sterbeort:</td><td>" + placeOfDeath[0].preferredName + "</td></tr>";
        }
        professionOrOccupation = data.professionOrOccupation;
        professions = [];
        if (professionOrOccupation) {
          if (professionOrOccupation.length > 0) {
            for (l = 0, len3 = professionOrOccupation.length; l < len3; l++) {
              profession = professionOrOccupation[l];
              professions.push(profession.preferredName);
            }
            htmlContent += "<tr><td>Beruf(e):</td><td>" + professions.join("<br />") + "</td></tr>";
          }
        }
        biographicalOrHistoricalInformation = data.biographicalOrHistoricalInformation;
        if (biographicalOrHistoricalInformation) {
          htmlContent += "<tr><td>Biographie:</td><td>" + biographicalOrHistoricalInformation + "</td></tr>";
        }
        topic = data.topic;
        topics = [];
        if (topic) {
          if (topic.length > 0) {
            for (m = 0, len4 = topic.length; m < len4; m++) {
              t = topic[m];
              topics.push(t.preferredName);
            }
            htmlContent += "<tr><td>Themen:</td><td>" + topics.join("<br />") + "</td></tr>";
          }
        }
        variantName = data.variantName;
        if (variantName) {
          if (variantName.length > 0) {
            variantNames = variantName.join("<br />");
            htmlContent += "<tr><td>Synonyme:</td><td>" + variantNames + "</td></tr>";
          }
        }
        htmlContent += "</table>";
        tooltip.DOM.innerHTML = htmlContent;
        return tooltip.autoSize();
      }
    }).fail(function(data, status, statusText) {
      return tooltip.hide();
    });
  };

  CustomDataTypeGND.prototype.__updateSuggestionsMenu = function(cdata, cdata_form, searchstring, input, suggest_Menu, searchsuggest_xhr, layout, opts) {
    var delayMillisseconds, that;
    that = this;
    delayMillisseconds = 200;
    return setTimeout((function() {
      var gnd_countSuggestions, gnd_searchterm, gnd_searchtype, ref, ref1, ref2, ref3, ref4, ref5, ref6, subclass, subclassQuery;
      gnd_searchterm = searchstring;
      gnd_searchtype = false;
      gnd_countSuggestions = 50;
      if (cdata_form) {
        gnd_searchtype = cdata_form.getFieldsByName("gndSelectType")[0].getValue();
        gnd_countSuggestions = cdata_form.getFieldsByName("countOfSuggestions")[0].getValue();
      }
      if (gnd_searchtype === 'all_supported_types' || !gnd_searchtype) {
        gnd_searchtype = [];
        if ((ref = that.getCustomSchemaSettings().add_differentiatedpersons) != null ? ref.value : void 0) {
          gnd_searchtype.push('DifferentiatedPerson');
        }
        if ((ref1 = that.getCustomSchemaSettings().add_coorporates) != null ? ref1.value : void 0) {
          gnd_searchtype.push('CorporateBody');
        }
        if ((ref2 = that.getCustomSchemaSettings().add_geographicplaces) != null ? ref2.value : void 0) {
          gnd_searchtype.push('PlaceOrGeographicName');
        }
        if ((ref3 = that.getCustomSchemaSettings().add_subjects) != null ? ref3.value : void 0) {
          gnd_searchtype.push('SubjectHeading');
        }
        if ((ref4 = that.getCustomSchemaSettings().add_works) != null ? ref4.value : void 0) {
          gnd_searchtype.push('Work');
        }
        if ((ref5 = that.getCustomSchemaSettings().add_conferenceorevent) != null ? ref5.value : void 0) {
          gnd_searchtype.push('ConferenceOrEvent');
        }
        gnd_searchtype = gnd_searchtype.join(',');
      }
      subclass = (ref6 = that.getCustomSchemaSettings().exact_types) != null ? ref6.value : void 0;
      subclassQuery = '';
      if (subclass !== void 0) {
        if (subclass !== 'ALLE') {
          subclassQuery = '&exact_type=' + subclass;
        }
      }
      if (gnd_searchterm.length === 0) {
        return;
      }
      if (searchsuggest_xhr.xhr !== void 0) {
        searchsuggest_xhr.xhr.abort();
      }
      searchsuggest_xhr.xhr = new CUI.XHR({
        url: location.protocol + '//ws.gbv.de/suggest/gnd/?searchterm=' + gnd_searchterm + '&type=' + gnd_searchtype + subclassQuery + '&count=' + gnd_countSuggestions
      });
      return searchsuggest_xhr.xhr.start().done(function(data, status, statusText) {
        var extendedInfo_xhr, fn, i, itemList, key, len, menu_items, ref7, suggestion;
        extendedInfo_xhr = {
          "xhr": void 0
        };
        menu_items = [];
        ref7 = data[1];
        fn = function(key) {
          var aktType, item, lastType;
          aktType = data[2][key];
          lastType = '';
          if (key > 0) {
            lastType = data[2][key - 1];
          }
          if (aktType !== lastType) {
            item = {
              divider: true
            };
            menu_items.push(item);
            item = {
              label: aktType
            };
            menu_items.push(item);
            item = {
              divider: true
            };
            menu_items.push(item);
          }
          item = {
            text: suggestion,
            value: data[3][key],
            tooltip: {
              markdown: true,
              placement: "e",
              content: function(tooltip) {
                var ref8;
                if ((ref8 = that.getCustomMaskSettings().show_infopopup) != null ? ref8.value : void 0) {
                  aktType = aktType.split(' / ');
                  aktType = aktType[0];
                  if (aktType === "DifferentiatedPerson" || aktType === "CorporateBody" || aktType === "PlaceOrGeographicName" || aktType === "ConferenceOrEvent") {
                    that.__getAdditionalTooltipInfo(data[3][key], tooltip, extendedInfo_xhr);
                    return new CUI.Label({
                      icon: "spinner",
                      text: "lade Informationen"
                    });
                  }
                }
              }
            }
          };
          return menu_items.push(item);
        };
        for (key = i = 0, len = ref7.length; i < len; key = ++i) {
          suggestion = ref7[key];
          fn(key);
        }
        itemList = {
          keyboardControl: true,
          onClick: function(ev2, btn) {
            var GNDId, GNDURIParts, xurl;
            cdata.conceptURI = btn.getOpt("value");
            GNDURIParts = cdata.conceptURI.split('/');
            GNDId = GNDURIParts.pop();
            cdata.conceptName = btn.getText();
            xurl = 'https://jsontojsonp.gbv.de/?url=' + CUI.encodeURIComponentNicely('https://lobid.org/gnd/' + GNDId);
            extendedInfo_xhr = new CUI.XHR({
              url: xurl
            });
            return extendedInfo_xhr.start().done(function(data, status, statusText) {
              var resultsGNDID;
              resultsGNDID = data['gndIdentifier'];
              cdata.conceptURI = data['id'];
              cdata._standard = {
                text: cdata.conceptName
              };
              return cdata._fulltext = {
                text: ez5.GNDUtil.getFullTextFromEntityFactsJSON(data)
              };
            }).always(function() {
              that.__updateResult(cdata, layout, opts);
              suggest_Menu.hide();
              if (that.popover) {
                that.popover.hide();
              }
              return this;
            });
          },
          items: menu_items
        };
        if (itemList.items.length === 0) {
          itemList = {
            items: [
              {
                text: "kein Treffer",
                value: void 0
              }
            ]
          };
        }
        suggest_Menu.setItemList(itemList);
        return suggest_Menu.show();
      });
    }), delayMillisseconds);
  };

  CustomDataTypeGND.prototype.__getEditorFields = function(cdata) {
    var dropDownSearchOptions, option, ref, ref1, ref2, ref3, ref4, ref5;
    dropDownSearchOptions = [];
    if ((ref = this.getCustomSchemaSettings().add_differentiatedpersons) != null ? ref.value : void 0) {
      option = {
        value: 'DifferentiatedPerson',
        text: $$('custom.data.type.gnd.config.parameter.schema.add_differentiatedpersons.value.checkbox')
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref1 = this.getCustomSchemaSettings().add_coorporates) != null ? ref1.value : void 0) {
      option = {
        value: 'CorporateBody',
        text: $$('custom.data.type.gnd.config.parameter.schema.add_coorporates.value.checkbox')
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref2 = this.getCustomSchemaSettings().add_geographicplaces) != null ? ref2.value : void 0) {
      option = {
        value: 'PlaceOrGeographicName',
        text: $$('custom.data.type.gnd.config.parameter.schema.add_geographicplaces.value.checkbox')
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref3 = this.getCustomSchemaSettings().add_subjects) != null ? ref3.value : void 0) {
      option = {
        value: 'SubjectHeading',
        text: $$('custom.data.type.gnd.config.parameter.schema.add_subjects.value.checkbox')
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref4 = this.getCustomSchemaSettings().add_works) != null ? ref4.value : void 0) {
      option = {
        value: 'Work',
        text: $$('custom.data.type.gnd.config.parameter.schema.add_works.value.checkbox')
      };
      dropDownSearchOptions.push(option);
    }
    if ((ref5 = this.getCustomSchemaSettings().add_conferenceorevent) != null ? ref5.value : void 0) {
      option = {
        value: 'ConferenceOrEvent',
        text: $$('custom.data.type.gnd.config.parameter.schema.add_conferenceorevent.value.checkbox')
      };
      dropDownSearchOptions.push(option);
    }
    if (dropDownSearchOptions.length > 1) {
      option = {
        value: 'all_supported_types',
        text: $$('custom.data.type.gnd.config.option.schema.exact_types.value.all')
      };
      dropDownSearchOptions.unshift(option);
    }
    if (dropDownSearchOptions.length === 0) {
      dropDownSearchOptions = [
        {
          value: 'DifferentiatedPerson',
          text: 'Individualisierte Personen'
        }, {
          value: 'CorporateBody',
          text: 'Körperschaften'
        }, {
          value: 'PlaceOrGeographicName',
          text: 'Orte und Geographische Namen'
        }, {
          value: 'SubjectHeading',
          text: 'Schlagwörter'
        }, {
          value: 'Work',
          text: 'Werke'
        }, {
          value: 'ConferenceOrEvent',
          text: 'Konferenzen und Veranstaltungen'
        }
      ];
    }
    return [
      {
        type: CUI.Select,
        undo_and_changed_support: false,
        form: {
          label: $$('custom.data.type.gnd.modal.form.text.type')
        },
        options: dropDownSearchOptions,
        name: 'gndSelectType',
        "class": 'commonPlugin_Select'
      }, {
        type: CUI.Select,
        undo_and_changed_support: false,
        "class": 'commonPlugin_Select',
        form: {
          label: $$('custom.data.type.gnd.modal.form.text.count')
        },
        options: [
          {
            value: 10,
            text: '10 ' + $$('custom.data.type.gnd.modal.form.text.count_short')
          }, {
            value: 20,
            text: '20 ' + $$('custom.data.type.gnd.modal.form.text.count_short')
          }, {
            value: 50,
            text: '50 ' + $$('custom.data.type.gnd.modal.form.text.count_short')
          }, {
            value: 100,
            text: '100 ' + $$('custom.data.type.gnd.modal.form.text.count_short')
          }, {
            value: 250,
            text: '250 ' + $$('custom.data.type.gnd.modal.form.text.count_short')
          }
        ],
        name: 'countOfSuggestions'
      }, {
        type: CUI.Input,
        undo_and_changed_support: false,
        form: {
          label: $$("custom.data.type.gnd.modal.form.text.searchbar")
        },
        placeholder: $$("custom.data.type.gnd.modal.form.text.searchbar.placeholder"),
        name: "searchbarInput",
        "class": 'commonPlugin_Input'
      }, {
        form: {
          label: $$('custom.data.type.gnd.modal.form.text.result.label')
        },
        type: CUI.Output,
        name: "conceptName",
        data: {
          conceptName: cdata.conceptName
        }
      }, {
        form: {
          label: $$('custom.data.type.gnd.modal.form.text.uri.label')
        },
        type: CUI.FormButton,
        name: "conceptURI",
        icon: new CUI.Icon({
          "class": "fa-lightbulb-o"
        }),
        text: cdata.conceptURI,
        onClick: (function(_this) {
          return function(evt, button) {
            return window.open(cdata.conceptURI, "_blank");
          };
        })(this),
        onRender: (function(_this) {
          return function(_this) {
            if (cdata.conceptURI === '') {
              return _this.hide();
            }
          };
        })(this)
      }
    ];
  };

  CustomDataTypeGND.prototype.__renderButtonByData = function(cdata) {
    var conceptURI, encodedURI, tt_text;
    switch (this.getDataStatus(cdata)) {
      case "empty":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.gnd.edit.no_gnd")
        }).DOM;
      case "invalid":
        return new CUI.EmptyLabel({
          text: $$("custom.data.type.gnd.edit.no_valid_gnd")
        }).DOM;
    }
    conceptURI = CUI.parseLocation(cdata.conceptURI).url;
    tt_text = $$("custom.data.type.gnd.url.tooltip", {
      name: cdata.conceptName
    });
    encodedURI = encodeURIComponent(cdata.conceptURI);
    return new CUI.HorizontalLayout({
      maximize: true,
      left: {
        content: new CUI.Label({
          centered: false,
          text: cdata.conceptName
        })
      },
      center: {
        content: new CUI.ButtonHref({
          appearance: "link",
          href: cdata.conceptURI,
          target: "_blank",
          tooltip: {
            markdown: true,
            text: tt_text
          }
        })
      },
      right: null
    }).DOM;
  };

  CustomDataTypeGND.prototype.getCustomDataOptionsInDatamodelInfo = function(custom_settings) {
    var ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, tags;
    tags = [];
    if ((ref = custom_settings.add_differentiatedpersons) != null ? ref.value : void 0) {
      tags.push("✓ Personen");
    } else {
      tags.push("✘ Personen");
    }
    if ((ref1 = custom_settings.add_coorporates) != null ? ref1.value : void 0) {
      tags.push("✓ Körperschaften");
    } else {
      tags.push("✘ Körperschaften");
    }
    if ((ref2 = custom_settings.add_geographicplaces) != null ? ref2.value : void 0) {
      tags.push("✓ Orte");
    } else {
      tags.push("✘ Orte");
    }
    if ((ref3 = custom_settings.add_subjects) != null ? ref3.value : void 0) {
      tags.push("✓ Schlagwörter");
    } else {
      tags.push("✘ Schlagwörter");
    }
    if ((ref4 = custom_settings.add_works) != null ? ref4.value : void 0) {
      tags.push("✓ Werke");
    } else {
      tags.push("✘ Werke");
    }
    if ((ref5 = custom_settings.add_conferenceorevent) != null ? ref5.value : void 0) {
      tags.push("✓ Konferenzen und Veranstaltungen");
    } else {
      tags.push("✘ Konferenzen und Veranstaltungen");
    }
    if ((ref6 = custom_settings.exact_types) != null ? ref6.value : void 0) {
      tags.push("✓ Exakter Typ: " + ((ref7 = custom_settings.exact_types) != null ? ref7.value : void 0));
    } else {
      tags.push("✘ Exakter Typ");
    }
    return tags;
  };

  return CustomDataTypeGND;

})(CustomDataTypeWithCommons);

CustomDataType.register(CustomDataTypeGND);
// Generated by CoffeeScript 1.12.7
ez5.GNDUtil = (function() {
  function GNDUtil() {}

  GNDUtil.getFullTextFromEntityFactsJSON = function(efJSON) {
    var _fulltext, entry, i, i1, j, j1, k, k1, l, l1, len, len1, len10, len11, len12, len13, len14, len15, len16, len17, len18, len19, len2, len20, len21, len22, len23, len24, len25, len26, len27, len28, len29, len3, len4, len5, len6, len7, len8, len9, m, m1, n, n1, o, o1, p, p1, q, q1, r, r1, ref, ref1, ref10, ref11, ref12, ref13, ref14, ref15, ref16, ref17, ref18, ref19, ref2, ref20, ref21, ref22, ref23, ref24, ref25, ref26, ref27, ref28, ref29, ref3, ref4, ref5, ref6, ref7, ref8, ref9, s, s1, t, t1, u, v, w, x, y, z;
    _fulltext = '';
    _fulltext += efJSON['id'] + ' ';
    _fulltext = efJSON['gndIdentifier'] + ' ';
    if (efJSON != null ? efJSON.oldAuthorityNumber : void 0) {
      ref = efJSON.oldAuthorityNumber;
      for (i = 0, len = ref.length; i < len; i++) {
        entry = ref[i];
        _fulltext += entry + ' ';
      }
    }
    if (efJSON != null ? efJSON.gndSubjectCategory : void 0) {
      ref1 = efJSON.gndSubjectCategory;
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        entry = ref1[j];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    _fulltext += efJSON['preferredName'] + ' ';
    if (efJSON != null ? efJSON.variantName : void 0) {
      ref2 = efJSON.variantName;
      for (k = 0, len2 = ref2.length; k < len2; k++) {
        entry = ref2[k];
        _fulltext += entry + ' ';
      }
    }
    if (efJSON != null ? efJSON.biographicalOrHistoricalInformation : void 0) {
      ref3 = efJSON.biographicalOrHistoricalInformation;
      for (l = 0, len3 = ref3.length; l < len3; l++) {
        entry = ref3[l];
        _fulltext += entry + ' ';
      }
    }
    if (efJSON != null ? efJSON.dateOfEstablishment : void 0) {
      ref4 = efJSON.dateOfEstablishment;
      for (m = 0, len4 = ref4.length; m < len4; m++) {
        entry = ref4[m];
        _fulltext += entry + ' ';
      }
    }
    if (efJSON != null ? efJSON.dateOfPublication : void 0) {
      ref5 = efJSON.dateOfPublication;
      for (n = 0, len5 = ref5.length; n < len5; n++) {
        entry = ref5[n];
        _fulltext += entry + ' ';
      }
    }
    if (efJSON != null ? efJSON.dateOfBirth : void 0) {
      _fulltext += efJSON.dateOfBirth + ' ';
    }
    if (efJSON != null ? efJSON.dateOfProduction : void 0) {
      _fulltext += efJSON.dateOfProduction + ' ';
    }
    if (efJSON != null ? efJSON.dateOfDeath : void 0) {
      _fulltext += efJSON.dateOfDeath + ' ';
    }
    if (efJSON != null ? efJSON.dateOfTermination : void 0) {
      _fulltext += efJSON.dateOfTermination + ' ';
    }
    if (efJSON != null ? efJSON.author : void 0) {
      ref6 = efJSON.author;
      for (o = 0, len6 = ref6.length; o < len6; o++) {
        entry = ref6[o];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.firstAuthor : void 0) {
      ref7 = efJSON.firstAuthor;
      for (p = 0, len7 = ref7.length; p < len7; p++) {
        entry = ref7[p];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.organizerOrHost : void 0) {
      ref8 = efJSON.organizerOrHost;
      for (q = 0, len8 = ref8.length; q < len8; q++) {
        entry = ref8[q];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.gender : void 0) {
      ref9 = efJSON.gender;
      for (r = 0, len9 = ref9.length; r < len9; r++) {
        entry = ref9[r];
        if (entry.label) {
          _fulltext += entry.label + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.placeOfEvent : void 0) {
      ref10 = efJSON.placeOfEvent;
      for (s = 0, len10 = ref10.length; s < len10; s++) {
        entry = ref10[s];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.placeOfBirth : void 0) {
      ref11 = efJSON.placeOfBirth;
      for (t = 0, len11 = ref11.length; t < len11; t++) {
        entry = ref11[t];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.placeOfDeath : void 0) {
      ref12 = efJSON.placeOfDeath;
      for (u = 0, len12 = ref12.length; u < len12; u++) {
        entry = ref12[u];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.placeOfBusiness : void 0) {
      ref13 = efJSON.placeOfBusiness;
      for (v = 0, len13 = ref13.length; v < len13; v++) {
        entry = ref13[v];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.associatedPlace : void 0) {
      ref14 = efJSON.associatedPlace;
      for (w = 0, len14 = ref14.length; w < len14; w++) {
        entry = ref14[w];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.topic : void 0) {
      ref15 = efJSON.topic;
      for (x = 0, len15 = ref15.length; x < len15; x++) {
        entry = ref15[x];
        if (entry.label) {
          _fulltext += entry.label + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.predecessor : void 0) {
      ref16 = efJSON.predecessor;
      for (y = 0, len16 = ref16.length; y < len16; y++) {
        entry = ref16[y];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.precedingCorporateBody : void 0) {
      ref17 = efJSON.precedingCorporateBody;
      for (z = 0, len17 = ref17.length; z < len17; z++) {
        entry = ref17[z];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.isA : void 0) {
      ref18 = efJSON.isA;
      for (i1 = 0, len18 = ref18.length; i1 < len18; i1++) {
        entry = ref18[i1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.composer : void 0) {
      ref19 = efJSON.composer;
      for (j1 = 0, len19 = ref19.length; j1 < len19; j1++) {
        entry = ref19[j1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.relatedWork : void 0) {
      ref20 = efJSON.relatedWork;
      for (k1 = 0, len20 = ref20.length; k1 < len20; k1++) {
        entry = ref20[k1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.relatedPerson : void 0) {
      ref21 = efJSON.relatedPerson;
      for (l1 = 0, len21 = ref21.length; l1 < len21; l1++) {
        entry = ref21[l1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.precedingPlaceOrGeographicName : void 0) {
      ref22 = efJSON.precedingPlaceOrGeographicName;
      for (m1 = 0, len22 = ref22.length; m1 < len22; m1++) {
        entry = ref22[m1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.hierarchicalSuperiorOfTheCorporateBody : void 0) {
      ref23 = efJSON.hierarchicalSuperiorOfTheCorporateBody;
      for (n1 = 0, len23 = ref23.length; n1 < len23; n1++) {
        entry = ref23[n1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.broaderTermInstantial : void 0) {
      ref24 = efJSON.broaderTermInstantial;
      for (o1 = 0, len24 = ref24.length; o1 < len24; o1++) {
        entry = ref24[o1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.broaderTermGeneral : void 0) {
      ref25 = efJSON.broaderTermGeneral;
      for (p1 = 0, len25 = ref25.length; p1 < len25; p1++) {
        entry = ref25[p1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.professionOrOccupation : void 0) {
      ref26 = efJSON.professionOrOccupation;
      for (q1 = 0, len26 = ref26.length; q1 < len26; q1++) {
        entry = ref26[q1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.architect : void 0) {
      ref27 = efJSON.architect;
      for (r1 = 0, len27 = ref27.length; r1 < len27; r1++) {
        entry = ref27[r1];
        if (entry.preferredName) {
          _fulltext += entry.preferredName + ' ';
        }
      }
    }
    if (efJSON != null ? efJSON.opusNumericDesignationOfMusicalWork : void 0) {
      ref28 = efJSON.opusNumericDesignationOfMusicalWork;
      for (s1 = 0, len28 = ref28.length; s1 < len28; s1++) {
        entry = ref28[s1];
        _fulltext += entry + ' ';
      }
    }
    if (efJSON != null ? efJSON.definition : void 0) {
      ref29 = efJSON.definition;
      for (t1 = 0, len29 = ref29.length; t1 < len29; t1++) {
        entry = ref29[t1];
        _fulltext += entry + ' ';
      }
    }
    return _fulltext;
  };

  return GNDUtil;

})();
