// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty,
  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

ez5.DetailLinkedMaskSplitter = (function(superClass) {
  extend(DetailLinkedMaskSplitter, superClass);

  function DetailLinkedMaskSplitter() {
    return DetailLinkedMaskSplitter.__super__.constructor.apply(this, arguments);
  }

  DetailLinkedMaskSplitter.NAVIGATION_LIMIT = 10;

  DetailLinkedMaskSplitter.prototype.getOptions = function() {
    var i, len, objecttype, objecttypeOptions, objecttypes, options;
    objecttypes = this.__getObjecttypesWithLinkToTable(this.maskEditor.current_mask.table.table_id);
    objecttypeOptions = [];
    for (i = 0, len = objecttypes.length; i < len; i++) {
      objecttype = objecttypes[i];
      objecttypeOptions.push({
        value: objecttype.name,
        text: objecttype._name_localized
      });
    }
    options = [
      {
        form: {
          label: $$("detail.linked.mask.splitter.options.mode")
        },
        type: CUI.Select,
        name: "mode",
        options: [
          {
            text: $$("detail.linked.mask.splitter.options.mode.standard"),
            value: "standard"
          }, {
            text: $$("detail.linked.mask.splitter.options.mode.short"),
            value: "short"
          }, {
            text: $$("detail.linked.mask.splitter.options.mode.text"),
            value: "text"
          }
        ]
      }, {
        form: {
          label: $$("detail.linked.mask.splitter.options.objecttypes")
        },
        type: CUI.Options,
        name: "objecttypes",
        options: objecttypeOptions,
        onDataInit: (function(_this) {
          return function(_, data) {
            var j, len1, table;
            if (!CUI.util.isUndef(data.objecttypes)) {
              return;
            }
            data.objecttypes = [];
            objecttypes = _this.__getObjecttypesWithLinkToTable(_this.maskEditor.current_mask.table.table_id);
            for (j = 0, len1 = objecttypes.length; j < len1; j++) {
              table = objecttypes[j];
              data.objecttypes.push(table.name);
            }
          };
        })(this)
      }
    ];
    if (ez5.version("6")) {
      options.push({
        form: {
          label: $$("detail.linked.mask.splitter.options.include_inherited")
        },
        type: CUI.Checkbox,
        name: "include_inherited"
      });
      options.push({
        form: {
          label: $$("detail.linked.mask.splitter.options.show_fields")
        },
        type: CUI.Checkbox,
        name: "show_fields"
      });
      options.push(this.__getSortDataTableField());
    }
    return options;
  };

  DetailLinkedMaskSplitter.prototype.getDefaultOptions = function() {
    var defaultOptions;
    defaultOptions = {
      mode: "standard"
    };
    return defaultOptions;
  };

  DetailLinkedMaskSplitter.prototype.renderField = function(opts) {
    var dataOptions, globalObjectId, idTable, linkedFieldNames, mainContent, objecttype, ref, showFields, spinner;
    if (opts == null) {
      opts = {};
    }
    if (opts.mode !== "detail") {
      return;
    }
    globalObjectId = (ref = opts.top_level_data) != null ? ref._global_object_id : void 0;
    if (!globalObjectId) {
      return;
    }
    objecttype = opts.top_level_data._objecttype;
    if (!objecttype) {
      return;
    }
    dataOptions = this.getDataOptions();
    idTable = ez5.schema.CURRENT._objecttype_by_name[objecttype].table_id;
    linkedFieldNames = this.__getLinkedFieldNames(idTable, dataOptions.objecttypes);
    if (CUI.util.isEmpty(linkedFieldNames)) {
      return;
    }
    mainContent = CUI.dom.div("ez5-detail-linked-mask-splitter-content");
    spinner = new LocaLabel({
      loca_key: "detail.linked.mask.splitter.detail.spinner"
    });
    CUI.dom.append(mainContent, spinner);
    showFields = ez5.version("6") && dataOptions.show_fields;
    this.__searchByLinkedFieldNames(linkedFieldNames, globalObjectId, dataOptions.mode).done((function(_this) {
      return function(dataByObjecttype) {
        var content, data, fieldLocalizedName, i, j, k, len, len1, len2, localized_objecttype, object, objecttypesWithSort, ref1, ref2, ref3, resultObjects, sortEntry;
        CUI.dom.empty(mainContent);
        dataByObjecttype.sort(function(a, b) {
          var cmp, fieldA, fieldB, objecttypeA, objecttypeB, ref1, ref2;
          objecttypeA = ((ref1 = a.objecttypes) != null ? ref1[0] : void 0) || "";
          objecttypeB = ((ref2 = b.objecttypes) != null ? ref2[0] : void 0) || "";
          cmp = objecttypeA.localeCompare(objecttypeB);
          if (cmp !== 0) {
            return cmp;
          }
          if (showFields) {
            fieldA = a._fieldLocalizedName || "";
            fieldB = b._fieldLocalizedName || "";
            return fieldA.localeCompare(fieldB);
          }
          return 0;
        });
        objecttypesWithSort = {};
        if (ez5.version("6") && dataOptions.sort_config) {
          ref1 = dataOptions.sort_config;
          for (i = 0, len = ref1.length; i < len; i++) {
            sortEntry = ref1[i];
            if (sortEntry.objecttype && sortEntry.field && sortEntry.field !== "") {
              objecttypesWithSort[sortEntry.objecttype] = true;
            }
          }
        }
        for (j = 0, len1 = dataByObjecttype.length; j < len1; j++) {
          data = dataByObjecttype[j];
          if (data.objects.length === 0) {
            continue;
          }
          objecttype = data.objecttypes[0];
          if (!objecttypesWithSort[objecttype]) {
            data.objects.sort(function(a, b) {
              var ref2, ref3, ref4, ref5, standardNameA, standardNameB;
              standardNameA = ez5.loca.getBestFrontendValue((ref2 = a._standard) != null ? (ref3 = ref2["1"]) != null ? ref3.text : void 0 : void 0);
              standardNameB = ez5.loca.getBestFrontendValue((ref4 = b._standard) != null ? (ref5 = ref4["1"]) != null ? ref5.text : void 0 : void 0);
              if (standardNameA && standardNameB) {
                return standardNameA.localeCompare(standardNameB);
              }
              return 0;
            });
          }
          resultObjects = [];
          ref2 = data.objects;
          for (k = 0, len2 = ref2.length; k < len2; k++) {
            object = ref2[k];
            resultObjects.push(new ResultObject().setData(object));
          }
          localized_objecttype = (ref3 = resultObjects[0]) != null ? ref3.objecttypeLocalized() : void 0;
          fieldLocalizedName = showFields ? data._fieldLocalizedName : null;
          content = _this.__renderObjects(localized_objecttype, resultObjects, dataOptions.mode, opts, fieldLocalizedName);
          CUI.dom.append(mainContent, content);
        }
      };
    })(this)).fail((function(_this) {
      return function(err) {
        console.error("DetailLinkedMaskSplitter :: Error when fetching objects.", err);
        return CUI.dom.empty(mainContent);
      };
    })(this));
    return mainContent;
  };

  DetailLinkedMaskSplitter.prototype.__renderObjects = function(objecttype, resultObjects, mode, opts, fieldLocalizedName) {
    var content, currentPage, label, length, limit, navigationToolbar, objectsContent, objecttypeHeader, renderObjects, titleDiv;
    if (opts == null) {
      opts = {};
    }
    if (fieldLocalizedName == null) {
      fieldLocalizedName = null;
    }
    objecttypeHeader = CUI.dom.div("ez5-field-block-header");
    objectsContent = CUI.dom.div("ez5-field-block-content");
    titleDiv = CUI.dom.div("ez5-field-block-title");
    if (fieldLocalizedName) {
      label = new CUI.Label({
        text: $$("detail.linked.mask.splitter.header.objecttype.field.title", {
          objecttype: objecttype,
          field: fieldLocalizedName
        }),
        "class": "ez5-field-label"
      });
    } else {
      label = new CUI.Label({
        text: $$("detail.linked.mask.splitter.header.objecttype.title", {
          objecttype: objecttype
        }),
        "class": "ez5-field-label"
      });
    }
    CUI.dom.append(titleDiv, label);
    CUI.dom.append(objecttypeHeader, titleDiv);
    limit = ez5.DetailLinkedMaskSplitter.NAVIGATION_LIMIT;
    length = resultObjects.length;
    currentPage = 0;
    renderObjects = function(page) {
      var condensedContainer, detailTools, div, horizontalLayout, i, index, itemDiv, itemField, offset, ref, ref1, resultObject, toIndex;
      if (page == null) {
        page = currentPage;
      }
      CUI.dom.empty(objectsContent);
      currentPage = page;
      offset = page * limit;
      toIndex = offset + limit;
      if (toIndex > length) {
        toIndex = length;
      }
      if (mode === "short") {
        condensedContainer = CUI.dom.div("ez5-nested--condensed ez5-nested--single-column");
        CUI.dom.append(objectsContent, condensedContainer);
      }
      for (index = i = ref = offset, ref1 = toIndex; ref <= ref1 ? i < ref1 : i > ref1; index = ref <= ref1 ? ++i : --i) {
        resultObject = resultObjects[index];
        div = (function() {
          switch (mode) {
            case "short":
              return resultObject.renderCardLinkedObjectShort();
            case "text":
              return resultObject.renderTextDetail();
            case "standard":
              return resultObject.renderCardLinkedObjectStandard();
          }
        })();
        if (mode === "short") {
          itemDiv = CUI.dom.div("ez5-nested-fields");
          itemField = CUI.dom.div("ez5-field");
          CUI.dom.append(itemDiv, itemField);
          CUI.dom.append(itemField, div);
          CUI.dom.append(condensedContainer, itemDiv);
        } else {
          horizontalLayout = new CUI.HorizontalLayout({
            maximize_horizontal: true,
            maximize_vertical: false,
            "class": "ez5-linked-object-detail ez5-linked-object linked-object-popover",
            right: {}
          });
          horizontalLayout.replace(div, "center");
          if (opts.detail) {
            detailTools = resultObject.getDetailTools({
              detail: opts.detail,
              getElement: (function(_this) {
                return function() {
                  return horizontalLayout;
                };
              })(this)
            });
            horizontalLayout.replace(Toolbox.getFlyoutButtonbar(detailTools, {
              appearance: "flat"
            }), "right");
          }
          CUI.dom.append(objectsContent, horizontalLayout);
        }
      }
      if (navigationToolbar) {
        navigationToolbar.update({
          count: length,
          offset: offset,
          limit: limit
        });
      }
    };
    content = [objecttypeHeader, objectsContent];
    if (length > limit) {
      navigationToolbar = new NavigationToolbar({
        size: "mini",
        append_count_label: false,
        onLoadPage: renderObjects
      });
      content.push(navigationToolbar);
    }
    renderObjects();
    return content;
  };

  DetailLinkedMaskSplitter.prototype.__getLinkedFieldNames = function(idTable, objecttypes) {
    var columnSchema, field, fieldLocalizedName, fieldName, fn, i, len, linkedFieldNames, nestedName, objecttype, objecttypeManager, ref, showFields, table, table_name;
    if (objecttypes == null) {
      objecttypes = [];
    }
    linkedFieldNames = {};
    showFields = ez5.version("6") && this.getDataOptions().show_fields;
    objecttypeManager = new ObjecttypeManager();
    objecttypeManager.addObjecttypes((function(_this) {
      return function(table, mask) {
        var ref;
        if (ref = table.name(), indexOf.call(objecttypes, ref) < 0) {
          return false;
        }
        return mask.schema.is_preferred;
      };
    })(this));
    ref = objecttypeManager.getAllFields();
    for (i = 0, len = ref.length; i < len; i++) {
      field = ref[i];
      columnSchema = field.ColumnSchema;
      if (!this.__hasColumnLinkToTable(columnSchema, idTable)) {
        continue;
      }
      if (!this.__isFieldSearchable(field)) {
        continue;
      }
      table = field.table.schema;
      table_name = table.name;
      fieldName = table_name + "." + columnSchema.name + "._global_object_id";
      if (table.owned_by) {
        nestedName = this.__getNestedLinkedFieldName(table);
        fieldName = "" + nestedName + fieldName;
      }
      objecttype = fieldName.split(".")[0];
      fieldLocalizedName = null;
      if (showFields) {
        fieldLocalizedName = field.nameLocalized();
      }
      if (ez5.version("6") && !this.getDataOptions().include_inherited && field.isInherited()) {
        fn = fieldName.replace("._global_object_id", "");
        if (linkedFieldNames[objecttype] == null) {
          linkedFieldNames[objecttype] = [];
        }
        linkedFieldNames[objecttype].push({
          fieldName: fn + ":inherited",
          localizedName: fieldLocalizedName,
          isInherited: true
        });
      }
      if (linkedFieldNames[objecttype] == null) {
        linkedFieldNames[objecttype] = [];
      }
      linkedFieldNames[objecttype].push({
        fieldName: fieldName,
        localizedName: fieldLocalizedName,
        isInherited: false
      });
    }
    return linkedFieldNames;
  };

  DetailLinkedMaskSplitter.prototype.__searchByLinkedFieldNames = function(linkedFieldNamesPerObjecttype, globalObjectId, mode) {
    var dataOptions, dfr, fieldInfo, fieldLocalizedNames, fieldName, fn1, hasInheritedField, i, inheritedFieldName, inheritedLinkeds, j, k, len, len1, len2, linkedFieldInfos, objecttype, ref, regularFields, results, searchData, searchPromise, searches, showFields, sortConfigByObjecttype, sortEntry;
    dfr = new CUI.Deferred();
    searches = [];
    results = [];
    mode = mode === "text" ? "long" : mode;
    dataOptions = this.getDataOptions();
    showFields = ez5.version("6") && dataOptions.show_fields;
    sortConfigByObjecttype = {};
    if (ez5.version("6") && dataOptions.sort_config) {
      ref = dataOptions.sort_config;
      for (i = 0, len = ref.length; i < len; i++) {
        sortEntry = ref[i];
        if (sortEntry.objecttype && sortEntry.field && sortEntry.field !== "") {
          sortConfigByObjecttype[sortEntry.objecttype] = [
            {
              field: sortEntry.field,
              order: sortEntry.order || "ASC"
            }
          ];
        }
      }
    }
    for (objecttype in linkedFieldNamesPerObjecttype) {
      linkedFieldInfos = linkedFieldNamesPerObjecttype[objecttype];
      inheritedLinkeds = [];
      regularFields = [];
      fieldLocalizedNames = {};
      for (j = 0, len1 = linkedFieldInfos.length; j < len1; j++) {
        fieldInfo = linkedFieldInfos[j];
        if (fieldInfo.isInherited) {
          inheritedLinkeds.push(fieldInfo.fieldName);
        } else {
          regularFields.push(fieldInfo.fieldName);
          if (fieldInfo.localizedName) {
            fieldLocalizedNames[fieldInfo.fieldName] = fieldInfo.localizedName;
          }
        }
      }
      if (showFields) {
        fn1 = (function(_this) {
          return function(fieldName, fieldLocalizedNames) {
            var searchPromise;
            searchPromise = ez5.api.search({
              data: {
                debug: "DetailMaskSplitterSearch"
              },
              json_data: searchData
            });
            searchPromise.done(function(result) {
              result._fieldName = fieldName;
              result._fieldLocalizedName = fieldLocalizedNames[fieldName];
              return results.push(result);
            });
            return searches.push(searchPromise);
          };
        })(this);
        for (k = 0, len2 = regularFields.length; k < len2; k++) {
          fieldName = regularFields[k];
          inheritedFieldName = fieldName.replace("._global_object_id", "") + ":inherited";
          hasInheritedField = indexOf.call(inheritedLinkeds, inheritedFieldName) >= 0;
          searchData = {
            limit: 1000,
            format: mode,
            objecttypes: [objecttype]
          };
          if (hasInheritedField) {
            searchData.search = [
              {
                type: "complex",
                bool: "must",
                search: [
                  {
                    type: "in",
                    fields: [fieldName],
                    "in": [globalObjectId]
                  }, {
                    type: "in",
                    fields: [inheritedFieldName],
                    "in": [false]
                  }
                ]
              }
            ];
          } else {
            searchData.search = [
              {
                type: "in",
                fields: [fieldName],
                "in": [globalObjectId]
              }
            ];
          }
          if (sortConfigByObjecttype[objecttype]) {
            searchData.sort = sortConfigByObjecttype[objecttype];
          }
          fn1(fieldName, fieldLocalizedNames);
        }
      } else {
        searchData = {
          limit: 1000,
          format: mode,
          objecttypes: [objecttype]
        };
        if (inheritedLinkeds.length > 0) {
          searchData.search = [
            {
              type: "complex",
              bool: "must",
              search: [
                {
                  type: "in",
                  fields: regularFields,
                  "in": [globalObjectId]
                }, {
                  type: "in",
                  fields: inheritedLinkeds,
                  "in": [false]
                }
              ]
            }
          ];
        } else {
          searchData.search = [
            {
              type: "in",
              fields: regularFields,
              "in": [globalObjectId]
            }
          ];
        }
        if (sortConfigByObjecttype[objecttype]) {
          searchData.sort = sortConfigByObjecttype[objecttype];
        }
        searchPromise = ez5.api.search({
          data: {
            debug: "DetailMaskSplitterSearch"
          },
          json_data: searchData
        });
        searchPromise.done((function(_this) {
          return function(result) {
            return results.push(result);
          };
        })(this));
        searches.push(searchPromise);
      }
    }
    CUI.when(searches).done((function(_this) {
      return function() {
        return dfr.resolve(results);
      };
    })(this)).fail((function(_this) {
      return function(err) {
        return dfr.reject(err);
      };
    })(this));
    return dfr.promise();
  };

  DetailLinkedMaskSplitter.prototype.__getSortDataTableField = function() {
    var getObjecttypeOptions, getSortFieldOptions;
    getObjecttypeOptions = (function(_this) {
      return function() {
        var i, isAlreadyConfigured, len, objecttype, objecttypeName, options, ref, ref1, selectedObjecttypes;
        isAlreadyConfigured = function(objecttypeName) {
          var ref, ref1, sortConfig;
          sortConfig = ((ref = _this._data) != null ? (ref1 = ref.options) != null ? ref1.sort_config : void 0 : void 0) || [];
          return sortConfig.some(function(entry) {
            return entry.objecttype === objecttypeName;
          });
        };
        options = [
          {
            value: null,
            text: $$("detail.linked.mask.splitter.options.sort_config.objecttype.empty")
          }
        ];
        selectedObjecttypes = ((ref = _this._data) != null ? (ref1 = ref.options) != null ? ref1.objecttypes : void 0 : void 0) || [];
        for (i = 0, len = selectedObjecttypes.length; i < len; i++) {
          objecttypeName = selectedObjecttypes[i];
          objecttype = ez5.schema.CURRENT._objecttype_by_name[objecttypeName];
          if (objecttype) {
            options.push({
              value: objecttypeName,
              text: objecttype._name_localized || objecttypeName,
              disabled: isAlreadyConfigured(objecttypeName)
            });
          }
        }
        return options;
      };
    })(this);
    getSortFieldOptions = (function(_this) {
      return function(objecttypeName) {
        var mask, objecttype, options;
        options = [
          {
            text: $$("detail.linked.mask.splitter.options.sort_field.default"),
            value: ""
          }, {
            text: $$("detail.linked.mask.splitter.options.sort_field.system_object_id"),
            value: "_system_object_id"
          }, {
            text: $$("detail.linked.mask.splitter.options.sort_field.created"),
            value: "_changelog.date_created"
          }, {
            text: $$("detail.linked.mask.splitter.options.sort_field.last_updated"),
            value: "_changelog.date_last_updated"
          }, {
            text: $$("detail.linked.mask.splitter.options.sort_field.standard_1"),
            value: "_standard.1.text"
          }, {
            text: $$("detail.linked.mask.splitter.options.sort_field.standard_2"),
            value: "_standard.2.text"
          }, {
            text: $$("detail.linked.mask.splitter.options.sort_field.standard_3"),
            value: "_standard.3.text"
          }
        ];
        if (!objecttypeName) {
          return options;
        }
        objecttype = ez5.schema.CURRENT._objecttype_by_name[objecttypeName];
        if (!objecttype) {
          return options;
        }
        mask = Mask.getMaskByMaskName("_all_fields", objecttype.table_id);
        if (!mask) {
          return options;
        }
        mask.invokeOnFields("all", true, function(field) {
          var fieldName;
          if (field instanceof MaskSplitter) {
            return;
          }
          if (field.isTopLevelField() || field.isSystemField()) {
            return;
          }
          if (!field.hasRenderForSort()) {
            return;
          }
          if (!(typeof field.isVisibleSort === "function" ? field.isVisibleSort() : void 0) && (typeof field.isVisibleSort === "function" ? field.isVisibleSort() : void 0) === false) {
            return;
          }
          fieldName = objecttypeName + "." + (field.name());
          return options.push({
            text: field.nameLocalized(),
            value: fieldName
          });
        });
        return options;
      };
    })(this);
    return {
      type: CUI.DataTable,
      name: "sort_config",
      new_rows: "append",
      form: {
        label: $$("detail.linked.mask.splitter.options.sort_config")
      },
      fields: [
        {
          type: CUI.Select,
          form: {
            label: $$("detail.linked.mask.splitter.options.sort_config.objecttype")
          },
          name: "objecttype",
          options: getObjecttypeOptions,
          onDataChanged: (function(_this) {
            return function(data, element) {
              var fieldSelect, form, ref;
              form = element.getForm();
              if (form) {
                fieldSelect = (ref = form.getFieldsByName("field")) != null ? ref[0] : void 0;
                if (fieldSelect) {
                  return fieldSelect.reload();
                }
              }
            };
          })(this)
        }, {
          type: CUI.Select,
          form: {
            label: $$("detail.linked.mask.splitter.options.sort_config.field")
          },
          name: "field",
          options: (function(_this) {
            return function(field) {
              var data;
              data = field.getData();
              return getSortFieldOptions(data != null ? data.objecttype : void 0);
            };
          })(this)
        }, {
          type: CUI.Select,
          form: {
            label: $$("detail.linked.mask.splitter.options.sort_config.order")
          },
          name: "order",
          options: [
            {
              text: $$("detail.linked.mask.splitter.options.sort_order.asc"),
              value: "ASC"
            }, {
              text: $$("detail.linked.mask.splitter.options.sort_order.desc"),
              value: "DESC"
            }
          ]
        }
      ]
    };
  };

  DetailLinkedMaskSplitter.prototype.__getObjecttypesWithLinkToTable = function(idTable) {
    var columnSchema, field, i, len, objecttype, objecttypeManager, objecttypes, ref;
    objecttypes = [];
    objecttypeManager = new ObjecttypeManager({
      version: "HEAD"
    });
    objecttypeManager.addObjecttypes((function(_this) {
      return function(table, mask) {
        return mask.schema.is_preferred;
      };
    })(this));
    ref = objecttypeManager.getAllFields();
    for (i = 0, len = ref.length; i < len; i++) {
      field = ref[i];
      columnSchema = field.ColumnSchema;
      if (this.__hasColumnLinkToTable(columnSchema, idTable) && this.__isFieldSearchable(field)) {
        objecttype = field.getMainMask().table.schema;
        if (indexOf.call(objecttypes, objecttype) >= 0) {
          continue;
        }
        objecttypes.push(objecttype);
      }
    }
    return objecttypes;
  };

  DetailLinkedMaskSplitter.prototype.__getNestedLinkedFieldName = function(table) {
    var ownerTable;
    if (!table) {
      return;
    }
    if (!table.owned_by) {
      return "";
    }
    ownerTable = ez5.schema.CURRENT._table_by_id[table.owned_by.other_table_id];
    return this.__getNestedLinkedFieldName(ownerTable) + ownerTable.name + "._nested:";
  };

  DetailLinkedMaskSplitter.prototype.hasContent = function() {
    return true;
  };

  DetailLinkedMaskSplitter.prototype.__hasColumnLinkToTable = function(column, idTable) {
    return column && column.type === "link" && column._foreign_key.referenced_table.table_id === idTable;
  };

  DetailLinkedMaskSplitter.prototype.__isFieldSearchable = function(field) {
    var fatherField;
    if (!field) {
      return true;
    }
    fatherField = field.getFatherField();
    return this.__isFieldSearchable(fatherField) && field.isVisible("expert");
  };

  DetailLinkedMaskSplitter.prototype.isSimpleSplit = function() {
    return true;
  };

  DetailLinkedMaskSplitter.prototype.renderAsField = function() {
    return true;
  };

  DetailLinkedMaskSplitter.prototype.isEnabledForNested = function() {
    return false;
  };

  return DetailLinkedMaskSplitter;

})(CustomMaskSplitter);

MaskSplitter.plugins.registerPlugin(ez5.DetailLinkedMaskSplitter);
