class Easydb4MigrationPlugin.OrdinariatFreiburg extends Easydb4MigrationPlugin
	name: ->
		"ordinariat-freiburg"

	init: ->
		@gnd_source_field = "lk_gnd_normdaten_id"
		@gnd_target_field = "gnd_id"
		@gnd_field_ots = [
			"arbeitsfeld1",
			"arbeitsfeld2",
			"archivalie",
			"ikonogrbez",
			"lokalisierung",
			"objektname",
			"person",
			"provenienz",
			"sachbezeichnung",
			"schlagwort",
			"titel",
			"topographie"
		]
		console.debug @name(), "| init | source field for gnd links:", @gnd_source_field
		console.debug @name(), "| init | target field for gnd links:", @gnd_target_field
		console.debug @name(), "| init | objecttypes with gnd link:", @gnd_field_ots

		@item_ot = "item"
		@item_foto_ot = "item_foto"
		@objekt_foto_ot = "objekt__foto"

		@item_item_typ_ot = "item_item_typ"
		@item_item_typ_created = false
		@item_item_typ__ist_kind_von = 'ist Kind von'
		@item_item_typ__hat_kind = 'hat Kind'

		# load all gnd ids into the cache
		@gnd_rows = {}

		dfr = new CUI.Deferred()

		@_migration.query("""
			SELECT
				id,
				gnd_uri,
				gnd_preferred_name,
				gnd_id || ' ' || replace(gnd_old_authority_number, X'0A', ' ') || ' ' || replace(gnd_fulltext, X'0A', ' ') AS fulltext
			FROM "source.public.gnd"
			WHERE id IS NOT NULL
			AND gnd_uri IS NOT NULL
		""")
		.fail(dfr.reject)
		.done (result) =>
			for row in result.rows
				@gnd_rows[row.id] = row
			console.debug @name(), "| init | loaded", Object.keys(@gnd_rows).length, "rows from source.public.gnd"
			dfr.resolve()

		# load from freigabe table to create tags
		@freigabe_tags = {}

		dfr2 = new CUI.Deferred()
		@_migration.query("""
			SELECT id, name
			FROM "source.public.freigabe"
			WHERE id IS NOT NULL
			AND name IS NOT NULL
		""")
		.fail(dfr2.reject)
		.done (result) =>
			for row in result.rows
				@freigabe_tags["freigabe:" + row.id] = row.name
			console.debug @name(), "| init | loaded", Object.keys(@freigabe_tags).length, "tags from source.public.freigabe"
			dfr2.resolve()


		# load ids of itemtyp "foto" and "objekt" to format the correct references
		dfr3 = new CUI.Deferred()

		@itemtyp_objekt_ref = ""
		@itemtyp_foto_ref = ""
		@_migration.query("""
			SELECT * FROM (
				SELECT
					id,
					'foto' AS internal_name,
					name
				FROM "source.public.itemtyp"
				WHERE lower(name) LIKE 'foto%'
				LIMIT 1 -- there should only be one hit
			)

			UNION ALL

			SELECT * FROM (
				SELECT
					id,
					'objekt' AS internal_name,
					name
				FROM "source.public.itemtyp"
				WHERE lower(name) LIKE 'objekt%'
				LIMIT 1 -- there should only be one hit
			)
		""")
		.fail(dfr3.reject)
		.done (result) =>

			itemtyp_foto_id = 0
			itemtyp_objekt_id = 0

			for row in result.rows
				if row.internal_name == "objekt"
					itemtyp_objekt_id = row.id
					@itemtyp_objekt_ref = "itemtyp:" + itemtyp_objekt_id
					console.debug @name(), "| init | loaded id for itemtyp with name", row.name, "=> ref =", @itemtyp_objekt_ref
				if row.internal_name == "foto"
					itemtyp_foto_id = row.id
					@itemtyp_foto_ref = "itemtyp:" + itemtyp_foto_id
					console.debug @name(), "| init | loaded id for itemtyp with name", row.name, "=> ref =", @itemtyp_foto_ref


			# map item and replaced item_foto references to use in collection after objecttype was changed
			@item_references = {}

			# load the references of all item objects that are linked in item_1314, item_1333, item_1272
			# these item objects need to be exported as dummys first
			# map reference to pool reference
			@dummy_items = {}
			@dummys_exported = false

			@item_links = {}
			@item_foto_links = {}

			@seen_objekt_foto_refs = {}

			@hauptfotos = {}

			@_migration.query("""
				SELECT
					item_from.id,
					item.id AS item_id,
					'item' AS ot,
					item.pool_id AS pool_id,
					NULL AS item_from_id,
					NULL AS hauptfoto
				FROM "source.public.item" item
				JOIN "source.public.item__item" item_from
				ON (
					-- item objects that link to this object
					-- relates to _nested:item__item_1333
					item.id = item_from.lk_item_from AND
					item.lk_itemtyp_id = """ + itemtyp_objekt_id + """
				)

				UNION ALL

				SELECT
					item_to.id,
					item.id AS item_id,
					'item_foto' AS ot,
					item.pool_id AS pool_id,
					item_to.lk_item_from AS item_from_id,
					item_to.hauptfoto
				FROM "source.public.item" item
				JOIN "source.public.item__item" item_to
				ON (
					-- item_foto objects that are linked to this object using objekt__foto link objects
					-- relates to _nested:item__item_1272
					item.id = item_to.lk_item_to AND
					item.lk_itemtyp_id = """ + itemtyp_foto_id + """
				)
			""")
			.fail(dfr3.reject)
			.done (result) =>
				for row in result.rows
					if not row.id
						continue
					if not row.item_id
						continue
					if not row.ot
						continue
					if not row.pool_id
						continue

					if not @dummy_items[row.ot]?
						@dummy_items[row.ot] = {}

					@dummy_items[row.ot][@item_ot + ":" + row.item_id] = "pool:" + row.pool_id
					if row.ot == @item_foto_ot
						@item_foto_links[row.id] = @item_ot + ":" + row.item_id

						if row.hauptfoto == 1
							@hauptfotos[@item_ot + ":" + row.item_id] = true
					else
						@item_links[row.id] = @item_ot + ":" + row.item_id

				if @dummy_items[@item_ot]?
					console.debug @name(), "| init | loaded", Object.keys(@dummy_items[@item_ot]).length, "dummy", @item_ot, "objects"
				if @dummy_items[@item_foto_ot]?
					console.debug @name(), "| init | loaded", Object.keys(@dummy_items[@item_foto_ot]).length, "dummy", @item_foto_ot, "objects"
				console.debug @name(), "| init | loaded", Object.keys(@item_links).length, "item_links"
				console.debug @name(), "| init | loaded", Object.keys(@item_foto_links).length, "item_foto_links"

				dfr3.resolve()

		dfr.promise()
		dfr2.promise()
		dfr3.promise()


	format_gnd_link: (gnd_row) ->
		gnd = {
			conceptURI: gnd_row.gnd_uri
			frontendLanguage: "de"
		}

		if gnd_row.gnd_preferred_name
			gnd.conceptName = gnd_row.gnd_preferred_name
			gnd._standard = {
				text: gnd_row.gnd_preferred_name
			}

		if gnd_row.fulltext
			gnd._fulltext = {
				text: gnd_row.fulltext
			}
		else if gnd_row.gnd_preferred_name
			gnd._fulltext = {
				text: gnd_row.gnd_preferred_name
			}

		return gnd


	payload_item: (filename, json, store_file, filename_idx) ->
		# aus dem objekttyp item sollen zwei objekttypen werden. als umschalter dient das feld: lk_itemtyp_id
		# 	- item ("# Item - Objekt")
		# 	- item_foto ("# Item - Foto/PDF")

		ot = json.objecttype
		console.debug @name(), "| objecttype:", ot, "| payload_item()", filename

		nested_prefix = "_nested:" + ot + "__"

		items = []
		item_fotos = []
		objekt_foto_objects = []

		for obj in json.objects
			if not obj[ot]
				continue

			if not obj[ot]["easydb4_reference"]
				continue

			obj_ref = obj[ot]["easydb4_reference"]

			# if lk_itemtyp_id links to id 'foto', change the objecttype to item_foto
			if obj[ot]["lk_itemtyp_id"]?
				if obj[ot]["lk_itemtyp_id"]["itemtyp"]?
					if obj[ot]["lk_itemtyp_id"]["itemtyp"]["lookup:_id"]?
						if obj[ot]["lk_itemtyp_id"]["itemtyp"]["lookup:_id"]["easydb4_reference"]?
							if obj[ot]["lk_itemtyp_id"]["itemtyp"]["lookup:_id"]["easydb4_reference"] == @itemtyp_foto_ref

								# avoid importing of editlink nested tables
								for nested_suffix in ["item_1314", "item_1333", "item_1272"]
									if not obj[ot]?
										continue
									if not obj[ot][nested_prefix + nested_suffix]?
										continue
									obj[ot]["__debug:" + nested_prefix + nested_suffix] = [{
										"skip": "links handled in item objects"
									}]
									# todo delete(obj[ot][nested_prefix + nested_suffix])

								# if this object already has a dummy, increase the version
								if @dummy_items[@item_foto_ot]?
									if @dummy_items[@item_foto_ot][obj_ref]?
										obj[ot]["lookup:_id"] =
											"easydb4_reference": obj_ref
										obj[ot]["_version:auto_increment"] = true
										delete obj[ot]["_version"]

								item_fotos.push(obj)
								# console.debug @name(), "| objecttype:", ot, "| change objecttype of", obj[ot]["__key"], "to", @item_foto_ot

								@item_references[obj_ref] = @item_foto_ot

								continue

			# this part is not reached if the objecttype is switched to item_foto

			# collect references from item_1314, item_1333, create links in _nested:item__item_item_bidi
			item_item_bidi = []
			seen_item_refs = []
			for nested_suffix in ["item_1314", "item_1333"]
				if not obj[ot][nested_prefix + nested_suffix]
					continue

				nested_debug = []
				for rel in obj[ot][nested_prefix + nested_suffix]
					if not "__key" in rel
						nested_debug.push
							"skip": "no __key"
							"row": rel
						continue
					if not "easydb4_reference" in rel
						nested_debug.push
							"skip": "no easydb4_reference"
							"row": rel
						continue

					hauptfoto = false
					if "hauptfoto" in rel
						hauptfoto = rel["hauptfoto"] == true

					if @item_links[rel["__key"]]
						item_ref = @item_links[rel["__key"]]
						if obj_ref == item_ref
							# don't link to self
							nested_debug.push
								"skip": "self link"
								"ref": item_ref
								"row": rel
							continue

						if item_ref in seen_item_refs
							# don't link duplicates
							nested_debug.push
								"skip": "duplicate"
								"ref": item_ref
								"row": rel
							continue

						seen_item_refs.push(item_ref)

						bidi_link_obj =
							"easydb4_reference": rel["easydb4_reference"]
							"hauptfoto": hauptfoto
							"objekt":
								"_objecttype": @item_ot
								"_mask": "_all_fields"
								"item":
									"lookup:_id":
										"easydb4_reference": item_ref

						if nested_suffix == "item_1333"
							bidi_link_obj["typ"] = @link_item_item_typ(@item_item_typ__ist_kind_von)
						# if nested_suffix == "item_1272"
						# 	bidi_link_obj["typ"] = @link_item_item_typ(@item_item_typ__hat_kind)

						item_item_bidi.push(bidi_link_obj)

						nested_debug.push
							"link_created_in": nested_prefix + "item_item_bidi"
							"ref": item_ref
							"row": rel

				if nested_debug.length < 1
					nested_debug.push
						"empty": true

			if item_item_bidi.length > 0
				obj[ot][nested_prefix + "item_item_bidi"] = item_item_bidi

			# collect references from item_1314, link objekt__foto objects with links to item_foto objects
			seen_item_refs = []
			nested_suffix = "item_1314"
			if obj[ot][nested_prefix + nested_suffix]?

				nested_debug = []
				for rel in obj[ot][nested_prefix + nested_suffix]
					if not "__key" in rel
						nested_debug.push
							"skip": "no __key"
							"row": rel
						continue
					if not "easydb4_reference" in rel
						nested_debug.push
							"skip": "no easydb4_reference"
							"row": rel
						continue

					if @item_foto_links[rel["__key"]]
						item_ref = @item_foto_links[rel["__key"]]
						if obj_ref == item_ref
							# don't link to self
							nested_debug.push
								"skip": "self link"
								"ref": item_ref
								"row": rel
							continue

						if item_ref in seen_item_refs
							# don't link duplicates
							nested_debug.push
								"skip": "duplicate"
								"ref": item_ref
								"row": rel
							continue

						seen_item_refs.push(item_ref)

						# create objekt__foto objects

						# avoid duplicate link objects
						if not @seen_objekt_foto_refs[obj_ref]?
							@seen_objekt_foto_refs[obj_ref] = []
						if item_ref in @seen_objekt_foto_refs[obj_ref]
							continue

						objekt_foto_obj =
							"_objecttype": @objekt_foto_ot
							"_mask": "_all_fields"

						objekt_link =
							"_objecttype": @item_ot
							"_mask": "_all_fields"
						objekt_link[@item_ot] =
							"lookup:_id":
								"easydb4_reference": obj_ref

						foto_link =
							"_objecttype": @item_foto_ot
							"_mask": "_all_fields"
						foto_link[@item_foto_ot] =
							"lookup:_id":
								"easydb4_reference": item_ref

						is_hauptfoto = @hauptfotos[item_ref]?
						objekt_foto_obj[@objekt_foto_ot] =
							"_version": 1
							"objekt": objekt_link
							"foto": foto_link
							"__is_hauptfoto": is_hauptfoto

						# order objekt_foto objects:
						# if the linked item_foto is marked as hauptfoto, insert them at beginning
						if is_hauptfoto
							objekt_foto_objects.unshift(objekt_foto_obj)
						else
							objekt_foto_objects.push(objekt_foto_obj)

						@seen_objekt_foto_refs[obj_ref].push(item_ref)

						nested_debug.push
							"objekt_foto_ref": rel["__key"]
							"item_ref": item_ref
							"row": rel

				if nested_debug.length < 1
					nested_debug.push
						"empty": true

			if item_item_bidi.length > 0
				obj[ot][nested_prefix + "item_item_bidi"] = item_item_bidi

			# avoid importing of editlink nested tables
			for nested_suffix in ["item_1314", "item_1333", "item_1272"]
				if not obj[ot][nested_prefix + nested_suffix]?
					continue
				# todo delete(obj[ot][nested_prefix + nested_suffix])

			# check if this object was already exported as a dummy object, in this case increase the version
			if @dummy_items[ot]?
				if @dummy_items[ot][obj_ref]?
					obj[ot]["lookup:_id"] =
						"easydb4_reference": obj_ref
					obj[ot]["_version:auto_increment"] = true
					delete obj[ot]["_version"]
					# console.debug @name(), "| objecttype:", ot, "| easydb4_reference", obj_ref, "exists as dummy -> auto increment version", obj[ot]

			items.push(obj)
			@item_references[obj_ref] = ot

		# split into two payloads to separate item and item_foto objects

		# update and export the item_foto objects in new payload
		if item_fotos.length > 0

			# create new json file for the payload
			new_json = null
			init_json = =>
				new_json =
					import_type: "db"
					objecttype: @item_foto_ot
					objects: []
			init_json()

			for obj in item_fotos
				new_obj = obj
				new_obj["_objecttype"] = @item_foto_ot
				new_obj[@item_foto_ot] = obj[ot]
				delete(new_obj[ot])

				# rename nested tables
				for k, v of new_obj[@item_foto_ot]
					if not k.startsWith(nested_prefix)
						continue

					new_nested_key = k.replace(nested_prefix, "_nested:" + @item_foto_ot + "__")
					new_obj[@item_foto_ot][new_nested_key] = v
					delete(new_obj[@item_foto_ot][k])

				new_json.objects.push(new_obj)

			fn = @item_foto_ot + "-" + filename_idx + "-" + item_fotos.length + ".json"
			console.debug @name(), "| payload_item() | new json:", fn, "with", item_fotos.length, @item_foto_ot, "objects"
			store_file(fn, new_json, filename_idx)


		# export the unchanged item objects in new payload
		if items.length > 0

			new_json = null
			init_json = =>
				new_json =
					import_type: "db"
					objecttype: ot
					objects: items
			init_json()

			fn = ot + "-" + filename_idx + "-" + items.length + ".json"
			console.debug @name(), "| payload_item() | new json:", fn, "with", items.length, ot, "objects"
			store_file(fn, new_json, filename_idx)

		# to ensure the correct order of export of bidirectionally linked object, the item objects must be stored before
		# the original payload is empty
		json.objects = []

		# export the created objekt_foto objects
		if objekt_foto_objects.length > 0
			objekt_foto_json = null
			init_json = =>
				objekt_foto_json =
					import_type: "db"
					objecttype: @objekt_foto_ot
					objects: objekt_foto_objects
			init_json()

			fn = @objekt_foto_ot + "-" + (filename_idx+1) + "-" + objekt_foto_objects.length + ".json"
			console.debug @name(), "| payload_item() | saved", objekt_foto_objects.length, @objekt_foto_ot, "objects in", fn
			store_file(fn, objekt_foto_json, (filename_idx+1))

		return


	payload_tags: (filename, json) ->
		console.debug @name(), "| basetype: tags | payload_tags()", filename

		tags = []
		for ref, name of @freigabe_tags
			console.debug @name(), "tag:", ref, "name:", name
			tags.push
				tag:
					reference: ref
					displayname:
						"de-DE": name
					is_default: false
					enabled: true
					displaytype: "search"
					type: "individual"

		json.tags.push
			taggroup:
				reference: "easydb4:lk_freigabe_id"
				type: "checkbox"
				displayname:
					"de-DE": "easydb4:lk_freigabe_id"
			_tags: tags

		return


	payload_tag_freigabe: (filename, json) ->
		# in publikation gibt es das feld lk_freigabe_id. dies wurde zu pools migriert. das sollten aber tags sein
		# 	das gleiche gilt für archivalie
		#
		# "source.public.publikation".lk_freigabe_id -> "source.public.freigabe"
		# "source.public.archivalie".lk_freigabe_id -> "source.public.freigabe"

		ot = json.objecttype
		console.debug @name(), "| objecttype:", ot, "| payload_tag_freigabe()", filename

		updated_objs = []
		for obj in json.objects
			console.debug @name(), "| objecttype:", ot, "| payload_tag_freigabe()", obj
			if not obj[ot]["_pool"]["pool"]["lookup:_id"]["reference"]
				updated_objs.push(obj)
				continue

			# if the pool reference matches a reference to freigabe, set a tag instead
			tag_ref = obj[ot]["_pool"]["pool"]["lookup:_id"]["reference"]
			console.debug @name(), "| objecttype:", ot, "| payload_tag_freigabe() -> tag_ref:", tag_ref
			if not @freigabe_tags[tag_ref]
				delete(obj[ot]["_pool"])
				updated_objs.push(obj)
				continue

			new_obj = obj

			if not obj._tags
				new_obj._tags = []

			new_obj._tags.push
				"lookup:_id":
					reference: tag_ref
			console.debug @name(), "| objecttype:", ot, "| payload_tag_freigabe() -> tags:", obj._tags

			delete(new_obj[ot]["_pool"])

			updated_objs.push(new_obj)

		json.objects = updated_objs

		# for objecttype archivalie: also link gnds
		# need to call payload_gnd_links() explicitly, because the main method will return earlier
		if json.objecttype in @gnd_field_ots
			return @payload_gnd_links(filename, json)

		return


	payload_collections: (filename, json, store_file, filename_idx) ->
		console.debug @name(), "| payload_collections()", filename

		for col in json.collections
			# replace objecttype in lookups for collection objects if it was changed
			if col._objects
				console.debug @name(), "| collection:", col._objects.length, "objects"

				replaced_col_objs = []

				for obj in col._objects
					# console.debug @name(), "| collection object:", obj

					if not obj["lookup:_global_object_id"]
						continue
					if not obj["lookup:_global_object_id"]["_objecttype"]
						continue
					if obj["lookup:_global_object_id"]["_objecttype"] != @item_ot
						replaced_col_objs.push(obj)
						continue

					if not obj["lookup:_global_object_id"]["easydb4_reference"]
						continue

					obj_ref = obj["lookup:_global_object_id"]["easydb4_reference"]

					if not @item_references[obj_ref]
						continue

					if @item_references[obj_ref] == @item_ot
						replaced_col_objs.push(obj)
						continue

					if @item_references[obj_ref] == @item_foto_ot
						new_obj =
							"lookup:_global_object_id":
								_objecttype: @item_foto_ot
								easydb4_reference: obj_ref
						# console.debug @name(), "| collection object:", obj_ref, "is of type", @item_foto_ot, "=> switch to", new_obj

						replaced_col_objs.push(new_obj)
						continue

				col._objects = replaced_col_objs

			# replace objecttype in lookups for objects in slide, if the objecttype was changed
			if not col.collection
				continue
			if not col.collection.webfrontend_props
				continue
			if not col.collection.webfrontend_props.presentation
				continue
			if not col.collection.webfrontend_props.presentation.slides
				continue

			for slide in col.collection.webfrontend_props.presentation.slides
				if slide.left
					slide.left = @update_slide_gid_lookup(slide.left)
				if slide.right
					slide.right = @update_slide_gid_lookup(slide.right)
				if slide.center
					slide.center = @update_slide_gid_lookup(slide.center)

		return


	update_slide_gid_lookup: (s) ->

		console.debug @name(), "| presentation slide:", s

		if not s["lookup:global_object_id"]
			return null
		if not s["lookup:global_object_id"]["_objecttype"]
			return null
		if s["lookup:global_object_id"]["_objecttype"] != @item_ot
			return s

		if not s["lookup:global_object_id"]["easydb4_reference"]
			return null

		obj_ref = s["lookup:global_object_id"]["easydb4_reference"]

		if not @item_references[obj_ref]
			return null

		if @item_references[obj_ref] == @item_foto_ot
			new_s =
				"lookup:global_object_id":
					_objecttype: @item_foto_ot
					easydb4_reference: obj_ref
			console.debug @name(), "| presentation slide object:", obj_ref, "is of type", @item_foto_ot, "=> switch to", new_s

			return new_s

		return s


	payload_gnd_links: (filename, json) ->
		ot = json.objecttype
		console.debug @name(), "| objecttype:", ot, "| payload_gnd_links()", filename

		object_keys = []

		for obj in json.objects
			if not obj[ot]
				continue

			if obj[ot][@gnd_source_field]
				delete(obj[ot][@gnd_source_field])

			if obj[ot][@gnd_source_field + ":source_name"]
				delete(obj[ot][@gnd_source_field + ":source_name"])

			if obj[ot]["lookup:"+@gnd_source_field]
				delete(obj[ot]["lookup:"+@gnd_source_field])

			if obj[ot]["__key"]
				object_keys.push(obj[ot]["__key"])

		# load the foreign keys to the gnd table and map them for each object
		dfr = new CUI.Deferred()
		query = """
			SELECT id, lk_gnd_normdaten_id
			FROM "source.public.#{ot}"
			WHERE id IN ( """ + object_keys.join(", ") + """ )
			AND lk_gnd_normdaten_id IS NOT NULL
		"""
		@_migration.query(query)
		.fail(dfr.reject)
		.done (result) =>
			if result.rows.length > 0
				# iterate over the objects again and insert the gnd link
				console.debug @name(), "| objecttype:", ot, "| loaded", result.rows.length, "gnd ids for batch"
				for obj in json.objects
					if not obj[ot]["__key"]
						continue

					for row in result.rows
						if obj[ot]["__key"] != row.id
							continue

						if not @gnd_rows[row.lk_gnd_normdaten_id]
							break

						obj[ot][@gnd_target_field] = @format_gnd_link(@gnd_rows[row.lk_gnd_normdaten_id])

						break

			dfr.resolve()

		return dfr.promise()


	export_dummy_objects: (store_file, filename_idx) ->

		for dummy_ot, refs of @dummy_items
			# create new json file for the payload

			dummy_json = null
			init_json = =>
				dummy_json =
					import_type: "db"
					objecttype: dummy_ot
					objects: []
			init_json()

			batch_offset = 1
			dummy_objects = []

			for ref, pool_ref of refs

				dummy_obj =
					"_objecttype": dummy_ot
					"_mask": "_all_fields"
				dummy_obj[dummy_ot] =
					"_version": 1
					"easydb4_reference": ref
					"_pool":
						"pool":
							"lookup:_id":
								"reference": pool_ref

				dummy_json.objects.push(dummy_obj)

				if dummy_json.objects.length >= 1000
					fn = "dummy-" + (filename_idx-1) + "-" + batch_offset + "-" + dummy_ot + "-" + dummy_json.objects.length + ".json"
					console.debug @name(), "| export_dummy_objects() | saved", dummy_json.objects.length, dummy_ot, "objects in", fn
					store_file(fn, dummy_json, (filename_idx-1))

					dummy_json.objects = []
					batch_offset++

			if dummy_json.objects.length > 0
				fn = "dummy-" + (filename_idx-1) + "-" + batch_offset + "-" + dummy_ot + "-" + dummy_json.objects.length + ".json"
				console.debug @name(), "| export_dummy_objects() | saved", dummy_json.objects.length, dummy_ot, "objects in", fn
				store_file(fn, dummy_json, (filename_idx-1))

		return


	format_item_item_typ: (name) ->
		obj =
			"_objecttype": @item_item_typ_ot
			"_mask": "_all_fields"

		obj[@item_item_typ_ot] =
			"_version": 1
			"name": name

		return obj


	link_item_item_typ: (name) ->
		obj =
			"_objecttype": @item_item_typ_ot
			"_mask": "_all_fields"

		obj[@item_item_typ_ot] =
			"lookup:_id":
				"name": name

		return obj


	create_item_item_typ_objects: (store_file, filename_idx) ->

		dummy_json = null
		init_json = =>
			dummy_json =
				import_type: "db"
				objecttype: @item_item_typ_ot
				objects: []

		# version 2: link objects with another
		init_json()

		link = @format_item_item_typ(@item_item_typ__ist_kind_von)
		link[@item_item_typ_ot]["_version"] = 2
		link[@item_item_typ_ot]["lookup:_id"] =
			"name": @item_item_typ__ist_kind_von
		link[@item_item_typ_ot]["zugehoeriger_typ"] = @link_item_item_typ(@item_item_typ__hat_kind)
		dummy_json.objects.push(link)

		link = @format_item_item_typ(@item_item_typ__hat_kind)
		link[@item_item_typ_ot]["_version"] = 2
		link[@item_item_typ_ot]["lookup:_id"] =
			"name": @item_item_typ__hat_kind
		link[@item_item_typ_ot]["zugehoeriger_typ"] = @link_item_item_typ(@item_item_typ__ist_kind_von)
		dummy_json.objects.push(link)

		fn = "new-" + (filename_idx-1) + "-version-2-" + @item_item_typ_ot + "-" + dummy_json.objects.length + ".json"
		console.debug @name(), "| create_item_item_typ_objects() | saved", dummy_json.objects.length, @item_item_typ_ot, "objects in", fn
		store_file(fn, dummy_json, (filename_idx-1))

		# version 1: create objects with values
		init_json()
		dummy_json.objects.push(@format_item_item_typ(@item_item_typ__ist_kind_von))
		dummy_json.objects.push(@format_item_item_typ(@item_item_typ__hat_kind))

		fn = "new-" + (filename_idx-1) + "-version-1-" + @item_item_typ_ot + "-" + dummy_json.objects.length + ".json"
		console.debug @name(), "| create_item_item_typ_objects() | saved", dummy_json.objects.length, @item_item_typ_ot, "objects in", fn
		store_file(fn, dummy_json, (filename_idx-1))

		return


	payload: (filename, json, update, store_file, filename_idx) ->

		if json.import_type == "tags"
			return @payload_tags(filename, json)

		if json.import_type == "collection"
			return @payload_collections(filename, json, store_file, filename_idx)

		if json.import_type != "db"
			return

		# before all other objects: export dummys and other objects that do not come from the source database

		# 1) if the dummy item objects have not been exported yet, create dummy versions in another payload before this
		if not @dummys_exported
			@export_dummy_objects(store_file, filename_idx)
			@dummys_exported = true

		# 2) export the new item_item_typ objects
		if not @item_item_typ_created
			@create_item_item_typ_objects(store_file, filename_idx)
			@item_item_typ_created = true

		if json.objecttype == @item_ot
			return @payload_item(filename, json, store_file, filename_idx)

		if json.objecttype == "publikation" or json.objecttype == "archivalie"
			return @payload_tag_freigabe(filename, json)

		if json.objecttype in @gnd_field_ots
			return @payload_gnd_links(filename, json)

		return

ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.OrdinariatFreiburg)
