class Easydb4MigrationPlugin.UniFreiburg extends Easydb4MigrationPlugin
	name: ->
		"uni-freiburg"

	init: ->
		console.error "reset bildansichten"

		@bildansichten =
			bildansicht_arch_neu: []
			bildansicht_kuge_neu: []
			bildansicht_muenz_neu: []

	payload: (filename, json, update, store_file) ->
		if json.objecttype == "listenfelder"
			return @splitByType(filename, json, update, store_file, "listenfelder", "type",
				"listenfelder_Objektgattung": "liste_objektgattung"
				"listenfelder_Befundgattung": "liste_befundgattung"
				"listenfelder_Bildart": "liste_bildart"
				"listenfelder_Datierung-Epoche": "liste_epoche"
				"listenfelder_Entstehung_theol": "liste_entstehung_theol"
				"listenfelder_Epoche_Muenz": "liste_epoche_muenz"
				"listenfelder_Epoche_theol": "liste_epoche_theol"
				"listenfelder_Jahr": "liste_jahr"
				"listenfelder_Region_theol": "liste_region_theol"
				"listenfelder_Verfügbarkeit": "liste_verfuegbarkeit"
				"listenfelder_Wiedergabe": "liste_wiedergabe"
			)

		if json.objecttype != "bilder"
			return

		dfr = new CUI.Deferred()
		@_migration.query('SELECT * FROM "source.public.pool"')
		.fail(dfr.reject)
		.done (result) =>
			# if json.objecttype == "mat_attribute"
			# 	return @splitByType(filename, json, update, store_file, "mat_attribute", "typus")

			move_reg = (obj, key, key2) =>
				if obj.bilder[key] == undefined
					return

				# console.debug "move_reg:", obj, key, key2

				obj.bilder[key2] = obj.bilder[key]
				delete(obj.bilder[key])


			ptb = @_migration.__info.pool_tables[0]

			theol = []
			arch = []
			kuge = []
			muenz = []

			for row in result.rows
				if not row.editmask
					continue

				ref = ptb.real_source_name+":"+row.id

				if row.editmask.match(/Theol/)
					theol.push(ref)

				if row.editmask.match(/Arch/)
					arch.push(ref)

				if row.editmask.match(/KuGe/)
					kuge.push(ref)

				if row.editmask.match(/Muenz/)
					muenz.push(ref)


			bildansichten =
				bildansicht_arch_neu: []
				bildansicht_kuge_neu: []
				bildansicht_muenz_neu: []

			for obj in json.objects
				ref = obj.bilder._pool.pool["lookup:_id"].reference

				# titel je pool

				if ref in theol
					move_reg(obj, "herstellungsort", "herstellungsort_theol_neu")
					move_reg(obj, "titel", "titel_theol_neu")

				if ref in arch
					move_reg(obj, "titel", "titel_arch_neu")

				if ref in kuge
					move_reg(obj, "titel", "titel_kuge_neu")

				# bildansicht > listen

				value = obj.bilder.bildansicht?.trim()

				if not CUI.util.isEmpty(value)

					key = null

					if ref in arch
						key = "arch"

					if ref in kuge
						key = "kuge"

					if ref in muenz
						key = "muenz"

					if key

						lobj = {}
						lobj["lookup:_id"] = easydb4_reference: "bildansicht:"+value

						ot_name = "bildansicht_"+key+"_neu"

						obj.bilder[ot_name] =
							_objecttype: ot_name
							_mask: "_all_fields"

						obj.bilder[ot_name][ot_name] = lobj

						if value not in @bildansichten[ot_name]
							bildansichten[ot_name].push(value)
							@bildansichten[ot_name].push(value)

						delete(obj.bilder.bildansicht)

			for k, v of bildansichten
				console.info "Bildansichten:", key, "neu:", v.length, "totel:", @bildansichten[k].length

			for ot_name, values of bildansichten
				if values.length == 0
					continue

				payload =
					import_type: "db"
					objecttype: ot_name
					objects: []

				for value in values
					obj =
						_objecttype: ot_name
						_mask: "_all_fields"

					obj[ot_name] =
						_version: 1
						easydb4_reference: "bildansicht:"+value
						name: value

					payload.objects.push(obj)

				store_file(ot_name+".json", payload)

			dfr.resolve()


		dfr.promise()


ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.UniFreiburg)
