class Easydb4MigrationPlugin.UniGoettingen extends Easydb4MigrationPlugin
	name: ->
		"uni-goettingen"

	payload: (filename, json, update, store_file) ->

		beginn_map =
			1: "frühestens"
			2: "nach"
			3: "vor"

		ende_map =
			1: "spätestens"
			2: "nach"
			3: "vor"

		zeitpunkt_map =
			1: "um"
			2: "ca."

		# dias_attribute
		#
		#

		console.debug "post process", json

		if json.objecttype == "bilder"
			for _obj in json.objects
				obj = _obj.bilder

				if obj["_nested:bilder__datierung_zeitpunkt"]
					CUI.util.removeFromArray(null, obj["_nested:bilder__datierung_zeitpunkt"], (d) ->
						d.typ != "1"
					)
					for nested in obj["_nested:bilder__datierung_zeitpunkt"]
						console.debug "attr komplett:", nested
						if not nested.attr_komplett
							continue

						name = nested.attr_komplett.attr_datierung_zeitpunkt["lookup:_id"].name

						if not zeitpunkt_map[name]
							# the "0" case
							delete(nested.attr_komplett)
						else
							nested.attr_komplett.attr_datierung_zeitpunkt["lookup:_id"].name = zeitpunkt_map[name]

				if obj["_nested:bilder__datierung_spanne"]
					CUI.util.removeFromArray(null, obj["_nested:bilder__datierung_spanne"], (d) ->
						d.typ != "2"
					)
					for nested in obj["_nested:bilder__datierung_spanne"]
						console.debug "spanne beginn | ende:", nested

						if nested.attr_beginn
							name = nested.attr_beginn.attr_datierung_spanne_beginn["lookup:_id"].name
							nested.attr_beginn.attr_datierung_spanne_beginn["lookup:_id"].name = beginn_map[name]

						if nested.attr_ende2
							name = nested.attr_ende2.attr_datierung_spanne_ende["lookup:_id"].name
							nested.attr_ende2.attr_datierung_spanne_ende["lookup:_id"].name = ende_map[name]

				if obj["_nested:bilder__datierung_jahrhundert"]
					CUI.util.removeFromArray(null, obj["_nested:bilder__datierung_jahrhundert"], (d) ->
						d.typ != "3"
					)

			return

		switch json.objecttype
			when "attr_datierung_spanne_beginn"
				map = beginn_map
			when "attr_datierung_spanne_ende"
				map = ende_map
			when "attr_datierung_zeitpunkt"
				map = zeitpunkt_map
			else
				return

		for obj in json.objects
			name = obj[json.objecttype].name
			if map[name]
				obj[json.objecttype].name = map[name]


		return



ez5.session_ready =>
	Easydb4Migration.plugins.registerPlugin(Easydb4MigrationPlugin.UniGoettingen)
