// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

Easydb4Migration.UnibZuerich = (function(superClass) {
  extend(UnibZuerich, superClass);

  function UnibZuerich() {
    return UnibZuerich.__super__.constructor.apply(this, arguments);
  }

  UnibZuerich.prototype.name = function() {
    return "unib-zuerich";
  };

  UnibZuerich.prototype.payload = function(filename, json, update) {
    var connect, dfr, fn;
    if (json.objecttype !== "bilder") {
      return;
    }
    fn = this._migration.getFileRootUrl() + 'bildcode_mapping.csv';
    console.debug("payload:", json);
    dfr = new CUI.Deferred();
    connect = new CUI.XHR({
      responseType: "text",
      url: fn
    });
    connect.start().done((function(_this) {
      return function(data) {
        var bild_fn, csv, filename_by_bildcode, i, j, len, len1, obj, ref, ref1, row;
        console.debug("recevied data", data, filename, json, update, arguments, connect.getXHR());
        csv = new CUI.CSVData();
        csv.parse({
          text: data,
          defer: false
        });
        filename_by_bildcode = {};
        ref = csv.getRows();
        for (i = 0, len = ref.length; i < len; i++) {
          row = ref[i];
          filename_by_bildcode[row[0]] = encodeURI(row[1].replace("/mnt/Bildarchiv/", "http://localhost/bildarchiv/"));
        }
        ref1 = json.objects;
        for (j = 0, len1 = ref1.length; j < len1; j++) {
          obj = ref1[j];
          bild_fn = filename_by_bildcode[obj.bilder.unique_identifier];
          if (!bild_fn) {
            _this._migration.loginfo("Bildcode '" + obj.bilder.unique_identifier + "' not found in CSV. Skipping.");
            continue;
          }
          if (!obj.bilder.bild) {
            obj.bilder.bild = [
              {
                preferred: true
              }
            ];
          }
          if (obj.bilder.bild[0]["eas:url"]) {
            _this._migration.loginfo("Overwrite URL for '" + obj.bilder.unique_identifier + "': " + obj.bilder.bild[0]["eas:url"] + " -> " + bild_fn);
          } else {
            _this._migration.loginfo("Setting URL for '" + obj.bilder.unique_identifier + "': " + bild_fn);
          }
          obj.bilder.bild[0]["eas:url"] = bild_fn;
          obj.bilder.bild[0]["_post_process_source"] = obj.unique_identifier;
        }
        console.debug("csv:", csv, _this._migration.getSettings(), filename_by_bildcode);
        return dfr.resolve();
      };
    })(this)).fail((function(_this) {
      return function() {
        CUI.problem({
          markdown: true,
          text: "Die Datei **" + fn + "** wurde nicht gefunden."
        });
        return dfr.reject("File: " + fn + " for post process could not be read.");
      };
    })(this));
    return dfr.promise();
  };

  return UnibZuerich;

})(Easydb4MigrationPlugin);

ez5.session_ready((function(_this) {
  return function() {
    return Easydb4Migration.plugins.registerPlugin(Easydb4Migration.UnibZuerich);
  };
})(this));
