class ez5.PdfCreator.Modal extends CUI.Element

	initOpts: ->
		super()
		@addOpts
			data:
				check: "PlainObject"
				default: {}
			onSave:
				check: Function
			idObjecttype:
				check: "Integer"
				mandatory: true
			idMask:
				check: "Integer"
		return @

	readOpts: ->
		super()

		# Default zoom
		@__currentZoom = 100
		@__previewObjects = []
		@__saveButton = new LocaButton
			loca_key: "pdf-creator.modal.save.button"
			disabled: true
			primary: true
			onClick: =>
				@__save()
				@_onSave?(@_data)
				@__modal.destroy() # Save and hide or just save.

		@__printPreviewButton = new LocaButton
			loca_key: "pdf-creator.preview.print.button"
			group: "print-preview"
			left: true
			disabled: true
			onClick: =>
				@__printPreviewButton.startSpinner()
				@__printPreview().fail((errorMessage) ->
					if not CUI.util.isString(errorMessage)
						errorMessage = $$("pdf-creator.preview.print.error-message")
					CUI.problem(text: errorMessage)
				).always(=>
					@__printPreviewButton.stopSpinner()
				)


		masks = ez5.mask.CURRENT._masks_by_table_id[@_idObjecttype]
		maskInstances = [Mask.getMaskByMaskName("_all_fields", @_idObjecttype)]
		for mask in masks
			if mask.mask_id == @_idMask
				selectedMaskName = mask.name
			maskInstances.push(ez5.mask.CURRENT._mask_instance_by_name[mask.name])
		mfs = new MaskFieldSelectorDetail
			mask_name: selectedMaskName or "_all_fields"
			masks: maskInstances
			show_all_fields_mask : true
			onChanged: (old_mask, new_mask) =>
				@_idMask = ez5.mask.CURRENT._mask_instance_by_name[new_mask]?._id
				@__pdfDocumentNode.setMask(@_idMask)
				@__updatePreview()
				return CUI.resolvedPromise()
		@__maskSelector = mfs.getSelect().start()

		@__previewObjectPage = 0
		@__previewObjectOffset = 0
		@__previewObjectNavigation = new NavigationToolbar
			onLoadPage: (@__previewObjectPage) =>
				@__updatePreview()
				return

		@__searchPopoverButton = new LocaButton
			loca_key: "pdf-creator.preview.select-objects.button"
			group: "print-preview"
			left: true
			disabled: false
			onClick: =>
				searchPopover.openPopover()

		content = @__buildModalContent()

		mask = @__pdfDocumentNode.getMask()
		collection = new CollectionMemory
		searchPopover = new SearchPopover
			link_mask: mask
			popover_element: @__searchPopoverButton
			collection: collection
			request_format: "long"
			onDone: =>
				@__previewLabel.setText($$("pdf-creator.preview.selected-objects|label", count: collection.getCount()))
				@__previewObjects = collection.getObjects().map((object) => object.getObject())

				@__searchPopoverButton.startSpinner()
				ez5.PdfCreatorUtils.fetchLinkedObjects(@__previewObjects).done(=>
					@__previewObjectPage = 0
					@__updatePreview()
					if @__previewObjects.length > 0
						@__printPreviewButton.enable()
					else
						@__printPreviewButton.disable()

					@__searchPopoverButton.stopSpinner()
				)

		@__modal = new CUI.Modal
			fill_space: "both"
			cancel: true
			onCancel: =>
				if not @__saveButton.isEnabled() # No changes were made.
					return @__modal.destroy()

				CUI.confirm(text: $$("pdf-creator.modal.close.confirmation|text")).done(=>
					@__modal.destroy()
				)
			pane:
				class: "pdf-creator"
				header_left: new CUI.Label(text: $$("pdf-creator.title"))
				content: content
				footer_right: @__saveButton
				footer_left: new CUI.HorizontalList
					content: new CUI.Buttonbar(buttons: [
						@__printPreviewButton
					,
						@__searchPopoverButton
					,
						@__maskSelector
					])

		return @

	__printPreview: ->
		#return ez5.PdfCreatorUtils.print(@__previewObjects, @__pdfDocumentNode)
		pdfCreatorTemplate = new ez5.PdfCreator.Template(data: @_data)
		return pdfCreatorTemplate.print(@__previewObjects)

	__checkSaveData: ->
		saveData = @__getSaveData()
		if CUI.util.isEqual(@_data?.documentData, saveData.documentData)
			@__saveButton.disable()
		else
			@__saveButton.enable()
		return

	__getSaveData: ->
		saveData =
			documentData: @__pdfDocumentNode.getSaveData()
			zoom: @__currentZoom
			name: @__pdfDocumentNode.getTemplateName()
		return saveData

	__save: ->
		date = CUI.util.moment().format()
		saveData = @__getSaveData()
		@_data.documentData = saveData.documentData
		@_data.zoom = saveData.zoom
		@_data.name = saveData.name
		@_data.date_last_modified = date
		@_data.id_objecttype = @_idObjecttype
		@_data.user_last_modify = ez5.session.user.getDisplayText()
		if not @_data.user_create
			@_data.user_create = @_data.user_last_modify
		if not @_data.date_created
			@_data.date_created = date
		return

	__loadData: ->
		if CUI.util.isEmpty(@_data)
			@__pdfDocumentNode.select()
			return

		waitBlock = new CUI.WaitBlock(element: @__treePane.center()).show()
		saveData = CUI.util.copyObject(@_data, true)
		if saveData.zoom
			@__currentZoom = saveData.zoom

		documentData = ez5.PdfCreatorUtils.initDocumentData(saveData.documentData)

		tree = @__buildTree(documentData)
		@__treePane.append(tree, "center")
		@__pdfDocumentNode.open()
		@__pdfDocumentNode.select().done(=>
			@__updatePreview()
			waitBlock.destroy()
		)
		return

	open: ->
		@__modal.show()
		ez5.PdfCreator.fetchPrintCSSPromise.done(=>
			@__loadData()
			@__updatePreview()
		)
		return

	__updateSettingsForm: ->
		if @__settingsForm
			@__settingsForm.destroy()

		selectedNode = @__tree.getSelectedNode()
		if not selectedNode
			label = new EmptyLocaLabel(text: $$("pdf-creator.settings.node-not-selected"), centered: true)
			@__settingsPane.replace(label)
			return

		onDataChanged = =>
			@__updatePreview()

		opts = onDataChanged: =>
			CUI.scheduleCallback
				ms: 200
				call: onDataChanged

		@__settingsForm = selectedNode.getSettingsForm(opts)
		@__settingsPane.replace(@__settingsForm)
		@__settingsLabel.setText($$("pdf-creator.settings.title", name: selectedNode.getDisplayName()))
		return

	__updatePreviewNavigation: =>
		maxCountPerPage = @__pdfDocumentNode.getMaxCountPerPage()
		@__previewObjectOffset = @__previewObjectPage * maxCountPerPage

		if @__previewObjectOffset > @__previewObjects.length
			@__previewObjectPage = 0
			@__previewObjectOffset = 0

		@__previewObjectNavigation.update
			count: @__previewObjects.length
			offset: @__previewObjectOffset
			limit: maxCountPerPage
		return

	__updatePreview: ->
		opts =
			preview: true
			objects: []
			selectedNode: @__tree.getSelectedNode()
			styles: ez5.PdfCreator.printSyles
			custom_css_url: ez5.session.getBaseConfig("plugin", "pdf-creator")?.custom_css_url

		# TODO: FIX it - (if we want to use this)
		# It throws "recursion protection" error and it makes the loading slow with big objecttypes.
#		if not @__previewObjects?.length > 0
#			resultObjectDemo = new ResultObjectDemo
#				mask: @__pdfDocumentNode.getMask()
#				version: "CURRENT"
#				format: "long"
#			@__previewObjects = []
#			for i in [0...100]
#				@__previewObjects.push(resultObjectDemo.data)

		if CUI.util.isEmpty(@__previewObjects)
			noPreviewObjectsLabel = new EmptyLocaLabel
				class: "pdf-creator-preview-no-objects-label"
				text: $$("pdf-creator.preview.subtitle.md")
				centered: true
				markdown: true
			CUI.dom.replace(@__iframeWrapper, noPreviewObjectsLabel)
			@__zoomButtonbar.disable()
			@__checkSaveData()
			return

		if @__iframeWrapper.children[0] != @__zoomWrapper
			CUI.dom.replace(@__iframeWrapper, @__zoomWrapper)
			@__zoomButtonbar.enable()

		@__updatePreviewNavigation()
		count = @__pdfDocumentNode.getMaxCountPerPage()
		opts.objects = @__previewObjects.slice(@__previewObjectOffset, @__previewObjectOffset + count)

		width = @__pdfDocumentNode.getWidth()
		height = @__pdfDocumentNode.getHeight()
		if width != @__documentWidth or height != @__documentHeight
			@__documentWidth = width
			@__documentHeight = height
			CUI.dom.setStyle(@__iframe,
				width: @__documentWidth + "cm"
				height: @__documentHeight + "cm"
			)

		html = @__pdfDocumentNode.renderPdf(opts)
		@__iframe.contentDocument.children[0].replaceWith(html)
		@__setZoom()

		html.children[1].addEventListener("wheel", (ev) =>
			@__onWheel(ev.deltaY)
			ev.preventDefault()
			return
		, passive: false) # Passive is necessary to use 'preventDefault()' and prevent the scroll.

		@__checkSaveData()
		return

	__buildModalContent: ->
		tree = @__buildTree(open: true)

		@__addButton = new CUI.Button
			group: "tree_actions"
			icon: "plus"
			disabled: true
			menu:
				items: =>
					selectedNode = @__tree.getSelectedNode()
					items = []
					for _, plugin of ez5.PdfCreator.nodePlugins
						pluginNode = new plugin()
						do (pluginNode) =>
							items.push
								text: pluginNode.getDisplayName()
								disabled: not pluginNode.isParentAllowed(selectedNode)
								onClick: =>
									@__tree.getSelectedNode().addNode(pluginNode).done(=>
										pluginNode.select().done(=>
											@__updatePreview()
										)
									)
					return items
		@__removeButton = new CUI.Button
			group: "tree_actions"
			icon: "minus"
			disabled: true
			onClick: =>
				CUI.confirm(text: $$("pdf-creator.elements.buttons.remove.confirmation")).done(=>
					@__tree.getSelectedNode().remove()
					@__updatePreview()
				)

		@__moveToBottomButton = new CUI.Button
			icon: $$("tool.mask_editor.move_to_bottom|icon")
			group: "tree_actions"
			disabled: true
			onClick: =>
				@__moveSelectedNodeToBottom()

		@__moveToTopButton = new CUI.Button
			icon: $$("tool.mask_editor.move_to_top|icon")
			group: "tree_actions"
			disabled: true
			onClick: =>
				@__moveSelectedNodeToTop()

		@__moveUpButton = new CUI.Button
			group: "tree_actions"
			icon: "fa-angle-up"
			disabled: true
			onClick: =>
				@__moveSelectedNode(false)

		@__moveDownButton = new CUI.Button
			group: "tree_actions"
			icon: "fa-angle-down"
			disabled: true
			onClick: =>
				@__moveSelectedNode(true)



		@__copyButton = new CUI.Button
			group: "tree_more_actions"
			icon: "copy"
			disabled: true
			onClick: =>
				selectedNode = @__tree.getSelectedNode()
				node = selectedNode.copy()
				if not node
					return
				selectedNode.getFather()?.addChild(node)
				@__updatePreview()

		@__zoomLabel = new CUI.Label(text: "", appearance: "secondary")
		@__zoomButtonbar = new CUI.Buttonbar(buttons: [
			@__zoomLabel
		,
			icon: "zoom_out"
			group: "zoom"
			onClick: =>
				@__setZoom(-2)
		,
			loca_key: "pdf-creator.zoom.fit-view"
			group: "zoom"
			onClick: =>
				heightZoom = @__iframeWrapper.clientHeight / @__zoomWrapper.clientHeight
				widthZoom = @__iframeWrapper.clientWidth / @__zoomWrapper.clientWidth
				zoom = if heightZoom < widthZoom then heightZoom else widthZoom

				@__currentZoom = Math.floor(zoom * 100)
				@__setZoom()

				# Adjust the scroll vertically and horizontally.
				@__zoomWrapper.scrollIntoView()
				@__iframeWrapper.scrollLeft = CUI.dom.getDimension(@__iframeWrapper, "paddingLeft")
		,
			icon: "zoom_in"
			group: "zoom"
			onClick: =>
				@__setZoom(2)
		])

		@__iframeWrapper = CUI.dom.div("pdf-creator-iframe-wrapper")
		@__zoomWrapper = CUI.dom.div("pdf-creator-iframe-wrapper-zoom")
		@__iframe = CUI.dom.$element("iframe", "pdf-creator-iframe-preview")
		CUI.dom.append(@__zoomWrapper, @__iframe)
		CUI.dom.append(@__iframeWrapper, @__zoomWrapper)

		@__previewLabel = new CUI.Label(text: $$("pdf-creator.preview.title"))
		previewPane = new CUI.SimplePane
			header_left: @__previewLabel
			header_right: @__zoomButtonbar
			content: @__iframeWrapper
			footer_center: @__previewObjectNavigation

		CUI.Events.listen
			node: @__iframeWrapper
			type: "wheel"
			call: (ev) =>
				@__onWheel(ev.wheelDeltaY())
				ev.preventDefault()
				return

		@__settingsLabel = new CUI.Label(text: $$("pdf-creator.settings.title.node-not-selected"))
		@__settingsPane = new CUI.SimplePane
			header_left: @__settingsLabel
		@__updateSettingsForm()

		@__treePane = new CUI.SimplePane
			header_left: new CUI.Label(text: $$("pdf-creator.elements.title"))
			content: tree
			footer_left: new CUI.Buttonbar
				buttons: [
					@__addButton
					@__removeButton
					@__copyButton
					@__moveToTopButton
					@__moveUpButton
					@__moveDownButton
					@__moveToBottomButton
				]

		content = new CUI.HorizontalLayout
			left:
				class: "pdf-creator-tree"
				flexHandle:
					state_name: "pdf-creator-left"
					hidden: false
				content: @__treePane
			center:
				class: "pdf-creator-preview"
				content: previewPane
			right:
				class: "pdf-creator-settings"
				flexHandle:
					state_name: "pdf-creator-right"
					hidden: false
				content: @__settingsPane
		return content

	__onWheel: (deltaY) =>
		if deltaY > 0 # Down direction
			@__setZoom(-2)
		else # Up direction
			@__setZoom(2)
		return

	__buildTree: (opts = {}) =>
		if @__tree
			@__tree.destroy()
			@__pdfDocumentNode?.destroy()

		if not opts.idObjecttype
			opts.idObjecttype = @_idObjecttype
		if not opts.idMask
			opts.idMask = @_idMask

		updatePreview = => @__updatePreview()

		@__pdfDocumentNode = new ez5.PdfCreator.Node.Document(opts)
		@__tree = new CUI.ListViewTree
			selectableRows: true
			rowMove: true
			root: new CUI.ListViewTreeNode(children: [@__pdfDocumentNode])
			cols: ["maximize"]
			onSelect: =>
				@__updateSettingsForm()

				selectedNode = @__tree.getSelectedNode()
				if not selectedNode
					return

				@__addButton.disable()
				@__addButton.getMenu().getItemList().getItems().done((items) =>
					if items.some((item) -> not item.disabled)
						@__addButton.enable()
					else
						@__addButton.disable()
				)

				if selectedNode == @__pdfDocumentNode
					@__removeButton.disable()
					@__moveToTopButton.disable()
					@__moveToBottomButton.disable()
					@__moveUpButton.disable()
					@__moveDownButton.disable()
				else
					@__removeButton.enable()
					@__moveToTopButton.enable()
					@__moveToBottomButton.enable()
					@__moveUpButton.enable()
					@__moveDownButton.enable()

				if selectedNode.isCopyAllowed()
					@__copyButton.enable()
				else
					@__copyButton.disable()



				CUI.scheduleCallback
					ms: 200
					call: updatePreview
				return
			onRowMove: =>
				CUI.scheduleCallback
					ms: 200
					call: updatePreview
			onDeselect: =>
				@__updateSettingsForm()
				@__removeButton.disable()
				@__copyButton.disable()
				@__addButton.disable()
				@__moveUpButton.disable()
				@__moveDownButton.disable()
				@__moveToTopButton.disable()
				@__moveToBottomButton.disable()
				CUI.scheduleCallback
					ms: 200
					call: updatePreview
				return
		@__tree.render()
		@__tree.root.open()
		return @__tree

	__setZoom: (zoomOffset) =>
		if zoomOffset and (@__currentZoom + zoomOffset) > 0
			@__currentZoom += zoomOffset

		scale = @__currentZoom / 100
		CUI.dom.setStyle(@__zoomWrapper,
			transform:  "scale(#{scale}, #{scale})"
			left: 0
		)
		@__zoomLabel.setText($$("pdf-creator.zoom|label", zoom: @__currentZoom))

		iframeWrapperWidth = @__iframeWrapper.clientWidth
		zoomWrapperWidth = @__zoomWrapper.clientWidth * scale
		leftWidth = (iframeWrapperWidth - zoomWrapperWidth) / 2
		if leftWidth > 0
			CUI.dom.setStyle(@__zoomWrapper, left: "#{leftWidth}px")
		return

	__moveSelectedNode: (after) ->
		selectedNode = @__tree.getSelectedNode()
		if selectedNode.isOpen()
			selectedNode.close()
		nextRowIndex = @__getNextRowIndexForMove(selectedNode, after)
		if not nextRowIndex
			return
		@__tree.moveRow(selectedNode.getRowIdx(),nextRowIndex, after)
		return

	__moveSelectedNodeToTop: () ->
		selectedNode = @__tree.getSelectedNode()
		fatherChildren = selectedNode.father.children
		topIndex = fatherChildren[0].getRowIdx()
		if fatherChildren == @__pdfDocumentNode
			#Root node must be documentNode
			topIndex++
		@__tree.moveRow(selectedNode.getRowIdx(),topIndex, false)

	__moveSelectedNodeToBottom: () ->
		selectedNode = @__tree.getSelectedNode()
		fatherChildren = selectedNode.father.children
		lastNode = (fatherChildren[fatherChildren.length - 1])
		if lastNode.children
			lastNode.close()
		lastIdx = lastNode.getRowIdx()
		@__tree.moveRow(selectedNode.getRowIdx(),lastIdx, true)

	__getNextRowIndexForMove: (node, after) ->
		quantity = if after then 1 else -1
		fatherChildren = node.father.children
		rowIndexInArray = CUI.util.idxInArray(node, fatherChildren)

		getNextRowIndex = (_quantity) =>
			nextListViewRow = fatherChildren[rowIndexInArray + _quantity]
			if not nextListViewRow
				return

			if not node.allowRowMove(nextListViewRow, null, after)
				return getNextRowIndex(_quantity + quantity)

			return nextListViewRow.getRowIdx()

		return getNextRowIndex(quantity)
