// Generated by CoffeeScript 1.12.7
var extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

ez5.PdfCreator.Node.Asset = (function(superClass) {
  extend(Asset, superClass);

  function Asset() {
    return Asset.__super__.constructor.apply(this, arguments);
  }

  Asset.getName = function() {
    return "asset";
  };

  Asset.prototype.__renderPdfContent = function(opts) {
    var _assets, asset, assetBrowser, assets, assetsOffset, columnsOffset, data, div, easFieldsData, f, fieldsToReset, i, icon, j, k, len, len1, mask, placeholder, ref, ref1, rowIndex, rows, span, width;
    if (!opts.object) {
      return;
    }
    mask = this.__getMask();
    data = this.getData();
    easFieldsData = data.easFields;
    fieldsToReset = [];
    if (mask.name() === "_all_fields") {
      mask.invokeOnFields("all", true, ((function(_this) {
        return function(f, _, depth) {
          var ref;
          if (!(f instanceof LinkedObject) || depth > 1 || !((ref = f.FieldSchema) != null ? ref.output : void 0)) {
            return;
          }
          f.FieldSchema.output.__standard_eas = f.FieldSchema.output.standard_eas;
          f.FieldSchema.output.standard_eas = {
            order: 1
          };
          return fieldsToReset.push(f);
        };
      })(this)));
    }
    assets = mask.getAssetsForBrowser(opts.object, "all") || [];
    assets = assets.filter((function(_this) {
      return function(asset) {
        var name;
        if (asset.value._linked_object) {
          name = asset.value._linked_object.fullName();
        } else {
          name = asset.field.fullName();
        }
        return easFieldsData[name];
      };
    })(this));
    for (i = 0, len = fieldsToReset.length; i < len; i++) {
      f = fieldsToReset[i];
      f.FieldSchema.output.standard_eas = f.FieldSchema.output.__standard_eas;
      delete f.FieldSchema.output.__standard_eas;
    }
    if (data.range) {
      assets.splice(data.range);
    }
    if (assets.length === 0) {
      if (!data.show_placeholder) {
        return;
      }
      placeholder = CUI.dom.div("pdf-node-asset-placeholder");
      icon = new CUI.Icon({
        icon: "fa-file-o"
      });
      CUI.dom.append(placeholder, icon);
      if (data.placeholder_text) {
        span = CUI.dom.span();
        span.textContent = data.placeholder_text;
        CUI.dom.append(placeholder, span);
      }
      return placeholder;
    }
    div = CUI.dom.div();
    rows = Math.ceil(assets.length / data.columns);
    width = 100 / data.columns;
    assetsOffset = 0;
    columnsOffset = data.columns;
    for (rowIndex = j = 0, ref = rows; 0 <= ref ? j < ref : j > ref; rowIndex = 0 <= ref ? ++j : --j) {
      _assets = assets.slice(assetsOffset, columnsOffset);
      if (_assets.length === 0) {
        break;
      }
      assetsOffset += data.columns;
      columnsOffset += data.columns;
      assetBrowser = new AssetBrowser({
        assets: _assets,
        for_print: true,
        printLowRes: data.low_resolution
      });
      ref1 = assetBrowser.getAssets();
      for (k = 0, len1 = ref1.length; k < len1; k++) {
        asset = ref1[k];
        CUI.dom.setStyle(asset.getElement(), {
          width: width + "%"
        });
      }
      CUI.dom.append(div, assetBrowser);
    }
    if (data.show_info) {
      CUI.dom.addClass(div, "pdf-node-asset-show-info");
    }
    return div;
  };

  Asset.prototype.__getSettingsFields = function() {
    var easFields, fields, form, mask;
    mask = this.__getMask();
    easFields = [];
    mask.invokeOnFields("all", true, ((function(_this) {
      return function(f, _, depth) {
        var easField;
        if (depth > 1) {
          return;
        }
        if (f instanceof EASColumn || (f instanceof LinkedObject && depth <= 1)) {
          if (f instanceof LinkedObject) {
            easField = f.linkMask().getEASFields("all")[0];
            if (!easField) {
              return;
            }
          }
          return easFields.push({
            type: CUI.Checkbox,
            text: f.fullNameLocalized(),
            form: {
              hint: f.fullName()
            },
            name: f.fullName()
          });
        }
      };
    })(this)));
    if (easFields.length === 0) {
      easFields.push({
        type: CUI.DataFieldProxy,
        element: function() {
          return new CUI.Label({
            text: $$("pdf-creator.settings.node.assets.no-eas-fields-available|label")
          });
        }
      });
    }
    form = new CUI.Form({
      form: {
        label: $$("pdf-creator.settings.node.assets.eas-fields|label")
      },
      name: "easFields",
      fields: easFields
    });
    fields = [
      form, {
        type: CUI.Select,
        form: {
          label: $$("pdf-creator.settings.node.assets.columns|label")
        },
        name: "columns",
        options: [
          {
            value: 1
          }, {
            value: 2
          }, {
            value: 3
          }, {
            value: 4
          }, {
            value: 5
          }
        ]
      }, {
        type: CUI.Select,
        form: {
          label: $$("pdf-creator.settings.node.assets.range|label")
        },
        name: "range",
        options: [
          {
            text: $$("pdf-creator.settings.node.assets.range.option-all|label"),
            value: null
          }, {
            text: $$("pdf-creator.settings.node.assets.range.option-first|label"),
            value: 1
          }
        ]
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.assets.low-resolution|label")
        },
        name: "low_resolution"
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.assets.show-info|label")
        },
        name: "show_info"
      }, {
        type: CUI.Checkbox,
        form: {
          label: $$("pdf-creator.settings.node.assets.show-placeholder|label")
        },
        name: "show_placeholder"
      }, {
        type: CUI.Input,
        form: {
          label: $$("pdf-creator.settings.node.assets.placeholder-text|label")
        },
        name: "placeholder_text"
      }
    ];
    return fields;
  };

  Asset.prototype.setData = function(data) {
    Asset.__super__.setData.call(this, data);
    if (!this.__data.easFields) {
      this.__data.easFields = {};
    }
    return this;
  };

  Asset.prototype.__getStyleSettings = function() {
    return ["class-name"];
  };

  return Asset;

})(ez5.PdfCreator.Node);

ez5.PdfCreator.plugins.registerPlugin(ez5.PdfCreator.Node.Asset);
